% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{getCentralityMatrix}
\alias{getCentralityMatrix}
\title{Calculate centrality measures for graph nodes.}
\usage{
getCentralityMatrix(gg, weights = NULL)
}
\arguments{
\item{gg}{igraph object}

\item{weights}{Possibly a numeric vector giving edge weights. If this is
NULL and the graph has a weight edge attribute, then the attribute
is used. If this is NA then no weights are used (even if the graph
has a weight attribute).}
}
\value{
data.frame with following columns:
\itemize{
\item ID   - vertex ID
\item DEG  - degree
\item iDEG - in-degree (directed graph only)
\item oDEG - out-degree (directed graph only)
\item BET  - betweenness for undirected graph
\item dBET - betweenness when directionality is taken into account
(directed graph only)
\item CC   - clustering coefficient
\item SL   - semilocal centrality
\item mnSP - mean shortest path
\item PR   - page rank  for undirected graph
\item dPR  - page rank when directionality is taken into account
(directed graph only)
\item sdSP - standard deviation of the shortest path
}
}
\description{
Calculate centrality measures for graph nodes.
}
\details{
The edge attribute \code{weights} treated differently by different functions
calculating centrality measures. For example,
\code{\link[igraph]{betweenness}} use \code{weights} as an edge length,
while in \code{\link[igraph]{page_rank}} "an edge with a larger weight is
more likely to be selected by the surfer", which infer the opposite meaning.
Taking into account that all methods in \code{\link{getClustering}} treat
edge \code{weights} in the same way as \code{\link[igraph]{page_rank}}, we
calculate the \code{distance}=1/\code{weights} as edge weights for
\code{BET}, \code{dBET}, \code{mnSP}, and \code{sdSP} values. So we treat
\code{weights} in the package consistently as the strength and closiness of
vertices, rather the distance between them.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.csv", package = "BioNAR")
tbl <- read.csv(file, sep="\t")
gg <- buildNetwork(tbl)
m<-getCentralityMatrix(gg)
}
