% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateNetwork.R
\name{getAnnotationVertexList}
\alias{getAnnotationVertexList}
\title{Return vertex list for each term in annotation attribute}
\usage{
getAnnotationVertexList(g, name, vid = "name", col = COLLAPSE)
}
\arguments{
\item{g}{graph to get annotation from}

\item{name}{annotation attribute name}

\item{vid}{attribute to be used as a vertex ID}

\item{col}{list separation character in attribute, by
default is \code{;}}
}
\value{
named list with annotation in Annotation Vertices form
}
\description{
For different purposes annotation of graph vertices could be
represented in three forms:
\describe{
\item{Pairs}{dataframe with vertex ID and annotation terms}
\item{Vertex Annotation}{list named with vertex ID and
containing terms annotating each vertex}
\item{Annotation Vertices}{list named with term and
containing vertex IDs}
}
}
\details{
This function takes Vertex Annotation from vertex attribute
and convert it to Annotation Vertices form.
}
\examples{
file <- system.file("extdata", "PPI_Presynaptic.gml", package = "BioNAR")
gg <- igraph::read_graph(file, format="gml")
avl<-getAnnotationVertexList(gg, 'TopOntoOVGHDOID')
head(avl)
}
