% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{calcCentralityInternalDistances}
\alias{calcCentralityInternalDistances}
\title{Function calculates a set of distance metrics between each vertex pair  given
a list of vertex centrality matrices}
\usage{
calcCentralityInternalDistances(l, keepOrder = FALSE, dist = "euclidean")
}
\arguments{
\item{l}{list of matrices, for example centrality obtained by invocation
\code{\link{getRandomGraphCentrality}}}

\item{keepOrder}{if FALSE values will be sorted before distance calculations}

\item{dist}{methods available from \code{\link{dist}} function}
}
\value{
matrix with seven columns containing distances between all pairs of
\code{l} elements.
}
\description{
Function calculates a set of distance metrics between each vertex pair  given
a list of vertex centrality matrices
}
\examples{
data(karate,package='igraphdata')
m<-getCentralityMatrix(karate)
gnp<-list()
for(i in 1:10){
    gnp[[i]]<-getRandomGraphCentrality(karate,type = 'gnp')
}
gnpIDist<-calcCentralityInternalDistances(gnp)
summary(gnpIDist)
}
\seealso{
getRandomGraphCentrality

getCentralityMatrix

calcCentralityExternalDistances
}
