% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runCentrality.R
\name{applpMatrixToGraph}
\alias{applpMatrixToGraph}
\title{Add attributes to the vertex.}
\usage{
applpMatrixToGraph(gg, m)
}
\arguments{
\item{gg}{igraph object}

\item{m}{matrix of values to be applied as vertex attributes.
matrix should contains column "ID" to map value to the vertex.}
}
\value{
modified igraph object
}
\description{
This function suits more for updating calculated vertex properties rather
than node annotation. For the later case use \code{\link{annotateVertex}}.
}
\details{
Unlike \code{\link{annotateVertex}}, which is able to collapse multiple
annotation terms, this function assume that vertex ID values are unique
in the \code{m} matrix and corresponds to the \code{name} vertex attribute.
If graph has no \code{name} vertex attribute error will be raised.
}
\examples{
g1 <- make_star(10, mode="undirected")
V(g1)$name <- letters[1:10]
m<-cbind(ID=letters[1:10],capital=LETTERS[1:10])
g1<-BioNAR::applpMatrixToGraph(g1,m)
V(g1)$capital
}
\seealso{
annotateVertex
}
