% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{setRanges}
\alias{setRanges}
\alias{setRanges,BSFDataSet-method}
\title{Setter method for the ranges of the BSFDataSet object
The GRanges object that holds the genomic ranges information can be replaced.}
\usage{
setRanges(object, ...)

\S4method{setRanges}{BSFDataSet}(object, newRanges, dropSeqlevels = TRUE, quiet = FALSE)
}
\arguments{
\item{object}{a \code{BSFDataSet} object}

\item{...}{additional arguments}

\item{newRanges}{an object of type \code{GRanges}}

\item{dropSeqlevels}{enforce seqnames to be the same in ranges and signal,
by dropping unused seqlevels which is required for most downstream functions
such as \code{coverageOverRanges}}

\item{quiet}{logical; whether to print messages}
}
\value{
object of type \code{\link{BSFDataSet}} with updated ranges
}
\description{
Setter method for the ranges of the BSFDataSet object
The GRanges object that holds the genomic ranges information can be replaced.
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

rng = getRanges(bds)
rng = rng + 10
bdsNew = setRanges(bds, rng)

}
\seealso{
\code{\link{BSFDataSet}}
}
