% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{exampleSCE}
\alias{exampleSCE}
\title{Create minimal \code{SingleCellExperiment} for documentation examples.}
\usage{
exampleSCE(nrow = 8, ncol = 12, n_genes = 100, n_PCs = 10)
}
\arguments{
\item{nrow}{Number of rows of spots}

\item{ncol}{Number of columns of spots}

\item{n_genes}{Number of genes to simulate}

\item{n_PCs}{Number of principal components to include}
}
\value{
A SingleCellExperiment object with simulated counts, corresponding
  logcounts and PCs, and positional data in \code{colData}. Spots are
  distributed over an (\code{nrow} x \code{ncol}) rectangle.
}
\description{
Create minimal \code{SingleCellExperiment} for documentation examples.
}
\details{
Inspired by scuttle's \code{mockSCE()}.
}
\examples{
set.seed(149)
sce <- exampleSCE()

}
