% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negative_binomial_check.R
\name{goodness_of_fit_DESeq2}
\alias{goodness_of_fit_DESeq2}
\title{This function calculates goodness-of-fit pvalues for all genes by looking at
how the NB model by DESeq2 fit the data}
\usage{
goodness_of_fit_DESeq2(
  se,
  count_matrix,
  condition,
  other_variables = NULL,
  num_genes = 500
)
}
\arguments{
\item{se}{the se object where all the data is contained}

\item{count_matrix}{name of the assay with gene expression matrix (in counts)}

\item{condition}{name of the se colData with the condition status}

\item{other_variables}{name of the se colData containing other variables of
interest that should be considered in the DESeq2 model}

\item{num_genes}{downsample value, default is 500 (or all genes if less)}
}
\value{
a matrix of pvalues where each row is a gene and each column is a
level within the condition of interest
}
\description{
This function calculates goodness-of-fit pvalues for all genes by looking at
how the NB model by DESeq2 fit the data
}
\examples{
# example code
library(scran)
se <- mockSCE(ncells = 20)
se$Treatment <- as.factor(se$Treatment)
se$Mutation_Status <- as.factor(se$Mutation_Status)
nb_results <- goodness_of_fit_DESeq2(se = se, count_matrix = "counts",
  condition = "Treatment", other_variables = "Mutation_Status")
nb_results[1]
nb_results[2]
nb_results[3]
}
