% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendrogram_color_palette.R
\name{dendrogram_color_palette}
\alias{dendrogram_color_palette}
\title{Dendrogram color palette}
\usage{
dendrogram_color_palette(col, dendrogram_info)
}
\arguments{
\item{col}{string object representing color of the label}

\item{dendrogram_info}{dendrogram_ends object}
}
\value{
annotation_color vector of colors corresponding to col variable
}
\description{
This function creates the color palette used in the dendrogram plotter
}
\examples{
library(scran)
se <- mockSCE()
process_dendro <- BatchQC::process_dendrogram(se, "counts")
dendrogram_ends <- process_dendro$dendrogram_ends
col <- process_dendro$condition_var
dendro_colors <- dendrogram_color_palette(col = "Treatment",
                                    dendrogram_info = dendrogram_ends)
dendro_colors

}
