% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BaalChIP-generics.R, R/BaalChIP-methods.R
\name{BaalChIP.report}
\alias{BaalChIP.report}
\alias{BaalChIP.report,BaalChIP-method}
\title{Method BaalChIP.report}
\usage{
BaalChIP.report(.Object)

\S4method{BaalChIP.report}{BaalChIP}(.Object)
}
\arguments{
\item{.Object}{An object of the \code{\link{BaalChIP}} class.}
}
\value{
A named list, with a data.frame per group.
}
\description{
Generates a data.frame per group with all variants and a label for all identified allele-specific binding (ASB) variants.
}
\details{
The reported data frame contains the following columns:
\itemize{
\item ID: unique identifier string per analysed variant.
\item CHROM: chromosome identifier from the reference genome per variant.
\item POS: the reference position (1-based).
\item REF: reference base. Each base must be one of A,C,G,T in uppercase.
\item ALT: alternate non-reference base. Each base must be one of A,C,G,T in uppercase.
\item REF.counts: pooled counts of all reads with the reference allele.
\item ALT.counts: pooled counts of all reads with the non-reference allele.
\item Total.counts: pooled counts of all reads (REF + ALT).
\item AR: allelic ratio calculated directly from sequencing reads (REF / TOTAL).
\item RMbias: numerical value indicating the value estimated and applied by BaalChIP for the reference mapping bias. A value between 0.5 and 1 denotes a bias to the reference allele, and a value between 0 and 0.5 a bias to the alternative allele.
\item RAF: numerical value indicating the value applied by BaalChIP for the relative allele frequency (RAF) bias correction. A value between 0.5 and 1 denotes a bias to the reference allele, and a value between 0 and 0.5 a bias to the alternative allele.
\item Bayes_lower: lower interval for the estimated allelic ratio (allelic ratio is given by REF / TOTAL).
\item Bayes_upper: upper interval for the estimated allelic ratio (allelic ratio is given by REF / TOTAL).
\item Corrected.AR: average estimated allelic ratio (average between Bayes_lower and Bayes_upper). A value between 0.5 and 1 denotes a bias to the reference allele, and a value between 0 and 0.5 a bias to the alternative allele.
\item isASB: logical value indicating BaalChIP's classification of variants into allele-specific.
}
}
\examples{
data('BaalObject')
report <- BaalChIP.report(BaalObject)

#the reported list is grouped by group_name:
names(report)

#check out the report for one of the groups:
head(report[['MCF7']])
}
\seealso{
\code{\link{summaryASB}}, \code{\link{getASB}}
}
\author{
Ines de Santiago
}
