% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS_EffectiveSize.R
\name{BASiCS_EffectiveSize}
\alias{BASiCS_EffectiveSize}
\alias{BASiCS_effectiveSize}
\title{Calculate effective sample size for BASiCS_Chain parameters}
\usage{
BASiCS_EffectiveSize(object, Parameter, na.rm = TRUE)

BASiCS_effectiveSize(...)
}
\arguments{
\item{object}{an object of class \code{\linkS4class{BASiCS_Chain}}.}

\item{Parameter}{The parameter to use to calculate effective sample size.
Possible
values: \code{'mu'}, \code{'delta'}, \code{'phi'}, \code{'s'}, 
\code{'nu'}, \code{'theta'}, \code{'beta'}, \code{'sigma2'} and 
\code{'epsilon'}.}

\item{na.rm}{Remove \code{NA} values before calculating effective sample 
size. Only relevant when \code{Parameter = "epsilon"} (genes with very low 
expression are excluding when infering the mean/over-dispersion trend. 
Default: \code{na.rm = TRUE}.}

\item{...}{Unused.}
}
\value{
A vector with effective sample sizes for all the elements 
of \code{Parameter}
}
\description{
A function to calculate effective sample size
\code{\linkS4class{BASiCS_Chain}} objects.
}
\examples{

data(ChainSC)
BASiCS_EffectiveSize(ChainSC, Parameter = "mu")

}
