\name{getProbeDataAffy}
\alias{getProbeDataAffy}
\title{Read a data file describing the probe sequences on an Affymetrix genechip}
\description{Read a data file describing the probe sequences on an Affymetrix genechip}
\usage{
getProbeDataAffy(arraytype, datafile, pkgname = NULL, comparewithcdf = FALSE)
}
\arguments{
  \item{arraytype}{Character. Array type (e.g. 'HG-U133A')}
  \item{datafile}{Character with the filename of the input data file,
    or a connection (see example).
    If omitted a default name is constructed from \code{arraytype}
    (for details you will need to consult this function's source code).}
  \item{pkgname}{Character. Package name. If NULL the name is derived
    from \code{arraytype}.}
  \item{comparewithcdf}{Logical. If TRUE, run a consistency check
    against a CDF package of the same name (what used to be Laurent's
    "extraparanoia".)}
}
\details{This function serves as an interface between
  the (1) representation of array probe information data in the packages
  that are generated by \code{\link{makeProbePackage}} and (2) the
  vendor- and possibly version-specific way the data are represented
  in \code{datafile}.

  \code{datafile} is a tabulator-separated file with one row per probe,
  and column names \code{'Probe X'}, \code{'Probe Y'},
  \code{'Probe Sequence'}, and \code{'Probe.Set.Name'}. See the vignette
  for an example.
}

\value{A list with three components
    \item{dataEnv}{an environment which contains the data frame with the
      probe sequences and the other probe data.}
    \item{symVal}{a named list of symbol value substitutions which can
      be used to customize the man pages. See
      \code{\link[Biobase:createPackage]{createPackage}}.}
    \item{pkgname}{a character with the package name; will be the same
      as the function parameter \code{pkgname} if it was specified;
      otherwise, the name is constructed from the parameter \code{arraytype}.}
}

\seealso{makeProbePackage}
\examples{
  ## Please refer to the vignette
}
\keyword{IO}
\keyword{utilities}
