% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_dataset.R, R/nmr_dataset_1D.R
\name{validate_nmr_dataset}
\alias{validate_nmr_dataset}
\alias{validate_nmr_dataset_1D}
\title{Validate nmr_dataset objects}
\usage{
validate_nmr_dataset(samples)

validate_nmr_dataset_1D(nmr_dataset_1D)
}
\arguments{
\item{samples}{An nmr_dataset object}

\item{nmr_dataset_1D}{An \link{nmr_dataset_1D} object}
}
\value{
Validate nmr_dataset objects

The \link{nmr_dataset_1D} unchanged

This function is useful for its side-effects. Stopping in case of error
}
\description{
Validate nmr_dataset objects

Validate 1D nmr datasets
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
validate_nmr_dataset(dataset)

dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
dataset_1D_validated <- validate_nmr_dataset_1D(dataset_1D)

}
\seealso{
Other class helper functions: 
\code{\link{format.nmr_dataset}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_peak_table}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{is.nmr_dataset_peak_table}()},
\code{\link{new_nmr_dataset}()},
\code{\link{new_nmr_dataset_1D}()},
\code{\link{new_nmr_dataset_peak_table}()},
\code{\link{print.nmr_dataset}()},
\code{\link{print.nmr_dataset_1D}()},
\code{\link{print.nmr_dataset_peak_table}()},
\code{\link{validate_nmr_dataset_family}()},
\code{\link{validate_nmr_dataset_peak_table}()}

Other class helper functions: 
\code{\link{format.nmr_dataset}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_peak_table}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{is.nmr_dataset_peak_table}()},
\code{\link{new_nmr_dataset}()},
\code{\link{new_nmr_dataset_1D}()},
\code{\link{new_nmr_dataset_peak_table}()},
\code{\link{print.nmr_dataset}()},
\code{\link{print.nmr_dataset_1D}()},
\code{\link{print.nmr_dataset_peak_table}()},
\code{\link{validate_nmr_dataset_family}()},
\code{\link{validate_nmr_dataset_peak_table}()}
}
\concept{class helper functions}
