% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenomicRanges.R
\name{to_GPos}
\alias{to_GPos}
\title{Create GenomicRanges Objects from AlphaMissense Annotations}
\usage{
to_GPos(tbl)
}
\arguments{
\item{tbl}{a tibble derived from \code{am_data("hg19")} or
\code{am_data("hg38")}. The tibble must have columns \code{CHROM}, \code{POS},
and \code{genome}.}
}
\value{
\code{to_GPos()} returns a \code{GPos} object, which can be used in
the same was a \code{GRanges} object for range-based filtering and
annotation
}
\description{
\code{to_GPos()} coerces a tibble derived from
\code{am_data("hg19")} or \code{am_data("hg38")} resources to
GenomicRanges \code{GPos} objects.
}
\examples{
am_data("hg38") |>
    filter(CHROM == "chr2", POS < 10000000, REF == "G") |>
    select(-REF) |>
    to_GPos()

}
