% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClinVar.R
\name{clinvar_data}
\alias{clinvar_data}
\alias{clinvar_plot}
\title{Integrate ClinVar Labels with AlphaMissense Pathogenicity Scores}
\usage{
clinvar_data(record = ALPHAMISSENSE_RECORD, bfc = BiocFileCache())

clinvar_plot(uniprotId, alphamissense_table, clinvar_table)
}
\arguments{
\item{record}{character(1) Zenodo record for the AlphaMissense data
resources.}

\item{bfc}{an object returned by \code{BiocFileCache()} representing the
location of the AlphaMissenseR database. The default is the
'global' BiocFileCache.}

\item{uniprotId}{\code{character()} a valid UniProt accession identifier.}

\item{alphamissense_table}{a table containing AlphaMissense
predictions for protein variants. By default, the table is
derived from \code{am_data("aa_substitution")}. Alternatively, a
user-defined \code{\link[tibble:tbl_df-class]{tibble::tbl_df}} or \code{\link{data.frame}}
can be supplied.}

\item{clinvar_table}{a table containing ClinVar information. By
default, the table is derived from the supplemental data of the
AlphaMissense paper. Alternatively, a user-defined
\code{\link[tibble:tbl_df-class]{tibble::tbl_df}} or \code{\link{data.frame}} can be
supplied.}
}
\value{
\code{clinvar_data()} returns a tbl with 82872 rows and 5 variables:
\itemize{
\item \code{variant_id}: ClinVar variant identifier.
\item \code{transcript_id}: Ensembl transcript identifier.
\item \code{protein_variant}: UniProt accession:protein variant identifier.
\item \code{AlphaMissense}: AlphaMissense pathogenicity score.
\item \code{label}: Binary ClinVar class, either "benign" or "pathogenic".
}

\code{clinvar_plot()} returns a \code{ggplot} object which overlays
ClinVar classifications onto AlphaMissense predicted
scores. Blue, gray, and red colors represent pathogenicity
classifications for "likely benign", "ambiguous", or
"likely pathogenic", respectively. Large, bolded points are
ClinVar variants colored according to their clinical
classification, while smaller points in the background are
AlphaMissense predictions.
}
\description{
\code{clinvar_data()} loads ClinVar information from the
supplemental table of the AlphaMissense
\href{https://www.science.org/doi/10.1126/science.adg7492}{[2023]}
paper.

\code{clinvar_plot()} integrates ClinVar classifications
with AlphaMissense predicted scores derived from
\code{am_data("aa_substitutions")} and returns a ggplot object for
visualization.
}
\details{
For \code{clinvar_plot()},  \code{alphamissense_table} columns must include:
\itemize{
\item \code{uniprot_id}: UniProt accession identifier.
\item \code{protein_variant}: variant identifier string, with protein
position in the middle, and the reference and mutant amino acid
residues to the left and right of the position, respectively.
\item \code{am_class}: AlphaMissense classification of either "benign",
"ambiguous", or "pathogenic".
\item \code{am_pathogenicity}: AlphaMissense predicted score.
}

\code{clinvar_table} columns must include:
\itemize{
\item \code{uniprot_id}: UniProt accession identifier, matching \code{alphamissense_table}.
\item \code{protein_variant}: variant identifier string, matching
\code{alphamissense_table} format.
\item \code{cv_class}: binary ClinVar classification of "benign" or "pathogenic".
}
}
\examples{
clinvar_data()

alphamissense_table <- am_data("aa_substitutions")

clinvar_plot(
    uniprotId = "P37023",
    alphamissense_table = alphamissense_table
)

}
\references{
Cheng et al.,
Accurate proteome-wide missense variant effect prediction with AlphaMissense.
\emph{Science} 381, eadg7492. DOI:10.1126/science.adg7492.
}
