% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxillary-methods.R
\docType{methods}
\name{import-bam}
\alias{import-bam}
\alias{impBamGAL}
\alias{impBamGAL,character-method}
\title{Import Bam}
\usage{
impBamGAL(UserDir, ...)

\S4method{impBamGAL}{character}(
  UserDir,
  searchArea,
  files = NULL,
  XStag = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{UserDir}{The relative or full path of folder containing bam files.}

\item{...}{arguments to pass on}

\item{searchArea}{A \code{GenomicRanges object} that contains the regions of
interest}

\item{files}{use character vector to specify one or more files to import. The
default imports all bam files from the directory.}

\item{XStag}{Setting \code{XStag=TRUE} stores the strand specific
information in the mcols slot 'XS'}

\item{verbose}{makes the function more talkative.}
}
\description{
Imports a specified genomic region from a bam file using a GRanges
object as search area.
}
\details{
If the sequence data is strand-specific you may want to set XStag=TRUE. The
strand specific information has then to be stored in the meta columns with
column name 'XS'. If the aligner did not set the XS-tag and the data is strand-
specific it is still be possible to infer the strand from the bit flags after importing
the reads to R. Depending on the strand-specific protocol different combinations of the
flags will have to be used. For illumina fr-secondstrand, 83 and 163 are minus strand
reads and 99 and 147 are plus strand reads.
}
\examples{

#Declare searchArea
searchArea <- GRanges(seqnames=c('17'), ranges=IRanges(79478301,79478361))

#Relative or full path
pathToFiles <- system.file('extdata/ERP000101_subset', package='AllelicImbalance')

#all files in directory
reads <- impBamGAL(pathToFiles,searchArea,verbose=FALSE)
#specified files in directory
reads <- impBamGAL(pathToFiles,searchArea,
			files=c("ERR009160.bam", "ERR009167.bam"),verbose=FALSE)

}
\author{
Jesper R. Gadin, Lasse Folkersen
}
\keyword{bam}
\keyword{import}
