% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBscore.R
\name{DBscore}
\alias{DBscore}
\title{Differential binding analysis}
\usage{
DBscore(se, design, coef, ...)
}
\arguments{
\item{se}{An \link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
object. Outputs of \link{getWeightedBindingScore}.}

\item{design}{Design table for \link[limma:lmFit]{lmFit}.}

\item{coef}{column number or column name specifying which coefficient or
contrast of the linear model is of interest.
See \link[limma:topTable]{topTable}.}

\item{...}{Parameters can be used by \link[limma:lmFit]{lmFit}.}
}
\value{
A RangedSummarizedExperiment object with the dataframe returned by
 \link[limma:topTable]{topTable} as appendence of the origin rowData.
}
\description{
Use limma to do differential binding analysis for binding
 scores.
}
\examples{
library(SummarizedExperiment)
set.seed(1)
sigma2 <- 0.05 / rchisq(100, df=10) * 10
y <- matrix(rnorm(100*6,sd=sqrt(sigma2)),100,6)
design <- cbind(Intercept=1,Group=c(0,0,0,1,1,1))
y[1,4:6] <- y[1,4:6] + 1
se <- SummarizedExperiment(assays=list(counts=y))
DBscore(se, design, coef=1)
}
\author{
Jianhong Ou
}
