% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragSizeDist.R
\name{fragSizeDist}
\alias{fragSizeDist}
\title{fragment size distribution}
\usage{
fragSizeDist(
  bamFiles,
  bamFiles.labels,
  index = bamFiles,
  ylim = NULL,
  logYlim = NULL
)
}
\arguments{
\item{bamFiles}{A vector of characters indicates the file names of bams.}

\item{bamFiles.labels}{labels of the bam files, used for pdf file naming.}

\item{index}{The names of the index file of the 'BAM' file being processed;
This is given without the '.bai' extension.}

\item{ylim}{numeric(2). ylim of the histogram.}

\item{logYlim}{numeric(2). ylim of log-transformed histogram for the insert.}
}
\value{
Invisible fragment length distribution list.
}
\description{
estimate the fragment size of bams
}
\examples{
bamFiles <- dir(system.file("extdata", package="ATACseqQC"), "GL.*.bam$", full.names=TRUE)
bamFiles.labels <- sub(".bam", "", basename(bamFiles))
fragSizeDist(bamFiles, bamFiles.labels)
}
\author{
Jianhong Ou
}
