% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_signs.R
\name{makeSignMatrix}
\alias{makeSignMatrix}
\title{Create a new SingleCellExperiment object for sign-by-sample matrices.}
\usage{
makeSignMatrix(sce = NULL, weight_strg = 0.5, weight_vari = 0.5)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{weight_strg}{A weight parameter for strongly correlated gene sets.}

\item{weight_vari}{A weight parameter for variably correlated gene sets.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function creates a new SingleCellExperiment object for sign-by-sample
  matrices (SSM) by concatenating SSMs for strongly and variably correlated
  gene sets.
}
\examples{
data(pbmc_eg)
data(human_GO_eg)
mat <- t(as.matrix(SummarizedExperiment::assay(pbmc_eg, "centered")))
pbmc_cormat <- cor(mat, method = "spearman")
pbmcs <- list(GO = pbmc_eg)
S4Vectors::metadata(pbmcs$GO) <- list(sign = human_GO_eg[["BP"]])
pbmcs$GO <- remove_signs(sce = pbmcs$GO, min_ngenes = 2, max_ngenes = 1000)
pbmcs$GO <- cluster_genesets(sce = pbmcs$GO, cormat = pbmc_cormat,
                             th_posi = 0.24, th_nega = -0.20)
pbmcs$GO <- create_signs(sce = pbmcs$GO, min_cnt_strg = 2, min_cnt_vari = 2)
pbmcs$GO <- makeSignMatrix(sce = pbmcs$GO, weight_strg = 0.5,
                           weight_vari = 0.5)
# The resutls can be check by, e.g., assay(pbmcs$GO, "counts").

}
