% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_signs.R
\name{create_signs}
\alias{create_signs}
\title{Define signs for strongly and variably correlated gene sets.}
\usage{
create_signs(sce = NULL, min_cnt_strg = 2, min_cnt_vari = 2)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{min_cnt_strg}{An integer for the cutoff value for strongly correlated
gene sets.}

\item{min_cnt_vari}{An integer for the cutoff value for variably correlated
gene sets.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function define signs for strongly and variably correlated gene sets.
}
\examples{
data(pbmc_eg)
data(human_GO_eg)
mat <- t(as.matrix(SummarizedExperiment::assay(pbmc_eg, "centered")))
pbmc_cormat <- cor(mat, method = "spearman")
pbmcs <- list(GO = pbmc_eg)
S4Vectors::metadata(pbmcs$GO) <- list(sign = human_GO_eg[["BP"]])
pbmcs$GO <- remove_signs(sce = pbmcs$GO, min_ngenes = 2, max_ngenes = 1000)
pbmcs$GO <- cluster_genesets(sce = pbmcs$GO, cormat = pbmc_cormat,
                             th_posi = 0.24, th_nega = -0.20)
pbmcs$GO <- create_signs(sce = pbmcs$GO, min_cnt_strg = 2, min_cnt_vari = 2)
# The results are stored in `metadata(pbmcs$GO)$sign_all`.

}
