% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{clip_residuals}
\alias{clip_residuals}
\title{Perform clipping of residuals}
\usage{
clip_residuals(S, cutoff = sqrt(ncol(S)))
}
\arguments{
\item{S}{Matrix of residuals.}

\item{cutoff}{Value above/below which clipping should happen.}
}
\value{
Matrix of clipped residuals.
}
\description{
Clips Pearson or negative-binomial residuals above or below a determined
value. For Pearson (Poisson) residuals it is set by default for 1, for NB at
sqrt(n).
}
\references{
Lause, J., Berens, P. & Kobak, D. Analytic Pearson residuals for
normalization of single-cell RNA-seq UMI data. Genome Biol 22, 258 (2021).
https://doi.org/10.1186/s13059-021-02451-7
}
