% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{calc_residuals}
\alias{calc_residuals}
\title{Calculate residuals for Correspondence analysis}
\usage{
calc_residuals(mat, residuals = "pearson", clip = FALSE, cutoff = NULL)
}
\arguments{
\item{mat}{A numerical matrix or coercible to one by `as.matrix()`.
Should have row and column names.}

\item{residuals}{character string. Specifies which kind of residuals should
be calculated. Can be "pearson" (default), "freemantukey" or "NB" for
negative-binomial.}

\item{clip}{logical. Whether residuals should be clipped if they are
higher/lower than a specified cutoff}

\item{cutoff}{numeric. Residuals that are larger than cutoff or lower than
-cutoff are clipped to cutoff.}
}
\value{
A named list. The elements are:
\itemize{
\item "S": standardized residual matrix.
\item "tot": grand total of the original matrix.
\item "rowm": row masses.
\item "colm": column masses.
}
}
\description{
\code{calc_residuals} provides optional residuals as the basis for Correspondence
Analysis
}
