% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{cacomp_slot}
\alias{cacomp_slot}
\title{Access slots in a cacomp object}
\usage{
cacomp_slot(caobj, slot)
}
\arguments{
\item{caobj}{a cacomp object}

\item{slot}{slot to return}
}
\value{
Chosen slot of the cacomp object
}
\description{
Access slots in a cacomp object
}
\examples{
# Simulate scRNAseq data.
cnts <- data.frame(cell_1 = rpois(10, 5),
                   cell_2 = rpois(10, 10),
                   cell_3 = rpois(10, 20))
rownames(cnts) <- paste0("gene_", 1:10)
cnts <- as.matrix(cnts)

# Run correspondence analysis.
ca <- cacomp(obj = cnts, princ_coords = 3, top = 5)

# access left singular vectors
cacomp_slot(ca, "U")

}
