% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{cacomp_names}
\alias{cacomp_names}
\title{Prints slot names of cacomp object}
\usage{
cacomp_names(caobj)
}
\arguments{
\item{caobj}{a cacomp object}
}
\value{
Prints slot names of cacomp object
}
\description{
Prints slot names of cacomp object
}
\examples{
# Simulate scRNAseq data.
cnts <- data.frame(cell_1 = rpois(10, 5),
                   cell_2 = rpois(10, 10),
                   cell_3 = rpois(10, 20))
rownames(cnts) <- paste0("gene_", 1:10)
cnts <- as.matrix(cnts)

# Run correspondence analysis.
ca <- cacomp(obj = cnts, princ_coords = 3, top = 5)

# show slot names:
cacomp_names(ca)

}
