% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{normalFactors}
\alias{normalFactors}
\title{Estimating size factors from the reads count table}
\usage{
normalFactors(object)
}
\arguments{
\item{object}{a ABSSeq object with element of 'counts' and 'normMethod', see the constructor functions
\code{\link{ABSDataSet}}.}
}
\value{
a ABSDataSet object with the estimates size factors, one element per column. Use the \code{\link{sFactors}}
to show it.
}
\description{
Function for esitmating size factors
}
\details{
Given a matrix of count data, this function esitmates the size
factors by selected method.
It aslo provides four different methods for normalizing according to user-defined size factors,
total reads, up quantile (75%), qtotal (\code{\link{qtotalNormalized}}), TMM (edgeR) or geometric from DESeq (See \code{\link{estimateSizeFactorsForMatrix}}).
}
\examples{

data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
obj <- normalFactors(obj)
sFactors(obj)

}
