% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{genAFold}
\alias{genAFold}
\title{Calculate parameters for differential expression test base on absolute counts differences}
\usage{
genAFold(nncounts, cond, preval = 0.05, qforkappa = 0, pair = FALSE,
  priorgenesd)
}
\arguments{
\item{nncounts}{matrix for read count.}

\item{cond}{factor for conditions. If provide only one condition, fold-change estimation will be suppressed.}

\item{preval}{pre-defined scale control for variance normalization, default is 0.05, a large value generally increases the fold-changes (decreases penalty of variances) under low expression.}

\item{qforkappa}{quantile for estimating kappa(>=qforkappa), default is 0 (without trimming of data). Please set up a value in [0,1) if you want to trim the low expressed data.}

\item{pair}{switch for paired samples, default is false}

\item{priorgenesd}{prior value  for general SD of fold change, if provided, the estimation of general SD will be replaced by this value.}
}
\value{
A list with log2 foldchange, general SD for calculating pvalue, variance stabilized counts and expression level adjusted counts (used for PCA analysis)
}
\description{
Calculate aFold for each gene and general sd
}
\details{
shifted and calculate a set of parameters from normalized counts table before \code{\link{callDEs}}
}
\note{
This function should run after \code{\link{normalFactors}}.
}
\examples{

data(simuN5)
obj <- ABSDataSet(counts=simuN5$counts, groups=factor(simuN5$groups))
mtx <- counts(obj,TRUE)
aFold <- genAFold(mtx,factor(simuN5$groups))
hist(aFold[[1]])

}
