## ----message=FALSE, warning=FALSE,results='hide'------------------------------
library(crisprDesign)

## -----------------------------------------------------------------------------
data(BE4max, package="crisprBase")
BE4max

## -----------------------------------------------------------------------------
crisprBase::editingWeights(BE4max)["C2T",]

## -----------------------------------------------------------------------------
data(grListExample, package="crisprDesign")

## -----------------------------------------------------------------------------
gr <- queryTxObject(txObject=grListExample,
                    featureType="cds",
                    queryColumn="gene_symbol",
                    queryValue="IQSEC3")

## -----------------------------------------------------------------------------
gr <- gr[1]

## ----warning=FALSE, message=FALSE---------------------------------------------
library(BSgenome.Hsapiens.UCSC.hg38)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38
guideSet <- findSpacers(gr,
                        bsgenome=bsgenome,
                        crisprNuclease=BE4max,
                        strict_overlap=FALSE)
guideSet

## -----------------------------------------------------------------------------
guideSet <- guideSet[c(50,51)]
print(guideSet)

## -----------------------------------------------------------------------------
txid <- "ENST00000538872"
txTable <- getTxInfoDataFrame(tx_id=txid,
                              txObject=grListExample,
                              bsgenome=bsgenome,
                              extend=30)
head(txTable)

## -----------------------------------------------------------------------------
editingWindow <- c(-20,-8)
guideSet <- addEditedAlleles(guideSet,
                             baseEditor=BE4max,
                             txTable=txTable,
                             editingWindow=editingWindow,
                             minEditingWeight = 0,
                             minMutationScore = 0.3)

## -----------------------------------------------------------------------------
alleles <- editedAlleles(guideSet[1])
print(alleles)

## -----------------------------------------------------------------------------
metadata(alleles)

## -----------------------------------------------------------------------------
head(guideSet)

## -----------------------------------------------------------------------------
sessionInfo()

