## ----setup, echo=FALSE, results="hide", warning=FALSE-------------------------
knitr::opts_chunk$set(warning = FALSE, message = FALSE)

## ----installation, eval=FALSE-------------------------------------------------
# if (!require("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("annoLinker")

## ----loadlibrary,warning = FALSE,message=FALSE--------------------------------
library(annoLinker)
library(rtracklayer)
library(TxDb.Drerio.UCSC.danRer10.refGene)
library(org.Dr.eg.db)

## ----quickstart---------------------------------------------------------------
txdb <- TxDb.Drerio.UCSC.danRer10.refGene
org <- org.Dr.eg.db
extPath <- system.file("extdata", package = "annoLinker")
## load peaks
peaks <- rtracklayer::import(file.path(extPath, "peaks.bed"))
## load interactions
interactions <- rtracklayer::import(file.path(extPath, "interaction.bedpe"))
## load annotation data
annoData <- genes(txdb)
anno <- annoLinker(peaks, annoData, interactions, verbose = TRUE)
class(anno)
head(anno, n = 2)
anno_peaks(anno)[c(1, 2)]
head(as(anno, "GRanges"), n = 2)

## ----datavisualization--------------------------------------------------------
## plot the evidence for the first annotation
plotEvidence(anno,
    event = 1,
    output = "htmlWidget"
)
plotEvidence(anno,
    event = 1,
    output = "trackPlot",
    txdb = TxDb.Drerio.UCSC.danRer10.refGene,
    org = org.Dr.eg.db
)

## ----sessioninfo, echo=FALSE--------------------------------------------------
sessionInfo()

