## ----setup, message = FALSE, warning = FALSE, comment = NA, include=FALSE-----
knitr::opts_chunk$set(message = FALSE, warning = FALSE, comment = NA, 
                      fig.width = 6.25, fig.height = 5)
library(tidyverse)
library(DT)
options(DT.options = list(
  initComplete = JS("function(settings, json) {",
  "$(this.api().table().header()).css({'background-color': 
  '#000', 'color': '#fff'});","}")))

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("devtools", quietly = TRUE))
#     install.packages("devtools")
# devtools::install_github("BoYuan07/MetaDICT", build_vignettes = TRUE)

## -----------------------------------------------------------------------------
# load the package
library(MetaDICT)

## -----------------------------------------------------------------------------
# load data
data("exampleData")
O = exampleData$O
meta = exampleData$meta
dist_mat = exampleData$dist_mat
taxonomy = exampleData$taxonomy
tree = exampleData$tree

## -----------------------------------------------------------------------------
# batch label
batchid = meta$batch

# PCoA plot
pcoa_plot_discrete(O,batchid,"Batch")

## -----------------------------------------------------------------------------
# sample covariate
Y = meta$Y

# PCoA plot
pcoa_plot_discrete(O,Y,"Sample", colorset = "Set2")

## -----------------------------------------------------------------------------
plot_singular_values(O, meta)

## -----------------------------------------------------------------------------
# main function of MetaDICT
metadict_res = MetaDICT(O, meta, distance_matrix = dist_mat)

X = metadict_res$count
D = metadict_res$D
R_list = metadict_res$R
w = metadict_res$w
meta_output = metadict_res$meta

## -----------------------------------------------------------------------------
# PCoA plot of batch variable
pcoa_plot_discrete(X,batchid,"Batch")

# PCoA plot of sample covariate
pcoa_plot_discrete(X,Y,"Sample",colorset = "Set2")

## -----------------------------------------------------------------------------
metadict_res1 = MetaDICT(O, meta, tree = tree)
X1 = metadict_res1$count

## -----------------------------------------------------------------------------
# PCoA plot of batch variable
pcoa_plot_discrete(X1,batchid,"Batch")

# PCoA plot of sample covariate
pcoa_plot_discrete(X1,Y,"Sample",colorset = "Set2")

## -----------------------------------------------------------------------------
metadict_res2 = MetaDICT(O, meta, taxonomy = taxonomy, tax_level = "order")
X2 = metadict_res2$count

## -----------------------------------------------------------------------------
# PCoA plot of batch variable
pcoa_plot_discrete(X2,batchid,"Batch")

# PCoA plot of sample covariate
pcoa_plot_discrete(X2,Y,"Sample",colorset = "Set2")

## -----------------------------------------------------------------------------
metadict_res3 = MetaDICT(O,meta,covariates = c("Y2"), 
                         distance_matrix = dist_mat)
X3 = metadict_res3$count

## -----------------------------------------------------------------------------
# PCoA plot of batch variable
pcoa_plot_discrete(X3,batchid,"Batch")

# PCoA plot of sample covariate
pcoa_plot_discrete(X3,Y,"Sample",colorset = "Set2")

## -----------------------------------------------------------------------------
metadict_res4 = MetaDICT(O,meta,distance_matrix = dist_mat,
                         customize_parameter = TRUE, alpha = 0.01, beta = 0.01)

## -----------------------------------------------------------------------------
# load the data
data("exampleData_transfer")
new_data = exampleData_transfer$new_data
new_meta = exampleData_transfer$new_meta

# add new dataset to previous result
new_data_res = metadict_add_new_data(new_data, new_meta, metadict_res)

# corrected count
new_count = new_data_res$count

# integrate count tables
all_count_raw = cbind(X,new_data)
all_count_corrected = cbind(X,new_count)
covariates <- intersect(colnames(meta), colnames(new_meta))
all_meta = rbind(meta[,covariates, drop = FALSE],new_meta[,covariates, drop = FALSE])

## -----------------------------------------------------------------------------
# PCoA plot of batch variable
pcoa_plot_discrete(all_count_raw,all_meta$batch,"Batch")

# PCoA plot of sample covariate
pcoa_plot_discrete(all_count_raw,all_meta$Y,"Sample",colorset = "Set2")

## -----------------------------------------------------------------------------
# PCoA plot of batch variable
pcoa_plot_discrete(all_count_corrected,all_meta$batch,"Batch")

# PCoA plot of sample covariate
pcoa_plot_discrete(all_count_corrected,all_meta$Y,"Sample",colorset = "Set2")

## -----------------------------------------------------------------------------
library(ggraph)

## -----------------------------------------------------------------------------
D = metadict_res4$D
plot(diag(t(D)%*%(D)), ylab = "Column-wise Squared Norm")

## -----------------------------------------------------------------------------
D_filter = D[,1:20]
taxa_c = community_detection(D_filter, max_k = 5)
taxa_cluster = taxa_c$cluster
taxa_graph = taxa_c$graph
ggraph(taxa_graph, layout = "stress") +  
    geom_node_point(aes(color = as.factor(taxa_cluster)), size = 2) +  
    scale_color_brewer(palette = "Set1", name = "Taxa Cluster") + 
    theme_bw() +
    xlab("") +
    ylab("") +
    theme(
        legend.position = "right",  
        legend.title = element_text(size = 12, face = "bold"),  
        legend.text = element_text(size = 10)  
    )

## -----------------------------------------------------------------------------
sessionInfo()

