/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.AbstractNativeAppSAXParser;
import org.biojava.bio.program.sax.QName;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class FastaSequenceSAXParser
extends AbstractNativeAppSAXParser {
    private AttributesImpl oAtts = new AttributesImpl();
    private ArrayList oHeader = new ArrayList();
    private QName oAttQName = new QName(this);
    private char[] aoChars;
    private StringBuffer oSeqName = new StringBuffer();
    private StringBuffer oSeq = new StringBuffer();
    private boolean tOnFirst = true;
    private static final int STARTUP = 0;
    private static final int IN_STREAM = 1;

    public FastaSequenceSAXParser() {
        this.iState = 0;
        this.setNamespacePrefix("biojava");
    }

    private void appendSequence(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\t\r ");
        while (stringTokenizer.hasMoreTokens()) {
            this.oSeq.append(stringTokenizer.nextToken());
        }
    }

    private void emitSequence() throws SAXException {
        this.oAtts.clear();
        this.oAttQName.setQName("sequenceName");
        this.oAtts.addAttribute(this.oAttQName.getURI(), this.oAttQName.getLocalName(), this.oAttQName.getQName(), "CDATA", this.oSeqName.toString());
        this.startElement(new QName(this, this.prefix("Sequence")), this.oAtts);
        this.aoChars = this.oSeq.toString().toCharArray();
        this.characters(this.aoChars, 0, this.aoChars.length);
        this.endElement(new QName(this, this.prefix("Sequence")));
    }

    private void interpret(BufferedReader bufferedReader, String string) throws SAXException {
        if (this.iState == 0) {
            this.oAtts.clear();
            this.startElement(new QName(this, this.prefix("SequenceCollection")), this.oAtts);
            this.changeState(1);
        }
        if (this.iState == 1) {
            if (string.startsWith(">")) {
                if (!this.tOnFirst) {
                    this.emitSequence();
                }
                this.parseHeaderLine(string);
                this.oSeq.setLength(0);
                return;
            }
            this.appendSequence(string);
        }
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        String string = null;
        BufferedReader bufferedReader = this.getContentStream(inputSource);
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                this.interpret(bufferedReader, string);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
            System.out.println("Stream read interupted");
        }
        this.emitSequence();
        this.endElement(new QName(this, this.prefix("SequenceCollection")));
        bufferedReader.close();
    }

    private void parseHeaderLine(String string) {
        this.oSeqName.setLength(0);
        this.oSeqName.append(string.substring(1));
        this.tOnFirst = false;
    }
}

