## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----server-start-------------------------------------------------------------
# library(bettr)
# 
# # Basic server mode
# bettr(serverMode = TRUE)
# 
# # With cache versioning
# bettr(serverMode = TRUE, cacheVersion = "v1.0")
# 
# # Custom theme
# bettr(serverMode = TRUE, bstheme = "flatly")

## ----json-from-dataframe------------------------------------------------------
# library(bettr)
# 
# # Create benchmark data
# benchmark_data <- data.frame(
#     Method = c("AlgorithmA", "AlgorithmB", "AlgorithmC"),
#     Accuracy = c(0.95, 0.92, 0.89),
#     Speed = c(120, 150, 100),
#     Memory = c(256, 512, 128)
# )
# 
# # Add metric metadata
# metric_info <- data.frame(
#     Metric = c("Accuracy", "Speed", "Memory"),
#     Type = c("Quality", "Performance", "Resource"),
#     Unit = c("Proportion", "ms", "MB")
# )
# 
# # Define initial transformations
# transforms <- list(
#     Speed = list(flip = TRUE, transform = "[0,1]"),
#     Memory = list(flip = TRUE, transform = "[0,1]")
# )
# 
# # Create SummarizedExperiment
# bettrSE <- assembleSE(
#     df = benchmark_data,
#     idCol = "Method",
#     metricInfo = metric_info,
#     initialTransforms = transforms
# )
# 
# # Export to JSON
# json_file <- tempfile(fileext = ".json")
# bettrToJSON(bettrSE, file = json_file)

## ----json-from-se-------------------------------------------------------------
# # If you already have a SummarizedExperiment
# json_file <- tempfile(fileext = ".json")
# bettrToJSON(my_existing_SE, file = json_file)
# 
# # Get JSON as string (for programmatic use)
# json_string <- bettrToJSON(my_existing_SE, file = NULL)

## ----json-read----------------------------------------------------------------
# # Read from file
# bettrSE <- bettrFromJSON(file = "benchmark_results.json")
# 
# # Read from JSON string
# bettrSE <- bettrFromJSON(json = json_string)
# 
# # Use in non-server mode
# bettr(bettrSE = bettrSE)

## ----url-jsonurl--------------------------------------------------------------
# # Start server
# bettr(serverMode = TRUE)
# 
# # Construct URL
# base_url <- "http://localhost:4567"
# data_url <- "https://raw.githubusercontent.com/user/repo/main/results.json"
# full_url <- paste0(base_url, "/?jsonUrl=", URLencode(data_url, reserved = TRUE))
# 
# # Open in browser
# browseURL(full_url)

## ----url-jsonfile-------------------------------------------------------------
# # Start server
# bettr(serverMode = TRUE)
# 
# # Construct URL
# base_url <- "http://localhost:4567"
# file_path <- "/Users/username/benchmarks/latest_results.json"
# full_url <- paste0(base_url, "/?jsonFile=", URLencode(file_path, reserved = TRUE))
# 
# # Open in browser
# browseURL(full_url)

## ----url-jsonfile-example-----------------------------------------------------
# # Start server
# bettr(serverMode = TRUE)
# 
# # Get path to included example JSON file
# json_path <- system.file("extdata", "duo2018_bettr.json", package = "bettr")
# 
# # Construct URL
# base_url <- "http://localhost:4567"
# full_url <- paste0(base_url, "/?jsonFile=", URLencode(json_path, reserved = TRUE))
# 
# # Open in browser
# browseURL(full_url)

## ----cache-versioning---------------------------------------------------------
# # Deploy version 1.0
# bettr(serverMode = TRUE, cacheVersion = "v1.0")
# 
# # Later, deploy version 1.1 with breaking changes
# bettr(serverMode = TRUE, cacheVersion = "v1.1")

## ----version-formats----------------------------------------------------------
# # Semantic versioning
# cacheVersion = "v1.2.3"
# 
# # Date-based
# cacheVersion = "2025-10-07"
# 
# # Build numbers
# cacheVersion = "build-456"
# 
# # Custom
# cacheVersion = "production-release-oct2025"

## ----session-info-------------------------------------------------------------
sessionInfo()

