/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.tuple;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.iterator.PDoubleSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PIntegerSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PLongSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PObjectSequenceIterator;
import com.oracle.graal.python.builtins.objects.iterator.PSequenceIterator;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotHashFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotRichCompare;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSqContains;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyTupleCheckExactNode;
import com.oracle.graal.python.lib.PyTupleCheckNode;
import com.oracle.graal.python.lib.PyTupleGetItem;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.lib.RichCmpOp;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.DoubleSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.IntSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.LongSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTuple})
public final class TupleBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TupleBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TupleBuiltinsFactory.getFactories();
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetNewargsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PTuple doIt(Object self, @Bind Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, new Object[]{PFactory.createTuple(language, getTupleStorage.execute(inliningTarget, self))});
        }
    }

    @Slot(value=Slot.SlotKind.tp_hash, isComplex=true)
    @GenerateNodeFactory
    public static abstract class HashNode
    extends TpSlotHashFun.HashBuiltinNode {
        protected static long HASH_UNSET = -1L;

        @Specialization(guards={"self.getHash() != HASH_UNSET"})
        long getHash(PTuple self) {
            return self.getHash();
        }

        @Specialization(guards={"self.getHash() == HASH_UNSET"})
        long computeHash(VirtualFrame frame, PTuple self, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="hash") @Cached PyObjectHashNode hashNode) {
            long hash = HashNode.doComputeHash(frame, inliningTarget, getItemNode, hashNode, self.getSequenceStorage());
            self.setHash(hash);
            return hash;
        }

        @Specialization
        long computeHash(VirtualFrame frame, PythonAbstractNativeObject self, @Bind Node inliningTarget, @Cached.Shared(value="getItem") @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached.Shared(value="hash") @Cached PyObjectHashNode hashNode, @Cached TupleNodes.GetNativeTupleStorage getStorage) {
            return HashNode.doComputeHash(frame, inliningTarget, getItemNode, hashNode, getStorage.execute(self));
        }

        private static long doComputeHash(VirtualFrame frame, Node inliningTarget, SequenceStorageNodes.GetItemNode getItemNode, PyObjectHashNode hashNode, SequenceStorage tupleStore) {
            int len = tupleStore.length();
            long multiplier = 1000003L;
            long hash = 3430008L;
            for (int i = 0; i < len; ++i) {
                Object item = getItemNode.execute(tupleStore, i);
                long tmp = hashNode.execute((Frame)frame, inliningTarget, item);
                hash = (hash ^ tmp) * multiplier;
                multiplier += (long)(82520 + len + len);
            }
            if ((hash += 97531L) == -1L) {
                hash = -2L;
            }
            return hash;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"isIntStorage(primary)"})
        static PIntegerSequenceIterator doPTupleInt(PTuple primary, @Bind PythonLanguage language) {
            return PFactory.createIntegerSequenceIterator(language, (IntSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isObjectStorage(primary)"})
        static PObjectSequenceIterator doPTupleObject(PTuple primary, @Bind PythonLanguage language) {
            return PFactory.createObjectSequenceIterator(language, (ObjectSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isLongStorage(primary)"})
        static PLongSequenceIterator doPTupleLong(PTuple primary, @Bind PythonLanguage language) {
            return PFactory.createLongSequenceIterator(language, (LongSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"isDoubleStorage(primary)"})
        static PDoubleSequenceIterator doPTupleDouble(PTuple primary, @Bind PythonLanguage language) {
            return PFactory.createDoubleSequenceIterator(language, (DoubleSequenceStorage)primary.getSequenceStorage(), primary);
        }

        @Specialization(guards={"!isIntStorage(primary)", "!isLongStorage(primary)", "!isDoubleStorage(primary)"})
        static PSequenceIterator doPTuple(PTuple primary, @Bind PythonLanguage language) {
            return PFactory.createSequenceIterator(language, primary);
        }

        @Specialization
        static PSequenceIterator doNativeTuple(PythonAbstractNativeObject primary, @Bind PythonLanguage language) {
            return PFactory.createSequenceIterator(language, primary);
        }
    }

    @Slot(value=Slot.SlotKind.sq_contains, isComplex=true)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends TpSlotSqContains.SqContainsBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        boolean contains(VirtualFrame frame, Object self, Object other, @Bind Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached SequenceStorageNodes.ContainsNode containsNode) {
            return containsNode.execute(frame, inliningTarget, getTupleStorage.execute(inliningTarget, self), other);
        }
    }

    @Slot(value=Slot.SlotKind.sq_repeat, isComplex=true)
    @GenerateNodeFactory
    static abstract class MulNode
    extends TpSlotSizeArgFun.SqRepeatBuiltinNode {
        MulNode() {
        }

        @Specialization
        static Object doTuple(VirtualFrame frame, Object left, int repeats, @Bind Node inliningTarget, @Cached PyTupleCheckExactNode checkTuple, @Cached TupleNodes.GetTupleStorage getLeft, @Cached InlinedConditionProfile isSingleRepeat, @Cached SequenceStorageNodes.RepeatNode repeatNode) {
            if (isSingleRepeat.profile(inliningTarget, repeats == 1 && checkTuple.execute(inliningTarget, left))) {
                return left;
            }
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), repeatNode.execute(frame, getLeft.execute(inliningTarget, left), repeats));
        }
    }

    @Slot(value=Slot.SlotKind.sq_concat, isComplex=true)
    @GenerateNodeFactory
    static abstract class TupleConcatNode
    extends TpSlotBinaryFunc.SqConcatBuiltinNode {
        TupleConcatNode() {
        }

        @Specialization(guards={"checkRight.execute(inliningTarget, right)"}, limit="1")
        static PTuple doTuple(Object left, Object right, @Bind Node inliningTarget, @Cached PyTupleCheckNode checkRight, @Cached TupleNodes.GetTupleStorage getLeft, @Cached TupleNodes.GetTupleStorage getRight, @Cached SequenceStorageNodes.ConcatListOrTupleNode concatNode, @Bind PythonLanguage language) {
            SequenceStorage leftStorage = getLeft.execute(inliningTarget, left);
            SequenceStorage rightStorage = getRight.execute(inliningTarget, right);
            SequenceStorage concatenated = concatNode.execute(inliningTarget, leftStorage, rightStorage);
            return PFactory.createTuple(language, concatenated);
        }

        @Fallback
        static Object doGeneric(Object left, Object right, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.CAN_ONLY_CONCAT_S_NOT_P_TO_S, "tuple", right, "tuple");
        }
    }

    @Slot(value=Slot.SlotKind.tp_richcompare, isComplex=true)
    @GenerateNodeFactory
    static abstract class TupleRichCmpNode
    extends TpSlotRichCompare.RichCmpBuiltinNode {
        TupleRichCmpNode() {
        }

        @Specialization
        static Object doTuple(VirtualFrame frame, Object left, Object right, RichCmpOp op, @Bind Node inliningTarget, @Cached PyTupleCheckNode checkLeft, @Cached PyTupleCheckNode checkRight, @Cached InlinedConditionProfile tupleCheckProfile, @Cached TupleNodes.GetTupleStorage getLeft, @Cached TupleNodes.GetTupleStorage getRight, @Cached SequenceStorageNodes.CmpNode cmp) {
            if (tupleCheckProfile.profile(inliningTarget, !checkLeft.execute(inliningTarget, left) || !checkRight.execute(inliningTarget, right))) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            return cmp.execute(frame, inliningTarget, getLeft.execute(inliningTarget, left), getRight.execute(inliningTarget, right), false, null, null, op);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    public static abstract class GetItemNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        @Specialization
        static Object doIt(VirtualFrame frame, Object self, Object idx, @Bind Node inliningTarget, @Cached InlinedConditionProfile validProfile, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode raiseNode, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached SequenceStorageNodes.SequenceStorageMpSubscriptNode subscriptNode) {
            if (!validProfile.profile(inliningTarget, SequenceStorageNodes.SequenceStorageMpSubscriptNode.isValidIndex(inliningTarget, idx, indexCheckNode))) {
                GetItemNode.raiseNonIntIndex(inliningTarget, raiseNode, idx);
            }
            return subscriptNode.execute(frame, inliningTarget, getTupleStorage.execute(inliningTarget, self), idx, ErrorMessages.TUPLE_OUT_OF_BOUNDS, PFactory::createTuple);
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseNonIntIndex(Node inliningTarget, PRaiseNode raiseNode, Object index) {
            raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "tuple", index);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    public static abstract class TupleSqItem
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        @Specialization
        static Object doIt(Object self, int index, @Bind Node inliningTarget, @Cached PyTupleGetItem getItem) {
            return getItem.execute(inliningTarget, self, index);
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        private static final TruffleString NULL = PythonUtils.tsLiteral("(null)");

        public abstract TruffleString execute(VirtualFrame var1, Object var2);

        public static TruffleString toString(VirtualFrame frame, Node inliningTarget, Object item, PyObjectReprAsTruffleStringNode reprNode) {
            if (item != null) {
                return reprNode.execute((Frame)frame, inliningTarget, item);
            }
            return NULL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public static TruffleString repr(VirtualFrame frame, Object self, @Bind Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage tupleStore = getTupleStorage.execute(inliningTarget, self);
            int len = tupleStore.length();
            if (len == 0) {
                return StringLiterals.T_EMPTY_PARENS;
            }
            if (!PythonContext.get(reprNode).reprEnter(self)) {
                return StringLiterals.T_ELLIPSIS_IN_PARENS;
            }
            try {
                TruffleStringBuilder buf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_LPAREN);
                for (int i = 0; i < len - 1; ++i) {
                    appendStringNode.execute(buf, (AbstractTruffleString)ReprNode.toString(frame, inliningTarget, getItemNode.execute(tupleStore, i), reprNode));
                    appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                }
                if (len > 0) {
                    appendStringNode.execute(buf, (AbstractTruffleString)ReprNode.toString(frame, inliningTarget, getItemNode.execute(tupleStore, len - 1), reprNode));
                }
                if (len == 1) {
                    appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_COMMA);
                }
                appendStringNode.execute(buf, (AbstractTruffleString)StringLiterals.T_RPAREN);
                TruffleString truffleString = toStringNode.execute(buf);
                return truffleString;
            }
            finally {
                PythonContext.get(reprNode).reprLeave(self);
            }
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.sq_length), @Slot(value=Slot.SlotKind.mp_length)})
    @GenerateUncached
    @GenerateNodeFactory
    public static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        @Specialization
        public int len(Object self, @Bind Node inliningTarget, @Cached PyTupleSizeNode pyTupleSizeNode) {
            return pyTupleSizeNode.execute(inliningTarget, self);
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class CountNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static long count(VirtualFrame frame, Object self, Object value, @Bind Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached(value="createNotNormalized()") SequenceStorageNodes.GetItemNode getItemNode, @Cached PyObjectRichCompareBool eqNode) {
            long count = 0L;
            SequenceStorage tupleStore = getTupleStorage.execute(inliningTarget, self);
            for (int i = 0; i < tupleStore.length(); ++i) {
                Object seqItem = getItemNode.execute(tupleStore, i);
                if (!eqNode.execute((Frame)frame, inliningTarget, seqItem, value, RichCmpOp.Py_EQ)) continue;
                ++count;
            }
            return count;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "value", "start", "stop"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0"), @ArgumentClinic(name="stop", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE")})
    @GenerateNodeFactory
    public static abstract class IndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TupleBuiltinsClinicProviders.IndexNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        int index(VirtualFrame frame, Object self, Object value, int startIn, int endIn, @Bind Node inliningTarget, @Cached TupleNodes.GetTupleStorage getTupleStorage, @Cached InlinedBranchProfile startLe0Profile, @Cached InlinedBranchProfile endLe0Profile, @Cached SequenceStorageNodes.ItemIndexNode itemIndexNode, @Cached PRaiseNode raiseNode) {
            int idx;
            int end;
            SequenceStorage storage = getTupleStorage.execute(inliningTarget, self);
            int start = startIn;
            if (start < 0) {
                startLe0Profile.enter(inliningTarget);
                if ((start += storage.length()) < 0) {
                    start = 0;
                }
            }
            if ((end = endIn) < 0) {
                endLe0Profile.enter(inliningTarget);
                end += storage.length();
            }
            if ((idx = itemIndexNode.execute(frame, inliningTarget, storage, value, start, end)) != -1) {
                return idx;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.X_NOT_IN_TUPLE);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="tuple", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class TupleNode
    extends PythonBinaryBuiltinNode {
        @Specialization(guards={"isBuiltinTupleType(cls)"})
        static Object doBuiltin(VirtualFrame frame, Object cls, Object iterable, @Cached.Shared @Cached TupleNodes.ConstructTupleNode constructTupleNode) {
            return constructTupleNode.execute((Frame)frame, iterable);
        }

        @Specialization(guards={"!needsNativeAllocationNode.execute(inliningTarget, cls)"}, replaces={"doBuiltin"})
        static PTuple constructTuple(VirtualFrame frame, Object cls, Object iterable, @Bind Node inliningTarget, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached.Shared @Cached TupleNodes.ConstructTupleNode constructTupleNode, @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            PTuple tuple = constructTupleNode.execute((Frame)frame, iterable);
            if (isSameTypeNode.execute(inliningTarget, cls, (Object)PythonBuiltinClassType.PTuple)) {
                return tuple;
            }
            return PFactory.createTuple(language, cls, getInstanceShape.execute(cls), tuple.getSequenceStorage());
        }

        @Specialization(guards={"needsNativeAllocationNode.execute(inliningTarget, cls)", "isSubtypeOfTuple( isSubtype, cls)"}, limit="1")
        @HostCompilerDirectives.InliningCutoff
        static Object doNative(VirtualFrame frame, Object cls, Object iterable, @Bind Node inliningTarget, @Cached.Shared @Cached TypeNodes.NeedsNativeAllocationNode needsNativeAllocationNode, @Cached IsSubtypeNode isSubtype, @Cached CExtNodes.TupleSubtypeNew subtypeNew) {
            return subtypeNew.call(cls, iterable);
        }

        protected static boolean isBuiltinTupleType(Object cls) {
            return cls == PythonBuiltinClassType.PTuple;
        }

        protected static boolean isSubtypeOfTuple(IsSubtypeNode isSubtypeNode, Object cls) {
            return isSubtypeNode.execute(cls, (Object)PythonBuiltinClassType.PTuple);
        }

        @Fallback
        static PTuple tupleObject(Object cls, Object arg, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
        }
    }
}

