/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Objects;
import java.util.UUID;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.ioresource.ConsoleOutputResource;
import us.fatehi.utility.ioresource.FileOutputResource;
import us.fatehi.utility.ioresource.OutputResource;
import us.fatehi.utility.ioresource.WriterOutputResource;

public final class OutputOptionsBuilder
implements OptionsBuilder<OutputOptionsBuilder, OutputOptions> {
    private OutputResource outputResource;
    private String outputFormatValue;
    private Charset inputEncodingCharset;
    private Charset outputEncodingCharset;
    private String title;

    public static OutputOptionsBuilder builder() {
        return new OutputOptionsBuilder();
    }

    public static OutputOptionsBuilder builder(OutputOptions outputOptions) {
        return new OutputOptionsBuilder().fromOptions(outputOptions);
    }

    public static OutputOptions newOutputOptions() {
        return new OutputOptionsBuilder().toOptions();
    }

    public static OutputOptions newOutputOptions(OutputFormat outputFormat, Path outputFile) {
        return OutputOptionsBuilder.builder().withOutputFormat(outputFormat).withOutputFile(outputFile).toOptions();
    }

    private OutputOptionsBuilder() {
    }

    public OutputOptionsBuilder fromOptions(OutputOptions options) {
        if (options == null) {
            return this;
        }
        this.withInputEncoding(options.getInputCharset()).withOutputEncoding(options.getOutputCharset()).withOutputFormatValue(options.getOutputFormatValue()).title(options.getTitle());
        this.outputResource = options.getOutputResource();
        return this;
    }

    public OutputOptionsBuilder title(String title) {
        this.title = Utility.trimToEmpty((String)title);
        return this;
    }

    public OutputOptions toOptions() {
        this.withInputEncoding(this.inputEncodingCharset);
        this.withOutputResource(this.outputResource);
        this.withOutputEncoding(this.inputEncodingCharset);
        if (Utility.isBlank((CharSequence)this.outputFormatValue)) {
            String fileExtension;
            OutputResource outputResource = this.outputResource;
            if (outputResource instanceof FileOutputResource) {
                FileOutputResource resource = (FileOutputResource)outputResource;
                fileExtension = IOUtility.getFileExtension((Path)resource.getOutputFile());
            } else {
                fileExtension = null;
            }
            String string = this.outputFormatValue = Utility.isBlank(fileExtension) ? "text" : fileExtension;
        }
        if (Utility.isBlank((CharSequence)this.title)) {
            this.title = "";
        }
        return new OutputOptions(this.inputEncodingCharset, this.outputResource, this.outputEncodingCharset, this.outputFormatValue, this.title);
    }

    public OutputOptionsBuilder withConsoleOutput() {
        this.outputResource = new ConsoleOutputResource();
        return this;
    }

    public OutputOptionsBuilder withInputEncoding(Charset inputCharset) {
        this.inputEncodingCharset = inputCharset == null ? StandardCharsets.UTF_8 : inputCharset;
        return this;
    }

    public OutputOptionsBuilder withInputEncoding(String inputEncoding) {
        try {
            this.inputEncodingCharset = Charset.forName(inputEncoding);
        }
        catch (IllegalArgumentException e) {
            this.inputEncodingCharset = StandardCharsets.UTF_8;
        }
        return this;
    }

    public OutputOptionsBuilder withOutputEncoding(Charset outputCharset) {
        this.outputEncodingCharset = outputCharset == null ? StandardCharsets.UTF_8 : outputCharset;
        return this;
    }

    public OutputOptionsBuilder withOutputEncoding(String outputEncoding) {
        try {
            this.outputEncodingCharset = Charset.forName(outputEncoding);
        }
        catch (IllegalArgumentException e) {
            this.outputEncodingCharset = StandardCharsets.UTF_8;
        }
        return this;
    }

    public OutputOptionsBuilder withOutputFile(Path outputFile) {
        Objects.requireNonNull(outputFile, "No output file provided");
        this.outputResource = new FileOutputResource(outputFile);
        return this;
    }

    public OutputOptionsBuilder withOutputFormat(OutputFormat outputFormat) {
        this.outputFormatValue = Objects.requireNonNull(outputFormat, "No output format provided").getFormat();
        return this;
    }

    public OutputOptionsBuilder withOutputFormatValue(String outputFormatValue) {
        this.outputFormatValue = Objects.requireNonNull(outputFormatValue, "No output format value provided");
        return this;
    }

    public OutputOptionsBuilder withOutputResource(OutputResource outputResource) {
        if (outputResource == null) {
            if (this.outputFormatValue == null || "text".equals(this.outputFormatValue)) {
                this.outputResource = new ConsoleOutputResource();
            } else {
                String extension = "htmlx".equals(this.outputFormatValue) ? "svg.html" : (this.outputFormatValue.matches("[A-Za-z]+") ? this.outputFormatValue : "out");
                Path randomOutputFile = Path.of(".", "schemacrawler-%s.%s".formatted(UUID.randomUUID(), extension)).normalize().toAbsolutePath();
                this.outputResource = new FileOutputResource(randomOutputFile);
            }
        } else {
            this.outputResource = outputResource;
        }
        return this;
    }

    public OutputOptionsBuilder withOutputWriter(Writer writer) {
        Objects.requireNonNull(writer, "No output writer provided");
        this.outputResource = new WriterOutputResource(writer);
        return this;
    }
}

