/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.options;

import java.util.Objects;
import schemacrawler.schemacrawler.OptionsBuilder;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.ConfigOptionsBuilder;
import schemacrawler.tools.options.LanguageOptions;
import schemacrawler.tools.options.LanguageType;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;

public abstract class LanguageOptionsBuilder<L extends LanguageType<?>, O extends LanguageOptions<L>>
implements OptionsBuilder<LanguageOptionsBuilder<L, O>, O>,
ConfigOptionsBuilder<LanguageOptionsBuilder<L, O>, O> {
    private final L defaultLanguage;
    private final String languageKey;
    private final String resourceKey;
    private L language;
    private String script;

    protected LanguageOptionsBuilder(String languageKey, String resourceKey, L defaultLanguage) {
        this.languageKey = Objects.requireNonNull(languageKey, "No language key provided");
        this.resourceKey = Objects.requireNonNull(resourceKey, "No resource key provided");
        this.defaultLanguage = (LanguageType)Objects.requireNonNull(defaultLanguage, "No default language provided");
    }

    public LanguageOptionsBuilder<L, O> fromConfig(Config config) {
        this.script = this.getScript(config);
        String languageString = this.getLanguageFromConfig(config);
        this.language = this.languageFromString(languageString);
        return this;
    }

    public LanguageOptionsBuilder<L, O> fromOptions(O options) {
        if (options != null) {
            this.language = ((LanguageOptions)options).getLanguage();
            this.script = ((LanguageOptions)options).getScript();
        }
        return this;
    }

    public L getLanguage() {
        return this.language;
    }

    public String getScript() {
        return this.script;
    }

    public void setLanguage(L language) {
        this.language = (LanguageType)Objects.requireNonNull(language, "No language type provided");
    }

    public void setScript(String script) {
        this.script = script;
    }

    public Config toConfig() {
        throw new UnsupportedOperationException();
    }

    protected abstract L languageFromString(String var1);

    private String getLanguageFromConfig(Config config) {
        String language = config.getStringValue(this.languageKey, null);
        if (!Utility.isBlank((CharSequence)language)) {
            return language;
        }
        String fileExtension = IOUtility.getFileExtension((String)this.script);
        if (!Utility.isBlank((CharSequence)fileExtension)) {
            return fileExtension;
        }
        return this.defaultLanguage.toString();
    }

    private String getScript(Config config) {
        return config.getStringValue(this.resourceKey, null);
    }
}

