/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.helper.JSCollectionsNormalizeNode;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.access.RequireObjectCoercibleNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNode;
import com.oracle.truffle.js.nodes.cast.LongToIntOrDoubleNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.unary.IsCallableNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class GroupByNode
extends JavaScriptBaseNode {
    protected final boolean toPropertyKeyCoercion;
    protected final JSContext context;

    protected GroupByNode(JSContext context, boolean toPropertyKeyCoercion) {
        this.context = context;
        this.toPropertyKeyCoercion = toPropertyKeyCoercion;
    }

    public abstract Map<Object, List<Object>> execute(Object var1, Object var2);

    @Specialization
    protected static Map<Object, List<Object>> groupBy(Object items, Object callbackfn, @Bind Node node, @Cached RequireObjectCoercibleNode requireObjectCoercibleNode, @Cached IsCallableNode isCallableNode, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached IteratorStepNode iteratorStepNode, @Cached IteratorValueNode iteratorValueNode, @Cached(value="create(context)") IteratorCloseNode iteratorCloseNode, @Cached(value="createCall()") JSFunctionCallNode callNode, @Cached(inline=true) LongToIntOrDoubleNode toIntOrDoubleNode, @Cached(value="maybeCreateToPropertyKeyNode(toPropertyKeyCoercion)", neverDefault=false) JSToPropertyKeyNode toPropertyKeyNode, @Cached(value="maybeCreateNormalizeKeyNode(toPropertyKeyCoercion)", neverDefault=false) JSCollectionsNormalizeNode normalizeKeyNode, @Cached InlinedBranchProfile errorBranch) {
        requireObjectCoercibleNode.execute(items);
        if (!isCallableNode.executeBoolean(callbackfn)) {
            errorBranch.enter(node);
            throw Errors.createTypeErrorNotAFunction(callbackfn, node);
        }
        Map<Object, List<Object>> groups = GroupByNode.initGroups();
        IteratorRecord iteratorRecord = getIteratorNode.execute(node, items);
        long k = 0L;
        try {
            while (true) {
                Object next;
                if ((next = iteratorStepNode.execute(iteratorRecord)) == Boolean.FALSE) {
                    return groups;
                }
                Object value = iteratorValueNode.execute(next);
                Object key = callNode.executeCall(JSArguments.create((Object)Undefined.instance, callbackfn, value, toIntOrDoubleNode.execute(node, k)));
                if (toPropertyKeyNode != null) {
                    key = toPropertyKeyNode.execute(key);
                }
                if (normalizeKeyNode != null) {
                    key = normalizeKeyNode.execute(key);
                }
                GroupByNode.addValueToKeyedGroup(groups, key, value);
                ++k;
            }
        }
        catch (AbstractTruffleException ex) {
            errorBranch.enter(node);
            iteratorCloseNode.executeAbrupt(iteratorRecord.getIterator());
            throw ex;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static Map<Object, List<Object>> initGroups() {
        return new LinkedHashMap<Object, List<Object>>();
    }

    @CompilerDirectives.TruffleBoundary
    private static void addValueToKeyedGroup(Map<Object, List<Object>> groups, Object key, Object value) {
        List<Object> group = groups.get(key);
        if (group == null) {
            group = new ArrayList<Object>();
            groups.put(key, group);
        }
        group.add(value);
    }

    protected static JSToPropertyKeyNode maybeCreateToPropertyKeyNode(boolean toPropertyKeyCoercion) {
        return toPropertyKeyCoercion ? JSToPropertyKeyNode.create() : null;
    }

    protected static JSCollectionsNormalizeNode maybeCreateNormalizeKeyNode(boolean toPropertyKeyCoercion) {
        return toPropertyKeyCoercion ? null : JSCollectionsNormalizeNode.create();
    }
}

