/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.field.AbstractWithoutTimeZoneField;
import org.firebirdsql.jdbc.field.FieldDataProvider;

final class FBTimeField
extends AbstractWithoutTimeZoneField {
    private static final LocalDate LOCAL_DATE_EPOCH = LocalDate.of(1970, 1, 1);

    FBTimeField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public Object getObject() throws SQLException {
        return this.getTime();
    }

    @Override
    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return String.valueOf(this.getTime());
    }

    @Override
    public Time getTime(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimeCalendar(this.getFieldData(), cal);
    }

    @Override
    LocalTime getLocalTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeLocalTime(this.getFieldData());
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Timestamp(this.getDatatypeCoder().decodeTimeCalendar(this.getFieldData(), cal).getTime());
    }

    @Override
    LocalDateTime getLocalDateTime() throws SQLException {
        LocalTime localTime = this.getLocalTime();
        return localTime != null ? localTime.atDate(LOCAL_DATE_EPOCH) : null;
    }

    @Override
    public void setString(String value) throws SQLException {
        this.setTime(this.fromString(value, Time::valueOf));
    }

    @Override
    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimeCalendar(new Time(value.getTime()), cal));
    }

    @Override
    void setLocalDateTime(LocalDateTime value) throws SQLException {
        this.setLocalTime(value != null ? value.toLocalTime() : null);
    }

    @Override
    public void setTime(Time value, Calendar cal) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimeCalendar(value, cal));
    }

    @Override
    void setLocalTime(LocalTime value) throws SQLException {
        if (this.setWhenNull(value)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeLocalTime(value));
    }

    @Override
    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.getDatatypeCoder().decodeTimeRaw(this.getFieldData());
    }

    @Override
    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        if (this.setWhenNull(raw)) {
            return;
        }
        this.setFieldData(this.getDatatypeCoder().encodeTimeRaw(raw));
    }
}

