/*
 * Copyright (c) 2024 Raspberry Pi Ltd. SPDX-License-Identifier: BSD-3-Clause
 *
 * @file     src/rp2_common/cmsis/stub/CMSIS/Device/RP2350/Include/RP2350.h
 * @brief    CMSIS HeaderFile
 * @version  0.1
 * @date     Thu Aug  8 04:04:02 2024
 * @note     Generated by SVDConv V3.3.47
 *           from File 'src/rp2_common/cmsis/../../rp2350/hardware_regs/RP2350.svd',
 *           last modified on Thu Aug  8 03:59:33 2024
 */


/** @addtogroup Raspberry Pi
  * @{
  */


/** @addtogroup RP2350
  * @{
  */


#ifndef RP2350_H
#define RP2350_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M33 Specific Interrupt Numbers  ======================================= */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                              */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                             */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SecureFault_IRQn          =  -9,              /*!< -9 Secure Fault Handler                                                   */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ===========================================  RP2350 Specific Interrupt Numbers  =========================================== */
  TIMER0_IRQ_0_IRQn         =   0,              /*!< 0  TIMER0_IRQ_0                                                           */
  TIMER0_IRQ_1_IRQn         =   1,              /*!< 1  TIMER0_IRQ_1                                                           */
  TIMER0_IRQ_2_IRQn         =   2,              /*!< 2  TIMER0_IRQ_2                                                           */
  TIMER0_IRQ_3_IRQn         =   3,              /*!< 3  TIMER0_IRQ_3                                                           */
  TIMER1_IRQ_0_IRQn         =   4,              /*!< 4  TIMER1_IRQ_0                                                           */
  TIMER1_IRQ_1_IRQn         =   5,              /*!< 5  TIMER1_IRQ_1                                                           */
  TIMER1_IRQ_2_IRQn         =   6,              /*!< 6  TIMER1_IRQ_2                                                           */
  TIMER1_IRQ_3_IRQn         =   7,              /*!< 7  TIMER1_IRQ_3                                                           */
  PWM_IRQ_WRAP_0_IRQn       =   8,              /*!< 8  PWM_IRQ_WRAP_0                                                         */
  PWM_IRQ_WRAP_1_IRQn       =   9,              /*!< 9  PWM_IRQ_WRAP_1                                                         */
  DMA_IRQ_0_IRQn            =  10,              /*!< 10 DMA_IRQ_0                                                              */
  DMA_IRQ_1_IRQn            =  11,              /*!< 11 DMA_IRQ_1                                                              */
  DMA_IRQ_2_IRQn            =  12,              /*!< 12 DMA_IRQ_2                                                              */
  DMA_IRQ_3_IRQn            =  13,              /*!< 13 DMA_IRQ_3                                                              */
  USBCTRL_IRQ_IRQn          =  14,              /*!< 14 USBCTRL_IRQ                                                            */
  PIO0_IRQ_0_IRQn           =  15,              /*!< 15 PIO0_IRQ_0                                                             */
  PIO0_IRQ_1_IRQn           =  16,              /*!< 16 PIO0_IRQ_1                                                             */
  PIO1_IRQ_0_IRQn           =  17,              /*!< 17 PIO1_IRQ_0                                                             */
  PIO1_IRQ_1_IRQn           =  18,              /*!< 18 PIO1_IRQ_1                                                             */
  PIO2_IRQ_0_IRQn           =  19,              /*!< 19 PIO2_IRQ_0                                                             */
  PIO2_IRQ_1_IRQn           =  20,              /*!< 20 PIO2_IRQ_1                                                             */
  IO_IRQ_BANK0_IRQn         =  21,              /*!< 21 IO_IRQ_BANK0                                                           */
  IO_IRQ_BANK0_NS_IRQn      =  22,              /*!< 22 IO_IRQ_BANK0_NS                                                        */
  IO_IRQ_QSPI_IRQn          =  23,              /*!< 23 IO_IRQ_QSPI                                                            */
  IO_IRQ_QSPI_NS_IRQn       =  24,              /*!< 24 IO_IRQ_QSPI_NS                                                         */
  SIO_IRQ_FIFO_IRQn         =  25,              /*!< 25 SIO_IRQ_FIFO                                                           */
  SIO_IRQ_BELL_IRQn         =  26,              /*!< 26 SIO_IRQ_BELL                                                           */
  SIO_IRQ_FIFO_NS_IRQn      =  27,              /*!< 27 SIO_IRQ_FIFO_NS                                                        */
  SIO_IRQ_BELL_NS_IRQn      =  28,              /*!< 28 SIO_IRQ_BELL_NS                                                        */
  SIO_IRQ_MTIMECMP_IRQn     =  29,              /*!< 29 SIO_IRQ_MTIMECMP                                                       */
  CLOCKS_IRQ_IRQn           =  30,              /*!< 30 CLOCKS_IRQ                                                             */
  SPI0_IRQ_IRQn             =  31,              /*!< 31 SPI0_IRQ                                                               */
  SPI1_IRQ_IRQn             =  32,              /*!< 32 SPI1_IRQ                                                               */
  UART0_IRQ_IRQn            =  33,              /*!< 33 UART0_IRQ                                                              */
  UART1_IRQ_IRQn            =  34,              /*!< 34 UART1_IRQ                                                              */
  ADC_IRQ_FIFO_IRQn         =  35,              /*!< 35 ADC_IRQ_FIFO                                                           */
  I2C0_IRQ_IRQn             =  36,              /*!< 36 I2C0_IRQ                                                               */
  I2C1_IRQ_IRQn             =  37,              /*!< 37 I2C1_IRQ                                                               */
  OTP_IRQ_IRQn              =  38,              /*!< 38 OTP_IRQ                                                                */
  TRNG_IRQ_IRQn             =  39,              /*!< 39 TRNG_IRQ                                                               */
  PLL_SYS_IRQ_IRQn          =  42,              /*!< 42 PLL_SYS_IRQ                                                            */
  PLL_USB_IRQ_IRQn          =  43,              /*!< 43 PLL_USB_IRQ                                                            */
  POWMAN_IRQ_POW_IRQn       =  44,              /*!< 44 POWMAN_IRQ_POW                                                         */
  POWMAN_IRQ_TIMER_IRQn     =  45               /*!< 45 POWMAN_IRQ_TIMER                                                       */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ==========================  Configuration of the ARM Cortex-M33 Processor and Core Peripherals  =========================== */
#define __CM33_REV                 0x0100U      /*!< CM33 Core Revision                                                        */
#define __NVIC_PRIO_BITS               4        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 1        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
#define __MPU_PRESENT                  1        /*!< MPU present                                                               */
#define __FPU_PRESENT                  1        /*!< FPU present                                                               */
#define __FPU_DP                       0        /*!< Double Precision FPU                                                      */
#define __DSP_PRESENT                  1        /*!< DSP extension present                                                     */
#define __SAUREGION_PRESENT            1        /*!< SAU region present                                                        */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm33.h"                          /*!< ARM Cortex-M33 processor and core peripherals                             */
#include "system_RP2350.h"                      /*!< RP2350 System                                                             */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                          RESETS                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief RESETS (RESETS)
  */

typedef struct {                                /*!< RESETS Structure                                                          */
  __IOM uint32_t  RESET;                        /*!< RESET                                                                     */
  __IOM uint32_t  WDSEL;                        /*!< WDSEL                                                                     */
  __IOM uint32_t  RESET_DONE;                   /*!< RESET_DONE                                                                */
} RESETS_Type;                                  /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                            PSM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PSM (PSM)
  */

typedef struct {                                /*!< PSM Structure                                                             */
  __IOM uint32_t  FRCE_ON;                      /*!< Force block out of reset (i.e. power it on)                               */
  __IOM uint32_t  FRCE_OFF;                     /*!< Force into reset (i.e. power it off)                                      */
  __IOM uint32_t  WDSEL;                        /*!< Set to 1 if the watchdog should reset this                                */
  __IOM uint32_t  DONE;                         /*!< Is the subsystem ready?                                                   */
} PSM_Type;                                     /*!< Size = 16 (0x10)                                                          */



/* =========================================================================================================================== */
/* ================                                          CLOCKS                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief CLOCKS (CLOCKS)
  */

typedef struct {                                /*!< CLOCKS Structure                                                          */
  __IOM uint32_t  CLK_GPOUT0_CTRL;              /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_GPOUT0_DIV;               /*!< CLK_GPOUT0_DIV                                                            */
  __IOM uint32_t  CLK_GPOUT0_SELECTED;          /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_GPOUT1_CTRL;              /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_GPOUT1_DIV;               /*!< CLK_GPOUT1_DIV                                                            */
  __IOM uint32_t  CLK_GPOUT1_SELECTED;          /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_GPOUT2_CTRL;              /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_GPOUT2_DIV;               /*!< CLK_GPOUT2_DIV                                                            */
  __IOM uint32_t  CLK_GPOUT2_SELECTED;          /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_GPOUT3_CTRL;              /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_GPOUT3_DIV;               /*!< CLK_GPOUT3_DIV                                                            */
  __IOM uint32_t  CLK_GPOUT3_SELECTED;          /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_REF_CTRL;                 /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_REF_DIV;                  /*!< CLK_REF_DIV                                                               */
  __IOM uint32_t  CLK_REF_SELECTED;             /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_SYS_CTRL;                 /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_SYS_DIV;                  /*!< CLK_SYS_DIV                                                               */
  __IOM uint32_t  CLK_SYS_SELECTED;             /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_PERI_CTRL;                /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_PERI_DIV;                 /*!< CLK_PERI_DIV                                                              */
  __IOM uint32_t  CLK_PERI_SELECTED;            /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_HSTX_CTRL;                /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_HSTX_DIV;                 /*!< CLK_HSTX_DIV                                                              */
  __IOM uint32_t  CLK_HSTX_SELECTED;            /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_USB_CTRL;                 /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_USB_DIV;                  /*!< CLK_USB_DIV                                                               */
  __IOM uint32_t  CLK_USB_SELECTED;             /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  CLK_ADC_CTRL;                 /*!< Clock control, can be changed on-the-fly (except for auxsrc)              */
  __IOM uint32_t  CLK_ADC_DIV;                  /*!< CLK_ADC_DIV                                                               */
  __IOM uint32_t  CLK_ADC_SELECTED;             /*!< Indicates which src is currently selected (one-hot)                       */
  __IOM uint32_t  DFTCLK_XOSC_CTRL;             /*!< DFTCLK_XOSC_CTRL                                                          */
  __IOM uint32_t  DFTCLK_ROSC_CTRL;             /*!< DFTCLK_ROSC_CTRL                                                          */
  __IOM uint32_t  DFTCLK_LPOSC_CTRL;            /*!< DFTCLK_LPOSC_CTRL                                                         */
  __IOM uint32_t  CLK_SYS_RESUS_CTRL;           /*!< CLK_SYS_RESUS_CTRL                                                        */
  __IOM uint32_t  CLK_SYS_RESUS_STATUS;         /*!< CLK_SYS_RESUS_STATUS                                                      */
  __IOM uint32_t  FC0_REF_KHZ;                  /*!< Reference clock frequency in kHz                                          */
  __IOM uint32_t  FC0_MIN_KHZ;                  /*!< Minimum pass frequency in kHz. This is optional. Set to 0 if
                                                     you are not using the pass/fail flags                                     */
  __IOM uint32_t  FC0_MAX_KHZ;                  /*!< Maximum pass frequency in kHz. This is optional. Set to 0x1ffffff
                                                     if you are not using the pass/fail flags                                  */
  __IOM uint32_t  FC0_DELAY;                    /*!< Delays the start of frequency counting to allow the mux to settle
                                                     Delay is measured in multiples of the reference clock period              */
  __IOM uint32_t  FC0_INTERVAL;                 /*!< The test interval is 0.98us * 2**interval, but let's call it
                                                     1us * 2**interval The default gives a test interval of
                                                     250us                                                                     */
  __IOM uint32_t  FC0_SRC;                      /*!< Clock sent to frequency counter, set to 0 when not required
                                                     Writing to this register initiates the frequency count                    */
  __IOM uint32_t  FC0_STATUS;                   /*!< Frequency counter status                                                  */
  __IOM uint32_t  FC0_RESULT;                   /*!< Result of frequency measurement, only valid when status_done=1            */
  __IOM uint32_t  WAKE_EN0;                     /*!< enable clock in wake mode                                                 */
  __IOM uint32_t  WAKE_EN1;                     /*!< enable clock in wake mode                                                 */
  __IOM uint32_t  SLEEP_EN0;                    /*!< enable clock in sleep mode                                                */
  __IOM uint32_t  SLEEP_EN1;                    /*!< enable clock in sleep mode                                                */
  __IOM uint32_t  ENABLED0;                     /*!< indicates the state of the clock enable                                   */
  __IOM uint32_t  ENABLED1;                     /*!< indicates the state of the clock enable                                   */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
} CLOCKS_Type;                                  /*!< Size = 212 (0xd4)                                                         */



/* =========================================================================================================================== */
/* ================                                           TICKS                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief TICKS (TICKS)
  */

typedef struct {                                /*!< TICKS Structure                                                           */
  __IOM uint32_t  PROC0_CTRL;                   /*!< Controls the tick generator                                               */
  __IOM uint32_t  PROC0_CYCLES;                 /*!< PROC0_CYCLES                                                              */
  __IOM uint32_t  PROC0_COUNT;                  /*!< PROC0_COUNT                                                               */
  __IOM uint32_t  PROC1_CTRL;                   /*!< Controls the tick generator                                               */
  __IOM uint32_t  PROC1_CYCLES;                 /*!< PROC1_CYCLES                                                              */
  __IOM uint32_t  PROC1_COUNT;                  /*!< PROC1_COUNT                                                               */
  __IOM uint32_t  TIMER0_CTRL;                  /*!< Controls the tick generator                                               */
  __IOM uint32_t  TIMER0_CYCLES;                /*!< TIMER0_CYCLES                                                             */
  __IOM uint32_t  TIMER0_COUNT;                 /*!< TIMER0_COUNT                                                              */
  __IOM uint32_t  TIMER1_CTRL;                  /*!< Controls the tick generator                                               */
  __IOM uint32_t  TIMER1_CYCLES;                /*!< TIMER1_CYCLES                                                             */
  __IOM uint32_t  TIMER1_COUNT;                 /*!< TIMER1_COUNT                                                              */
  __IOM uint32_t  WATCHDOG_CTRL;                /*!< Controls the tick generator                                               */
  __IOM uint32_t  WATCHDOG_CYCLES;              /*!< WATCHDOG_CYCLES                                                           */
  __IOM uint32_t  WATCHDOG_COUNT;               /*!< WATCHDOG_COUNT                                                            */
  __IOM uint32_t  RISCV_CTRL;                   /*!< Controls the tick generator                                               */
  __IOM uint32_t  RISCV_CYCLES;                 /*!< RISCV_CYCLES                                                              */
  __IOM uint32_t  RISCV_COUNT;                  /*!< RISCV_COUNT                                                               */
} TICKS_Type;                                   /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                        PADS_BANK0                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief PADS_BANK0 (PADS_BANK0)
  */

typedef struct {                                /*!< PADS_BANK0 Structure                                                      */
  __IOM uint32_t  VOLTAGE_SELECT;               /*!< Voltage select. Per bank control                                          */
  __IOM uint32_t  GPIO0;                        /*!< GPIO0                                                                     */
  __IOM uint32_t  GPIO1;                        /*!< GPIO1                                                                     */
  __IOM uint32_t  GPIO2;                        /*!< GPIO2                                                                     */
  __IOM uint32_t  GPIO3;                        /*!< GPIO3                                                                     */
  __IOM uint32_t  GPIO4;                        /*!< GPIO4                                                                     */
  __IOM uint32_t  GPIO5;                        /*!< GPIO5                                                                     */
  __IOM uint32_t  GPIO6;                        /*!< GPIO6                                                                     */
  __IOM uint32_t  GPIO7;                        /*!< GPIO7                                                                     */
  __IOM uint32_t  GPIO8;                        /*!< GPIO8                                                                     */
  __IOM uint32_t  GPIO9;                        /*!< GPIO9                                                                     */
  __IOM uint32_t  GPIO10;                       /*!< GPIO10                                                                    */
  __IOM uint32_t  GPIO11;                       /*!< GPIO11                                                                    */
  __IOM uint32_t  GPIO12;                       /*!< GPIO12                                                                    */
  __IOM uint32_t  GPIO13;                       /*!< GPIO13                                                                    */
  __IOM uint32_t  GPIO14;                       /*!< GPIO14                                                                    */
  __IOM uint32_t  GPIO15;                       /*!< GPIO15                                                                    */
  __IOM uint32_t  GPIO16;                       /*!< GPIO16                                                                    */
  __IOM uint32_t  GPIO17;                       /*!< GPIO17                                                                    */
  __IOM uint32_t  GPIO18;                       /*!< GPIO18                                                                    */
  __IOM uint32_t  GPIO19;                       /*!< GPIO19                                                                    */
  __IOM uint32_t  GPIO20;                       /*!< GPIO20                                                                    */
  __IOM uint32_t  GPIO21;                       /*!< GPIO21                                                                    */
  __IOM uint32_t  GPIO22;                       /*!< GPIO22                                                                    */
  __IOM uint32_t  GPIO23;                       /*!< GPIO23                                                                    */
  __IOM uint32_t  GPIO24;                       /*!< GPIO24                                                                    */
  __IOM uint32_t  GPIO25;                       /*!< GPIO25                                                                    */
  __IOM uint32_t  GPIO26;                       /*!< GPIO26                                                                    */
  __IOM uint32_t  GPIO27;                       /*!< GPIO27                                                                    */
  __IOM uint32_t  GPIO28;                       /*!< GPIO28                                                                    */
  __IOM uint32_t  GPIO29;                       /*!< GPIO29                                                                    */
  __IOM uint32_t  GPIO30;                       /*!< GPIO30                                                                    */
  __IOM uint32_t  GPIO31;                       /*!< GPIO31                                                                    */
  __IOM uint32_t  GPIO32;                       /*!< GPIO32                                                                    */
  __IOM uint32_t  GPIO33;                       /*!< GPIO33                                                                    */
  __IOM uint32_t  GPIO34;                       /*!< GPIO34                                                                    */
  __IOM uint32_t  GPIO35;                       /*!< GPIO35                                                                    */
  __IOM uint32_t  GPIO36;                       /*!< GPIO36                                                                    */
  __IOM uint32_t  GPIO37;                       /*!< GPIO37                                                                    */
  __IOM uint32_t  GPIO38;                       /*!< GPIO38                                                                    */
  __IOM uint32_t  GPIO39;                       /*!< GPIO39                                                                    */
  __IOM uint32_t  GPIO40;                       /*!< GPIO40                                                                    */
  __IOM uint32_t  GPIO41;                       /*!< GPIO41                                                                    */
  __IOM uint32_t  GPIO42;                       /*!< GPIO42                                                                    */
  __IOM uint32_t  GPIO43;                       /*!< GPIO43                                                                    */
  __IOM uint32_t  GPIO44;                       /*!< GPIO44                                                                    */
  __IOM uint32_t  GPIO45;                       /*!< GPIO45                                                                    */
  __IOM uint32_t  GPIO46;                       /*!< GPIO46                                                                    */
  __IOM uint32_t  GPIO47;                       /*!< GPIO47                                                                    */
  __IOM uint32_t  SWCLK;                        /*!< SWCLK                                                                     */
  __IOM uint32_t  SWD;                          /*!< SWD                                                                       */
} PADS_BANK0_Type;                              /*!< Size = 204 (0xcc)                                                         */



/* =========================================================================================================================== */
/* ================                                         PADS_QSPI                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief PADS_QSPI (PADS_QSPI)
  */

typedef struct {                                /*!< PADS_QSPI Structure                                                       */
  __IOM uint32_t  VOLTAGE_SELECT;               /*!< Voltage select. Per bank control                                          */
  __IOM uint32_t  GPIO_QSPI_SCLK;               /*!< GPIO_QSPI_SCLK                                                            */
  __IOM uint32_t  GPIO_QSPI_SD0;                /*!< GPIO_QSPI_SD0                                                             */
  __IOM uint32_t  GPIO_QSPI_SD1;                /*!< GPIO_QSPI_SD1                                                             */
  __IOM uint32_t  GPIO_QSPI_SD2;                /*!< GPIO_QSPI_SD2                                                             */
  __IOM uint32_t  GPIO_QSPI_SD3;                /*!< GPIO_QSPI_SD3                                                             */
  __IOM uint32_t  GPIO_QSPI_SS;                 /*!< GPIO_QSPI_SS                                                              */
} PADS_QSPI_Type;                               /*!< Size = 28 (0x1c)                                                          */



/* =========================================================================================================================== */
/* ================                                          IO_QSPI                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief IO_QSPI (IO_QSPI)
  */

typedef struct {                                /*!< IO_QSPI Structure                                                         */
  __IOM uint32_t  USBPHY_DP_STATUS;             /*!< USBPHY_DP_STATUS                                                          */
  __IOM uint32_t  USBPHY_DP_CTRL;               /*!< USBPHY_DP_CTRL                                                            */
  __IOM uint32_t  USBPHY_DM_STATUS;             /*!< USBPHY_DM_STATUS                                                          */
  __IOM uint32_t  USBPHY_DM_CTRL;               /*!< USBPHY_DM_CTRL                                                            */
  __IOM uint32_t  GPIO_QSPI_SCLK_STATUS;        /*!< GPIO_QSPI_SCLK_STATUS                                                     */
  __IOM uint32_t  GPIO_QSPI_SCLK_CTRL;          /*!< GPIO_QSPI_SCLK_CTRL                                                       */
  __IOM uint32_t  GPIO_QSPI_SS_STATUS;          /*!< GPIO_QSPI_SS_STATUS                                                       */
  __IOM uint32_t  GPIO_QSPI_SS_CTRL;            /*!< GPIO_QSPI_SS_CTRL                                                         */
  __IOM uint32_t  GPIO_QSPI_SD0_STATUS;         /*!< GPIO_QSPI_SD0_STATUS                                                      */
  __IOM uint32_t  GPIO_QSPI_SD0_CTRL;           /*!< GPIO_QSPI_SD0_CTRL                                                        */
  __IOM uint32_t  GPIO_QSPI_SD1_STATUS;         /*!< GPIO_QSPI_SD1_STATUS                                                      */
  __IOM uint32_t  GPIO_QSPI_SD1_CTRL;           /*!< GPIO_QSPI_SD1_CTRL                                                        */
  __IOM uint32_t  GPIO_QSPI_SD2_STATUS;         /*!< GPIO_QSPI_SD2_STATUS                                                      */
  __IOM uint32_t  GPIO_QSPI_SD2_CTRL;           /*!< GPIO_QSPI_SD2_CTRL                                                        */
  __IOM uint32_t  GPIO_QSPI_SD3_STATUS;         /*!< GPIO_QSPI_SD3_STATUS                                                      */
  __IOM uint32_t  GPIO_QSPI_SD3_CTRL;           /*!< GPIO_QSPI_SD3_CTRL                                                        */
  __IM  uint32_t  RESERVED[112];
  __IOM uint32_t  IRQSUMMARY_PROC0_SECURE;      /*!< IRQSUMMARY_PROC0_SECURE                                                   */
  __IOM uint32_t  IRQSUMMARY_PROC0_NONSECURE;   /*!< IRQSUMMARY_PROC0_NONSECURE                                                */
  __IOM uint32_t  IRQSUMMARY_PROC1_SECURE;      /*!< IRQSUMMARY_PROC1_SECURE                                                   */
  __IOM uint32_t  IRQSUMMARY_PROC1_NONSECURE;   /*!< IRQSUMMARY_PROC1_NONSECURE                                                */
  __IOM uint32_t  IRQSUMMARY_DORMANT_WAKE_SECURE;/*!< IRQSUMMARY_DORMANT_WAKE_SECURE                                           */
  __IOM uint32_t  IRQSUMMARY_DORMANT_WAKE_NONSECURE;/*!< IRQSUMMARY_DORMANT_WAKE_NONSECURE                                     */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  PROC0_INTE;                   /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTF;                   /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTS;                   /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC1_INTE;                   /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTF;                   /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTS;                   /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  DORMANT_WAKE_INTE;            /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTF;            /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTS;            /*!< Interrupt status after masking & forcing for dormant_wake                 */
} IO_QSPI_Type;                                 /*!< Size = 576 (0x240)                                                        */



/* =========================================================================================================================== */
/* ================                                         IO_BANK0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief IO_BANK0 (IO_BANK0)
  */

typedef struct {                                /*!< IO_BANK0 Structure                                                        */
  __IOM uint32_t  GPIO0_STATUS;                 /*!< GPIO0_STATUS                                                              */
  __IOM uint32_t  GPIO0_CTRL;                   /*!< GPIO0_CTRL                                                                */
  __IOM uint32_t  GPIO1_STATUS;                 /*!< GPIO1_STATUS                                                              */
  __IOM uint32_t  GPIO1_CTRL;                   /*!< GPIO1_CTRL                                                                */
  __IOM uint32_t  GPIO2_STATUS;                 /*!< GPIO2_STATUS                                                              */
  __IOM uint32_t  GPIO2_CTRL;                   /*!< GPIO2_CTRL                                                                */
  __IOM uint32_t  GPIO3_STATUS;                 /*!< GPIO3_STATUS                                                              */
  __IOM uint32_t  GPIO3_CTRL;                   /*!< GPIO3_CTRL                                                                */
  __IOM uint32_t  GPIO4_STATUS;                 /*!< GPIO4_STATUS                                                              */
  __IOM uint32_t  GPIO4_CTRL;                   /*!< GPIO4_CTRL                                                                */
  __IOM uint32_t  GPIO5_STATUS;                 /*!< GPIO5_STATUS                                                              */
  __IOM uint32_t  GPIO5_CTRL;                   /*!< GPIO5_CTRL                                                                */
  __IOM uint32_t  GPIO6_STATUS;                 /*!< GPIO6_STATUS                                                              */
  __IOM uint32_t  GPIO6_CTRL;                   /*!< GPIO6_CTRL                                                                */
  __IOM uint32_t  GPIO7_STATUS;                 /*!< GPIO7_STATUS                                                              */
  __IOM uint32_t  GPIO7_CTRL;                   /*!< GPIO7_CTRL                                                                */
  __IOM uint32_t  GPIO8_STATUS;                 /*!< GPIO8_STATUS                                                              */
  __IOM uint32_t  GPIO8_CTRL;                   /*!< GPIO8_CTRL                                                                */
  __IOM uint32_t  GPIO9_STATUS;                 /*!< GPIO9_STATUS                                                              */
  __IOM uint32_t  GPIO9_CTRL;                   /*!< GPIO9_CTRL                                                                */
  __IOM uint32_t  GPIO10_STATUS;                /*!< GPIO10_STATUS                                                             */
  __IOM uint32_t  GPIO10_CTRL;                  /*!< GPIO10_CTRL                                                               */
  __IOM uint32_t  GPIO11_STATUS;                /*!< GPIO11_STATUS                                                             */
  __IOM uint32_t  GPIO11_CTRL;                  /*!< GPIO11_CTRL                                                               */
  __IOM uint32_t  GPIO12_STATUS;                /*!< GPIO12_STATUS                                                             */
  __IOM uint32_t  GPIO12_CTRL;                  /*!< GPIO12_CTRL                                                               */
  __IOM uint32_t  GPIO13_STATUS;                /*!< GPIO13_STATUS                                                             */
  __IOM uint32_t  GPIO13_CTRL;                  /*!< GPIO13_CTRL                                                               */
  __IOM uint32_t  GPIO14_STATUS;                /*!< GPIO14_STATUS                                                             */
  __IOM uint32_t  GPIO14_CTRL;                  /*!< GPIO14_CTRL                                                               */
  __IOM uint32_t  GPIO15_STATUS;                /*!< GPIO15_STATUS                                                             */
  __IOM uint32_t  GPIO15_CTRL;                  /*!< GPIO15_CTRL                                                               */
  __IOM uint32_t  GPIO16_STATUS;                /*!< GPIO16_STATUS                                                             */
  __IOM uint32_t  GPIO16_CTRL;                  /*!< GPIO16_CTRL                                                               */
  __IOM uint32_t  GPIO17_STATUS;                /*!< GPIO17_STATUS                                                             */
  __IOM uint32_t  GPIO17_CTRL;                  /*!< GPIO17_CTRL                                                               */
  __IOM uint32_t  GPIO18_STATUS;                /*!< GPIO18_STATUS                                                             */
  __IOM uint32_t  GPIO18_CTRL;                  /*!< GPIO18_CTRL                                                               */
  __IOM uint32_t  GPIO19_STATUS;                /*!< GPIO19_STATUS                                                             */
  __IOM uint32_t  GPIO19_CTRL;                  /*!< GPIO19_CTRL                                                               */
  __IOM uint32_t  GPIO20_STATUS;                /*!< GPIO20_STATUS                                                             */
  __IOM uint32_t  GPIO20_CTRL;                  /*!< GPIO20_CTRL                                                               */
  __IOM uint32_t  GPIO21_STATUS;                /*!< GPIO21_STATUS                                                             */
  __IOM uint32_t  GPIO21_CTRL;                  /*!< GPIO21_CTRL                                                               */
  __IOM uint32_t  GPIO22_STATUS;                /*!< GPIO22_STATUS                                                             */
  __IOM uint32_t  GPIO22_CTRL;                  /*!< GPIO22_CTRL                                                               */
  __IOM uint32_t  GPIO23_STATUS;                /*!< GPIO23_STATUS                                                             */
  __IOM uint32_t  GPIO23_CTRL;                  /*!< GPIO23_CTRL                                                               */
  __IOM uint32_t  GPIO24_STATUS;                /*!< GPIO24_STATUS                                                             */
  __IOM uint32_t  GPIO24_CTRL;                  /*!< GPIO24_CTRL                                                               */
  __IOM uint32_t  GPIO25_STATUS;                /*!< GPIO25_STATUS                                                             */
  __IOM uint32_t  GPIO25_CTRL;                  /*!< GPIO25_CTRL                                                               */
  __IOM uint32_t  GPIO26_STATUS;                /*!< GPIO26_STATUS                                                             */
  __IOM uint32_t  GPIO26_CTRL;                  /*!< GPIO26_CTRL                                                               */
  __IOM uint32_t  GPIO27_STATUS;                /*!< GPIO27_STATUS                                                             */
  __IOM uint32_t  GPIO27_CTRL;                  /*!< GPIO27_CTRL                                                               */
  __IOM uint32_t  GPIO28_STATUS;                /*!< GPIO28_STATUS                                                             */
  __IOM uint32_t  GPIO28_CTRL;                  /*!< GPIO28_CTRL                                                               */
  __IOM uint32_t  GPIO29_STATUS;                /*!< GPIO29_STATUS                                                             */
  __IOM uint32_t  GPIO29_CTRL;                  /*!< GPIO29_CTRL                                                               */
  __IOM uint32_t  GPIO30_STATUS;                /*!< GPIO30_STATUS                                                             */
  __IOM uint32_t  GPIO30_CTRL;                  /*!< GPIO30_CTRL                                                               */
  __IOM uint32_t  GPIO31_STATUS;                /*!< GPIO31_STATUS                                                             */
  __IOM uint32_t  GPIO31_CTRL;                  /*!< GPIO31_CTRL                                                               */
  __IOM uint32_t  GPIO32_STATUS;                /*!< GPIO32_STATUS                                                             */
  __IOM uint32_t  GPIO32_CTRL;                  /*!< GPIO32_CTRL                                                               */
  __IOM uint32_t  GPIO33_STATUS;                /*!< GPIO33_STATUS                                                             */
  __IOM uint32_t  GPIO33_CTRL;                  /*!< GPIO33_CTRL                                                               */
  __IOM uint32_t  GPIO34_STATUS;                /*!< GPIO34_STATUS                                                             */
  __IOM uint32_t  GPIO34_CTRL;                  /*!< GPIO34_CTRL                                                               */
  __IOM uint32_t  GPIO35_STATUS;                /*!< GPIO35_STATUS                                                             */
  __IOM uint32_t  GPIO35_CTRL;                  /*!< GPIO35_CTRL                                                               */
  __IOM uint32_t  GPIO36_STATUS;                /*!< GPIO36_STATUS                                                             */
  __IOM uint32_t  GPIO36_CTRL;                  /*!< GPIO36_CTRL                                                               */
  __IOM uint32_t  GPIO37_STATUS;                /*!< GPIO37_STATUS                                                             */
  __IOM uint32_t  GPIO37_CTRL;                  /*!< GPIO37_CTRL                                                               */
  __IOM uint32_t  GPIO38_STATUS;                /*!< GPIO38_STATUS                                                             */
  __IOM uint32_t  GPIO38_CTRL;                  /*!< GPIO38_CTRL                                                               */
  __IOM uint32_t  GPIO39_STATUS;                /*!< GPIO39_STATUS                                                             */
  __IOM uint32_t  GPIO39_CTRL;                  /*!< GPIO39_CTRL                                                               */
  __IOM uint32_t  GPIO40_STATUS;                /*!< GPIO40_STATUS                                                             */
  __IOM uint32_t  GPIO40_CTRL;                  /*!< GPIO40_CTRL                                                               */
  __IOM uint32_t  GPIO41_STATUS;                /*!< GPIO41_STATUS                                                             */
  __IOM uint32_t  GPIO41_CTRL;                  /*!< GPIO41_CTRL                                                               */
  __IOM uint32_t  GPIO42_STATUS;                /*!< GPIO42_STATUS                                                             */
  __IOM uint32_t  GPIO42_CTRL;                  /*!< GPIO42_CTRL                                                               */
  __IOM uint32_t  GPIO43_STATUS;                /*!< GPIO43_STATUS                                                             */
  __IOM uint32_t  GPIO43_CTRL;                  /*!< GPIO43_CTRL                                                               */
  __IOM uint32_t  GPIO44_STATUS;                /*!< GPIO44_STATUS                                                             */
  __IOM uint32_t  GPIO44_CTRL;                  /*!< GPIO44_CTRL                                                               */
  __IOM uint32_t  GPIO45_STATUS;                /*!< GPIO45_STATUS                                                             */
  __IOM uint32_t  GPIO45_CTRL;                  /*!< GPIO45_CTRL                                                               */
  __IOM uint32_t  GPIO46_STATUS;                /*!< GPIO46_STATUS                                                             */
  __IOM uint32_t  GPIO46_CTRL;                  /*!< GPIO46_CTRL                                                               */
  __IOM uint32_t  GPIO47_STATUS;                /*!< GPIO47_STATUS                                                             */
  __IOM uint32_t  GPIO47_CTRL;                  /*!< GPIO47_CTRL                                                               */
  __IM  uint32_t  RESERVED[32];
  __IOM uint32_t  IRQSUMMARY_PROC0_SECURE0;     /*!< IRQSUMMARY_PROC0_SECURE0                                                  */
  __IOM uint32_t  IRQSUMMARY_PROC0_SECURE1;     /*!< IRQSUMMARY_PROC0_SECURE1                                                  */
  __IOM uint32_t  IRQSUMMARY_PROC0_NONSECURE0;  /*!< IRQSUMMARY_PROC0_NONSECURE0                                               */
  __IOM uint32_t  IRQSUMMARY_PROC0_NONSECURE1;  /*!< IRQSUMMARY_PROC0_NONSECURE1                                               */
  __IOM uint32_t  IRQSUMMARY_PROC1_SECURE0;     /*!< IRQSUMMARY_PROC1_SECURE0                                                  */
  __IOM uint32_t  IRQSUMMARY_PROC1_SECURE1;     /*!< IRQSUMMARY_PROC1_SECURE1                                                  */
  __IOM uint32_t  IRQSUMMARY_PROC1_NONSECURE0;  /*!< IRQSUMMARY_PROC1_NONSECURE0                                               */
  __IOM uint32_t  IRQSUMMARY_PROC1_NONSECURE1;  /*!< IRQSUMMARY_PROC1_NONSECURE1                                               */
  __IOM uint32_t  IRQSUMMARY_DORMANT_WAKE_SECURE0;/*!< IRQSUMMARY_DORMANT_WAKE_SECURE0                                         */
  __IOM uint32_t  IRQSUMMARY_DORMANT_WAKE_SECURE1;/*!< IRQSUMMARY_DORMANT_WAKE_SECURE1                                         */
  __IOM uint32_t  IRQSUMMARY_DORMANT_WAKE_NONSECURE0;/*!< IRQSUMMARY_DORMANT_WAKE_NONSECURE0                                   */
  __IOM uint32_t  IRQSUMMARY_DORMANT_WAKE_NONSECURE1;/*!< IRQSUMMARY_DORMANT_WAKE_NONSECURE1                                   */
  __IOM uint32_t  INTR0;                        /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTR1;                        /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTR2;                        /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTR3;                        /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTR4;                        /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTR5;                        /*!< Raw Interrupts                                                            */
  __IOM uint32_t  PROC0_INTE0;                  /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTE1;                  /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTE2;                  /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTE3;                  /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTE4;                  /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTE5;                  /*!< Interrupt Enable for proc0                                                */
  __IOM uint32_t  PROC0_INTF0;                  /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTF1;                  /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTF2;                  /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTF3;                  /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTF4;                  /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTF5;                  /*!< Interrupt Force for proc0                                                 */
  __IOM uint32_t  PROC0_INTS0;                  /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC0_INTS1;                  /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC0_INTS2;                  /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC0_INTS3;                  /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC0_INTS4;                  /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC0_INTS5;                  /*!< Interrupt status after masking & forcing for proc0                        */
  __IOM uint32_t  PROC1_INTE0;                  /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTE1;                  /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTE2;                  /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTE3;                  /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTE4;                  /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTE5;                  /*!< Interrupt Enable for proc1                                                */
  __IOM uint32_t  PROC1_INTF0;                  /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTF1;                  /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTF2;                  /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTF3;                  /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTF4;                  /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTF5;                  /*!< Interrupt Force for proc1                                                 */
  __IOM uint32_t  PROC1_INTS0;                  /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  PROC1_INTS1;                  /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  PROC1_INTS2;                  /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  PROC1_INTS3;                  /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  PROC1_INTS4;                  /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  PROC1_INTS5;                  /*!< Interrupt status after masking & forcing for proc1                        */
  __IOM uint32_t  DORMANT_WAKE_INTE0;           /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTE1;           /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTE2;           /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTE3;           /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTE4;           /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTE5;           /*!< Interrupt Enable for dormant_wake                                         */
  __IOM uint32_t  DORMANT_WAKE_INTF0;           /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTF1;           /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTF2;           /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTF3;           /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTF4;           /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTF5;           /*!< Interrupt Force for dormant_wake                                          */
  __IOM uint32_t  DORMANT_WAKE_INTS0;           /*!< Interrupt status after masking & forcing for dormant_wake                 */
  __IOM uint32_t  DORMANT_WAKE_INTS1;           /*!< Interrupt status after masking & forcing for dormant_wake                 */
  __IOM uint32_t  DORMANT_WAKE_INTS2;           /*!< Interrupt status after masking & forcing for dormant_wake                 */
  __IOM uint32_t  DORMANT_WAKE_INTS3;           /*!< Interrupt status after masking & forcing for dormant_wake                 */
  __IOM uint32_t  DORMANT_WAKE_INTS4;           /*!< Interrupt status after masking & forcing for dormant_wake                 */
  __IOM uint32_t  DORMANT_WAKE_INTS5;           /*!< Interrupt status after masking & forcing for dormant_wake                 */
} IO_BANK0_Type;                                /*!< Size = 800 (0x320)                                                        */



/* =========================================================================================================================== */
/* ================                                          SYSINFO                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief SYSINFO (SYSINFO)
  */

typedef struct {                                /*!< SYSINFO Structure                                                         */
  __IOM uint32_t  CHIP_ID;                      /*!< JEDEC JEP-106 compliant chip identifier.                                  */
  __IOM uint32_t  PACKAGE_SEL;                  /*!< PACKAGE_SEL                                                               */
  __IOM uint32_t  PLATFORM;                     /*!< Platform register. Allows software to know what environment
                                                     it is running in during pre-production development. Post-production,
                                                     the PLATFORM is always ASIC, non-SIM.                                     */
  __IM  uint32_t  RESERVED[2];
  __IOM uint32_t  GITREF_RP2350;                /*!< Git hash of the chip source. Used to identify chip version.               */
} SYSINFO_Type;                                 /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                          SHA256                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief SHA-256 hash function implementation (SHA256)
  */

typedef struct {                                /*!< SHA256 Structure                                                          */
  __IOM uint32_t  CSR;                          /*!< Control and status register                                               */
  __IOM uint32_t  WDATA;                        /*!< Write data register                                                       */
  __IOM uint32_t  SUM0;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM1;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM2;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM3;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM4;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM5;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM6;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
  __IOM uint32_t  SUM7;                         /*!< 256-bit checksum result. Contents are undefined when CSR_SUM_VLD
                                                     is 0.                                                                     */
} SHA256_Type;                                  /*!< Size = 40 (0x28)                                                          */



/* =========================================================================================================================== */
/* ================                                         HSTX_FIFO                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief FIFO status and write access for HSTX (HSTX_FIFO)
  */

typedef struct {                                /*!< HSTX_FIFO Structure                                                       */
  __IOM uint32_t  STAT;                         /*!< FIFO status                                                               */
  __IOM uint32_t  FIFO;                         /*!< Write access to FIFO                                                      */
} HSTX_FIFO_Type;                               /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                         HSTX_CTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief Control interface to HSTX. For FIFO write access and status, see the HSTX_FIFO register block. (HSTX_CTRL)
  */

typedef struct {                                /*!< HSTX_CTRL Structure                                                       */
  __IOM uint32_t  CSR;                          /*!< CSR                                                                       */
  __IOM uint32_t  BIT0;                         /*!< Data control register for output bit 0                                    */
  __IOM uint32_t  BIT1;                         /*!< Data control register for output bit 1                                    */
  __IOM uint32_t  BIT2;                         /*!< Data control register for output bit 2                                    */
  __IOM uint32_t  BIT3;                         /*!< Data control register for output bit 3                                    */
  __IOM uint32_t  BIT4;                         /*!< Data control register for output bit 4                                    */
  __IOM uint32_t  BIT5;                         /*!< Data control register for output bit 5                                    */
  __IOM uint32_t  BIT6;                         /*!< Data control register for output bit 6                                    */
  __IOM uint32_t  BIT7;                         /*!< Data control register for output bit 7                                    */
  __IOM uint32_t  EXPAND_SHIFT;                 /*!< Configure the optional shifter inside the command expander                */
  __IOM uint32_t  EXPAND_TMDS;                  /*!< Configure the optional TMDS encoder inside the command expander           */
} HSTX_CTRL_Type;                               /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                           EPPB                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Cortex-M33 EPPB vendor register block for RP2350 (EPPB)
  */

typedef struct {                                /*!< EPPB Structure                                                            */
  __IOM uint32_t  NMI_MASK0;                    /*!< NMI mask for IRQs 0 through 31. This register is core-local,
                                                     and is reset by a processor warm reset.                                   */
  __IOM uint32_t  NMI_MASK1;                    /*!< NMI mask for IRQs 0 though 51. This register is core-local,
                                                     and is reset by a processor warm reset.                                   */
  __IOM uint32_t  SLEEPCTRL;                    /*!< Nonstandard sleep control register                                        */
} EPPB_Type;                                    /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                            PPB                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief TEAL registers accessible through the debug interface (PPB)
  */

typedef struct {                                /*!< PPB Structure                                                             */
  __IOM uint32_t  ITM_STIM0;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM1;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM2;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM3;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM4;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM5;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM6;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM7;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM8;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM9;                    /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM10;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM11;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM12;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM13;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM14;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM15;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM16;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM17;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM18;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM19;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM20;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM21;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM22;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM23;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM24;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM25;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM26;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM27;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM28;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM29;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM30;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IOM uint32_t  ITM_STIM31;                   /*!< Provides the interface for generating Instrumentation packets             */
  __IM  uint32_t  RESERVED[864];
  __IOM uint32_t  ITM_TER0;                     /*!< Provide an individual enable bit for each ITM_STIM register               */
  __IM  uint32_t  RESERVED1[15];
  __IOM uint32_t  ITM_TPR;                      /*!< Controls which stimulus ports can be accessed by unprivileged
                                                     code                                                                      */
  __IM  uint32_t  RESERVED2[15];
  __IOM uint32_t  ITM_TCR;                      /*!< Configures and controls transfers through the ITM interface               */
  __IM  uint32_t  RESERVED3[27];
  __IOM uint32_t  INT_ATREADY;                  /*!< Integration Mode: Read ATB Ready                                          */
  __IM  uint32_t  RESERVED4;
  __IOM uint32_t  INT_ATVALID;                  /*!< Integration Mode: Write ATB Valid                                         */
  __IM  uint32_t  RESERVED5;
  __IOM uint32_t  ITM_ITCTRL;                   /*!< Integration Mode Control Register                                         */
  __IM  uint32_t  RESERVED6[46];
  __IOM uint32_t  ITM_DEVARCH;                  /*!< Provides CoreSight discovery information for the ITM                      */
  __IM  uint32_t  RESERVED7[3];
  __IOM uint32_t  ITM_DEVTYPE;                  /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR4;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR5;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR6;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR7;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR0;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR1;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR2;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_PIDR3;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_CIDR0;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_CIDR1;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_CIDR2;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  ITM_CIDR3;                    /*!< Provides CoreSight discovery information for the ITM                      */
  __IOM uint32_t  DWT_CTRL;                     /*!< Provides configuration and status information for the DWT unit,
                                                     and used to control features of the unit                                  */
  __IOM uint32_t  DWT_CYCCNT;                   /*!< Shows or sets the value of the processor cycle counter, CYCCNT            */
  __IM  uint32_t  RESERVED8;
  __IOM uint32_t  DWT_EXCCNT;                   /*!< Counts the total cycles spent in exception processing                     */
  __IM  uint32_t  RESERVED9;
  __IOM uint32_t  DWT_LSUCNT;                   /*!< Increments on the additional cycles required to execute all
                                                     load or store instructions                                                */
  __IOM uint32_t  DWT_FOLDCNT;                  /*!< Increments on the additional cycles required to execute all
                                                     load or store instructions                                                */
  __IM  uint32_t  RESERVED10;
  __IOM uint32_t  DWT_COMP0;                    /*!< Provides a reference value for use by watchpoint comparator
                                                     0                                                                         */
  __IM  uint32_t  RESERVED11;
  __IOM uint32_t  DWT_FUNCTION0;                /*!< Controls the operation of watchpoint comparator 0                         */
  __IM  uint32_t  RESERVED12;
  __IOM uint32_t  DWT_COMP1;                    /*!< Provides a reference value for use by watchpoint comparator
                                                     1                                                                         */
  __IM  uint32_t  RESERVED13;
  __IOM uint32_t  DWT_FUNCTION1;                /*!< Controls the operation of watchpoint comparator 1                         */
  __IM  uint32_t  RESERVED14;
  __IOM uint32_t  DWT_COMP2;                    /*!< Provides a reference value for use by watchpoint comparator
                                                     2                                                                         */
  __IM  uint32_t  RESERVED15;
  __IOM uint32_t  DWT_FUNCTION2;                /*!< Controls the operation of watchpoint comparator 2                         */
  __IM  uint32_t  RESERVED16;
  __IOM uint32_t  DWT_COMP3;                    /*!< Provides a reference value for use by watchpoint comparator
                                                     3                                                                         */
  __IM  uint32_t  RESERVED17;
  __IOM uint32_t  DWT_FUNCTION3;                /*!< Controls the operation of watchpoint comparator 3                         */
  __IM  uint32_t  RESERVED18[984];
  __IOM uint32_t  DWT_DEVARCH;                  /*!< Provides CoreSight discovery information for the DWT                      */
  __IM  uint32_t  RESERVED19[3];
  __IOM uint32_t  DWT_DEVTYPE;                  /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR4;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR5;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR6;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR7;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR0;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR1;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR2;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_PIDR3;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_CIDR0;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_CIDR1;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_CIDR2;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  DWT_CIDR3;                    /*!< Provides CoreSight discovery information for the DWT                      */
  __IOM uint32_t  FP_CTRL;                      /*!< Provides FPB implementation information, and the global enable
                                                     for the FPB unit                                                          */
  __IOM uint32_t  FP_REMAP;                     /*!< Indicates whether the implementation supports Flash Patch remap
                                                     and, if it does, holds the target address for remap                       */
  __IOM uint32_t  FP_COMP0;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP1;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP2;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP3;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP4;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP5;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP6;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IOM uint32_t  FP_COMP7;                     /*!< Holds an address for comparison. The effect of the match depends
                                                     on the configuration of the FPB and whether the comparator
                                                     is an instruction address comparator or a literal address
                                                     comparator                                                                */
  __IM  uint32_t  RESERVED20[997];
  __IOM uint32_t  FP_DEVARCH;                   /*!< Provides CoreSight discovery information for the FPB                      */
  __IM  uint32_t  RESERVED21[3];
  __IOM uint32_t  FP_DEVTYPE;                   /*!< Provides CoreSight discovery information for the FPB                      */
  __IOM uint32_t  FP_PIDR4;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR5;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR6;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR7;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR0;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR1;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR2;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_PIDR3;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_CIDR0;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_CIDR1;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_CIDR2;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IOM uint32_t  FP_CIDR3;                     /*!< Provides CoreSight discovery information for the FP                       */
  __IM  uint32_t  RESERVED22[11265];
  __IOM uint32_t  ICTR;                         /*!< Provides information about the interrupt controller                       */
  __IOM uint32_t  ACTLR;                        /*!< Provides IMPLEMENTATION DEFINED configuration and control options         */
  __IM  uint32_t  RESERVED23;
  __IOM uint32_t  SYST_CSR;                     /*!< Use the SysTick Control and Status Register to enable the SysTick
                                                     features.                                                                 */
  __IOM uint32_t  SYST_RVR;                     /*!< Use the SysTick Reload Value Register to specify the start value
                                                     to load into the current value register when the counter
                                                     reaches 0. It can be any value between 0 and 0x00FFFFFF.
                                                     A start value of 0 is possible, but has no effect because
                                                     the SysTick interrupt and COUNTFLAG are activated when
                                                     counting from 1 to 0. The reset value of this register
                                                     is UNKNOWN. To generate a multi-shot timer with a period
                                                     of N processor clock cycles, use a RELOAD value of N-1.
                                                     For example, if the SysTick interrupt is required every
                                                     100 clock pulses, set RELOAD to 99.                                       */
  __IOM uint32_t  SYST_CVR;                     /*!< Use the SysTick Current Value Register to find the current value
                                                     in the register. The reset value of this register is UNKNOWN.             */
  __IOM uint32_t  SYST_CALIB;                   /*!< Use the SysTick Calibration Value Register to enable software
                                                     to scale to any required speed using divide and multiply.                 */
  __IM  uint32_t  RESERVED24[56];
  __IOM uint32_t  NVIC_ISER0;                   /*!< Enables or reads the enabled state of each group of 32 interrupts         */
  __IOM uint32_t  NVIC_ISER1;                   /*!< Enables or reads the enabled state of each group of 32 interrupts         */
  __IM  uint32_t  RESERVED25[30];
  __IOM uint32_t  NVIC_ICER0;                   /*!< Clears or reads the enabled state of each group of 32 interrupts          */
  __IOM uint32_t  NVIC_ICER1;                   /*!< Clears or reads the enabled state of each group of 32 interrupts          */
  __IM  uint32_t  RESERVED26[30];
  __IOM uint32_t  NVIC_ISPR0;                   /*!< Enables or reads the pending state of each group of 32 interrupts         */
  __IOM uint32_t  NVIC_ISPR1;                   /*!< Enables or reads the pending state of each group of 32 interrupts         */
  __IM  uint32_t  RESERVED27[30];
  __IOM uint32_t  NVIC_ICPR0;                   /*!< Clears or reads the pending state of each group of 32 interrupts          */
  __IOM uint32_t  NVIC_ICPR1;                   /*!< Clears or reads the pending state of each group of 32 interrupts          */
  __IM  uint32_t  RESERVED28[30];
  __IOM uint32_t  NVIC_IABR0;                   /*!< For each group of 32 interrupts, shows the active state of each
                                                     interrupt                                                                 */
  __IOM uint32_t  NVIC_IABR1;                   /*!< For each group of 32 interrupts, shows the active state of each
                                                     interrupt                                                                 */
  __IM  uint32_t  RESERVED29[30];
  __IOM uint32_t  NVIC_ITNS0;                   /*!< For each group of 32 interrupts, determines whether each interrupt
                                                     targets Non-secure or Secure state                                        */
  __IOM uint32_t  NVIC_ITNS1;                   /*!< For each group of 32 interrupts, determines whether each interrupt
                                                     targets Non-secure or Secure state                                        */
  __IM  uint32_t  RESERVED30[30];
  __IOM uint32_t  NVIC_IPR0;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR1;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR2;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR3;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR4;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR5;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR6;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR7;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR8;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR9;                    /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR10;                   /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR11;                   /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR12;                   /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR13;                   /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR14;                   /*!< Sets or reads interrupt priorities                                        */
  __IOM uint32_t  NVIC_IPR15;                   /*!< Sets or reads interrupt priorities                                        */
  __IM  uint32_t  RESERVED31[560];
  __IOM uint32_t  CPUID;                        /*!< Provides identification information for the PE, including an
                                                     implementer code for the device and a device ID number                    */
  __IOM uint32_t  ICSR;                         /*!< Controls and provides status information for NMI, PendSV, SysTick
                                                     and interrupts                                                            */
  __IOM uint32_t  VTOR;                         /*!< The VTOR indicates the offset of the vector table base address
                                                     from memory address 0x00000000.                                           */
  __IOM uint32_t  AIRCR;                        /*!< Use the Application Interrupt and Reset Control Register to:
                                                     determine data endianness, clear all active state information
                                                     from debug halt mode, request a system reset.                             */
  __IOM uint32_t  SCR;                          /*!< System Control Register. Use the System Control Register for
                                                     power-management functions: signal to the system when the
                                                     processor can enter a low power state, control how the
                                                     processor enters and exits low power states.                              */
  __IOM uint32_t  CCR;                          /*!< Sets or returns configuration and control data                            */
  __IOM uint32_t  SHPR1;                        /*!< Sets or returns priority for system handlers 4 - 7                        */
  __IOM uint32_t  SHPR2;                        /*!< Sets or returns priority for system handlers 8 - 11                       */
  __IOM uint32_t  SHPR3;                        /*!< Sets or returns priority for system handlers 12 - 15                      */
  __IOM uint32_t  SHCSR;                        /*!< Provides access to the active and pending status of system exceptions     */
  __IOM uint32_t  CFSR;                         /*!< Contains the three Configurable Fault Status Registers. 31:16
                                                     UFSR: Provides information on UsageFault exceptions 15:8
                                                     BFSR: Provides information on BusFault exceptions 7:0 MMFSR:
                                                     Provides information on MemManage exceptions                              */
  __IOM uint32_t  HFSR;                         /*!< Shows the cause of any HardFaults                                         */
  __IOM uint32_t  DFSR;                         /*!< Shows which debug event occurred                                          */
  __IOM uint32_t  MMFAR;                        /*!< Shows the address of the memory location that caused an MPU
                                                     fault                                                                     */
  __IOM uint32_t  BFAR;                         /*!< Shows the address associated with a precise data access BusFault          */
  __IM  uint32_t  RESERVED32;
  __IOM uint32_t  ID_PFR0;                      /*!< Gives top-level information about the instruction set supported
                                                     by the PE                                                                 */
  __IOM uint32_t  ID_PFR1;                      /*!< Gives information about the programmers' model and Extensions
                                                     support                                                                   */
  __IOM uint32_t  ID_DFR0;                      /*!< Provides top level information about the debug system                     */
  __IOM uint32_t  ID_AFR0;                      /*!< Provides information about the IMPLEMENTATION DEFINED features
                                                     of the PE                                                                 */
  __IOM uint32_t  ID_MMFR0;                     /*!< Provides information about the implemented memory model and
                                                     memory management support                                                 */
  __IOM uint32_t  ID_MMFR1;                     /*!< Provides information about the implemented memory model and
                                                     memory management support                                                 */
  __IOM uint32_t  ID_MMFR2;                     /*!< Provides information about the implemented memory model and
                                                     memory management support                                                 */
  __IOM uint32_t  ID_MMFR3;                     /*!< Provides information about the implemented memory model and
                                                     memory management support                                                 */
  __IOM uint32_t  ID_ISAR0;                     /*!< Provides information about the instruction set implemented by
                                                     the PE                                                                    */
  __IOM uint32_t  ID_ISAR1;                     /*!< Provides information about the instruction set implemented by
                                                     the PE                                                                    */
  __IOM uint32_t  ID_ISAR2;                     /*!< Provides information about the instruction set implemented by
                                                     the PE                                                                    */
  __IOM uint32_t  ID_ISAR3;                     /*!< Provides information about the instruction set implemented by
                                                     the PE                                                                    */
  __IOM uint32_t  ID_ISAR4;                     /*!< Provides information about the instruction set implemented by
                                                     the PE                                                                    */
  __IOM uint32_t  ID_ISAR5;                     /*!< Provides information about the instruction set implemented by
                                                     the PE                                                                    */
  __IM  uint32_t  RESERVED33;
  __IOM uint32_t  CTR;                          /*!< Provides information about the architecture of the caches. CTR
                                                     is RES0 if CLIDR is zero.                                                 */
  __IM  uint32_t  RESERVED34[2];
  __IOM uint32_t  CPACR;                        /*!< Specifies the access privileges for coprocessors and the FP
                                                     Extension                                                                 */
  __IOM uint32_t  NSACR;                        /*!< Defines the Non-secure access permissions for both the FP Extension
                                                     and coprocessors CP0 to CP7                                               */
  __IOM uint32_t  MPU_TYPE;                     /*!< The MPU Type Register indicates how many regions the MPU `FTSSS
                                                     supports                                                                  */
  __IOM uint32_t  MPU_CTRL;                     /*!< Enables the MPU and, when the MPU is enabled, controls whether
                                                     the default memory map is enabled as a background region
                                                     for privileged accesses, and whether the MPU is enabled
                                                     for HardFaults, NMIs, and exception handlers when FAULTMASK
                                                     is set to 1                                                               */
  __IOM uint32_t  MPU_RNR;                      /*!< Selects the region currently accessed by MPU_RBAR and MPU_RLAR            */
  __IOM uint32_t  MPU_RBAR;                     /*!< Provides indirect read and write access to the base address
                                                     of the currently selected MPU region `FTSSS                               */
  __IOM uint32_t  MPU_RLAR;                     /*!< Provides indirect read and write access to the limit address
                                                     of the currently selected MPU region `FTSSS                               */
  __IOM uint32_t  MPU_RBAR_A1;                  /*!< Provides indirect read and write access to the base address
                                                     of the MPU region selected by MPU_RNR[7:2]:(1[1:0]) `FTSSS                */
  __IOM uint32_t  MPU_RLAR_A1;                  /*!< Provides indirect read and write access to the limit address
                                                     of the currently selected MPU region selected by MPU_RNR[7:2]:(1[1:0])
                                                     `FTSSS                                                                    */
  __IOM uint32_t  MPU_RBAR_A2;                  /*!< Provides indirect read and write access to the base address
                                                     of the MPU region selected by MPU_RNR[7:2]:(2[1:0]) `FTSSS                */
  __IOM uint32_t  MPU_RLAR_A2;                  /*!< Provides indirect read and write access to the limit address
                                                     of the currently selected MPU region selected by MPU_RNR[7:2]:(2[1:0])
                                                     `FTSSS                                                                    */
  __IOM uint32_t  MPU_RBAR_A3;                  /*!< Provides indirect read and write access to the base address
                                                     of the MPU region selected by MPU_RNR[7:2]:(3[1:0]) `FTSSS                */
  __IOM uint32_t  MPU_RLAR_A3;                  /*!< Provides indirect read and write access to the limit address
                                                     of the currently selected MPU region selected by MPU_RNR[7:2]:(3[1:0])
                                                     `FTSSS                                                                    */
  __IM  uint32_t  RESERVED35;
  __IOM uint32_t  MPU_MAIR0;                    /*!< Along with MPU_MAIR1, provides the memory attribute encodings
                                                     corresponding to the AttrIndex values                                     */
  __IOM uint32_t  MPU_MAIR1;                    /*!< Along with MPU_MAIR0, provides the memory attribute encodings
                                                     corresponding to the AttrIndex values                                     */
  __IM  uint32_t  RESERVED36[2];
  __IOM uint32_t  SAU_CTRL;                     /*!< Allows enabling of the Security Attribution Unit                          */
  __IOM uint32_t  SAU_TYPE;                     /*!< Indicates the number of regions implemented by the Security
                                                     Attribution Unit                                                          */
  __IOM uint32_t  SAU_RNR;                      /*!< Selects the region currently accessed by SAU_RBAR and SAU_RLAR            */
  __IOM uint32_t  SAU_RBAR;                     /*!< Provides indirect read and write access to the base address
                                                     of the currently selected SAU region                                      */
  __IOM uint32_t  SAU_RLAR;                     /*!< Provides indirect read and write access to the limit address
                                                     of the currently selected SAU region                                      */
  __IOM uint32_t  SFSR;                         /*!< Provides information about any security related faults                    */
  __IOM uint32_t  SFAR;                         /*!< Shows the address of the memory location that caused a Security
                                                     violation                                                                 */
  __IM  uint32_t  RESERVED37;
  __IOM uint32_t  DHCSR;                        /*!< Controls halting debug                                                    */
  __IOM uint32_t  DCRSR;                        /*!< With the DCRDR, provides debug access to the general-purpose
                                                     registers, special-purpose registers, and the FP extension
                                                     registers. A write to the DCRSR specifies the register
                                                     to transfer, whether the transfer is a read or write, and
                                                     starts the transfer                                                       */
  __IOM uint32_t  DCRDR;                        /*!< With the DCRSR, provides debug access to the general-purpose
                                                     registers, special-purpose registers, and the FP Extension
                                                     registers. If the Main Extension is implemented, it can
                                                     also be used for message passing between an external debugger
                                                     and a debug agent running on the PE                                       */
  __IOM uint32_t  DEMCR;                        /*!< Manages vector catch behavior and DebugMonitor handling when
                                                     debugging                                                                 */
  __IM  uint32_t  RESERVED38[2];
  __IOM uint32_t  DSCSR;                        /*!< Provides control and status information for Secure debug                  */
  __IM  uint32_t  RESERVED39[61];
  __IOM uint32_t  STIR;                         /*!< Provides a mechanism for software to generate an interrupt                */
  __IM  uint32_t  RESERVED40[12];
  __IOM uint32_t  FPCCR;                        /*!< Holds control data for the Floating-point extension                       */
  __IOM uint32_t  FPCAR;                        /*!< Holds the location of the unpopulated floating-point register
                                                     space allocated on an exception stack frame                               */
  __IOM uint32_t  FPDSCR;                       /*!< Holds the default values for the floating-point status control
                                                     data that the PE assigns to the FPSCR when it creates a
                                                     new floating-point context                                                */
  __IOM uint32_t  MVFR0;                        /*!< Describes the features provided by the Floating-point Extension           */
  __IOM uint32_t  MVFR1;                        /*!< Describes the features provided by the Floating-point Extension           */
  __IOM uint32_t  MVFR2;                        /*!< Describes the features provided by the Floating-point Extension           */
  __IM  uint32_t  RESERVED41[28];
  __IOM uint32_t  DDEVARCH;                     /*!< Provides CoreSight discovery information for the SCS                      */
  __IM  uint32_t  RESERVED42[3];
  __IOM uint32_t  DDEVTYPE;                     /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR4;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR5;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR6;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR7;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR0;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR1;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR2;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DPIDR3;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DCIDR0;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DCIDR1;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DCIDR2;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IOM uint32_t  DCIDR3;                       /*!< Provides CoreSight discovery information for the SCS                      */
  __IM  uint32_t  RESERVED43[51201];
  __IOM uint32_t  TRCPRGCTLR;                   /*!< Programming Control Register                                              */
  __IM  uint32_t  RESERVED44;
  __IOM uint32_t  TRCSTATR;                     /*!< The TRCSTATR indicates the ETM-Teal status                                */
  __IOM uint32_t  TRCCONFIGR;                   /*!< The TRCCONFIGR sets the basic tracing options for the trace
                                                     unit                                                                      */
  __IM  uint32_t  RESERVED45[3];
  __IOM uint32_t  TRCEVENTCTL0R;                /*!< The TRCEVENTCTL0R controls the tracing of events in the trace
                                                     stream. The events also drive the ETM-Teal external outputs.              */
  __IOM uint32_t  TRCEVENTCTL1R;                /*!< The TRCEVENTCTL1R controls how the events selected by TRCEVENTCTL0R
                                                     behave                                                                    */
  __IM  uint32_t  RESERVED46;
  __IOM uint32_t  TRCSTALLCTLR;                 /*!< The TRCSTALLCTLR enables ETM-Teal to stall the processor if
                                                     the ETM-Teal FIFO goes over the programmed level to minimize
                                                     risk of overflow                                                          */
  __IOM uint32_t  TRCTSCTLR;                    /*!< The TRCTSCTLR controls the insertion of global timestamps into
                                                     the trace stream. A timestamp is always inserted into the
                                                     instruction trace stream                                                  */
  __IOM uint32_t  TRCSYNCPR;                    /*!< The TRCSYNCPR specifies the period of trace synchronization
                                                     of the trace streams. TRCSYNCPR defines a number of bytes
                                                     of trace between requests for trace synchronization. This
                                                     value is always a power of two                                            */
  __IOM uint32_t  TRCCCCTLR;                    /*!< The TRCCCCTLR sets the threshold value for instruction trace
                                                     cycle counting. The threshold represents the minimum interval
                                                     between cycle count trace packets                                         */
  __IM  uint32_t  RESERVED47[17];
  __IOM uint32_t  TRCVICTLR;                    /*!< The TRCVICTLR controls instruction trace filtering                        */
  __IM  uint32_t  RESERVED48[47];
  __IOM uint32_t  TRCCNTRLDVR0;                 /*!< The TRCCNTRLDVR defines the reload value for the reduced function
                                                     counter                                                                   */
  __IM  uint32_t  RESERVED49[15];
  __IOM uint32_t  TRCIDR8;                      /*!< TRCIDR8                                                                   */
  __IOM uint32_t  TRCIDR9;                      /*!< TRCIDR9                                                                   */
  __IOM uint32_t  TRCIDR10;                     /*!< TRCIDR10                                                                  */
  __IOM uint32_t  TRCIDR11;                     /*!< TRCIDR11                                                                  */
  __IOM uint32_t  TRCIDR12;                     /*!< TRCIDR12                                                                  */
  __IOM uint32_t  TRCIDR13;                     /*!< TRCIDR13                                                                  */
  __IM  uint32_t  RESERVED50[10];
  __IOM uint32_t  TRCIMSPEC;                    /*!< The TRCIMSPEC shows the presence of any IMPLEMENTATION SPECIFIC
                                                     features, and enables any features that are provided                      */
  __IM  uint32_t  RESERVED51[7];
  __IOM uint32_t  TRCIDR0;                      /*!< TRCIDR0                                                                   */
  __IOM uint32_t  TRCIDR1;                      /*!< TRCIDR1                                                                   */
  __IOM uint32_t  TRCIDR2;                      /*!< TRCIDR2                                                                   */
  __IOM uint32_t  TRCIDR3;                      /*!< TRCIDR3                                                                   */
  __IOM uint32_t  TRCIDR4;                      /*!< TRCIDR4                                                                   */
  __IOM uint32_t  TRCIDR5;                      /*!< TRCIDR5                                                                   */
  __IOM uint32_t  TRCIDR6;                      /*!< TRCIDR6                                                                   */
  __IOM uint32_t  TRCIDR7;                      /*!< TRCIDR7                                                                   */
  __IM  uint32_t  RESERVED52[2];
  __IOM uint32_t  TRCRSCTLR2;                   /*!< The TRCRSCTLR controls the trace resources                                */
  __IOM uint32_t  TRCRSCTLR3;                   /*!< The TRCRSCTLR controls the trace resources                                */
  __IM  uint32_t  RESERVED53[36];
  __IOM uint32_t  TRCSSCSR;                     /*!< Controls the corresponding single-shot comparator resource                */
  __IM  uint32_t  RESERVED54[7];
  __IOM uint32_t  TRCSSPCICR;                   /*!< Selects the PE comparator inputs for Single-shot control                  */
  __IM  uint32_t  RESERVED55[19];
  __IOM uint32_t  TRCPDCR;                      /*!< Requests the system to provide power to the trace unit                    */
  __IOM uint32_t  TRCPDSR;                      /*!< Returns the following information about the trace unit: - OS
                                                     Lock status. - Core power domain status. - Power interruption
                                                     status                                                                    */
  __IM  uint32_t  RESERVED56[755];
  __IOM uint32_t  TRCITATBIDR;                  /*!< Trace Integration ATB Identification Register                             */
  __IM  uint32_t  RESERVED57[3];
  __IOM uint32_t  TRCITIATBINR;                 /*!< Trace Integration Instruction ATB In Register                             */
  __IM  uint32_t  RESERVED58;
  __IOM uint32_t  TRCITIATBOUTR;                /*!< Trace Integration Instruction ATB Out Register                            */
  __IM  uint32_t  RESERVED59[40];
  __IOM uint32_t  TRCCLAIMSET;                  /*!< Claim Tag Set Register                                                    */
  __IOM uint32_t  TRCCLAIMCLR;                  /*!< Claim Tag Clear Register                                                  */
  __IM  uint32_t  RESERVED60[4];
  __IOM uint32_t  TRCAUTHSTATUS;                /*!< Returns the level of tracing that the trace unit can support              */
  __IOM uint32_t  TRCDEVARCH;                   /*!< TRCDEVARCH                                                                */
  __IM  uint32_t  RESERVED61[2];
  __IOM uint32_t  TRCDEVID;                     /*!< TRCDEVID                                                                  */
  __IOM uint32_t  TRCDEVTYPE;                   /*!< TRCDEVTYPE                                                                */
  __IOM uint32_t  TRCPIDR4;                     /*!< TRCPIDR4                                                                  */
  __IOM uint32_t  TRCPIDR5;                     /*!< TRCPIDR5                                                                  */
  __IOM uint32_t  TRCPIDR6;                     /*!< TRCPIDR6                                                                  */
  __IOM uint32_t  TRCPIDR7;                     /*!< TRCPIDR7                                                                  */
  __IOM uint32_t  TRCPIDR0;                     /*!< TRCPIDR0                                                                  */
  __IOM uint32_t  TRCPIDR1;                     /*!< TRCPIDR1                                                                  */
  __IOM uint32_t  TRCPIDR2;                     /*!< TRCPIDR2                                                                  */
  __IOM uint32_t  TRCPIDR3;                     /*!< TRCPIDR3                                                                  */
  __IOM uint32_t  TRCCIDR0;                     /*!< TRCCIDR0                                                                  */
  __IOM uint32_t  TRCCIDR1;                     /*!< TRCCIDR1                                                                  */
  __IOM uint32_t  TRCCIDR2;                     /*!< TRCCIDR2                                                                  */
  __IOM uint32_t  TRCCIDR3;                     /*!< TRCCIDR3                                                                  */
  __IOM uint32_t  CTICONTROL;                   /*!< CTI Control Register                                                      */
  __IM  uint32_t  RESERVED62[3];
  __IOM uint32_t  CTIINTACK;                    /*!< CTI Interrupt Acknowledge Register                                        */
  __IOM uint32_t  CTIAPPSET;                    /*!< CTI Application Trigger Set Register                                      */
  __IOM uint32_t  CTIAPPCLEAR;                  /*!< CTI Application Trigger Clear Register                                    */
  __IOM uint32_t  CTIAPPPULSE;                  /*!< CTI Application Pulse Register                                            */
  __IOM uint32_t  CTIINEN0;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN1;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN2;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN3;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN4;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN5;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN6;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIINEN7;                     /*!< CTI Trigger to Channel Enable Registers                                   */
  __IM  uint32_t  RESERVED63[24];
  __IOM uint32_t  CTIOUTEN0;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN1;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN2;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN3;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN4;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN5;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN6;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTIOUTEN7;                    /*!< CTI Trigger to Channel Enable Registers                                   */
  __IM  uint32_t  RESERVED64[28];
  __IOM uint32_t  CTITRIGINSTATUS;              /*!< CTI Trigger to Channel Enable Registers                                   */
  __IOM uint32_t  CTITRIGOUTSTATUS;             /*!< CTI Trigger In Status Register                                            */
  __IOM uint32_t  CTICHINSTATUS;                /*!< CTI Channel In Status Register                                            */
  __IM  uint32_t  RESERVED65;
  __IOM uint32_t  CTIGATE;                      /*!< Enable CTI Channel Gate register                                          */
  __IOM uint32_t  ASICCTL;                      /*!< External Multiplexer Control register                                     */
  __IM  uint32_t  RESERVED66[871];
  __IOM uint32_t  ITCHOUT;                      /*!< Integration Test Channel Output register                                  */
  __IOM uint32_t  ITTRIGOUT;                    /*!< Integration Test Trigger Output register                                  */
  __IM  uint32_t  RESERVED67[2];
  __IOM uint32_t  ITCHIN;                       /*!< Integration Test Channel Input register                                   */
  __IM  uint32_t  RESERVED68[2];
  __IOM uint32_t  ITCTRL;                       /*!< Integration Mode Control register                                         */
  __IM  uint32_t  RESERVED69[46];
  __IOM uint32_t  DEVARCH;                      /*!< Device Architecture register                                              */
  __IM  uint32_t  RESERVED70[2];
  __IOM uint32_t  DEVID;                        /*!< Device Configuration register                                             */
  __IOM uint32_t  DEVTYPE;                      /*!< Device Type Identifier register                                           */
  __IOM uint32_t  PIDR4;                        /*!< CoreSight Peripheral ID4                                                  */
  __IOM uint32_t  PIDR5;                        /*!< CoreSight Peripheral ID5                                                  */
  __IOM uint32_t  PIDR6;                        /*!< CoreSight Peripheral ID6                                                  */
  __IOM uint32_t  PIDR7;                        /*!< CoreSight Peripheral ID7                                                  */
  __IOM uint32_t  PIDR0;                        /*!< CoreSight Peripheral ID0                                                  */
  __IOM uint32_t  PIDR1;                        /*!< CoreSight Peripheral ID1                                                  */
  __IOM uint32_t  PIDR2;                        /*!< CoreSight Peripheral ID2                                                  */
  __IOM uint32_t  PIDR3;                        /*!< CoreSight Peripheral ID3                                                  */
  __IOM uint32_t  CIDR0;                        /*!< CoreSight Component ID0                                                   */
  __IOM uint32_t  CIDR1;                        /*!< CoreSight Component ID1                                                   */
  __IOM uint32_t  CIDR2;                        /*!< CoreSight Component ID2                                                   */
  __IOM uint32_t  CIDR3;                        /*!< CoreSight Component ID3                                                   */
} PPB_Type;                                     /*!< Size = 274432 (0x43000)                                                   */



/* =========================================================================================================================== */
/* ================                                            QMI                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief QSPI Memory Interface.

            Provides a memory-mapped interface to up to two SPI/DSPI/QSPI flash or PSRAM devices. Also provides a serial interface for programming and configuration of the external device. (QMI)
  */

typedef struct {                                /*!< QMI Structure                                                             */
  __IOM uint32_t  DIRECT_CSR;                   /*!< Control and status for direct serial mode Direct serial mode
                                                     allows the processor to send and receive raw serial frames,
                                                     for programming, configuration and control of the external
                                                     memory devices. Only SPI mode 0 (CPOL=0 CPHA=0) is supported.             */
  __IOM uint32_t  DIRECT_TX;                    /*!< Transmit FIFO for direct mode                                             */
  __IOM uint32_t  DIRECT_RX;                    /*!< Receive FIFO for direct mode                                              */
  __IOM uint32_t  M0_TIMING;                    /*!< Timing configuration register for memory address window 0.                */
  __IOM uint32_t  M0_RFMT;                      /*!< Read transfer format configuration for memory address window
                                                     0. Configure the bus width of each transfer phase individually,
                                                     and configure the length or presence of the command prefix,
                                                     command suffix and dummy/turnaround transfer phases. Only
                                                     24-bit addresses are supported. The reset value of the
                                                     M0_RFMT register is configured to support a basic 03h serial
                                                     read transfer with no additional configuration.                           */
  __IOM uint32_t  M0_RCMD;                      /*!< Command constants used for reads from memory address window
                                                     0. The reset value of the M0_RCMD register is configured
                                                     to support a basic 03h serial read transfer with no additional
                                                     configuration.                                                            */
  __IOM uint32_t  M0_WFMT;                      /*!< Write transfer format configuration for memory address window
                                                     0. Configure the bus width of each transfer phase individually,
                                                     and configure the length or presence of the command prefix,
                                                     command suffix and dummy/turnaround transfer phases. Only
                                                     24-bit addresses are supported. The reset value of the
                                                     M0_WFMT register is configured to support a basic 02h serial
                                                     write transfer. However, writes to this window must first
                                                     be enabled via the XIP_CTRL_WRITABLE_M0 bit, as XIP memory
                                                     is read-only by default.                                                  */
  __IOM uint32_t  M0_WCMD;                      /*!< Command constants used for writes to memory address window 0.
                                                     The reset value of the M0_WCMD register is configured to
                                                     support a basic 02h serial write transfer with no additional
                                                     configuration.                                                            */
  __IOM uint32_t  M1_TIMING;                    /*!< Timing configuration register for memory address window 1.                */
  __IOM uint32_t  M1_RFMT;                      /*!< Read transfer format configuration for memory address window
                                                     1. Configure the bus width of each transfer phase individually,
                                                     and configure the length or presence of the command prefix,
                                                     command suffix and dummy/turnaround transfer phases. Only
                                                     24-bit addresses are supported. The reset value of the
                                                     M1_RFMT register is configured to support a basic 03h serial
                                                     read transfer with no additional configuration.                           */
  __IOM uint32_t  M1_RCMD;                      /*!< Command constants used for reads from memory address window
                                                     1. The reset value of the M1_RCMD register is configured
                                                     to support a basic 03h serial read transfer with no additional
                                                     configuration.                                                            */
  __IOM uint32_t  M1_WFMT;                      /*!< Write transfer format configuration for memory address window
                                                     1. Configure the bus width of each transfer phase individually,
                                                     and configure the length or presence of the command prefix,
                                                     command suffix and dummy/turnaround transfer phases. Only
                                                     24-bit addresses are supported. The reset value of the
                                                     M1_WFMT register is configured to support a basic 02h serial
                                                     write transfer. However, writes to this window must first
                                                     be enabled via the XIP_CTRL_WRITABLE_M1 bit, as XIP memory
                                                     is read-only by default.                                                  */
  __IOM uint32_t  M1_WCMD;                      /*!< Command constants used for writes to memory address window 1.
                                                     The reset value of the M1_WCMD register is configured to
                                                     support a basic 02h serial write transfer with no additional
                                                     configuration.                                                            */
  __IOM uint32_t  ATRANS0;                      /*!< Configure address translation for XIP virtual addresses 0x000000
                                                     through 0x3fffff (a 4 MiB window starting at +0 MiB). Address
                                                     translation allows a program image to be executed in place
                                                     at multiple physical flash addresses (for example, a double-buffered
                                                     flash image for over-the-air updates), without the overhead
                                                     of position-independent code. At reset, the address translation
                                                     registers are initialised to an identity mapping, so that
                                                     they can be ignored if address translation is not required.
                                                     Note that the XIP cache is fully virtually addressed, so
                                                     a cache flush is required after changing the address translation.         */
  __IOM uint32_t  ATRANS1;                      /*!< Configure address translation for XIP virtual addresses 0x400000
                                                     through 0x7fffff (a 4 MiB window starting at +4 MiB). Address
                                                     translation allows a program image to be executed in place
                                                     at multiple physical flash addresses (for example, a double-buffered
                                                     flash image for over-the-air updates), without the overhead
                                                     of position-independent code. At reset, the address translation
                                                     registers are initialised to an identity mapping, so that
                                                     they can be ignored if address translation is not required.
                                                     Note that the XIP cache is fully virtually addressed, so
                                                     a cache flush is required after changing the address translation.         */
  __IOM uint32_t  ATRANS2;                      /*!< Configure address translation for XIP virtual addresses 0x800000
                                                     through 0xbfffff (a 4 MiB window starting at +8 MiB). Address
                                                     translation allows a program image to be executed in place
                                                     at multiple physical flash addresses (for example, a double-buffered
                                                     flash image for over-the-air updates), without the overhead
                                                     of position-independent code. At reset, the address translation
                                                     registers are initialised to an identity mapping, so that
                                                     they can be ignored if address translation is not required.
                                                     Note that the XIP cache is fully virtually addressed, so
                                                     a cache flush is required after changing the address translation.         */
  __IOM uint32_t  ATRANS3;                      /*!< Configure address translation for XIP virtual addresses 0xc00000
                                                     through 0xffffff (a 4 MiB window starting at +12 MiB).
                                                     Address translation allows a program image to be executed
                                                     in place at multiple physical flash addresses (for example,
                                                     a double-buffered flash image for over-the-air updates),
                                                     without the overhead of position-independent code. At reset,
                                                     the address translation registers are initialised to an
                                                     identity mapping, so that they can be ignored if address
                                                     translation is not required. Note that the XIP cache is
                                                     fully virtually addressed, so a cache flush is required
                                                     after changing the address translation.                                   */
  __IOM uint32_t  ATRANS4;                      /*!< Configure address translation for XIP virtual addresses 0x1000000
                                                     through 0x13fffff (a 4 MiB window starting at +16 MiB).
                                                     Address translation allows a program image to be executed
                                                     in place at multiple physical flash addresses (for example,
                                                     a double-buffered flash image for over-the-air updates),
                                                     without the overhead of position-independent code. At reset,
                                                     the address translation registers are initialised to an
                                                     identity mapping, so that they can be ignored if address
                                                     translation is not required. Note that the XIP cache is
                                                     fully virtually addressed, so a cache flush is required
                                                     after changing the address translation.                                   */
  __IOM uint32_t  ATRANS5;                      /*!< Configure address translation for XIP virtual addresses 0x1400000
                                                     through 0x17fffff (a 4 MiB window starting at +20 MiB).
                                                     Address translation allows a program image to be executed
                                                     in place at multiple physical flash addresses (for example,
                                                     a double-buffered flash image for over-the-air updates),
                                                     without the overhead of position-independent code. At reset,
                                                     the address translation registers are initialised to an
                                                     identity mapping, so that they can be ignored if address
                                                     translation is not required. Note that the XIP cache is
                                                     fully virtually addressed, so a cache flush is required
                                                     after changing the address translation.                                   */
  __IOM uint32_t  ATRANS6;                      /*!< Configure address translation for XIP virtual addresses 0x1800000
                                                     through 0x1bfffff (a 4 MiB window starting at +24 MiB).
                                                     Address translation allows a program image to be executed
                                                     in place at multiple physical flash addresses (for example,
                                                     a double-buffered flash image for over-the-air updates),
                                                     without the overhead of position-independent code. At reset,
                                                     the address translation registers are initialised to an
                                                     identity mapping, so that they can be ignored if address
                                                     translation is not required. Note that the XIP cache is
                                                     fully virtually addressed, so a cache flush is required
                                                     after changing the address translation.                                   */
  __IOM uint32_t  ATRANS7;                      /*!< Configure address translation for XIP virtual addresses 0x1c00000
                                                     through 0x1ffffff (a 4 MiB window starting at +28 MiB).
                                                     Address translation allows a program image to be executed
                                                     in place at multiple physical flash addresses (for example,
                                                     a double-buffered flash image for over-the-air updates),
                                                     without the overhead of position-independent code. At reset,
                                                     the address translation registers are initialised to an
                                                     identity mapping, so that they can be ignored if address
                                                     translation is not required. Note that the XIP cache is
                                                     fully virtually addressed, so a cache flush is required
                                                     after changing the address translation.                                   */
} QMI_Type;                                     /*!< Size = 84 (0x54)                                                          */



/* =========================================================================================================================== */
/* ================                                         XIP_CTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief QSPI flash execute-in-place block (XIP_CTRL)
  */

typedef struct {                                /*!< XIP_CTRL Structure                                                        */
  __IOM uint32_t  CTRL;                         /*!< Cache control register. Read-only from a Non-secure context.              */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  STAT;                         /*!< STAT                                                                      */
  __IOM uint32_t  CTR_HIT;                      /*!< Cache Hit counter                                                         */
  __IOM uint32_t  CTR_ACC;                      /*!< Cache Access counter                                                      */
  __IOM uint32_t  STREAM_ADDR;                  /*!< FIFO stream address                                                       */
  __IOM uint32_t  STREAM_CTR;                   /*!< FIFO stream control                                                       */
  __IOM uint32_t  STREAM_FIFO;                  /*!< FIFO stream data                                                          */
} XIP_CTRL_Type;                                /*!< Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                          XIP_AUX                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Auxiliary DMA access to XIP FIFOs, via fast AHB bus access (XIP_AUX)
  */

typedef struct {                                /*!< XIP_AUX Structure                                                         */
  __IOM uint32_t  STREAM;                       /*!< Read the XIP stream FIFO (fast bus access to XIP_CTRL_STREAM_FIFO)        */
  __IOM uint32_t  QMI_DIRECT_TX;                /*!< Write to the QMI direct-mode TX FIFO (fast bus access to QMI_DIRECT_TX)   */
  __IOM uint32_t  QMI_DIRECT_RX;                /*!< Read from the QMI direct-mode RX FIFO (fast bus access to QMI_DIRECT_RX)  */
} XIP_AUX_Type;                                 /*!< Size = 12 (0xc)                                                           */



/* =========================================================================================================================== */
/* ================                                          SYSCFG                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Register block for various chip control signals (SYSCFG)
  */

typedef struct {                                /*!< SYSCFG Structure                                                          */
  __IOM uint32_t  PROC_CONFIG;                  /*!< Configuration for processors                                              */
  __IOM uint32_t  PROC_IN_SYNC_BYPASS;          /*!< For each bit, if 1, bypass the input synchronizer between that
                                                     GPIO and the GPIO input register in the SIO. The input
                                                     synchronizers should generally be unbypassed, to avoid
                                                     injecting metastabilities into processors. If you're feeling
                                                     brave, you can bypass to save two cycles of input latency.
                                                     This register applies to GPIO 0...31.                                     */
  __IOM uint32_t  PROC_IN_SYNC_BYPASS_HI;       /*!< For each bit, if 1, bypass the input synchronizer between that
                                                     GPIO and the GPIO input register in the SIO. The input
                                                     synchronizers should generally be unbypassed, to avoid
                                                     injecting metastabilities into processors. If you're feeling
                                                     brave, you can bypass to save two cycles of input latency.
                                                     This register applies to GPIO 32...47. USB GPIO 56..57
                                                     QSPI GPIO 58..63                                                          */
  __IOM uint32_t  DBGFORCE;                     /*!< Directly control the chip SWD debug port                                  */
  __IOM uint32_t  MEMPOWERDOWN;                 /*!< Control PD pins to memories. Set high to put memories to a low
                                                     power state. In this state the memories will retain contents
                                                     but not be accessible Use with caution                                    */
  __IOM uint32_t  AUXCTRL;                      /*!< Auxiliary system control register                                         */
} SYSCFG_Type;                                  /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                           XOSC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Controls the crystal oscillator (XOSC)
  */

typedef struct {                                /*!< XOSC Structure                                                            */
  __IOM uint32_t  CTRL;                         /*!< Crystal Oscillator Control                                                */
  __IOM uint32_t  STATUS;                       /*!< Crystal Oscillator Status                                                 */
  __IOM uint32_t  DORMANT;                      /*!< Crystal Oscillator pause control                                          */
  __IOM uint32_t  STARTUP;                      /*!< Controls the startup delay                                                */
  __IOM uint32_t  COUNT;                        /*!< A down counter running at the xosc frequency which counts to
                                                     zero and stops. Can be used for short software pauses when
                                                     setting up time sensitive hardware. To start the counter,
                                                     write a non-zero value. Reads will return 1 while the count
                                                     is running and 0 when it has finished. Minimum count value
                                                     is 4. Count values <4 will be treated as count value =4.
                                                     Note that synchronisation to the register clock domain
                                                     costs 2 register clock cycles and the counter cannot compensate
                                                     for that.                                                                 */
} XOSC_Type;                                    /*!< Size = 20 (0x14)                                                          */



/* =========================================================================================================================== */
/* ================                                          PLL_SYS                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief PLL_SYS (PLL_SYS)
  */

typedef struct {                                /*!< PLL_SYS Structure                                                         */
  __IOM uint32_t  CS;                           /*!< Control and Status GENERAL CONSTRAINTS: Reference clock frequency
                                                     min=5MHz, max=800MHz Feedback divider min=16, max=320 VCO
                                                     frequency min=750MHz, max=1600MHz                                         */
  __IOM uint32_t  PWR;                          /*!< Controls the PLL power modes.                                             */
  __IOM uint32_t  FBDIV_INT;                    /*!< Feedback divisor (note: this PLL does not support fractional
                                                     division)                                                                 */
  __IOM uint32_t  PRIM;                         /*!< Controls the PLL post dividers for the primary output (note:
                                                     this PLL does not have a secondary output) the primary
                                                     output is driven from VCO divided by postdiv1*postdiv2                    */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
} PLL_SYS_Type;                                 /*!< Size = 32 (0x20)                                                          */



/* =========================================================================================================================== */
/* ================                                        ACCESSCTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief Hardware access control registers (ACCESSCTRL)
  */

typedef struct {                                /*!< ACCESSCTRL Structure                                                      */
  __IOM uint32_t  LOCK;                         /*!< Once a LOCK bit is written to 1, ACCESSCTRL silently ignores
                                                     writes from that master. LOCK is writable only by a Secure,
                                                     Privileged processor or debugger. LOCK bits are only writable
                                                     when their value is zero. Once set, they can never be cleared,
                                                     except by a full reset of ACCESSCTRL Setting the LOCK bit
                                                     does not affect whether an access raises a bus error. Unprivileged
                                                     writes, or writes from the DMA, will continue to raise
                                                     bus errors. All other accesses will continue not to.                      */
  __IOM uint32_t  FORCE_CORE_NS;                /*!< Force core 1's bus accesses to always be Non-secure, no matter
                                                     the core's internal state. Useful for schemes where one
                                                     core is designated as the Non-secure core, since some peripherals
                                                     may filter individual registers internally based on security
                                                     state but not on master ID.                                               */
  __IOM uint32_t  CFGRESET;                     /*!< Write 1 to reset all ACCESSCTRL configuration, except for the
                                                     LOCK and FORCE_CORE_NS registers. This bit is used in the
                                                     RP2350 bootrom to quickly restore ACCESSCTRL to a known
                                                     state during the boot path. Note that, like all registers
                                                     in ACCESSCTRL, this register is not writable when the writer's
                                                     corresponding LOCK bit is set, therefore a master which
                                                     has been locked out of ACCESSCTRL can not use the CFGRESET
                                                     register to disturb its contents.                                         */
  __IOM uint32_t  GPIO_NSMASK0;                 /*!< Control whether GPIO0...31 are accessible to Non-secure code.
                                                     Writable only by a Secure, Privileged processor or debugger.
                                                     0 -> Secure access only 1 -> Secure + Non-secure access                   */
  __IOM uint32_t  GPIO_NSMASK1;                 /*!< Control whether GPIO32..47 are accessible to Non-secure code,
                                                     and whether QSPI and USB bitbang are accessible through
                                                     the Non-secure SIO. Writable only by a Secure, Privileged
                                                     processor or debugger.                                                    */
  __IOM uint32_t  ROM;                          /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     ROM, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  XIP_MAIN;                     /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     XIP_MAIN, and at what security/privilege levels they can
                                                     do so. Defaults to fully open access. This register is
                                                     writable only from a Secure, Privileged processor or debugger,
                                                     with the exception of the NSU bit, which becomes Non-secure-Privileged-wr
                                                     table when the NSP bit is set.                                            */
  __IOM uint32_t  SRAM0;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM0, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM1;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM1, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM2;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM2, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM3;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM3, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM4;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM4, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM5;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM5, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM6;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM6, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM7;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM7, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM8;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM8, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SRAM9;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SRAM9, and at what security/privilege levels they can do
                                                     so. Defaults to fully open access. This register is writable
                                                     only from a Secure, Privileged processor or debugger, with
                                                     the exception of the NSU bit, which becomes Non-secure-Privileged-writabl
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  DMA;                          /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     DMA, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  USBCTRL;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     USBCTRL, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  PIO0;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PIO0, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  PIO1;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PIO1, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  PIO2;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PIO2, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  CORESIGHT_TRACE;              /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     CORESIGHT_TRACE, and at what security/privilege levels
                                                     they can do so. Defaults to Secure, Privileged processor
                                                     or debug access only. This register is writable only from
                                                     a Secure, Privileged processor or debugger, with the exception
                                                     of the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  CORESIGHT_PERIPH;             /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     CORESIGHT_PERIPH, and at what security/privilege levels
                                                     they can do so. Defaults to Secure, Privileged processor
                                                     or debug access only. This register is writable only from
                                                     a Secure, Privileged processor or debugger, with the exception
                                                     of the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  SYSINFO;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SYSINFO, and at what security/privilege levels they can
                                                     do so. Defaults to fully open access. This register is
                                                     writable only from a Secure, Privileged processor or debugger,
                                                     with the exception of the NSU bit, which becomes Non-secure-Privileged-wr
                                                     table when the NSP bit is set.                                            */
  __IOM uint32_t  RESETS;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     RESETS, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  IO_BANK0;                     /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     IO_BANK0, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  IO_BANK1;                     /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     IO_BANK1, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  PADS_BANK0;                   /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PADS_BANK0, and at what security/privilege levels they
                                                     can do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  PADS_QSPI;                    /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PADS_QSPI, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  BUSCTRL;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     BUSCTRL, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  ADC0;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     ADC0, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  HSTX;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     HSTX, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  I2C0;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     I2C0, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  I2C1;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     I2C1, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  PWM;                          /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PWM, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  SPI0;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SPI0, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  SPI1;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SPI1, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  TIMER0;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     TIMER0, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  TIMER1;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     TIMER1, and at what security/privilege levels they can
                                                     do so. Defaults to Secure access from any master. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  UART0;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     UART0, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  UART1;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     UART1, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  OTP;                          /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     OTP, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  TBMAN;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     TBMAN, and at what security/privilege levels they can do
                                                     so. Defaults to Secure access from any master. This register
                                                     is writable only from a Secure, Privileged processor or
                                                     debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  POWMAN;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     POWMAN, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  TRNG;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     TRNG, and at what security/privilege levels they can do
                                                     so. Defaults to Secure, Privileged processor or debug access
                                                     only. This register is writable only from a Secure, Privileged
                                                     processor or debugger, with the exception of the NSU bit,
                                                     which becomes Non-secure-Privileged-writable when the NSP
                                                     bit is set.                                                               */
  __IOM uint32_t  SHA256;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SHA256, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged access only. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
  __IOM uint32_t  SYSCFG;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     SYSCFG, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  CLOCKS;                       /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     CLOCKS, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  XOSC;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     XOSC, and at what security/privilege levels they can do
                                                     so. Defaults to Secure, Privileged processor or debug access
                                                     only. This register is writable only from a Secure, Privileged
                                                     processor or debugger, with the exception of the NSU bit,
                                                     which becomes Non-secure-Privileged-writable when the NSP
                                                     bit is set.                                                               */
  __IOM uint32_t  ROSC;                         /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     ROSC, and at what security/privilege levels they can do
                                                     so. Defaults to Secure, Privileged processor or debug access
                                                     only. This register is writable only from a Secure, Privileged
                                                     processor or debugger, with the exception of the NSU bit,
                                                     which becomes Non-secure-Privileged-writable when the NSP
                                                     bit is set.                                                               */
  __IOM uint32_t  PLL_SYS;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PLL_SYS, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  PLL_USB;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     PLL_USB, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  TICKS;                        /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     TICKS, and at what security/privilege levels they can do
                                                     so. Defaults to Secure, Privileged processor or debug access
                                                     only. This register is writable only from a Secure, Privileged
                                                     processor or debugger, with the exception of the NSU bit,
                                                     which becomes Non-secure-Privileged-writable when the NSP
                                                     bit is set.                                                               */
  __IOM uint32_t  WATCHDOG;                     /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     WATCHDOG, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  RSM;                          /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     RSM, and at what security/privilege levels they can do
                                                     so. Defaults to Secure, Privileged processor or debug access
                                                     only. This register is writable only from a Secure, Privileged
                                                     processor or debugger, with the exception of the NSU bit,
                                                     which becomes Non-secure-Privileged-writable when the NSP
                                                     bit is set.                                                               */
  __IOM uint32_t  XIP_CTRL;                     /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     XIP_CTRL, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  XIP_QMI;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     XIP_QMI, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged processor or debug
                                                     access only. This register is writable only from a Secure,
                                                     Privileged processor or debugger, with the exception of
                                                     the NSU bit, which becomes Non-secure-Privileged-writable
                                                     when the NSP bit is set.                                                  */
  __IOM uint32_t  XIP_AUX;                      /*!< Control whether debugger, DMA, core 0 and core 1 can access
                                                     XIP_AUX, and at what security/privilege levels they can
                                                     do so. Defaults to Secure, Privileged access only. This
                                                     register is writable only from a Secure, Privileged processor
                                                     or debugger, with the exception of the NSU bit, which becomes
                                                     Non-secure-Privileged-writable when the NSP bit is set.                   */
} ACCESSCTRL_Type;                              /*!< Size = 236 (0xec)                                                         */



/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief UART0 (UART0)
  */

typedef struct {                                /*!< UART0 Structure                                                           */
  __IOM uint32_t  UARTDR;                       /*!< Data Register, UARTDR                                                     */
  __IOM uint32_t  UARTRSR;                      /*!< Receive Status Register/Error Clear Register, UARTRSR/UARTECR             */
  __IM  uint32_t  RESERVED[4];
  __IOM uint32_t  UARTFR;                       /*!< Flag Register, UARTFR                                                     */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  UARTILPR;                     /*!< IrDA Low-Power Counter Register, UARTILPR                                 */
  __IOM uint32_t  UARTIBRD;                     /*!< Integer Baud Rate Register, UARTIBRD                                      */
  __IOM uint32_t  UARTFBRD;                     /*!< Fractional Baud Rate Register, UARTFBRD                                   */
  __IOM uint32_t  UARTLCR_H;                    /*!< Line Control Register, UARTLCR_H                                          */
  __IOM uint32_t  UARTCR;                       /*!< Control Register, UARTCR                                                  */
  __IOM uint32_t  UARTIFLS;                     /*!< Interrupt FIFO Level Select Register, UARTIFLS                            */
  __IOM uint32_t  UARTIMSC;                     /*!< Interrupt Mask Set/Clear Register, UARTIMSC                               */
  __IOM uint32_t  UARTRIS;                      /*!< Raw Interrupt Status Register, UARTRIS                                    */
  __IOM uint32_t  UARTMIS;                      /*!< Masked Interrupt Status Register, UARTMIS                                 */
  __IOM uint32_t  UARTICR;                      /*!< Interrupt Clear Register, UARTICR                                         */
  __IOM uint32_t  UARTDMACR;                    /*!< DMA Control Register, UARTDMACR                                           */
  __IM  uint32_t  RESERVED2[997];
  __IOM uint32_t  UARTPERIPHID0;                /*!< UARTPeriphID0 Register                                                    */
  __IOM uint32_t  UARTPERIPHID1;                /*!< UARTPeriphID1 Register                                                    */
  __IOM uint32_t  UARTPERIPHID2;                /*!< UARTPeriphID2 Register                                                    */
  __IOM uint32_t  UARTPERIPHID3;                /*!< UARTPeriphID3 Register                                                    */
  __IOM uint32_t  UARTPCELLID0;                 /*!< UARTPCellID0 Register                                                     */
  __IOM uint32_t  UARTPCELLID1;                 /*!< UARTPCellID1 Register                                                     */
  __IOM uint32_t  UARTPCELLID2;                 /*!< UARTPCellID2 Register                                                     */
  __IOM uint32_t  UARTPCELLID3;                 /*!< UARTPCellID3 Register                                                     */
} UART0_Type;                                   /*!< Size = 4096 (0x1000)                                                      */



/* =========================================================================================================================== */
/* ================                                           ROSC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief ROSC (ROSC)
  */

typedef struct {                                /*!< ROSC Structure                                                            */
  __IOM uint32_t  CTRL;                         /*!< Ring Oscillator control                                                   */
  __IOM uint32_t  FREQA;                        /*!< The FREQA & FREQB registers control the frequency by controlling
                                                     the drive strength of each stage The drive strength has
                                                     4 levels determined by the number of bits set Increasing
                                                     the number of bits set increases the drive strength and
                                                     increases the oscillation frequency 0 bits set is the default
                                                     drive strength 1 bit set doubles the drive strength 2 bits
                                                     set triples drive strength 3 bits set quadruples drive
                                                     strength For frequency randomisation set both DS0_RANDOM=1
                                                     & DS1_RANDOM=1                                                            */
  __IOM uint32_t  FREQB;                        /*!< For a detailed description see freqa register                             */
  __IOM uint32_t  RANDOM;                       /*!< Loads a value to the LFSR randomiser                                      */
  __IOM uint32_t  DORMANT;                      /*!< Ring Oscillator pause control                                             */
  __IOM uint32_t  DIV;                          /*!< Controls the output divider                                               */
  __IOM uint32_t  PHASE;                        /*!< Controls the phase shifted output                                         */
  __IOM uint32_t  STATUS;                       /*!< Ring Oscillator Status                                                    */
  __IOM uint32_t  RANDOMBIT;                    /*!< This just reads the state of the oscillator output so randomness
                                                     is compromised if the ring oscillator is stopped or run
                                                     at a harmonic of the bus frequency                                        */
  __IOM uint32_t  COUNT;                        /*!< A down counter running at the ROSC frequency which counts to
                                                     zero and stops. To start the counter write a non-zero value.
                                                     Can be used for short software pauses when setting up time
                                                     sensitive hardware.                                                       */
} ROSC_Type;                                    /*!< Size = 40 (0x28)                                                          */



/* =========================================================================================================================== */
/* ================                                          POWMAN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Controls vreg, bor, lposc, chip resets & xosc startup, powman and provides scratch register for general use and for bootcode use (POWMAN)
  */

typedef struct {                                /*!< POWMAN Structure                                                          */
  __IOM uint32_t  BADPASSWD;                    /*!< Indicates a bad password has been used                                    */
  __IOM uint32_t  VREG_CTRL;                    /*!< Voltage Regulator Control                                                 */
  __IOM uint32_t  VREG_STS;                     /*!< Voltage Regulator Status                                                  */
  __IOM uint32_t  VREG;                         /*!< Voltage Regulator Settings                                                */
  __IOM uint32_t  VREG_LP_ENTRY;                /*!< Voltage Regulator Low Power Entry Settings                                */
  __IOM uint32_t  VREG_LP_EXIT;                 /*!< Voltage Regulator Low Power Exit Settings                                 */
  __IOM uint32_t  BOD_CTRL;                     /*!< Brown-out Detection Control                                               */
  __IOM uint32_t  BOD;                          /*!< Brown-out Detection Settings                                              */
  __IOM uint32_t  BOD_LP_ENTRY;                 /*!< Brown-out Detection Low Power Entry Settings                              */
  __IOM uint32_t  BOD_LP_EXIT;                  /*!< Brown-out Detection Low Power Exit Settings                               */
  __IOM uint32_t  LPOSC;                        /*!< Low power oscillator control register.                                    */
  __IOM uint32_t  CHIP_RESET;                   /*!< Chip reset control and status                                             */
  __IOM uint32_t  WDSEL;                        /*!< Allows a watchdog reset to reset the internal state of powman
                                                     in addition to the power-on state machine (PSM). Note that
                                                     powman ignores watchdog resets that do not select at least
                                                     the CLOCKS stage or earlier stages in the PSM. If using
                                                     these bits, it's recommended to set PSM_WDSEL to all-ones
                                                     in addition to the desired bits in this register. Failing
                                                     to select CLOCKS or earlier will result in the POWMAN_WDSEL
                                                     register having no effect.                                                */
  __IOM uint32_t  SEQ_CFG;                      /*!< For configuration of the power sequencer Writes are ignored
                                                     while POWMAN_STATE_CHANGING=1                                             */
  __IOM uint32_t  STATE;                        /*!< This register controls the power state of the 4 power domains.
                                                     The current power state is indicated in POWMAN_STATE_CURRENT
                                                     which is read-only. To change the state, write to POWMAN_STATE_REQ.
                                                     The coding of POWMAN_STATE_CURRENT & POWMAN_STATE_REQ corresponds
                                                     to the power states defined in the datasheet: bit 3 = SWCORE
                                                     bit 2 = XIP cache bit 1 = SRAM0 bit 0 = SRAM1 0 = powered
                                                     up 1 = powered down When POWMAN_STATE_REQ is written, the
                                                     POWMAN_STATE_WAITING flag is set while the Power Manager
                                                     determines what is required. If an invalid transition is
                                                     requested the Power Manager will still register the request
                                                     in POWMAN_STATE_REQ but will also set the POWMAN_BAD_REQ
                                                     flag. It will then implement the power-up requests and
                                                     ignore the power down requests. To do nothing would risk
                                                     entering an unrecoverable lock-up state. Invalid requests
                                                     are: any combination of power up and power down requests
                                                     any request that results in swcore boing powered and xip
                                                     unpowered If the request is to power down the switched-core
                                                     domain then POWMAN_STATE_WAITING stays active until the
                                                     processors halt. During this time the POWMAN_STATE_REQ
                                                     field can be re-written to change or cancel the request.
                                                     When the power state transition begins the POWMAN_STATE_WAITING_flag
                                                     is cleared, the POWMAN_STATE_CHANGING flag is set and POWMAN
                                                     register writes are ignored until the transition completes.               */
  __IOM uint32_t  POW_FASTDIV;                  /*!< POW_FASTDIV                                                               */
  __IOM uint32_t  POW_DELAY;                    /*!< power state machine delays                                                */
  __IOM uint32_t  EXT_CTRL0;                    /*!< Configures a gpio as a power mode aware control output                    */
  __IOM uint32_t  EXT_CTRL1;                    /*!< Configures a gpio as a power mode aware control output                    */
  __IOM uint32_t  EXT_TIME_REF;                 /*!< Select a GPIO to use as a time reference, the source can be
                                                     used to drive the low power clock at 32kHz, or to provide
                                                     a 1ms tick to the timer, or provide a 1Hz tick to the timer.
                                                     The tick selection is controlled by the POWMAN_TIMER register.            */
  __IOM uint32_t  LPOSC_FREQ_KHZ_INT;           /*!< Informs the AON Timer of the integer component of the clock
                                                     frequency when running off the LPOSC.                                     */
  __IOM uint32_t  LPOSC_FREQ_KHZ_FRAC;          /*!< Informs the AON Timer of the fractional component of the clock
                                                     frequency when running off the LPOSC.                                     */
  __IOM uint32_t  XOSC_FREQ_KHZ_INT;            /*!< Informs the AON Timer of the integer component of the clock
                                                     frequency when running off the XOSC.                                      */
  __IOM uint32_t  XOSC_FREQ_KHZ_FRAC;           /*!< Informs the AON Timer of the fractional component of the clock
                                                     frequency when running off the XOSC.                                      */
  __IOM uint32_t  SET_TIME_63TO48;              /*!< SET_TIME_63TO48                                                           */
  __IOM uint32_t  SET_TIME_47TO32;              /*!< SET_TIME_47TO32                                                           */
  __IOM uint32_t  SET_TIME_31TO16;              /*!< SET_TIME_31TO16                                                           */
  __IOM uint32_t  SET_TIME_15TO0;               /*!< SET_TIME_15TO0                                                            */
  __IOM uint32_t  READ_TIME_UPPER;              /*!< READ_TIME_UPPER                                                           */
  __IOM uint32_t  READ_TIME_LOWER;              /*!< READ_TIME_LOWER                                                           */
  __IOM uint32_t  ALARM_TIME_63TO48;            /*!< ALARM_TIME_63TO48                                                         */
  __IOM uint32_t  ALARM_TIME_47TO32;            /*!< ALARM_TIME_47TO32                                                         */
  __IOM uint32_t  ALARM_TIME_31TO16;            /*!< ALARM_TIME_31TO16                                                         */
  __IOM uint32_t  ALARM_TIME_15TO0;             /*!< ALARM_TIME_15TO0                                                          */
  __IOM uint32_t  TIMER;                        /*!< TIMER                                                                     */
  __IOM uint32_t  PWRUP0;                       /*!< 4 GPIO powerup events can be configured to wake the chip up
                                                     from a low power state. The pwrups are level/edge sensitive
                                                     and can be set to trigger on a high/rising or low/falling
                                                     event The number of gpios available depends on the package
                                                     option. An invalid selection will be ignored source = 0
                                                     selects gpio0 . . source = 47 selects gpio47 source = 48
                                                     selects qspi_ss source = 49 selects qspi_sd0 source = 50
                                                     selects qspi_sd1 source = 51 selects qspi_sd2 source =
                                                     52 selects qspi_sd3 source = 53 selects qspi_sclk level
                                                     = 0 triggers the pwrup when the source is low level = 1
                                                     triggers the pwrup when the source is high                                */
  __IOM uint32_t  PWRUP1;                       /*!< 4 GPIO powerup events can be configured to wake the chip up
                                                     from a low power state. The pwrups are level/edge sensitive
                                                     and can be set to trigger on a high/rising or low/falling
                                                     event The number of gpios available depends on the package
                                                     option. An invalid selection will be ignored source = 0
                                                     selects gpio0 . . source = 47 selects gpio47 source = 48
                                                     selects qspi_ss source = 49 selects qspi_sd0 source = 50
                                                     selects qspi_sd1 source = 51 selects qspi_sd2 source =
                                                     52 selects qspi_sd3 source = 53 selects qspi_sclk level
                                                     = 0 triggers the pwrup when the source is low level = 1
                                                     triggers the pwrup when the source is high                                */
  __IOM uint32_t  PWRUP2;                       /*!< 4 GPIO powerup events can be configured to wake the chip up
                                                     from a low power state. The pwrups are level/edge sensitive
                                                     and can be set to trigger on a high/rising or low/falling
                                                     event The number of gpios available depends on the package
                                                     option. An invalid selection will be ignored source = 0
                                                     selects gpio0 . . source = 47 selects gpio47 source = 48
                                                     selects qspi_ss source = 49 selects qspi_sd0 source = 50
                                                     selects qspi_sd1 source = 51 selects qspi_sd2 source =
                                                     52 selects qspi_sd3 source = 53 selects qspi_sclk level
                                                     = 0 triggers the pwrup when the source is low level = 1
                                                     triggers the pwrup when the source is high                                */
  __IOM uint32_t  PWRUP3;                       /*!< 4 GPIO powerup events can be configured to wake the chip up
                                                     from a low power state. The pwrups are level/edge sensitive
                                                     and can be set to trigger on a high/rising or low/falling
                                                     event The number of gpios available depends on the package
                                                     option. An invalid selection will be ignored source = 0
                                                     selects gpio0 . . source = 47 selects gpio47 source = 48
                                                     selects qspi_ss source = 49 selects qspi_sd0 source = 50
                                                     selects qspi_sd1 source = 51 selects qspi_sd2 source =
                                                     52 selects qspi_sd3 source = 53 selects qspi_sclk level
                                                     = 0 triggers the pwrup when the source is low level = 1
                                                     triggers the pwrup when the source is high                                */
  __IOM uint32_t  CURRENT_PWRUP_REQ;            /*!< Indicates current powerup request state pwrup events can be
                                                     cleared by removing the enable from the pwrup register.
                                                     The alarm pwrup req can be cleared by clearing timer.alarm_enab
                                                     0 = chip reset, for the source of the last reset see POWMAN_CHIP_RESET
                                                     1 = pwrup0 2 = pwrup1 3 = pwrup2 4 = pwrup3 5 = coresight_pwrup
                                                     6 = alarm_pwrup                                                           */
  __IOM uint32_t  LAST_SWCORE_PWRUP;            /*!< Indicates which pwrup source triggered the last switched-core
                                                     power up 0 = chip reset, for the source of the last reset
                                                     see POWMAN_CHIP_RESET 1 = pwrup0 2 = pwrup1 3 = pwrup2
                                                     4 = pwrup3 5 = coresight_pwrup 6 = alarm_pwrup                            */
  __IOM uint32_t  DBG_PWRCFG;                   /*!< DBG_PWRCFG                                                                */
  __IOM uint32_t  BOOTDIS;                      /*!< Tell the bootrom to ignore the BOOT0..3 registers following
                                                     the next RSM reset (e.g. the next core power down/up).
                                                     If an early boot stage has soft-locked some OTP pages in
                                                     order to protect their contents from later stages, there
                                                     is a risk that Secure code running at a later stage can
                                                     unlock the pages by powering the core up and down. This
                                                     register can be used to ensure that the bootloader runs
                                                     as normal on the next power up, preventing Secure code
                                                     at a later stage from accessing OTP in its unlocked state.
                                                     Should be used in conjunction with the OTP BOOTDIS register.              */
  __IOM uint32_t  DBGCONFIG;                    /*!< DBGCONFIG                                                                 */
  __IOM uint32_t  SCRATCH0;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH1;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH2;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH3;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH4;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH5;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH6;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  SCRATCH7;                     /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  BOOT0;                        /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  BOOT1;                        /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  BOOT2;                        /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  BOOT3;                        /*!< Scratch register. Information persists in low power mode                  */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
} POWMAN_Type;                                  /*!< Size = 240 (0xf0)                                                         */



/* =========================================================================================================================== */
/* ================                                         WATCHDOG                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief WATCHDOG (WATCHDOG)
  */

typedef struct {                                /*!< WATCHDOG Structure                                                        */
  __IOM uint32_t  CTRL;                         /*!< Watchdog control The rst_wdsel register determines which subsystems
                                                     are reset when the watchdog is triggered. The watchdog
                                                     can be triggered in software.                                             */
  __IOM uint32_t  LOAD;                         /*!< Load the watchdog timer. The maximum setting is 0xffffff which
                                                     corresponds to approximately 16 seconds.                                  */
  __IOM uint32_t  REASON;                       /*!< Logs the reason for the last reset. Both bits are zero for the
                                                     case of a hardware reset. Additionally, as of RP2350, a
                                                     debugger warm reset of either core (SYSRESETREQ or hartreset)
                                                     will also clear the watchdog reason register, so that software
                                                     loaded under the debugger following a watchdog timeout
                                                     will not continue to see the timeout condition.                           */
  __IOM uint32_t  SCRATCH0;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH1;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH2;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH3;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH4;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH5;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH6;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
  __IOM uint32_t  SCRATCH7;                     /*!< Scratch register. Information persists through soft reset of
                                                     the chip.                                                                 */
} WATCHDOG_Type;                                /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                            DMA                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief DMA with separate read and write masters (DMA)
  */

typedef struct {                                /*!< DMA Structure                                                             */
  __IOM uint32_t  CH0_READ_ADDR;                /*!< DMA Channel 0 Read Address pointer                                        */
  __IOM uint32_t  CH0_WRITE_ADDR;               /*!< DMA Channel 0 Write Address pointer                                       */
  __IOM uint32_t  CH0_TRANS_COUNT;              /*!< DMA Channel 0 Transfer Count                                              */
  __IOM uint32_t  CH0_CTRL_TRIG;                /*!< DMA Channel 0 Control and Status                                          */
  __IOM uint32_t  CH0_AL1_CTRL;                 /*!< Alias for channel 0 CTRL register                                         */
  __IOM uint32_t  CH0_AL1_READ_ADDR;            /*!< Alias for channel 0 READ_ADDR register                                    */
  __IOM uint32_t  CH0_AL1_WRITE_ADDR;           /*!< Alias for channel 0 WRITE_ADDR register                                   */
  __IOM uint32_t  CH0_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 0 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH0_AL2_CTRL;                 /*!< Alias for channel 0 CTRL register                                         */
  __IOM uint32_t  CH0_AL2_TRANS_COUNT;          /*!< Alias for channel 0 TRANS_COUNT register                                  */
  __IOM uint32_t  CH0_AL2_READ_ADDR;            /*!< Alias for channel 0 READ_ADDR register                                    */
  __IOM uint32_t  CH0_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 0 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH0_AL3_CTRL;                 /*!< Alias for channel 0 CTRL register                                         */
  __IOM uint32_t  CH0_AL3_WRITE_ADDR;           /*!< Alias for channel 0 WRITE_ADDR register                                   */
  __IOM uint32_t  CH0_AL3_TRANS_COUNT;          /*!< Alias for channel 0 TRANS_COUNT register                                  */
  __IOM uint32_t  CH0_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 0 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH1_READ_ADDR;                /*!< DMA Channel 1 Read Address pointer                                        */
  __IOM uint32_t  CH1_WRITE_ADDR;               /*!< DMA Channel 1 Write Address pointer                                       */
  __IOM uint32_t  CH1_TRANS_COUNT;              /*!< DMA Channel 1 Transfer Count                                              */
  __IOM uint32_t  CH1_CTRL_TRIG;                /*!< DMA Channel 1 Control and Status                                          */
  __IOM uint32_t  CH1_AL1_CTRL;                 /*!< Alias for channel 1 CTRL register                                         */
  __IOM uint32_t  CH1_AL1_READ_ADDR;            /*!< Alias for channel 1 READ_ADDR register                                    */
  __IOM uint32_t  CH1_AL1_WRITE_ADDR;           /*!< Alias for channel 1 WRITE_ADDR register                                   */
  __IOM uint32_t  CH1_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 1 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH1_AL2_CTRL;                 /*!< Alias for channel 1 CTRL register                                         */
  __IOM uint32_t  CH1_AL2_TRANS_COUNT;          /*!< Alias for channel 1 TRANS_COUNT register                                  */
  __IOM uint32_t  CH1_AL2_READ_ADDR;            /*!< Alias for channel 1 READ_ADDR register                                    */
  __IOM uint32_t  CH1_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 1 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH1_AL3_CTRL;                 /*!< Alias for channel 1 CTRL register                                         */
  __IOM uint32_t  CH1_AL3_WRITE_ADDR;           /*!< Alias for channel 1 WRITE_ADDR register                                   */
  __IOM uint32_t  CH1_AL3_TRANS_COUNT;          /*!< Alias for channel 1 TRANS_COUNT register                                  */
  __IOM uint32_t  CH1_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 1 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH2_READ_ADDR;                /*!< DMA Channel 2 Read Address pointer                                        */
  __IOM uint32_t  CH2_WRITE_ADDR;               /*!< DMA Channel 2 Write Address pointer                                       */
  __IOM uint32_t  CH2_TRANS_COUNT;              /*!< DMA Channel 2 Transfer Count                                              */
  __IOM uint32_t  CH2_CTRL_TRIG;                /*!< DMA Channel 2 Control and Status                                          */
  __IOM uint32_t  CH2_AL1_CTRL;                 /*!< Alias for channel 2 CTRL register                                         */
  __IOM uint32_t  CH2_AL1_READ_ADDR;            /*!< Alias for channel 2 READ_ADDR register                                    */
  __IOM uint32_t  CH2_AL1_WRITE_ADDR;           /*!< Alias for channel 2 WRITE_ADDR register                                   */
  __IOM uint32_t  CH2_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 2 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH2_AL2_CTRL;                 /*!< Alias for channel 2 CTRL register                                         */
  __IOM uint32_t  CH2_AL2_TRANS_COUNT;          /*!< Alias for channel 2 TRANS_COUNT register                                  */
  __IOM uint32_t  CH2_AL2_READ_ADDR;            /*!< Alias for channel 2 READ_ADDR register                                    */
  __IOM uint32_t  CH2_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 2 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH2_AL3_CTRL;                 /*!< Alias for channel 2 CTRL register                                         */
  __IOM uint32_t  CH2_AL3_WRITE_ADDR;           /*!< Alias for channel 2 WRITE_ADDR register                                   */
  __IOM uint32_t  CH2_AL3_TRANS_COUNT;          /*!< Alias for channel 2 TRANS_COUNT register                                  */
  __IOM uint32_t  CH2_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 2 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH3_READ_ADDR;                /*!< DMA Channel 3 Read Address pointer                                        */
  __IOM uint32_t  CH3_WRITE_ADDR;               /*!< DMA Channel 3 Write Address pointer                                       */
  __IOM uint32_t  CH3_TRANS_COUNT;              /*!< DMA Channel 3 Transfer Count                                              */
  __IOM uint32_t  CH3_CTRL_TRIG;                /*!< DMA Channel 3 Control and Status                                          */
  __IOM uint32_t  CH3_AL1_CTRL;                 /*!< Alias for channel 3 CTRL register                                         */
  __IOM uint32_t  CH3_AL1_READ_ADDR;            /*!< Alias for channel 3 READ_ADDR register                                    */
  __IOM uint32_t  CH3_AL1_WRITE_ADDR;           /*!< Alias for channel 3 WRITE_ADDR register                                   */
  __IOM uint32_t  CH3_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 3 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH3_AL2_CTRL;                 /*!< Alias for channel 3 CTRL register                                         */
  __IOM uint32_t  CH3_AL2_TRANS_COUNT;          /*!< Alias for channel 3 TRANS_COUNT register                                  */
  __IOM uint32_t  CH3_AL2_READ_ADDR;            /*!< Alias for channel 3 READ_ADDR register                                    */
  __IOM uint32_t  CH3_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 3 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH3_AL3_CTRL;                 /*!< Alias for channel 3 CTRL register                                         */
  __IOM uint32_t  CH3_AL3_WRITE_ADDR;           /*!< Alias for channel 3 WRITE_ADDR register                                   */
  __IOM uint32_t  CH3_AL3_TRANS_COUNT;          /*!< Alias for channel 3 TRANS_COUNT register                                  */
  __IOM uint32_t  CH3_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 3 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH4_READ_ADDR;                /*!< DMA Channel 4 Read Address pointer                                        */
  __IOM uint32_t  CH4_WRITE_ADDR;               /*!< DMA Channel 4 Write Address pointer                                       */
  __IOM uint32_t  CH4_TRANS_COUNT;              /*!< DMA Channel 4 Transfer Count                                              */
  __IOM uint32_t  CH4_CTRL_TRIG;                /*!< DMA Channel 4 Control and Status                                          */
  __IOM uint32_t  CH4_AL1_CTRL;                 /*!< Alias for channel 4 CTRL register                                         */
  __IOM uint32_t  CH4_AL1_READ_ADDR;            /*!< Alias for channel 4 READ_ADDR register                                    */
  __IOM uint32_t  CH4_AL1_WRITE_ADDR;           /*!< Alias for channel 4 WRITE_ADDR register                                   */
  __IOM uint32_t  CH4_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 4 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH4_AL2_CTRL;                 /*!< Alias for channel 4 CTRL register                                         */
  __IOM uint32_t  CH4_AL2_TRANS_COUNT;          /*!< Alias for channel 4 TRANS_COUNT register                                  */
  __IOM uint32_t  CH4_AL2_READ_ADDR;            /*!< Alias for channel 4 READ_ADDR register                                    */
  __IOM uint32_t  CH4_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 4 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH4_AL3_CTRL;                 /*!< Alias for channel 4 CTRL register                                         */
  __IOM uint32_t  CH4_AL3_WRITE_ADDR;           /*!< Alias for channel 4 WRITE_ADDR register                                   */
  __IOM uint32_t  CH4_AL3_TRANS_COUNT;          /*!< Alias for channel 4 TRANS_COUNT register                                  */
  __IOM uint32_t  CH4_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 4 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH5_READ_ADDR;                /*!< DMA Channel 5 Read Address pointer                                        */
  __IOM uint32_t  CH5_WRITE_ADDR;               /*!< DMA Channel 5 Write Address pointer                                       */
  __IOM uint32_t  CH5_TRANS_COUNT;              /*!< DMA Channel 5 Transfer Count                                              */
  __IOM uint32_t  CH5_CTRL_TRIG;                /*!< DMA Channel 5 Control and Status                                          */
  __IOM uint32_t  CH5_AL1_CTRL;                 /*!< Alias for channel 5 CTRL register                                         */
  __IOM uint32_t  CH5_AL1_READ_ADDR;            /*!< Alias for channel 5 READ_ADDR register                                    */
  __IOM uint32_t  CH5_AL1_WRITE_ADDR;           /*!< Alias for channel 5 WRITE_ADDR register                                   */
  __IOM uint32_t  CH5_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 5 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH5_AL2_CTRL;                 /*!< Alias for channel 5 CTRL register                                         */
  __IOM uint32_t  CH5_AL2_TRANS_COUNT;          /*!< Alias for channel 5 TRANS_COUNT register                                  */
  __IOM uint32_t  CH5_AL2_READ_ADDR;            /*!< Alias for channel 5 READ_ADDR register                                    */
  __IOM uint32_t  CH5_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 5 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH5_AL3_CTRL;                 /*!< Alias for channel 5 CTRL register                                         */
  __IOM uint32_t  CH5_AL3_WRITE_ADDR;           /*!< Alias for channel 5 WRITE_ADDR register                                   */
  __IOM uint32_t  CH5_AL3_TRANS_COUNT;          /*!< Alias for channel 5 TRANS_COUNT register                                  */
  __IOM uint32_t  CH5_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 5 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH6_READ_ADDR;                /*!< DMA Channel 6 Read Address pointer                                        */
  __IOM uint32_t  CH6_WRITE_ADDR;               /*!< DMA Channel 6 Write Address pointer                                       */
  __IOM uint32_t  CH6_TRANS_COUNT;              /*!< DMA Channel 6 Transfer Count                                              */
  __IOM uint32_t  CH6_CTRL_TRIG;                /*!< DMA Channel 6 Control and Status                                          */
  __IOM uint32_t  CH6_AL1_CTRL;                 /*!< Alias for channel 6 CTRL register                                         */
  __IOM uint32_t  CH6_AL1_READ_ADDR;            /*!< Alias for channel 6 READ_ADDR register                                    */
  __IOM uint32_t  CH6_AL1_WRITE_ADDR;           /*!< Alias for channel 6 WRITE_ADDR register                                   */
  __IOM uint32_t  CH6_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 6 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH6_AL2_CTRL;                 /*!< Alias for channel 6 CTRL register                                         */
  __IOM uint32_t  CH6_AL2_TRANS_COUNT;          /*!< Alias for channel 6 TRANS_COUNT register                                  */
  __IOM uint32_t  CH6_AL2_READ_ADDR;            /*!< Alias for channel 6 READ_ADDR register                                    */
  __IOM uint32_t  CH6_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 6 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH6_AL3_CTRL;                 /*!< Alias for channel 6 CTRL register                                         */
  __IOM uint32_t  CH6_AL3_WRITE_ADDR;           /*!< Alias for channel 6 WRITE_ADDR register                                   */
  __IOM uint32_t  CH6_AL3_TRANS_COUNT;          /*!< Alias for channel 6 TRANS_COUNT register                                  */
  __IOM uint32_t  CH6_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 6 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH7_READ_ADDR;                /*!< DMA Channel 7 Read Address pointer                                        */
  __IOM uint32_t  CH7_WRITE_ADDR;               /*!< DMA Channel 7 Write Address pointer                                       */
  __IOM uint32_t  CH7_TRANS_COUNT;              /*!< DMA Channel 7 Transfer Count                                              */
  __IOM uint32_t  CH7_CTRL_TRIG;                /*!< DMA Channel 7 Control and Status                                          */
  __IOM uint32_t  CH7_AL1_CTRL;                 /*!< Alias for channel 7 CTRL register                                         */
  __IOM uint32_t  CH7_AL1_READ_ADDR;            /*!< Alias for channel 7 READ_ADDR register                                    */
  __IOM uint32_t  CH7_AL1_WRITE_ADDR;           /*!< Alias for channel 7 WRITE_ADDR register                                   */
  __IOM uint32_t  CH7_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 7 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH7_AL2_CTRL;                 /*!< Alias for channel 7 CTRL register                                         */
  __IOM uint32_t  CH7_AL2_TRANS_COUNT;          /*!< Alias for channel 7 TRANS_COUNT register                                  */
  __IOM uint32_t  CH7_AL2_READ_ADDR;            /*!< Alias for channel 7 READ_ADDR register                                    */
  __IOM uint32_t  CH7_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 7 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH7_AL3_CTRL;                 /*!< Alias for channel 7 CTRL register                                         */
  __IOM uint32_t  CH7_AL3_WRITE_ADDR;           /*!< Alias for channel 7 WRITE_ADDR register                                   */
  __IOM uint32_t  CH7_AL3_TRANS_COUNT;          /*!< Alias for channel 7 TRANS_COUNT register                                  */
  __IOM uint32_t  CH7_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 7 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH8_READ_ADDR;                /*!< DMA Channel 8 Read Address pointer                                        */
  __IOM uint32_t  CH8_WRITE_ADDR;               /*!< DMA Channel 8 Write Address pointer                                       */
  __IOM uint32_t  CH8_TRANS_COUNT;              /*!< DMA Channel 8 Transfer Count                                              */
  __IOM uint32_t  CH8_CTRL_TRIG;                /*!< DMA Channel 8 Control and Status                                          */
  __IOM uint32_t  CH8_AL1_CTRL;                 /*!< Alias for channel 8 CTRL register                                         */
  __IOM uint32_t  CH8_AL1_READ_ADDR;            /*!< Alias for channel 8 READ_ADDR register                                    */
  __IOM uint32_t  CH8_AL1_WRITE_ADDR;           /*!< Alias for channel 8 WRITE_ADDR register                                   */
  __IOM uint32_t  CH8_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 8 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH8_AL2_CTRL;                 /*!< Alias for channel 8 CTRL register                                         */
  __IOM uint32_t  CH8_AL2_TRANS_COUNT;          /*!< Alias for channel 8 TRANS_COUNT register                                  */
  __IOM uint32_t  CH8_AL2_READ_ADDR;            /*!< Alias for channel 8 READ_ADDR register                                    */
  __IOM uint32_t  CH8_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 8 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH8_AL3_CTRL;                 /*!< Alias for channel 8 CTRL register                                         */
  __IOM uint32_t  CH8_AL3_WRITE_ADDR;           /*!< Alias for channel 8 WRITE_ADDR register                                   */
  __IOM uint32_t  CH8_AL3_TRANS_COUNT;          /*!< Alias for channel 8 TRANS_COUNT register                                  */
  __IOM uint32_t  CH8_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 8 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH9_READ_ADDR;                /*!< DMA Channel 9 Read Address pointer                                        */
  __IOM uint32_t  CH9_WRITE_ADDR;               /*!< DMA Channel 9 Write Address pointer                                       */
  __IOM uint32_t  CH9_TRANS_COUNT;              /*!< DMA Channel 9 Transfer Count                                              */
  __IOM uint32_t  CH9_CTRL_TRIG;                /*!< DMA Channel 9 Control and Status                                          */
  __IOM uint32_t  CH9_AL1_CTRL;                 /*!< Alias for channel 9 CTRL register                                         */
  __IOM uint32_t  CH9_AL1_READ_ADDR;            /*!< Alias for channel 9 READ_ADDR register                                    */
  __IOM uint32_t  CH9_AL1_WRITE_ADDR;           /*!< Alias for channel 9 WRITE_ADDR register                                   */
  __IOM uint32_t  CH9_AL1_TRANS_COUNT_TRIG;     /*!< Alias for channel 9 TRANS_COUNT register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH9_AL2_CTRL;                 /*!< Alias for channel 9 CTRL register                                         */
  __IOM uint32_t  CH9_AL2_TRANS_COUNT;          /*!< Alias for channel 9 TRANS_COUNT register                                  */
  __IOM uint32_t  CH9_AL2_READ_ADDR;            /*!< Alias for channel 9 READ_ADDR register                                    */
  __IOM uint32_t  CH9_AL2_WRITE_ADDR_TRIG;      /*!< Alias for channel 9 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH9_AL3_CTRL;                 /*!< Alias for channel 9 CTRL register                                         */
  __IOM uint32_t  CH9_AL3_WRITE_ADDR;           /*!< Alias for channel 9 WRITE_ADDR register                                   */
  __IOM uint32_t  CH9_AL3_TRANS_COUNT;          /*!< Alias for channel 9 TRANS_COUNT register                                  */
  __IOM uint32_t  CH9_AL3_READ_ADDR_TRIG;       /*!< Alias for channel 9 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH10_READ_ADDR;               /*!< DMA Channel 10 Read Address pointer                                       */
  __IOM uint32_t  CH10_WRITE_ADDR;              /*!< DMA Channel 10 Write Address pointer                                      */
  __IOM uint32_t  CH10_TRANS_COUNT;             /*!< DMA Channel 10 Transfer Count                                             */
  __IOM uint32_t  CH10_CTRL_TRIG;               /*!< DMA Channel 10 Control and Status                                         */
  __IOM uint32_t  CH10_AL1_CTRL;                /*!< Alias for channel 10 CTRL register                                        */
  __IOM uint32_t  CH10_AL1_READ_ADDR;           /*!< Alias for channel 10 READ_ADDR register                                   */
  __IOM uint32_t  CH10_AL1_WRITE_ADDR;          /*!< Alias for channel 10 WRITE_ADDR register                                  */
  __IOM uint32_t  CH10_AL1_TRANS_COUNT_TRIG;    /*!< Alias for channel 10 TRANS_COUNT register This is a trigger
                                                     register (0xc). Writing a nonzero value will reload the
                                                     channel counter and start the channel.                                    */
  __IOM uint32_t  CH10_AL2_CTRL;                /*!< Alias for channel 10 CTRL register                                        */
  __IOM uint32_t  CH10_AL2_TRANS_COUNT;         /*!< Alias for channel 10 TRANS_COUNT register                                 */
  __IOM uint32_t  CH10_AL2_READ_ADDR;           /*!< Alias for channel 10 READ_ADDR register                                   */
  __IOM uint32_t  CH10_AL2_WRITE_ADDR_TRIG;     /*!< Alias for channel 10 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH10_AL3_CTRL;                /*!< Alias for channel 10 CTRL register                                        */
  __IOM uint32_t  CH10_AL3_WRITE_ADDR;          /*!< Alias for channel 10 WRITE_ADDR register                                  */
  __IOM uint32_t  CH10_AL3_TRANS_COUNT;         /*!< Alias for channel 10 TRANS_COUNT register                                 */
  __IOM uint32_t  CH10_AL3_READ_ADDR_TRIG;      /*!< Alias for channel 10 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH11_READ_ADDR;               /*!< DMA Channel 11 Read Address pointer                                       */
  __IOM uint32_t  CH11_WRITE_ADDR;              /*!< DMA Channel 11 Write Address pointer                                      */
  __IOM uint32_t  CH11_TRANS_COUNT;             /*!< DMA Channel 11 Transfer Count                                             */
  __IOM uint32_t  CH11_CTRL_TRIG;               /*!< DMA Channel 11 Control and Status                                         */
  __IOM uint32_t  CH11_AL1_CTRL;                /*!< Alias for channel 11 CTRL register                                        */
  __IOM uint32_t  CH11_AL1_READ_ADDR;           /*!< Alias for channel 11 READ_ADDR register                                   */
  __IOM uint32_t  CH11_AL1_WRITE_ADDR;          /*!< Alias for channel 11 WRITE_ADDR register                                  */
  __IOM uint32_t  CH11_AL1_TRANS_COUNT_TRIG;    /*!< Alias for channel 11 TRANS_COUNT register This is a trigger
                                                     register (0xc). Writing a nonzero value will reload the
                                                     channel counter and start the channel.                                    */
  __IOM uint32_t  CH11_AL2_CTRL;                /*!< Alias for channel 11 CTRL register                                        */
  __IOM uint32_t  CH11_AL2_TRANS_COUNT;         /*!< Alias for channel 11 TRANS_COUNT register                                 */
  __IOM uint32_t  CH11_AL2_READ_ADDR;           /*!< Alias for channel 11 READ_ADDR register                                   */
  __IOM uint32_t  CH11_AL2_WRITE_ADDR_TRIG;     /*!< Alias for channel 11 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH11_AL3_CTRL;                /*!< Alias for channel 11 CTRL register                                        */
  __IOM uint32_t  CH11_AL3_WRITE_ADDR;          /*!< Alias for channel 11 WRITE_ADDR register                                  */
  __IOM uint32_t  CH11_AL3_TRANS_COUNT;         /*!< Alias for channel 11 TRANS_COUNT register                                 */
  __IOM uint32_t  CH11_AL3_READ_ADDR_TRIG;      /*!< Alias for channel 11 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH12_READ_ADDR;               /*!< DMA Channel 12 Read Address pointer                                       */
  __IOM uint32_t  CH12_WRITE_ADDR;              /*!< DMA Channel 12 Write Address pointer                                      */
  __IOM uint32_t  CH12_TRANS_COUNT;             /*!< DMA Channel 12 Transfer Count                                             */
  __IOM uint32_t  CH12_CTRL_TRIG;               /*!< DMA Channel 12 Control and Status                                         */
  __IOM uint32_t  CH12_AL1_CTRL;                /*!< Alias for channel 12 CTRL register                                        */
  __IOM uint32_t  CH12_AL1_READ_ADDR;           /*!< Alias for channel 12 READ_ADDR register                                   */
  __IOM uint32_t  CH12_AL1_WRITE_ADDR;          /*!< Alias for channel 12 WRITE_ADDR register                                  */
  __IOM uint32_t  CH12_AL1_TRANS_COUNT_TRIG;    /*!< Alias for channel 12 TRANS_COUNT register This is a trigger
                                                     register (0xc). Writing a nonzero value will reload the
                                                     channel counter and start the channel.                                    */
  __IOM uint32_t  CH12_AL2_CTRL;                /*!< Alias for channel 12 CTRL register                                        */
  __IOM uint32_t  CH12_AL2_TRANS_COUNT;         /*!< Alias for channel 12 TRANS_COUNT register                                 */
  __IOM uint32_t  CH12_AL2_READ_ADDR;           /*!< Alias for channel 12 READ_ADDR register                                   */
  __IOM uint32_t  CH12_AL2_WRITE_ADDR_TRIG;     /*!< Alias for channel 12 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH12_AL3_CTRL;                /*!< Alias for channel 12 CTRL register                                        */
  __IOM uint32_t  CH12_AL3_WRITE_ADDR;          /*!< Alias for channel 12 WRITE_ADDR register                                  */
  __IOM uint32_t  CH12_AL3_TRANS_COUNT;         /*!< Alias for channel 12 TRANS_COUNT register                                 */
  __IOM uint32_t  CH12_AL3_READ_ADDR_TRIG;      /*!< Alias for channel 12 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH13_READ_ADDR;               /*!< DMA Channel 13 Read Address pointer                                       */
  __IOM uint32_t  CH13_WRITE_ADDR;              /*!< DMA Channel 13 Write Address pointer                                      */
  __IOM uint32_t  CH13_TRANS_COUNT;             /*!< DMA Channel 13 Transfer Count                                             */
  __IOM uint32_t  CH13_CTRL_TRIG;               /*!< DMA Channel 13 Control and Status                                         */
  __IOM uint32_t  CH13_AL1_CTRL;                /*!< Alias for channel 13 CTRL register                                        */
  __IOM uint32_t  CH13_AL1_READ_ADDR;           /*!< Alias for channel 13 READ_ADDR register                                   */
  __IOM uint32_t  CH13_AL1_WRITE_ADDR;          /*!< Alias for channel 13 WRITE_ADDR register                                  */
  __IOM uint32_t  CH13_AL1_TRANS_COUNT_TRIG;    /*!< Alias for channel 13 TRANS_COUNT register This is a trigger
                                                     register (0xc). Writing a nonzero value will reload the
                                                     channel counter and start the channel.                                    */
  __IOM uint32_t  CH13_AL2_CTRL;                /*!< Alias for channel 13 CTRL register                                        */
  __IOM uint32_t  CH13_AL2_TRANS_COUNT;         /*!< Alias for channel 13 TRANS_COUNT register                                 */
  __IOM uint32_t  CH13_AL2_READ_ADDR;           /*!< Alias for channel 13 READ_ADDR register                                   */
  __IOM uint32_t  CH13_AL2_WRITE_ADDR_TRIG;     /*!< Alias for channel 13 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH13_AL3_CTRL;                /*!< Alias for channel 13 CTRL register                                        */
  __IOM uint32_t  CH13_AL3_WRITE_ADDR;          /*!< Alias for channel 13 WRITE_ADDR register                                  */
  __IOM uint32_t  CH13_AL3_TRANS_COUNT;         /*!< Alias for channel 13 TRANS_COUNT register                                 */
  __IOM uint32_t  CH13_AL3_READ_ADDR_TRIG;      /*!< Alias for channel 13 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH14_READ_ADDR;               /*!< DMA Channel 14 Read Address pointer                                       */
  __IOM uint32_t  CH14_WRITE_ADDR;              /*!< DMA Channel 14 Write Address pointer                                      */
  __IOM uint32_t  CH14_TRANS_COUNT;             /*!< DMA Channel 14 Transfer Count                                             */
  __IOM uint32_t  CH14_CTRL_TRIG;               /*!< DMA Channel 14 Control and Status                                         */
  __IOM uint32_t  CH14_AL1_CTRL;                /*!< Alias for channel 14 CTRL register                                        */
  __IOM uint32_t  CH14_AL1_READ_ADDR;           /*!< Alias for channel 14 READ_ADDR register                                   */
  __IOM uint32_t  CH14_AL1_WRITE_ADDR;          /*!< Alias for channel 14 WRITE_ADDR register                                  */
  __IOM uint32_t  CH14_AL1_TRANS_COUNT_TRIG;    /*!< Alias for channel 14 TRANS_COUNT register This is a trigger
                                                     register (0xc). Writing a nonzero value will reload the
                                                     channel counter and start the channel.                                    */
  __IOM uint32_t  CH14_AL2_CTRL;                /*!< Alias for channel 14 CTRL register                                        */
  __IOM uint32_t  CH14_AL2_TRANS_COUNT;         /*!< Alias for channel 14 TRANS_COUNT register                                 */
  __IOM uint32_t  CH14_AL2_READ_ADDR;           /*!< Alias for channel 14 READ_ADDR register                                   */
  __IOM uint32_t  CH14_AL2_WRITE_ADDR_TRIG;     /*!< Alias for channel 14 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH14_AL3_CTRL;                /*!< Alias for channel 14 CTRL register                                        */
  __IOM uint32_t  CH14_AL3_WRITE_ADDR;          /*!< Alias for channel 14 WRITE_ADDR register                                  */
  __IOM uint32_t  CH14_AL3_TRANS_COUNT;         /*!< Alias for channel 14 TRANS_COUNT register                                 */
  __IOM uint32_t  CH14_AL3_READ_ADDR_TRIG;      /*!< Alias for channel 14 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH15_READ_ADDR;               /*!< DMA Channel 15 Read Address pointer                                       */
  __IOM uint32_t  CH15_WRITE_ADDR;              /*!< DMA Channel 15 Write Address pointer                                      */
  __IOM uint32_t  CH15_TRANS_COUNT;             /*!< DMA Channel 15 Transfer Count                                             */
  __IOM uint32_t  CH15_CTRL_TRIG;               /*!< DMA Channel 15 Control and Status                                         */
  __IOM uint32_t  CH15_AL1_CTRL;                /*!< Alias for channel 15 CTRL register                                        */
  __IOM uint32_t  CH15_AL1_READ_ADDR;           /*!< Alias for channel 15 READ_ADDR register                                   */
  __IOM uint32_t  CH15_AL1_WRITE_ADDR;          /*!< Alias for channel 15 WRITE_ADDR register                                  */
  __IOM uint32_t  CH15_AL1_TRANS_COUNT_TRIG;    /*!< Alias for channel 15 TRANS_COUNT register This is a trigger
                                                     register (0xc). Writing a nonzero value will reload the
                                                     channel counter and start the channel.                                    */
  __IOM uint32_t  CH15_AL2_CTRL;                /*!< Alias for channel 15 CTRL register                                        */
  __IOM uint32_t  CH15_AL2_TRANS_COUNT;         /*!< Alias for channel 15 TRANS_COUNT register                                 */
  __IOM uint32_t  CH15_AL2_READ_ADDR;           /*!< Alias for channel 15 READ_ADDR register                                   */
  __IOM uint32_t  CH15_AL2_WRITE_ADDR_TRIG;     /*!< Alias for channel 15 WRITE_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  CH15_AL3_CTRL;                /*!< Alias for channel 15 CTRL register                                        */
  __IOM uint32_t  CH15_AL3_WRITE_ADDR;          /*!< Alias for channel 15 WRITE_ADDR register                                  */
  __IOM uint32_t  CH15_AL3_TRANS_COUNT;         /*!< Alias for channel 15 TRANS_COUNT register                                 */
  __IOM uint32_t  CH15_AL3_READ_ADDR_TRIG;      /*!< Alias for channel 15 READ_ADDR register This is a trigger register
                                                     (0xc). Writing a nonzero value will reload the channel
                                                     counter and start the channel.                                            */
  __IOM uint32_t  INTR;                         /*!< Interrupt Status (raw)                                                    */
  __IOM uint32_t  INTE0;                        /*!< Interrupt Enables for IRQ 0                                               */
  __IOM uint32_t  INTF0;                        /*!< Force Interrupts                                                          */
  __IOM uint32_t  INTS0;                        /*!< Interrupt Status for IRQ 0                                                */
  __IOM uint32_t  INTR1;                        /*!< Interrupt Status (raw)                                                    */
  __IOM uint32_t  INTE1;                        /*!< Interrupt Enables for IRQ 1                                               */
  __IOM uint32_t  INTF1;                        /*!< Force Interrupts                                                          */
  __IOM uint32_t  INTS1;                        /*!< Interrupt Status for IRQ 1                                                */
  __IOM uint32_t  INTR2;                        /*!< Interrupt Status (raw)                                                    */
  __IOM uint32_t  INTE2;                        /*!< Interrupt Enables for IRQ 2                                               */
  __IOM uint32_t  INTF2;                        /*!< Force Interrupts                                                          */
  __IOM uint32_t  INTS2;                        /*!< Interrupt Status for IRQ 2                                                */
  __IOM uint32_t  INTR3;                        /*!< Interrupt Status (raw)                                                    */
  __IOM uint32_t  INTE3;                        /*!< Interrupt Enables for IRQ 3                                               */
  __IOM uint32_t  INTF3;                        /*!< Force Interrupts                                                          */
  __IOM uint32_t  INTS3;                        /*!< Interrupt Status for IRQ 3                                                */
  __IOM uint32_t  TIMER0;                       /*!< Pacing (X/Y) fractional timer The pacing timer produces TREQ
                                                     assertions at a rate set by ((X/Y) * sys_clk). This equation
                                                     is evaluated every sys_clk cycles and therefore can only
                                                     generate TREQs at a rate of 1 per sys_clk (i.e. permanent
                                                     TREQ) or less.                                                            */
  __IOM uint32_t  TIMER1;                       /*!< Pacing (X/Y) fractional timer The pacing timer produces TREQ
                                                     assertions at a rate set by ((X/Y) * sys_clk). This equation
                                                     is evaluated every sys_clk cycles and therefore can only
                                                     generate TREQs at a rate of 1 per sys_clk (i.e. permanent
                                                     TREQ) or less.                                                            */
  __IOM uint32_t  TIMER2;                       /*!< Pacing (X/Y) fractional timer The pacing timer produces TREQ
                                                     assertions at a rate set by ((X/Y) * sys_clk). This equation
                                                     is evaluated every sys_clk cycles and therefore can only
                                                     generate TREQs at a rate of 1 per sys_clk (i.e. permanent
                                                     TREQ) or less.                                                            */
  __IOM uint32_t  TIMER3;                       /*!< Pacing (X/Y) fractional timer The pacing timer produces TREQ
                                                     assertions at a rate set by ((X/Y) * sys_clk). This equation
                                                     is evaluated every sys_clk cycles and therefore can only
                                                     generate TREQs at a rate of 1 per sys_clk (i.e. permanent
                                                     TREQ) or less.                                                            */
  __IOM uint32_t  MULTI_CHAN_TRIGGER;           /*!< Trigger one or more channels simultaneously                               */
  __IOM uint32_t  SNIFF_CTRL;                   /*!< Sniffer Control                                                           */
  __IOM uint32_t  SNIFF_DATA;                   /*!< Data accumulator for sniff hardware                                       */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  FIFO_LEVELS;                  /*!< Debug RAF, WAF, TDF levels                                                */
  __IOM uint32_t  CHAN_ABORT;                   /*!< Abort an in-progress transfer sequence on one or more channels            */
  __IOM uint32_t  N_CHANNELS;                   /*!< The number of channels this DMA instance is equipped with. This
                                                     DMA supports up to 16 hardware channels, but can be configured
                                                     with as few as one, to minimise silicon area.                             */
  __IM  uint32_t  RESERVED1[5];
  __IOM uint32_t  SECCFG_CH0;                   /*!< Security configuration for channel 0. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH1;                   /*!< Security configuration for channel 1. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH2;                   /*!< Security configuration for channel 2. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH3;                   /*!< Security configuration for channel 3. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH4;                   /*!< Security configuration for channel 4. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH5;                   /*!< Security configuration for channel 5. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH6;                   /*!< Security configuration for channel 6. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH7;                   /*!< Security configuration for channel 7. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH8;                   /*!< Security configuration for channel 8. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH9;                   /*!< Security configuration for channel 9. Control whether this channel
                                                     performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH10;                  /*!< Security configuration for channel 10. Control whether this
                                                     channel performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH11;                  /*!< Security configuration for channel 11. Control whether this
                                                     channel performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH12;                  /*!< Security configuration for channel 12. Control whether this
                                                     channel performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH13;                  /*!< Security configuration for channel 13. Control whether this
                                                     channel performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH14;                  /*!< Security configuration for channel 14. Control whether this
                                                     channel performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_CH15;                  /*!< Security configuration for channel 15. Control whether this
                                                     channel performs Secure/Non-secure and Privileged/Unprivileged
                                                     bus accesses. If this channel generates bus accesses of
                                                     some security level, an access of at least that level (in
                                                     the order S+P > S+U > NS+P > NS+U) is required to program,
                                                     trigger, abort, check the status of, interrupt on or acknowledge
                                                     the interrupt of this channel. This register automatically
                                                     locks down (becomes read-only) once software starts to
                                                     configure the channel. This register is world-readable,
                                                     but is writable only from a Secure, Privileged context.                   */
  __IOM uint32_t  SECCFG_IRQ0;                  /*!< Security configuration for IRQ 0. Control whether the IRQ permits
                                                     configuration by Non-secure/Unprivileged contexts, and
                                                     whether it can observe Secure/Privileged channel interrupt
                                                     flags.                                                                    */
  __IOM uint32_t  SECCFG_IRQ1;                  /*!< Security configuration for IRQ 1. Control whether the IRQ permits
                                                     configuration by Non-secure/Unprivileged contexts, and
                                                     whether it can observe Secure/Privileged channel interrupt
                                                     flags.                                                                    */
  __IOM uint32_t  SECCFG_IRQ2;                  /*!< Security configuration for IRQ 2. Control whether the IRQ permits
                                                     configuration by Non-secure/Unprivileged contexts, and
                                                     whether it can observe Secure/Privileged channel interrupt
                                                     flags.                                                                    */
  __IOM uint32_t  SECCFG_IRQ3;                  /*!< Security configuration for IRQ 3. Control whether the IRQ permits
                                                     configuration by Non-secure/Unprivileged contexts, and
                                                     whether it can observe Secure/Privileged channel interrupt
                                                     flags.                                                                    */
  __IOM uint32_t  SECCFG_MISC;                  /*!< Miscellaneous security configuration                                      */
  __IM  uint32_t  RESERVED2[11];
  __IOM uint32_t  MPU_CTRL;                     /*!< Control register for DMA MPU. Accessible only from a Privileged
                                                     context.                                                                  */
  __IOM uint32_t  MPU_BAR0;                     /*!< Base address register for MPU region 0. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR0;                     /*!< Limit address register for MPU region 0. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR1;                     /*!< Base address register for MPU region 1. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR1;                     /*!< Limit address register for MPU region 1. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR2;                     /*!< Base address register for MPU region 2. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR2;                     /*!< Limit address register for MPU region 2. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR3;                     /*!< Base address register for MPU region 3. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR3;                     /*!< Limit address register for MPU region 3. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR4;                     /*!< Base address register for MPU region 4. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR4;                     /*!< Limit address register for MPU region 4. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR5;                     /*!< Base address register for MPU region 5. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR5;                     /*!< Limit address register for MPU region 5. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR6;                     /*!< Base address register for MPU region 6. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR6;                     /*!< Limit address register for MPU region 6. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IOM uint32_t  MPU_BAR7;                     /*!< Base address register for MPU region 7. Writable only from a
                                                     Secure, Privileged context.                                               */
  __IOM uint32_t  MPU_LAR7;                     /*!< Limit address register for MPU region 7. Writable only from
                                                     a Secure, Privileged context, with the exception of the
                                                     P bit.                                                                    */
  __IM  uint32_t  RESERVED3[175];
  __IOM uint32_t  CH0_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH0_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED4[14];
  __IOM uint32_t  CH1_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH1_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED5[14];
  __IOM uint32_t  CH2_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH2_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED6[14];
  __IOM uint32_t  CH3_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH3_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED7[14];
  __IOM uint32_t  CH4_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH4_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED8[14];
  __IOM uint32_t  CH5_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH5_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED9[14];
  __IOM uint32_t  CH6_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH6_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED10[14];
  __IOM uint32_t  CH7_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH7_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED11[14];
  __IOM uint32_t  CH8_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH8_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED12[14];
  __IOM uint32_t  CH9_DBG_CTDREQ;               /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH9_DBG_TCR;                  /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED13[14];
  __IOM uint32_t  CH10_DBG_CTDREQ;              /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH10_DBG_TCR;                 /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED14[14];
  __IOM uint32_t  CH11_DBG_CTDREQ;              /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH11_DBG_TCR;                 /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED15[14];
  __IOM uint32_t  CH12_DBG_CTDREQ;              /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH12_DBG_TCR;                 /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED16[14];
  __IOM uint32_t  CH13_DBG_CTDREQ;              /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH13_DBG_TCR;                 /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED17[14];
  __IOM uint32_t  CH14_DBG_CTDREQ;              /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH14_DBG_TCR;                 /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
  __IM  uint32_t  RESERVED18[14];
  __IOM uint32_t  CH15_DBG_CTDREQ;              /*!< Read: get channel DREQ counter (i.e. how many accesses the DMA
                                                     expects it can perform on the peripheral without overflow/underflow.
                                                     Write any value: clears the counter, and cause channel
                                                     to re-initiate DREQ handshake.                                            */
  __IOM uint32_t  CH15_DBG_TCR;                 /*!< Read to get channel TRANS_COUNT reload value, i.e. the length
                                                     of the next transfer                                                      */
} DMA_Type;                                     /*!< Size = 3016 (0xbc8)                                                       */



/* =========================================================================================================================== */
/* ================                                          TIMER0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Controls time and alarms

            time is a 64 bit value indicating the time since power-on

            timeh is the top 32 bits of time & timel is the bottom 32 bits to change time write to timelw before timehw to read time read from timelr before timehr

            An alarm is set by setting alarm_enable and writing to the corresponding alarm register When an alarm is pending, the corresponding alarm_running signal will be high An alarm can be cancelled before it has finished by clearing the alarm_enable When an alarm fires, the corresponding alarm_irq is set and alarm_running is cleared To clear the interrupt write a 1 to the corresponding alarm_irq The timer can be locked to prevent writing (TIMER0)
  */

typedef struct {                                /*!< TIMER0 Structure                                                          */
  __IOM uint32_t  TIMEHW;                       /*!< Write to bits 63:32 of time always write timelw before timehw             */
  __IOM uint32_t  TIMELW;                       /*!< Write to bits 31:0 of time writes do not get copied to time
                                                     until timehw is written                                                   */
  __IOM uint32_t  TIMEHR;                       /*!< Read from bits 63:32 of time always read timelr before timehr             */
  __IOM uint32_t  TIMELR;                       /*!< Read from bits 31:0 of time                                               */
  __IOM uint32_t  ALARM0;                       /*!< Arm alarm 0, and configure the time it will fire. Once armed,
                                                     the alarm fires when TIMER_ALARM0 == TIMELR. The alarm
                                                     will disarm itself once it fires, and can be disarmed early
                                                     using the ARMED status register.                                          */
  __IOM uint32_t  ALARM1;                       /*!< Arm alarm 1, and configure the time it will fire. Once armed,
                                                     the alarm fires when TIMER_ALARM1 == TIMELR. The alarm
                                                     will disarm itself once it fires, and can be disarmed early
                                                     using the ARMED status register.                                          */
  __IOM uint32_t  ALARM2;                       /*!< Arm alarm 2, and configure the time it will fire. Once armed,
                                                     the alarm fires when TIMER_ALARM2 == TIMELR. The alarm
                                                     will disarm itself once it fires, and can be disarmed early
                                                     using the ARMED status register.                                          */
  __IOM uint32_t  ALARM3;                       /*!< Arm alarm 3, and configure the time it will fire. Once armed,
                                                     the alarm fires when TIMER_ALARM3 == TIMELR. The alarm
                                                     will disarm itself once it fires, and can be disarmed early
                                                     using the ARMED status register.                                          */
  __IOM uint32_t  ARMED;                        /*!< Indicates the armed/disarmed status of each alarm. A write to
                                                     the corresponding ALARMx register arms the alarm. Alarms
                                                     automatically disarm upon firing, but writing ones here
                                                     will disarm immediately without waiting to fire.                          */
  __IOM uint32_t  TIMERAWH;                     /*!< Raw read from bits 63:32 of time (no side effects)                        */
  __IOM uint32_t  TIMERAWL;                     /*!< Raw read from bits 31:0 of time (no side effects)                         */
  __IOM uint32_t  DBGPAUSE;                     /*!< Set bits high to enable pause when the corresponding debug ports
                                                     are active                                                                */
  __IOM uint32_t  PAUSE;                        /*!< Set high to pause the timer                                               */
  __IOM uint32_t  LOCKED;                       /*!< Set locked bit to disable write access to timer Once set, cannot
                                                     be cleared (without a reset)                                              */
  __IOM uint32_t  SOURCE;                       /*!< Selects the source for the timer. Defaults to the normal tick
                                                     configured in the ticks block (typically configured to
                                                     1 microsecond). Writing to 1 will ignore the tick and count
                                                     clk_sys cycles instead.                                                   */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
} TIMER0_Type;                                  /*!< Size = 76 (0x4c)                                                          */



/* =========================================================================================================================== */
/* ================                                            PWM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Simple PWM (PWM)
  */

typedef struct {                                /*!< PWM Structure                                                             */
  __IOM uint32_t  CH0_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH0_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH0_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH0_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH0_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH1_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH1_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH1_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH1_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH1_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH2_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH2_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH2_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH2_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH2_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH3_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH3_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH3_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH3_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH3_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH4_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH4_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH4_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH4_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH4_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH5_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH5_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH5_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH5_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH5_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH6_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH6_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH6_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH6_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH6_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH7_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH7_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH7_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH7_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH7_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH8_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH8_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH8_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH8_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH8_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH9_CSR;                      /*!< Control and status register                                               */
  __IOM uint32_t  CH9_DIV;                      /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH9_CTR;                      /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH9_CC;                       /*!< Counter compare values                                                    */
  __IOM uint32_t  CH9_TOP;                      /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH10_CSR;                     /*!< Control and status register                                               */
  __IOM uint32_t  CH10_DIV;                     /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH10_CTR;                     /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH10_CC;                      /*!< Counter compare values                                                    */
  __IOM uint32_t  CH10_TOP;                     /*!< Counter wrap value                                                        */
  __IOM uint32_t  CH11_CSR;                     /*!< Control and status register                                               */
  __IOM uint32_t  CH11_DIV;                     /*!< INT and FRAC form a fixed-point fractional number. Counting
                                                     rate is system clock frequency divided by this number.
                                                     Fractional division uses simple 1st-order sigma-delta.                    */
  __IOM uint32_t  CH11_CTR;                     /*!< Direct access to the PWM counter                                          */
  __IOM uint32_t  CH11_CC;                      /*!< Counter compare values                                                    */
  __IOM uint32_t  CH11_TOP;                     /*!< Counter wrap value                                                        */
  __IOM uint32_t  EN;                           /*!< This register aliases the CSR_EN bits for all channels. Writing
                                                     to this register allows multiple channels to be enabled
                                                     or disabled simultaneously, so they can run in perfect
                                                     sync. For each channel, there is only one physical EN register
                                                     bit, which can be accessed through here or CHx_CSR.                       */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  IRQ0_INTE;                    /*!< Interrupt Enable for irq0                                                 */
  __IOM uint32_t  IRQ0_INTF;                    /*!< Interrupt Force for irq0                                                  */
  __IOM uint32_t  IRQ0_INTS;                    /*!< Interrupt status after masking & forcing for irq0                         */
  __IOM uint32_t  IRQ1_INTE;                    /*!< Interrupt Enable for irq1                                                 */
  __IOM uint32_t  IRQ1_INTF;                    /*!< Interrupt Force for irq1                                                  */
  __IOM uint32_t  IRQ1_INTS;                    /*!< Interrupt status after masking & forcing for irq1                         */
} PWM_Type;                                     /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Control and data interface to SAR ADC (ADC)
  */

typedef struct {                                /*!< ADC Structure                                                             */
  __IOM uint32_t  CS;                           /*!< ADC Control and Status                                                    */
  __IOM uint32_t  RESULT;                       /*!< Result of most recent ADC conversion                                      */
  __IOM uint32_t  FCS;                          /*!< FIFO control and status                                                   */
  __IOM uint32_t  FIFO;                         /*!< Conversion result FIFO                                                    */
  __IOM uint32_t  DIV;                          /*!< Clock divider. If non-zero, CS_START_MANY will start conversions
                                                     at regular intervals rather than back-to-back. The divider
                                                     is reset when either of these fields are written. Total
                                                     period is 1 + INT + FRAC / 256                                            */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
} ADC_Type;                                     /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                           I2C0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief DW_apb_i2c address block

            List of configuration constants for the Synopsys I2C hardware (you may see references to these in I2C register header; these are *fixed* values, set at hardware design time):

            IC_ULTRA_FAST_MODE ................ 0x0 
            IC_UFM_TBUF_CNT_DEFAULT ........... 0x8 
            IC_UFM_SCL_LOW_COUNT .............. 0x0008 
            IC_UFM_SCL_HIGH_COUNT ............. 0x0006 
            IC_TX_TL .......................... 0x0 
            IC_TX_CMD_BLOCK ................... 0x1 
            IC_HAS_DMA ........................ 0x1 
            IC_HAS_ASYNC_FIFO ................. 0x0 
            IC_SMBUS_ARP ...................... 0x0 
            IC_FIRST_DATA_BYTE_STATUS ......... 0x1 
            IC_INTR_IO ........................ 0x1 
            IC_MASTER_MODE .................... 0x1 
            IC_DEFAULT_ACK_GENERAL_CALL ....... 0x1 
            IC_INTR_POL ....................... 0x1 
            IC_OPTIONAL_SAR ................... 0x0 
            IC_DEFAULT_TAR_SLAVE_ADDR ......... 0x055 
            IC_DEFAULT_SLAVE_ADDR ............. 0x055 
            IC_DEFAULT_HS_SPKLEN .............. 0x1 
            IC_FS_SCL_HIGH_COUNT .............. 0x0006 
            IC_HS_SCL_LOW_COUNT ............... 0x0008 
            IC_DEVICE_ID_VALUE ................ 0x0 
            IC_10BITADDR_MASTER ............... 0x0 
            IC_CLK_FREQ_OPTIMIZATION .......... 0x0 
            IC_DEFAULT_FS_SPKLEN .............. 0x7 
            IC_ADD_ENCODED_PARAMS ............. 0x0 
            IC_DEFAULT_SDA_HOLD ............... 0x000001 
            IC_DEFAULT_SDA_SETUP .............. 0x64 
            IC_AVOID_RX_FIFO_FLUSH_ON_TX_ABRT . 0x0 
            IC_CLOCK_PERIOD ................... 100 
            IC_EMPTYFIFO_HOLD_MASTER_EN ....... 1 
            IC_RESTART_EN ..................... 0x1 
            IC_TX_CMD_BLOCK_DEFAULT ........... 0x0 
            IC_BUS_CLEAR_FEATURE .............. 0x0 
            IC_CAP_LOADING .................... 100 
            IC_FS_SCL_LOW_COUNT ............... 0x000d 
            APB_DATA_WIDTH .................... 32 
            IC_SDA_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff 
            IC_SLV_DATA_NACK_ONLY ............. 0x1 
            IC_10BITADDR_SLAVE ................ 0x0 
            IC_CLK_TYPE ....................... 0x0 
            IC_SMBUS_UDID_MSB ................. 0x0 
            IC_SMBUS_SUSPEND_ALERT ............ 0x0 
            IC_HS_SCL_HIGH_COUNT .............. 0x0006 
            IC_SLV_RESTART_DET_EN ............. 0x1 
            IC_SMBUS .......................... 0x0 
            IC_OPTIONAL_SAR_DEFAULT ........... 0x0 
            IC_PERSISTANT_SLV_ADDR_DEFAULT .... 0x0 
            IC_USE_COUNTS ..................... 0x0 
            IC_RX_BUFFER_DEPTH ................ 16 
            IC_SCL_STUCK_TIMEOUT_DEFAULT ...... 0xffffffff 
            IC_RX_FULL_HLD_BUS_EN ............. 0x1 
            IC_SLAVE_DISABLE .................. 0x1 
            IC_RX_TL .......................... 0x0 
            IC_DEVICE_ID ...................... 0x0 
            IC_HC_COUNT_VALUES ................ 0x0 
            I2C_DYNAMIC_TAR_UPDATE ............ 0 
            IC_SMBUS_CLK_LOW_MEXT_DEFAULT ..... 0xffffffff 
            IC_SMBUS_CLK_LOW_SEXT_DEFAULT ..... 0xffffffff 
            IC_HS_MASTER_CODE ................. 0x1 
            IC_SMBUS_RST_IDLE_CNT_DEFAULT ..... 0xffff 
            IC_SMBUS_UDID_LSB_DEFAULT ......... 0xffffffff 
            IC_SS_SCL_HIGH_COUNT .............. 0x0028 
            IC_SS_SCL_LOW_COUNT ............... 0x002f 
            IC_MAX_SPEED_MODE ................. 0x2 
            IC_STAT_FOR_CLK_STRETCH ........... 0x0 
            IC_STOP_DET_IF_MASTER_ACTIVE ...... 0x0 
            IC_DEFAULT_UFM_SPKLEN ............. 0x1 
            IC_TX_BUFFER_DEPTH ................ 16 (I2C0)
  */

typedef struct {                                /*!< I2C0 Structure                                                            */
  __IOM uint32_t  IC_CON;                       /*!< I2C Control Register. This register can be written only when
                                                     the DW_apb_i2c is disabled, which corresponds to the IC_ENABLE[0]
                                                     register being set to 0. Writes at other times have no
                                                     effect. Read/Write Access: - bit 10 is read only. - bit
                                                     11 is read only - bit 16 is read only - bit 17 is read
                                                     only - bits 18 and 19 are read only.                                      */
  __IOM uint32_t  IC_TAR;                       /*!< I2C Target Address Register This register is 12 bits wide, and
                                                     bits 31:12 are reserved. This register can be written to
                                                     only when IC_ENABLE[0] is set to 0. Note: If the software
                                                     or application is aware that the DW_apb_i2c is not using
                                                     the TAR address for the pending commands in the Tx FIFO,
                                                     then it is possible to update the TAR address even while
                                                     the Tx FIFO has entries (IC_STATUS[2]= 0). - It is not
                                                     necessary to perform any write to this register if DW_apb_i2c
                                                     is enabled as an I2C slave only.                                          */
  __IOM uint32_t  IC_SAR;                       /*!< I2C Slave Address Register                                                */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  IC_DATA_CMD;                  /*!< I2C Rx/Tx Data Buffer and Command Register; this is the register
                                                     the CPU writes to when filling the TX FIFO and the CPU
                                                     reads from when retrieving bytes from RX FIFO. The size
                                                     of the register changes as follows: Write: - 11 bits when
                                                     IC_EMPTYFIFO_HOLD_MASTER_EN=1 - 9 bits when IC_EMPTYFIFO_HOLD_MASTER_EN=0
                                                     Read: - 12 bits when IC_FIRST_DATA_BYTE_STATUS = 1 - 8
                                                     bits when IC_FIRST_DATA_BYTE_STATUS = 0 Note: In order
                                                     for the DW_apb_i2c to continue acknowledging reads, a read
                                                     command should be written for every byte that is to be
                                                     received; otherwise the DW_apb_i2c will stop acknowledging.               */
  __IOM uint32_t  IC_SS_SCL_HCNT;               /*!< Standard Speed I2C Clock SCL High Count Register                          */
  __IOM uint32_t  IC_SS_SCL_LCNT;               /*!< Standard Speed I2C Clock SCL Low Count Register                           */
  __IOM uint32_t  IC_FS_SCL_HCNT;               /*!< Fast Mode or Fast Mode Plus I2C Clock SCL High Count Register             */
  __IOM uint32_t  IC_FS_SCL_LCNT;               /*!< Fast Mode or Fast Mode Plus I2C Clock SCL Low Count Register              */
  __IM  uint32_t  RESERVED1[2];
  __IOM uint32_t  IC_INTR_STAT;                 /*!< I2C Interrupt Status Register Each bit in this register has
                                                     a corresponding mask bit in the IC_INTR_MASK register.
                                                     These bits are cleared by reading the matching interrupt
                                                     clear register. The unmasked raw versions of these bits
                                                     are available in the IC_RAW_INTR_STAT register.                           */
  __IOM uint32_t  IC_INTR_MASK;                 /*!< I2C Interrupt Mask Register. These bits mask their corresponding
                                                     interrupt status bits. This register is active low; a value
                                                     of 0 masks the interrupt, whereas a value of 1 unmasks
                                                     the interrupt.                                                            */
  __IOM uint32_t  IC_RAW_INTR_STAT;             /*!< I2C Raw Interrupt Status Register Unlike the IC_INTR_STAT register,
                                                     these bits are not masked so they always show the true
                                                     status of the DW_apb_i2c.                                                 */
  __IOM uint32_t  IC_RX_TL;                     /*!< I2C Receive FIFO Threshold Register                                       */
  __IOM uint32_t  IC_TX_TL;                     /*!< I2C Transmit FIFO Threshold Register                                      */
  __IOM uint32_t  IC_CLR_INTR;                  /*!< Clear Combined and Individual Interrupt Register                          */
  __IOM uint32_t  IC_CLR_RX_UNDER;              /*!< Clear RX_UNDER Interrupt Register                                         */
  __IOM uint32_t  IC_CLR_RX_OVER;               /*!< Clear RX_OVER Interrupt Register                                          */
  __IOM uint32_t  IC_CLR_TX_OVER;               /*!< Clear TX_OVER Interrupt Register                                          */
  __IOM uint32_t  IC_CLR_RD_REQ;                /*!< Clear RD_REQ Interrupt Register                                           */
  __IOM uint32_t  IC_CLR_TX_ABRT;               /*!< Clear TX_ABRT Interrupt Register                                          */
  __IOM uint32_t  IC_CLR_RX_DONE;               /*!< Clear RX_DONE Interrupt Register                                          */
  __IOM uint32_t  IC_CLR_ACTIVITY;              /*!< Clear ACTIVITY Interrupt Register                                         */
  __IOM uint32_t  IC_CLR_STOP_DET;              /*!< Clear STOP_DET Interrupt Register                                         */
  __IOM uint32_t  IC_CLR_START_DET;             /*!< Clear START_DET Interrupt Register                                        */
  __IOM uint32_t  IC_CLR_GEN_CALL;              /*!< Clear GEN_CALL Interrupt Register                                         */
  __IOM uint32_t  IC_ENABLE;                    /*!< I2C Enable Register                                                       */
  __IOM uint32_t  IC_STATUS;                    /*!< I2C Status Register This is a read-only register used to indicate
                                                     the current transfer status and FIFO status. The status
                                                     register may be read at any time. None of the bits in this
                                                     register request an interrupt. When the I2C is disabled
                                                     by writing 0 in bit 0 of the IC_ENABLE register: - Bits
                                                     1 and 2 are set to 1 - Bits 3 and 10 are set to 0 When
                                                     the master or slave state machines goes to idle and ic_en=0:
                                                     - Bits 5 and 6 are set to 0                                               */
  __IOM uint32_t  IC_TXFLR;                     /*!< I2C Transmit FIFO Level Register This register contains the
                                                     number of valid data entries in the transmit FIFO buffer.
                                                     It is cleared whenever: - The I2C is disabled - There is
                                                     a transmit abort - that is, TX_ABRT bit is set in the IC_RAW_INTR_STAT
                                                     register - The slave bulk transmit mode is aborted The
                                                     register increments whenever data is placed into the transmit
                                                     FIFO and decrements when data is taken from the transmit
                                                     FIFO.                                                                     */
  __IOM uint32_t  IC_RXFLR;                     /*!< I2C Receive FIFO Level Register This register contains the number
                                                     of valid data entries in the receive FIFO buffer. It is
                                                     cleared whenever: - The I2C is disabled - Whenever there
                                                     is a transmit abort caused by any of the events tracked
                                                     in IC_TX_ABRT_SOURCE The register increments whenever data
                                                     is placed into the receive FIFO and decrements when data
                                                     is taken from the receive FIFO.                                           */
  __IOM uint32_t  IC_SDA_HOLD;                  /*!< I2C SDA Hold Time Length Register The bits [15:0] of this register
                                                     are used to control the hold time of SDA during transmit
                                                     in both slave and master mode (after SCL goes from HIGH
                                                     to LOW). The bits [23:16] of this register are used to
                                                     extend the SDA transition (if any) whenever SCL is HIGH
                                                     in the receiver in either master or slave mode. Writes
                                                     to this register succeed only when IC_ENABLE[0]=0. The
                                                     values in this register are in units of ic_clk period.
                                                     The value programmed in IC_SDA_TX_HOLD must be greater
                                                     than the minimum hold time in each mode (one cycle in master
                                                     mode, seven cycles in slave mode) for the value to be implemented.
                                                     The programmed SDA hold time during transmit (IC_SDA_TX_HOLD)
                                                     cannot exceed at any time the duration of the low part
                                                     of scl. Therefore the programmed value cannot be larger
                                                     than N_SCL_LOW-2, where N_SCL_LOW is the duration of the
                                                     low part of the scl period measured in ic_clk cycles.                     */
  __IOM uint32_t  IC_TX_ABRT_SOURCE;            /*!< I2C Transmit Abort Source Register This register has 32 bits
                                                     that indicate the source of the TX_ABRT bit. Except for
                                                     Bit 9, this register is cleared whenever the IC_CLR_TX_ABRT
                                                     register or the IC_CLR_INTR register is read. To clear
                                                     Bit 9, the source of the ABRT_SBYTE_NORSTRT must be fixed
                                                     first; RESTART must be enabled (IC_CON[5]=1), the SPECIAL
                                                     bit must be cleared (IC_TAR[11]), or the GC_OR_START bit
                                                     must be cleared (IC_TAR[10]). Once the source of the ABRT_SBYTE_NORSTRT
                                                     is fixed, then this bit can be cleared in the same manner
                                                     as other bits in this register. If the source of the ABRT_SBYTE_NORSTRT
                                                     is not fixed before attempting to clear this bit, Bit 9
                                                     clears for one cycle and is then re-asserted.                             */
  __IOM uint32_t  IC_SLV_DATA_NACK_ONLY;        /*!< Generate Slave Data NACK Register The register is used to generate
                                                     a NACK for the data part of a transfer when DW_apb_i2c
                                                     is acting as a slave-receiver. This register only exists
                                                     when the IC_SLV_DATA_NACK_ONLY parameter is set to 1. When
                                                     this parameter disabled, this register does not exist and
                                                     writing to the register's address has no effect. A write
                                                     can occur on this register if both of the following conditions
                                                     are met: - DW_apb_i2c is disabled (IC_ENABLE[0] = 0) -
                                                     Slave part is inactive (IC_STATUS[6] = 0) Note: The IC_STATUS[6]
                                                     is a register read-back location for the internal slv_activity
                                                     signal; the user should poll this before writing the ic_slv_data_nack_onl
                                                     bit.                                                                      */
  __IOM uint32_t  IC_DMA_CR;                    /*!< DMA Control Register The register is used to enable the DMA
                                                     Controller interface operation. There is a separate bit
                                                     for transmit and receive. This can be programmed regardless
                                                     of the state of IC_ENABLE.                                                */
  __IOM uint32_t  IC_DMA_TDLR;                  /*!< DMA Transmit Data Level Register                                          */
  __IOM uint32_t  IC_DMA_RDLR;                  /*!< I2C Receive Data Level Register                                           */
  __IOM uint32_t  IC_SDA_SETUP;                 /*!< I2C SDA Setup Register This register controls the amount of
                                                     time delay (in terms of number of ic_clk clock periods)
                                                     introduced in the rising edge of SCL - relative to SDA
                                                     changing - when DW_apb_i2c services a read request in a
                                                     slave-transmitter operation. The relevant I2C requirement
                                                     is tSU:DAT (note 4) as detailed in the I2C Bus Specification.
                                                     This register must be programmed with a value equal to
                                                     or greater than 2. Writes to this register succeed only
                                                     when IC_ENABLE[0] = 0. Note: The length of setup time is
                                                     calculated using [(IC_SDA_SETUP - 1) * (ic_clk_period)],
                                                     so if the user requires 10 ic_clk periods of setup time,
                                                     they should program a value of 11. The IC_SDA_SETUP register
                                                     is only used by the DW_apb_i2c when operating as a slave
                                                     transmitter.                                                              */
  __IOM uint32_t  IC_ACK_GENERAL_CALL;          /*!< I2C ACK General Call Register The register controls whether
                                                     DW_apb_i2c responds with a ACK or NACK when it receives
                                                     an I2C General Call address. This register is applicable
                                                     only when the DW_apb_i2c is in slave mode.                                */
  __IOM uint32_t  IC_ENABLE_STATUS;             /*!< I2C Enable Status Register The register is used to report the
                                                     DW_apb_i2c hardware status when the IC_ENABLE[0] register
                                                     is set from 1 to 0; that is, when DW_apb_i2c is disabled.
                                                     If IC_ENABLE[0] has been set to 1, bits 2:1 are forced
                                                     to 0, and bit 0 is forced to 1. If IC_ENABLE[0] has been
                                                     set to 0, bits 2:1 is only be valid as soon as bit 0 is
                                                     read as '0'. Note: When IC_ENABLE[0] has been set to 0,
                                                     a delay occurs for bit 0 to be read as 0 because disabling
                                                     the DW_apb_i2c depends on I2C bus activities.                             */
  __IOM uint32_t  IC_FS_SPKLEN;                 /*!< I2C SS, FS or FM+ spike suppression limit This register is used
                                                     to store the duration, measured in ic_clk cycles, of the
                                                     longest spike that is filtered out by the spike suppression
                                                     logic when the component is operating in SS, FS or FM+
                                                     modes. The relevant I2C requirement is tSP (table 4) as
                                                     detailed in the I2C Bus Specification. This register must
                                                     be programmed with a minimum value of 1.                                  */
  __IM  uint32_t  RESERVED2;
  __IOM uint32_t  IC_CLR_RESTART_DET;           /*!< Clear RESTART_DET Interrupt Register                                      */
  __IM  uint32_t  RESERVED3[18];
  __IOM uint32_t  IC_COMP_PARAM_1;              /*!< Component Parameter Register 1 Note This register is not implemented
                                                     and therefore reads as 0. If it was implemented it would
                                                     be a constant read-only register that contains encoded
                                                     information about the component's parameter settings. Fields
                                                     shown below are the settings for those parameters                         */
  __IOM uint32_t  IC_COMP_VERSION;              /*!< I2C Component Version Register                                            */
  __IOM uint32_t  IC_COMP_TYPE;                 /*!< I2C Component Type Register                                               */
} I2C0_Type;                                    /*!< Size = 256 (0x100)                                                        */



/* =========================================================================================================================== */
/* ================                                           SPI0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief SPI0 (SPI0)
  */

typedef struct {                                /*!< SPI0 Structure                                                            */
  __IOM uint32_t  SSPCR0;                       /*!< Control register 0, SSPCR0 on page 3-4                                    */
  __IOM uint32_t  SSPCR1;                       /*!< Control register 1, SSPCR1 on page 3-5                                    */
  __IOM uint32_t  SSPDR;                        /*!< Data register, SSPDR on page 3-6                                          */
  __IOM uint32_t  SSPSR;                        /*!< Status register, SSPSR on page 3-7                                        */
  __IOM uint32_t  SSPCPSR;                      /*!< Clock prescale register, SSPCPSR on page 3-8                              */
  __IOM uint32_t  SSPIMSC;                      /*!< Interrupt mask set or clear register, SSPIMSC on page 3-9                 */
  __IOM uint32_t  SSPRIS;                       /*!< Raw interrupt status register, SSPRIS on page 3-10                        */
  __IOM uint32_t  SSPMIS;                       /*!< Masked interrupt status register, SSPMIS on page 3-11                     */
  __IOM uint32_t  SSPICR;                       /*!< Interrupt clear register, SSPICR on page 3-11                             */
  __IOM uint32_t  SSPDMACR;                     /*!< DMA control register, SSPDMACR on page 3-12                               */
  __IM  uint32_t  RESERVED[1006];
  __IOM uint32_t  SSPPERIPHID0;                 /*!< Peripheral identification registers, SSPPeriphID0-3 on page
                                                     3-13                                                                      */
  __IOM uint32_t  SSPPERIPHID1;                 /*!< Peripheral identification registers, SSPPeriphID0-3 on page
                                                     3-13                                                                      */
  __IOM uint32_t  SSPPERIPHID2;                 /*!< Peripheral identification registers, SSPPeriphID0-3 on page
                                                     3-13                                                                      */
  __IOM uint32_t  SSPPERIPHID3;                 /*!< Peripheral identification registers, SSPPeriphID0-3 on page
                                                     3-13                                                                      */
  __IOM uint32_t  SSPPCELLID0;                  /*!< PrimeCell identification registers, SSPPCellID0-3 on page 3-16            */
  __IOM uint32_t  SSPPCELLID1;                  /*!< PrimeCell identification registers, SSPPCellID0-3 on page 3-16            */
  __IOM uint32_t  SSPPCELLID2;                  /*!< PrimeCell identification registers, SSPPCellID0-3 on page 3-16            */
  __IOM uint32_t  SSPPCELLID3;                  /*!< PrimeCell identification registers, SSPPCellID0-3 on page 3-16            */
} SPI0_Type;                                    /*!< Size = 4096 (0x1000)                                                      */



/* =========================================================================================================================== */
/* ================                                           PIO0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Programmable IO block (PIO0)
  */

typedef struct {                                /*!< PIO0 Structure                                                            */
  __IOM uint32_t  CTRL;                         /*!< PIO control register                                                      */
  __IOM uint32_t  FSTAT;                        /*!< FIFO status register                                                      */
  __IOM uint32_t  FDEBUG;                       /*!< FIFO debug register                                                       */
  __IOM uint32_t  FLEVEL;                       /*!< FIFO levels                                                               */
  __IOM uint32_t  TXF0;                         /*!< Direct write access to the TX FIFO for this state machine. Each
                                                     write pushes one word to the FIFO. Attempting to write
                                                     to a full FIFO has no effect on the FIFO state or contents,
                                                     and sets the sticky FDEBUG_TXOVER error flag for this FIFO.               */
  __IOM uint32_t  TXF1;                         /*!< Direct write access to the TX FIFO for this state machine. Each
                                                     write pushes one word to the FIFO. Attempting to write
                                                     to a full FIFO has no effect on the FIFO state or contents,
                                                     and sets the sticky FDEBUG_TXOVER error flag for this FIFO.               */
  __IOM uint32_t  TXF2;                         /*!< Direct write access to the TX FIFO for this state machine. Each
                                                     write pushes one word to the FIFO. Attempting to write
                                                     to a full FIFO has no effect on the FIFO state or contents,
                                                     and sets the sticky FDEBUG_TXOVER error flag for this FIFO.               */
  __IOM uint32_t  TXF3;                         /*!< Direct write access to the TX FIFO for this state machine. Each
                                                     write pushes one word to the FIFO. Attempting to write
                                                     to a full FIFO has no effect on the FIFO state or contents,
                                                     and sets the sticky FDEBUG_TXOVER error flag for this FIFO.               */
  __IOM uint32_t  RXF0;                         /*!< Direct read access to the RX FIFO for this state machine. Each
                                                     read pops one word from the FIFO. Attempting to read from
                                                     an empty FIFO has no effect on the FIFO state, and sets
                                                     the sticky FDEBUG_RXUNDER error flag for this FIFO. The
                                                     data returned to the system on a read from an empty FIFO
                                                     is undefined.                                                             */
  __IOM uint32_t  RXF1;                         /*!< Direct read access to the RX FIFO for this state machine. Each
                                                     read pops one word from the FIFO. Attempting to read from
                                                     an empty FIFO has no effect on the FIFO state, and sets
                                                     the sticky FDEBUG_RXUNDER error flag for this FIFO. The
                                                     data returned to the system on a read from an empty FIFO
                                                     is undefined.                                                             */
  __IOM uint32_t  RXF2;                         /*!< Direct read access to the RX FIFO for this state machine. Each
                                                     read pops one word from the FIFO. Attempting to read from
                                                     an empty FIFO has no effect on the FIFO state, and sets
                                                     the sticky FDEBUG_RXUNDER error flag for this FIFO. The
                                                     data returned to the system on a read from an empty FIFO
                                                     is undefined.                                                             */
  __IOM uint32_t  RXF3;                         /*!< Direct read access to the RX FIFO for this state machine. Each
                                                     read pops one word from the FIFO. Attempting to read from
                                                     an empty FIFO has no effect on the FIFO state, and sets
                                                     the sticky FDEBUG_RXUNDER error flag for this FIFO. The
                                                     data returned to the system on a read from an empty FIFO
                                                     is undefined.                                                             */
  __IOM uint32_t  IRQ;                          /*!< State machine IRQ flags register. Write 1 to clear. There are
                                                     eight state machine IRQ flags, which can be set, cleared,
                                                     and waited on by the state machines. There's no fixed association
                                                     between flags and state machines -- any state machine can
                                                     use any flag. Any of the eight flags can be used for timing
                                                     synchronisation between state machines, using IRQ and WAIT
                                                     instructions. Any combination of the eight flags can also
                                                     routed out to either of the two system-level interrupt
                                                     requests, alongside FIFO status interrupts -- see e.g.
                                                     IRQ0_INTE.                                                                */
  __IOM uint32_t  IRQ_FORCE;                    /*!< Writing a 1 to each of these bits will forcibly assert the corresponding
                                                     IRQ. Note this is different to the INTF register: writing
                                                     here affects PIO internal state. INTF just asserts the
                                                     processor-facing IRQ signal for testing ISRs, and is not
                                                     visible to the state machines.                                            */
  __IOM uint32_t  INPUT_SYNC_BYPASS;            /*!< There is a 2-flipflop synchronizer on each GPIO input, which
                                                     protects PIO logic from metastabilities. This increases
                                                     input delay, and for fast synchronous IO (e.g. SPI) these
                                                     synchronizers may need to be bypassed. Each bit in this
                                                     register corresponds to one GPIO. 0 -> input is synchronized
                                                     (default) 1 -> synchronizer is bypassed If in doubt, leave
                                                     this register as all zeroes.                                              */
  __IOM uint32_t  DBG_PADOUT;                   /*!< Read to sample the pad output values PIO is currently driving
                                                     to the GPIOs. On RP2040 there are 30 GPIOs, so the two
                                                     most significant bits are hardwired to 0.                                 */
  __IOM uint32_t  DBG_PADOE;                    /*!< Read to sample the pad output enables (direction) PIO is currently
                                                     driving to the GPIOs. On RP2040 there are 30 GPIOs, so
                                                     the two most significant bits are hardwired to 0.                         */
  __IOM uint32_t  DBG_CFGINFO;                  /*!< The PIO hardware has some free parameters that may vary between
                                                     chip products. These should be provided in the chip datasheet,
                                                     but are also exposed here.                                                */
  __IOM uint32_t  INSTR_MEM0;                   /*!< Write-only access to instruction memory location 0                        */
  __IOM uint32_t  INSTR_MEM1;                   /*!< Write-only access to instruction memory location 1                        */
  __IOM uint32_t  INSTR_MEM2;                   /*!< Write-only access to instruction memory location 2                        */
  __IOM uint32_t  INSTR_MEM3;                   /*!< Write-only access to instruction memory location 3                        */
  __IOM uint32_t  INSTR_MEM4;                   /*!< Write-only access to instruction memory location 4                        */
  __IOM uint32_t  INSTR_MEM5;                   /*!< Write-only access to instruction memory location 5                        */
  __IOM uint32_t  INSTR_MEM6;                   /*!< Write-only access to instruction memory location 6                        */
  __IOM uint32_t  INSTR_MEM7;                   /*!< Write-only access to instruction memory location 7                        */
  __IOM uint32_t  INSTR_MEM8;                   /*!< Write-only access to instruction memory location 8                        */
  __IOM uint32_t  INSTR_MEM9;                   /*!< Write-only access to instruction memory location 9                        */
  __IOM uint32_t  INSTR_MEM10;                  /*!< Write-only access to instruction memory location 10                       */
  __IOM uint32_t  INSTR_MEM11;                  /*!< Write-only access to instruction memory location 11                       */
  __IOM uint32_t  INSTR_MEM12;                  /*!< Write-only access to instruction memory location 12                       */
  __IOM uint32_t  INSTR_MEM13;                  /*!< Write-only access to instruction memory location 13                       */
  __IOM uint32_t  INSTR_MEM14;                  /*!< Write-only access to instruction memory location 14                       */
  __IOM uint32_t  INSTR_MEM15;                  /*!< Write-only access to instruction memory location 15                       */
  __IOM uint32_t  INSTR_MEM16;                  /*!< Write-only access to instruction memory location 16                       */
  __IOM uint32_t  INSTR_MEM17;                  /*!< Write-only access to instruction memory location 17                       */
  __IOM uint32_t  INSTR_MEM18;                  /*!< Write-only access to instruction memory location 18                       */
  __IOM uint32_t  INSTR_MEM19;                  /*!< Write-only access to instruction memory location 19                       */
  __IOM uint32_t  INSTR_MEM20;                  /*!< Write-only access to instruction memory location 20                       */
  __IOM uint32_t  INSTR_MEM21;                  /*!< Write-only access to instruction memory location 21                       */
  __IOM uint32_t  INSTR_MEM22;                  /*!< Write-only access to instruction memory location 22                       */
  __IOM uint32_t  INSTR_MEM23;                  /*!< Write-only access to instruction memory location 23                       */
  __IOM uint32_t  INSTR_MEM24;                  /*!< Write-only access to instruction memory location 24                       */
  __IOM uint32_t  INSTR_MEM25;                  /*!< Write-only access to instruction memory location 25                       */
  __IOM uint32_t  INSTR_MEM26;                  /*!< Write-only access to instruction memory location 26                       */
  __IOM uint32_t  INSTR_MEM27;                  /*!< Write-only access to instruction memory location 27                       */
  __IOM uint32_t  INSTR_MEM28;                  /*!< Write-only access to instruction memory location 28                       */
  __IOM uint32_t  INSTR_MEM29;                  /*!< Write-only access to instruction memory location 29                       */
  __IOM uint32_t  INSTR_MEM30;                  /*!< Write-only access to instruction memory location 30                       */
  __IOM uint32_t  INSTR_MEM31;                  /*!< Write-only access to instruction memory location 31                       */
  __IOM uint32_t  SM0_CLKDIV;                   /*!< Clock divisor register for state machine 0 Frequency = clock
                                                     freq / (CLKDIV_INT + CLKDIV_FRAC / 256)                                   */
  __IOM uint32_t  SM0_EXECCTRL;                 /*!< Execution/behavioural settings for state machine 0                        */
  __IOM uint32_t  SM0_SHIFTCTRL;                /*!< Control behaviour of the input/output shift registers for state
                                                     machine 0                                                                 */
  __IOM uint32_t  SM0_ADDR;                     /*!< Current instruction address of state machine 0                            */
  __IOM uint32_t  SM0_INSTR;                    /*!< Read to see the instruction currently addressed by state machine
                                                     0's program counter Write to execute an instruction immediately
                                                     (including jumps) and then resume execution.                              */
  __IOM uint32_t  SM0_PINCTRL;                  /*!< State machine pin control                                                 */
  __IOM uint32_t  SM1_CLKDIV;                   /*!< Clock divisor register for state machine 1 Frequency = clock
                                                     freq / (CLKDIV_INT + CLKDIV_FRAC / 256)                                   */
  __IOM uint32_t  SM1_EXECCTRL;                 /*!< Execution/behavioural settings for state machine 1                        */
  __IOM uint32_t  SM1_SHIFTCTRL;                /*!< Control behaviour of the input/output shift registers for state
                                                     machine 1                                                                 */
  __IOM uint32_t  SM1_ADDR;                     /*!< Current instruction address of state machine 1                            */
  __IOM uint32_t  SM1_INSTR;                    /*!< Read to see the instruction currently addressed by state machine
                                                     1's program counter Write to execute an instruction immediately
                                                     (including jumps) and then resume execution.                              */
  __IOM uint32_t  SM1_PINCTRL;                  /*!< State machine pin control                                                 */
  __IOM uint32_t  SM2_CLKDIV;                   /*!< Clock divisor register for state machine 2 Frequency = clock
                                                     freq / (CLKDIV_INT + CLKDIV_FRAC / 256)                                   */
  __IOM uint32_t  SM2_EXECCTRL;                 /*!< Execution/behavioural settings for state machine 2                        */
  __IOM uint32_t  SM2_SHIFTCTRL;                /*!< Control behaviour of the input/output shift registers for state
                                                     machine 2                                                                 */
  __IOM uint32_t  SM2_ADDR;                     /*!< Current instruction address of state machine 2                            */
  __IOM uint32_t  SM2_INSTR;                    /*!< Read to see the instruction currently addressed by state machine
                                                     2's program counter Write to execute an instruction immediately
                                                     (including jumps) and then resume execution.                              */
  __IOM uint32_t  SM2_PINCTRL;                  /*!< State machine pin control                                                 */
  __IOM uint32_t  SM3_CLKDIV;                   /*!< Clock divisor register for state machine 3 Frequency = clock
                                                     freq / (CLKDIV_INT + CLKDIV_FRAC / 256)                                   */
  __IOM uint32_t  SM3_EXECCTRL;                 /*!< Execution/behavioural settings for state machine 3                        */
  __IOM uint32_t  SM3_SHIFTCTRL;                /*!< Control behaviour of the input/output shift registers for state
                                                     machine 3                                                                 */
  __IOM uint32_t  SM3_ADDR;                     /*!< Current instruction address of state machine 3                            */
  __IOM uint32_t  SM3_INSTR;                    /*!< Read to see the instruction currently addressed by state machine
                                                     3's program counter Write to execute an instruction immediately
                                                     (including jumps) and then resume execution.                              */
  __IOM uint32_t  SM3_PINCTRL;                  /*!< State machine pin control                                                 */
  __IOM uint32_t  RXF0_PUTGET0;                 /*!< Direct read/write access to entry 0 of SM0's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF0_PUTGET1;                 /*!< Direct read/write access to entry 1 of SM0's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF0_PUTGET2;                 /*!< Direct read/write access to entry 2 of SM0's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF0_PUTGET3;                 /*!< Direct read/write access to entry 3 of SM0's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF1_PUTGET0;                 /*!< Direct read/write access to entry 0 of SM1's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF1_PUTGET1;                 /*!< Direct read/write access to entry 1 of SM1's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF1_PUTGET2;                 /*!< Direct read/write access to entry 2 of SM1's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF1_PUTGET3;                 /*!< Direct read/write access to entry 3 of SM1's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF2_PUTGET0;                 /*!< Direct read/write access to entry 0 of SM2's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF2_PUTGET1;                 /*!< Direct read/write access to entry 1 of SM2's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF2_PUTGET2;                 /*!< Direct read/write access to entry 2 of SM2's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF2_PUTGET3;                 /*!< Direct read/write access to entry 3 of SM2's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF3_PUTGET0;                 /*!< Direct read/write access to entry 0 of SM3's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF3_PUTGET1;                 /*!< Direct read/write access to entry 1 of SM3's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF3_PUTGET2;                 /*!< Direct read/write access to entry 2 of SM3's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  RXF3_PUTGET3;                 /*!< Direct read/write access to entry 3 of SM3's RX FIFO, if SHIFTCTRL_FJOIN_RX_PU
                                                     xor SHIFTCTRL_FJOIN_RX_GET is set.                                        */
  __IOM uint32_t  GPIOBASE;                     /*!< Relocate GPIO 0 (from PIO's point of view) in the system GPIO
                                                     numbering, to access more than 32 GPIOs from PIO. Only
                                                     the values 0 and 16 are supported (only bit 4 is writable).               */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  IRQ0_INTE;                    /*!< Interrupt Enable for irq0                                                 */
  __IOM uint32_t  IRQ0_INTF;                    /*!< Interrupt Force for irq0                                                  */
  __IOM uint32_t  IRQ0_INTS;                    /*!< Interrupt status after masking & forcing for irq0                         */
  __IOM uint32_t  IRQ1_INTE;                    /*!< Interrupt Enable for irq1                                                 */
  __IOM uint32_t  IRQ1_INTF;                    /*!< Interrupt Force for irq1                                                  */
  __IOM uint32_t  IRQ1_INTS;                    /*!< Interrupt status after masking & forcing for irq1                         */
} PIO0_Type;                                    /*!< Size = 392 (0x188)                                                        */



/* =========================================================================================================================== */
/* ================                                          BUSCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Register block for busfabric control signals and performance counters (BUSCTRL)
  */

typedef struct {                                /*!< BUSCTRL Structure                                                         */
  __IOM uint32_t  BUS_PRIORITY;                 /*!< Set the priority of each master for bus arbitration.                      */
  __IOM uint32_t  BUS_PRIORITY_ACK;             /*!< Bus priority acknowledge                                                  */
  __IOM uint32_t  PERFCTR_EN;                   /*!< Enable the performance counters. If 0, the performance counters
                                                     do not increment. This can be used to precisely start/stop
                                                     event sampling around the profiled section of code. The
                                                     performance counters are initially disabled, to save energy.              */
  __IOM uint32_t  PERFCTR0;                     /*!< Bus fabric performance counter 0                                          */
  __IOM uint32_t  PERFSEL0;                     /*!< Bus fabric performance event select for PERFCTR0                          */
  __IOM uint32_t  PERFCTR1;                     /*!< Bus fabric performance counter 1                                          */
  __IOM uint32_t  PERFSEL1;                     /*!< Bus fabric performance event select for PERFCTR1                          */
  __IOM uint32_t  PERFCTR2;                     /*!< Bus fabric performance counter 2                                          */
  __IOM uint32_t  PERFSEL2;                     /*!< Bus fabric performance event select for PERFCTR2                          */
  __IOM uint32_t  PERFCTR3;                     /*!< Bus fabric performance counter 3                                          */
  __IOM uint32_t  PERFSEL3;                     /*!< Bus fabric performance event select for PERFCTR3                          */
} BUSCTRL_Type;                                 /*!< Size = 44 (0x2c)                                                          */



/* =========================================================================================================================== */
/* ================                                            SIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Single-cycle IO block 
            Provides core-local and inter-core hardware for the two processors, with single-cycle access. (SIO)
  */

typedef struct {                                /*!< SIO Structure                                                             */
  __IOM uint32_t  CPUID;                        /*!< Processor core identifier                                                 */
  __IOM uint32_t  GPIO_IN;                      /*!< Input value for GPIO0...31. In the Non-secure SIO, Secure-only
                                                     GPIOs (as per ACCESSCTRL) appear as zero.                                 */
  __IOM uint32_t  GPIO_HI_IN;                   /*!< Input value on GPIO32...47, QSPI IOs and USB pins In the Non-secure
                                                     SIO, Secure-only GPIOs (as per ACCESSCTRL) appear as zero.                */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  GPIO_OUT;                     /*!< GPIO0...31 output value                                                   */
  __IOM uint32_t  GPIO_HI_OUT;                  /*!< Output value for GPIO32...47, QSPI IOs and USB pins. Write to
                                                     set output level (1/0 -> high/low). Reading back gives
                                                     the last value written, NOT the input value from the pins.
                                                     If core 0 and core 1 both write to GPIO_HI_OUT simultaneously
                                                     (or to a SET/CLR/XOR alias), the result is as though the
                                                     write from core 0 took place first, and the write from
                                                     core 1 was then applied to that intermediate result. In
                                                     the Non-secure SIO, Secure-only GPIOs (as per ACCESSCTRL)
                                                     ignore writes, and their output status reads back as zero.
                                                     This is also true for SET/CLR/XOR aliases of this register.               */
  __IOM uint32_t  GPIO_OUT_SET;                 /*!< GPIO0...31 output value set                                               */
  __IOM uint32_t  GPIO_HI_OUT_SET;              /*!< Output value set for GPIO32..47, QSPI IOs and USB pins. Perform
                                                     an atomic bit-set on GPIO_HI_OUT, i.e. `GPIO_HI_OUT |=
                                                     wdata`                                                                    */
  __IOM uint32_t  GPIO_OUT_CLR;                 /*!< GPIO0...31 output value clear                                             */
  __IOM uint32_t  GPIO_HI_OUT_CLR;              /*!< Output value clear for GPIO32..47, QSPI IOs and USB pins. Perform
                                                     an atomic bit-clear on GPIO_HI_OUT, i.e. `GPIO_HI_OUT &=
                                                     ~wdata`                                                                   */
  __IOM uint32_t  GPIO_OUT_XOR;                 /*!< GPIO0...31 output value XOR                                               */
  __IOM uint32_t  GPIO_HI_OUT_XOR;              /*!< Output value XOR for GPIO32..47, QSPI IOs and USB pins. Perform
                                                     an atomic bitwise XOR on GPIO_HI_OUT, i.e. `GPIO_HI_OUT
                                                     ^= wdata`                                                                 */
  __IOM uint32_t  GPIO_OE;                      /*!< GPIO0...31 output enable                                                  */
  __IOM uint32_t  GPIO_HI_OE;                   /*!< Output enable value for GPIO32...47, QSPI IOs and USB pins.
                                                     Write output enable (1/0 -> output/input). Reading back
                                                     gives the last value written. If core 0 and core 1 both
                                                     write to GPIO_HI_OE simultaneously (or to a SET/CLR/XOR
                                                     alias), the result is as though the write from core 0 took
                                                     place first, and the write from core 1 was then applied
                                                     to that intermediate result. In the Non-secure SIO, Secure-only
                                                     GPIOs (as per ACCESSCTRL) ignore writes, and their output
                                                     status reads back as zero. This is also true for SET/CLR/XOR
                                                     aliases of this register.                                                 */
  __IOM uint32_t  GPIO_OE_SET;                  /*!< GPIO0...31 output enable set                                              */
  __IOM uint32_t  GPIO_HI_OE_SET;               /*!< Output enable set for GPIO32...47, QSPI IOs and USB pins. Perform
                                                     an atomic bit-set on GPIO_HI_OE, i.e. `GPIO_HI_OE |= wdata`               */
  __IOM uint32_t  GPIO_OE_CLR;                  /*!< GPIO0...31 output enable clear                                            */
  __IOM uint32_t  GPIO_HI_OE_CLR;               /*!< Output enable clear for GPIO32...47, QSPI IOs and USB pins.
                                                     Perform an atomic bit-clear on GPIO_HI_OE, i.e. `GPIO_HI_OE
                                                     &= ~wdata`                                                                */
  __IOM uint32_t  GPIO_OE_XOR;                  /*!< GPIO0...31 output enable XOR                                              */
  __IOM uint32_t  GPIO_HI_OE_XOR;               /*!< Output enable XOR for GPIO32...47, QSPI IOs and USB pins. Perform
                                                     an atomic bitwise XOR on GPIO_HI_OE, i.e. `GPIO_HI_OE ^=
                                                     wdata`                                                                    */
  __IOM uint32_t  FIFO_ST;                      /*!< Status register for inter-core FIFOs (mailboxes). There is one
                                                     FIFO in the core 0 -> core 1 direction, and one core 1
                                                     -> core 0. Both are 32 bits wide and 8 words deep. Core
                                                     0 can see the read side of the 1->0 FIFO (RX), and the
                                                     write side of 0->1 FIFO (TX). Core 1 can see the read side
                                                     of the 0->1 FIFO (RX), and the write side of 1->0 FIFO
                                                     (TX). The SIO IRQ for each core is the logical OR of the
                                                     VLD, WOF and ROE fields of its FIFO_ST register.                          */
  __IOM uint32_t  FIFO_WR;                      /*!< Write access to this core's TX FIFO                                       */
  __IOM uint32_t  FIFO_RD;                      /*!< Read access to this core's RX FIFO                                        */
  __IOM uint32_t  SPINLOCK_ST;                  /*!< Spinlock state A bitmap containing the state of all 32 spinlocks
                                                     (1=locked). Mainly intended for debugging.                                */
  __IM  uint32_t  RESERVED1[8];
  __IOM uint32_t  INTERP0_ACCUM0;               /*!< Read/write access to accumulator 0                                        */
  __IOM uint32_t  INTERP0_ACCUM1;               /*!< Read/write access to accumulator 1                                        */
  __IOM uint32_t  INTERP0_BASE0;                /*!< Read/write access to BASE0 register.                                      */
  __IOM uint32_t  INTERP0_BASE1;                /*!< Read/write access to BASE1 register.                                      */
  __IOM uint32_t  INTERP0_BASE2;                /*!< Read/write access to BASE2 register.                                      */
  __IOM uint32_t  INTERP0_POP_LANE0;            /*!< Read LANE0 result, and simultaneously write lane results to
                                                     both accumulators (POP).                                                  */
  __IOM uint32_t  INTERP0_POP_LANE1;            /*!< Read LANE1 result, and simultaneously write lane results to
                                                     both accumulators (POP).                                                  */
  __IOM uint32_t  INTERP0_POP_FULL;             /*!< Read FULL result, and simultaneously write lane results to both
                                                     accumulators (POP).                                                       */
  __IOM uint32_t  INTERP0_PEEK_LANE0;           /*!< Read LANE0 result, without altering any internal state (PEEK).            */
  __IOM uint32_t  INTERP0_PEEK_LANE1;           /*!< Read LANE1 result, without altering any internal state (PEEK).            */
  __IOM uint32_t  INTERP0_PEEK_FULL;            /*!< Read FULL result, without altering any internal state (PEEK).             */
  __IOM uint32_t  INTERP0_CTRL_LANE0;           /*!< Control register for lane 0                                               */
  __IOM uint32_t  INTERP0_CTRL_LANE1;           /*!< Control register for lane 1                                               */
  __IOM uint32_t  INTERP0_ACCUM0_ADD;           /*!< Values written here are atomically added to ACCUM0 Reading yields
                                                     lane 0's raw shift and mask value (BASE0 not added).                      */
  __IOM uint32_t  INTERP0_ACCUM1_ADD;           /*!< Values written here are atomically added to ACCUM1 Reading yields
                                                     lane 1's raw shift and mask value (BASE1 not added).                      */
  __IOM uint32_t  INTERP0_BASE_1AND0;           /*!< On write, the lower 16 bits go to BASE0, upper bits to BASE1
                                                     simultaneously. Each half is sign-extended to 32 bits if
                                                     that lane's SIGNED flag is set.                                           */
  __IOM uint32_t  INTERP1_ACCUM0;               /*!< Read/write access to accumulator 0                                        */
  __IOM uint32_t  INTERP1_ACCUM1;               /*!< Read/write access to accumulator 1                                        */
  __IOM uint32_t  INTERP1_BASE0;                /*!< Read/write access to BASE0 register.                                      */
  __IOM uint32_t  INTERP1_BASE1;                /*!< Read/write access to BASE1 register.                                      */
  __IOM uint32_t  INTERP1_BASE2;                /*!< Read/write access to BASE2 register.                                      */
  __IOM uint32_t  INTERP1_POP_LANE0;            /*!< Read LANE0 result, and simultaneously write lane results to
                                                     both accumulators (POP).                                                  */
  __IOM uint32_t  INTERP1_POP_LANE1;            /*!< Read LANE1 result, and simultaneously write lane results to
                                                     both accumulators (POP).                                                  */
  __IOM uint32_t  INTERP1_POP_FULL;             /*!< Read FULL result, and simultaneously write lane results to both
                                                     accumulators (POP).                                                       */
  __IOM uint32_t  INTERP1_PEEK_LANE0;           /*!< Read LANE0 result, without altering any internal state (PEEK).            */
  __IOM uint32_t  INTERP1_PEEK_LANE1;           /*!< Read LANE1 result, without altering any internal state (PEEK).            */
  __IOM uint32_t  INTERP1_PEEK_FULL;            /*!< Read FULL result, without altering any internal state (PEEK).             */
  __IOM uint32_t  INTERP1_CTRL_LANE0;           /*!< Control register for lane 0                                               */
  __IOM uint32_t  INTERP1_CTRL_LANE1;           /*!< Control register for lane 1                                               */
  __IOM uint32_t  INTERP1_ACCUM0_ADD;           /*!< Values written here are atomically added to ACCUM0 Reading yields
                                                     lane 0's raw shift and mask value (BASE0 not added).                      */
  __IOM uint32_t  INTERP1_ACCUM1_ADD;           /*!< Values written here are atomically added to ACCUM1 Reading yields
                                                     lane 1's raw shift and mask value (BASE1 not added).                      */
  __IOM uint32_t  INTERP1_BASE_1AND0;           /*!< On write, the lower 16 bits go to BASE0, upper bits to BASE1
                                                     simultaneously. Each half is sign-extended to 32 bits if
                                                     that lane's SIGNED flag is set.                                           */
  __IOM uint32_t  SPINLOCK0;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK1;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK2;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK3;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK4;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK5;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK6;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK7;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK8;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK9;                    /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK10;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK11;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK12;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK13;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK14;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK15;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK16;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK17;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK18;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK19;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK20;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK21;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK22;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK23;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK24;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK25;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK26;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK27;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK28;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK29;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK30;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  SPINLOCK31;                   /*!< Reading from a spinlock address will: - Return 0 if lock is
                                                     already locked - Otherwise return nonzero, and simultaneously
                                                     claim the lock Writing (any value) releases the lock. If
                                                     core 0 and core 1 attempt to claim the same lock simultaneously,
                                                     core 0 wins. The value returned on success is 0x1 << lock
                                                     number.                                                                   */
  __IOM uint32_t  DOORBELL_OUT_SET;             /*!< Trigger a doorbell interrupt on the opposite core. Write 1 to
                                                     a bit to set the corresponding bit in DOORBELL_IN on the
                                                     opposite core. This raises the opposite core's doorbell
                                                     interrupt. Read to get the status of the doorbells currently
                                                     asserted on the opposite core. This is equivalent to that
                                                     core reading its own DOORBELL_IN status.                                  */
  __IOM uint32_t  DOORBELL_OUT_CLR;             /*!< Clear doorbells which have been posted to the opposite core.
                                                     This register is intended for debugging and initialisation
                                                     purposes. Writing 1 to a bit in DOORBELL_OUT_CLR clears
                                                     the corresponding bit in DOORBELL_IN on the opposite core.
                                                     Clearing all bits will cause that core's doorbell interrupt
                                                     to deassert. Since the usual order of events is for software
                                                     to send events using DOORBELL_OUT_SET, and acknowledge
                                                     incoming events by writing to DOORBELL_IN_CLR, this register
                                                     should be used with caution to avoid race conditions. Reading
                                                     returns the status of the doorbells currently asserted
                                                     on the other core, i.e. is equivalent to that core reading
                                                     its own DOORBELL_IN status.                                               */
  __IOM uint32_t  DOORBELL_IN_SET;              /*!< Write 1s to trigger doorbell interrupts on this core. Read to
                                                     get status of doorbells currently asserted on this core.                  */
  __IOM uint32_t  DOORBELL_IN_CLR;              /*!< Check and acknowledge doorbells posted to this core. This core's
                                                     doorbell interrupt is asserted when any bit in this register
                                                     is 1. Write 1 to each bit to clear that bit. The doorbell
                                                     interrupt deasserts once all bits are cleared. Read to
                                                     get status of doorbells currently asserted on this core.                  */
  __IOM uint32_t  PERI_NONSEC;                  /*!< Detach certain core-local peripherals from Secure SIO, and attach
                                                     them to Non-secure SIO, so that Non-secure software can
                                                     use them. Attempting to access one of these peripherals
                                                     from the Secure SIO when it is attached to the Non-secure
                                                     SIO, or vice versa, will generate a bus error. This register
                                                     is per-core, and is only present on the Secure SIO. Most
                                                     SIO hardware is duplicated across the Secure and Non-secure
                                                     SIO, so is not listed in this register.                                   */
  __IM  uint32_t  RESERVED2[3];
  __IOM uint32_t  RISCV_SOFTIRQ;                /*!< Control the assertion of the standard software interrupt (MIP.MSIP)
                                                     on the RISC-V cores. Unlike the RISC-V timer, this interrupt
                                                     is not routed to a normal system-level interrupt line,
                                                     so can not be used by the Arm cores. It is safe for both
                                                     cores to write to this register on the same cycle. The
                                                     set/clear effect is accumulated across both cores, and
                                                     then applied. If a flag is both set and cleared on the
                                                     same cycle, only the set takes effect.                                    */
  __IOM uint32_t  MTIME_CTRL;                   /*!< Control register for the RISC-V 64-bit Machine-mode timer. This
                                                     timer is only present in the Secure SIO, so is only accessible
                                                     to an Arm core in Secure mode or a RISC-V core in Machine
                                                     mode. Note whilst this timer follows the RISC-V privileged
                                                     specification, it is equally usable by the Arm cores. The
                                                     interrupts are routed to normal system-level interrupt
                                                     lines as well as to the MIP.MTIP inputs on the RISC-V cores.              */
  __IM  uint32_t  RESERVED3[2];
  __IOM uint32_t  MTIME;                        /*!< Read/write access to the high half of RISC-V Machine-mode timer.
                                                     This register is shared between both cores. If both cores
                                                     write on the same cycle, core 1 takes precedence.                         */
  __IOM uint32_t  MTIMEH;                       /*!< Read/write access to the high half of RISC-V Machine-mode timer.
                                                     This register is shared between both cores. If both cores
                                                     write on the same cycle, core 1 takes precedence.                         */
  __IOM uint32_t  MTIMECMP;                     /*!< Low half of RISC-V Machine-mode timer comparator. This register
                                                     is core-local, i.e., each core gets a copy of this register,
                                                     with the comparison result routed to its own interrupt
                                                     line. The timer interrupt is asserted whenever MTIME is
                                                     greater than or equal to MTIMECMP. This comparison is unsigned,
                                                     and performed on the full 64-bit values.                                  */
  __IOM uint32_t  MTIMECMPH;                    /*!< High half of RISC-V Machine-mode timer comparator. This register
                                                     is core-local. The timer interrupt is asserted whenever
                                                     MTIME is greater than or equal to MTIMECMP. This comparison
                                                     is unsigned, and performed on the full 64-bit values.                     */
  __IOM uint32_t  TMDS_CTRL;                    /*!< Control register for TMDS encoder.                                        */
  __IOM uint32_t  TMDS_WDATA;                   /*!< Write-only access to the TMDS colour data register.                       */
  __IOM uint32_t  TMDS_PEEK_SINGLE;             /*!< Get the encoding of one pixel's worth of colour data, packed
                                                     into a 32-bit value (3x10-bit symbols). The PEEK alias
                                                     does not shift the colour register when read, but still
                                                     advances the running DC balance state of each encoder.
                                                     This is useful for pixel doubling.                                        */
  __IOM uint32_t  TMDS_POP_SINGLE;              /*!< Get the encoding of one pixel's worth of colour data, packed
                                                     into a 32-bit value. The packing is 5 chunks of 3 lanes
                                                     times 2 bits (30 bits total). Each chunk contains two bits
                                                     of a TMDS symbol per lane. This format is intended for
                                                     shifting out with the HSTX peripheral on RP2350. The POP
                                                     alias shifts the colour register when read, as well as
                                                     advancing the running DC balance state of each encoder.                   */
  __IOM uint32_t  TMDS_PEEK_DOUBLE_L0;          /*!< Get lane 0 of the encoding of two pixels' worth of colour data.
                                                     Two 10-bit TMDS symbols are packed at the bottom of a 32-bit
                                                     word. The PEEK alias does not shift the colour register
                                                     when read, but still advances the lane 0 DC balance state.
                                                     This is useful if all 3 lanes' worth of encode are to be
                                                     read at once, rather than processing the entire scanline
                                                     for one lane before moving to the next lane.                              */
  __IOM uint32_t  TMDS_POP_DOUBLE_L0;           /*!< Get lane 0 of the encoding of two pixels' worth of colour data.
                                                     Two 10-bit TMDS symbols are packed at the bottom of a 32-bit
                                                     word. The POP alias shifts the colour register when read,
                                                     according to the values of PIX_SHIFT and PIX2_NOSHIFT.                    */
  __IOM uint32_t  TMDS_PEEK_DOUBLE_L1;          /*!< Get lane 1 of the encoding of two pixels' worth of colour data.
                                                     Two 10-bit TMDS symbols are packed at the bottom of a 32-bit
                                                     word. The PEEK alias does not shift the colour register
                                                     when read, but still advances the lane 1 DC balance state.
                                                     This is useful if all 3 lanes' worth of encode are to be
                                                     read at once, rather than processing the entire scanline
                                                     for one lane before moving to the next lane.                              */
  __IOM uint32_t  TMDS_POP_DOUBLE_L1;           /*!< Get lane 1 of the encoding of two pixels' worth of colour data.
                                                     Two 10-bit TMDS symbols are packed at the bottom of a 32-bit
                                                     word. The POP alias shifts the colour register when read,
                                                     according to the values of PIX_SHIFT and PIX2_NOSHIFT.                    */
  __IOM uint32_t  TMDS_PEEK_DOUBLE_L2;          /*!< Get lane 2 of the encoding of two pixels' worth of colour data.
                                                     Two 10-bit TMDS symbols are packed at the bottom of a 32-bit
                                                     word. The PEEK alias does not shift the colour register
                                                     when read, but still advances the lane 2 DC balance state.
                                                     This is useful if all 3 lanes' worth of encode are to be
                                                     read at once, rather than processing the entire scanline
                                                     for one lane before moving to the next lane.                              */
  __IOM uint32_t  TMDS_POP_DOUBLE_L2;           /*!< Get lane 2 of the encoding of two pixels' worth of colour data.
                                                     Two 10-bit TMDS symbols are packed at the bottom of a 32-bit
                                                     word. The POP alias shifts the colour register when read,
                                                     according to the values of PIX_SHIFT and PIX2_NOSHIFT.                    */
} SIO_Type;                                     /*!< Size = 488 (0x1e8)                                                        */



/* =========================================================================================================================== */
/* ================                                          BOOTRAM                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Additional registers mapped adjacent to the bootram, for use by the bootrom. (BOOTRAM)
  */

typedef struct {                                /*!< BOOTRAM Structure                                                         */
  __IM  uint32_t  RESERVED[512];
  __IOM uint32_t  WRITE_ONCE0;                  /*!< This registers always ORs writes into its current contents.
                                                     Once a bit is set, it can only be cleared by a reset.                     */
  __IOM uint32_t  WRITE_ONCE1;                  /*!< This registers always ORs writes into its current contents.
                                                     Once a bit is set, it can only be cleared by a reset.                     */
  __IOM uint32_t  BOOTLOCK_STAT;                /*!< Bootlock status register. 1=unclaimed, 0=claimed. These locks
                                                     function identically to the SIO spinlocks, but are reserved
                                                     for bootrom use.                                                          */
  __IOM uint32_t  BOOTLOCK0;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK1;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK2;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK3;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK4;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK5;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK6;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
  __IOM uint32_t  BOOTLOCK7;                    /*!< Read to claim and check. Write to unclaim. The value returned
                                                     on successful claim is 1 << n, and on failed claim is zero.               */
} BOOTRAM_Type;                                 /*!< Size = 2092 (0x82c)                                                       */



/* =========================================================================================================================== */
/* ================                                      CORESIGHT_TRACE                                      ================ */
/* =========================================================================================================================== */


/**
  * @brief Coresight block - RP specific registers (CORESIGHT_TRACE)
  */

typedef struct {                                /*!< CORESIGHT_TRACE Structure                                                 */
  __IOM uint32_t  CTRL_STATUS;                  /*!< Control and status register                                               */
  __IOM uint32_t  TRACE_CAPTURE_FIFO;           /*!< FIFO for trace data captured from the TPIU                                */
} CORESIGHT_TRACE_Type;                         /*!< Size = 8 (0x8)                                                            */



/* =========================================================================================================================== */
/* ================                                            USB                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief USB FS/LS controller device registers (USB)
  */

typedef struct {                                /*!< USB Structure                                                             */
  __IOM uint32_t  ADDR_ENDP;                    /*!< Device address and endpoint control                                       */
  __IOM uint32_t  ADDR_ENDP1;                   /*!< Interrupt endpoint 1. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP2;                   /*!< Interrupt endpoint 2. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP3;                   /*!< Interrupt endpoint 3. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP4;                   /*!< Interrupt endpoint 4. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP5;                   /*!< Interrupt endpoint 5. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP6;                   /*!< Interrupt endpoint 6. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP7;                   /*!< Interrupt endpoint 7. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP8;                   /*!< Interrupt endpoint 8. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP9;                   /*!< Interrupt endpoint 9. Only valid for HOST mode.                           */
  __IOM uint32_t  ADDR_ENDP10;                  /*!< Interrupt endpoint 10. Only valid for HOST mode.                          */
  __IOM uint32_t  ADDR_ENDP11;                  /*!< Interrupt endpoint 11. Only valid for HOST mode.                          */
  __IOM uint32_t  ADDR_ENDP12;                  /*!< Interrupt endpoint 12. Only valid for HOST mode.                          */
  __IOM uint32_t  ADDR_ENDP13;                  /*!< Interrupt endpoint 13. Only valid for HOST mode.                          */
  __IOM uint32_t  ADDR_ENDP14;                  /*!< Interrupt endpoint 14. Only valid for HOST mode.                          */
  __IOM uint32_t  ADDR_ENDP15;                  /*!< Interrupt endpoint 15. Only valid for HOST mode.                          */
  __IOM uint32_t  MAIN_CTRL;                    /*!< Main control register                                                     */
  __IOM uint32_t  SOF_WR;                       /*!< Set the SOF (Start of Frame) frame number in the host controller.
                                                     The SOF packet is sent every 1ms and the host will increment
                                                     the frame number by 1 each time.                                          */
  __IOM uint32_t  SOF_RD;                       /*!< Read the last SOF (Start of Frame) frame number seen. In device
                                                     mode the last SOF received from the host. In host mode
                                                     the last SOF sent by the host.                                            */
  __IOM uint32_t  SIE_CTRL;                     /*!< SIE control register                                                      */
  __IOM uint32_t  SIE_STATUS;                   /*!< SIE status register                                                       */
  __IOM uint32_t  INT_EP_CTRL;                  /*!< interrupt endpoint control register                                       */
  __IOM uint32_t  BUFF_STATUS;                  /*!< Buffer status register. A bit set here indicates that a buffer
                                                     has completed on the endpoint (if the buffer interrupt
                                                     is enabled). It is possible for 2 buffers to be completed,
                                                     so clearing the buffer status bit may instantly re set
                                                     it on the next clock cycle.                                               */
  __IOM uint32_t  BUFF_CPU_SHOULD_HANDLE;       /*!< Which of the double buffers should be handled. Only valid if
                                                     using an interrupt per buffer (i.e. not per 2 buffers).
                                                     Not valid for host interrupt endpoint polling because they
                                                     are only single buffered.                                                 */
  __IOM uint32_t  EP_ABORT;                     /*!< Device only: Can be set to ignore the buffer control register
                                                     for this endpoint in case you would like to revoke a buffer.
                                                     A NAK will be sent for every access to the endpoint until
                                                     this bit is cleared. A corresponding bit in `EP_ABORT_DONE`
                                                     is set when it is safe to modify the buffer control register.             */
  __IOM uint32_t  EP_ABORT_DONE;                /*!< Device only: Used in conjunction with `EP_ABORT`. Set once an
                                                     endpoint is idle so the programmer knows it is safe to
                                                     modify the buffer control register.                                       */
  __IOM uint32_t  EP_STALL_ARM;                 /*!< Device: this bit must be set in conjunction with the `STALL`
                                                     bit in the buffer control register to send a STALL on EP0.
                                                     The device controller clears these bits when a SETUP packet
                                                     is received because the USB spec requires that a STALL
                                                     condition is cleared when a SETUP packet is received.                     */
  __IOM uint32_t  NAK_POLL;                     /*!< Used by the host controller. Sets the wait time in microseconds
                                                     before trying again if the device replies with a NAK.                     */
  __IOM uint32_t  EP_STATUS_STALL_NAK;          /*!< Device: bits are set when the `IRQ_ON_NAK` or `IRQ_ON_STALL`
                                                     bits are set. For EP0 this comes from `SIE_CTRL`. For all
                                                     other endpoints it comes from the endpoint control register.              */
  __IOM uint32_t  USB_MUXING;                   /*!< Where to connect the USB controller. Should be to_phy by default.         */
  __IOM uint32_t  USB_PWR;                      /*!< Overrides for the power signals in the event that the VBUS signals
                                                     are not hooked up to GPIO. Set the value of the override
                                                     and then the override enable to switch over to the override
                                                     value.                                                                    */
  __IOM uint32_t  USBPHY_DIRECT;                /*!< This register allows for direct control of the USB phy. Use
                                                     in conjunction with usbphy_direct_override register to
                                                     enable each override bit.                                                 */
  __IOM uint32_t  USBPHY_DIRECT_OVERRIDE;       /*!< Override enable for each control in usbphy_direct                         */
  __IOM uint32_t  USBPHY_TRIM;                  /*!< Used to adjust trim values of USB phy pull down resistors.                */
  __IOM uint32_t  LINESTATE_TUNING;             /*!< Used for debug only.                                                      */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
  __IM  uint32_t  RESERVED[25];
  __IOM uint32_t  SOF_TIMESTAMP_RAW;            /*!< Device only. Raw value of free-running PHY clock counter @48MHz.
                                                     Used to calculate time between SOF events.                                */
  __IOM uint32_t  SOF_TIMESTAMP_LAST;           /*!< Device only. Value of free-running PHY clock counter @48MHz
                                                     when last SOF event occurred.                                             */
  __IOM uint32_t  SM_STATE;                     /*!< SM_STATE                                                                  */
  __IOM uint32_t  EP_TX_ERROR;                  /*!< TX error count for each endpoint. Write to each field to reset
                                                     the counter to 0.                                                         */
  __IOM uint32_t  EP_RX_ERROR;                  /*!< RX error count for each endpoint. Write to each field to reset
                                                     the counter to 0.                                                         */
  __IOM uint32_t  DEV_SM_WATCHDOG;              /*!< Watchdog that forces the device state machine to idle and raises
                                                     an interrupt if the device stays in a state that isn't
                                                     idle for the configured limit. The counter is reset on
                                                     every state transition. Set limit while enable is low and
                                                     then set the enable.                                                      */
} USB_Type;                                     /*!< Size = 280 (0x118)                                                        */



/* =========================================================================================================================== */
/* ================                                           TRNG                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief ARM TrustZone RNG register block (TRNG)
  */

typedef struct {                                /*!< TRNG Structure                                                            */
  __IM  uint32_t  RESERVED[64];
  __IOM uint32_t  RNG_IMR;                      /*!< Interrupt masking.                                                        */
  __IOM uint32_t  RNG_ISR;                      /*!< RNG status register. If corresponding RNG_IMR bit is unmasked,
                                                     an interrupt will be generated.                                           */
  __IOM uint32_t  RNG_ICR;                      /*!< Interrupt/status bit clear Register.                                      */
  __IOM uint32_t  TRNG_CONFIG;                  /*!< Selecting the inverter-chain length.                                      */
  __IOM uint32_t  TRNG_VALID;                   /*!< 192 bit collection indication.                                            */
  __IOM uint32_t  EHR_DATA0;                    /*!< RNG collected bits.                                                       */
  __IOM uint32_t  EHR_DATA1;                    /*!< RNG collected bits.                                                       */
  __IOM uint32_t  EHR_DATA2;                    /*!< RNG collected bits.                                                       */
  __IOM uint32_t  EHR_DATA3;                    /*!< RNG collected bits.                                                       */
  __IOM uint32_t  EHR_DATA4;                    /*!< RNG collected bits.                                                       */
  __IOM uint32_t  EHR_DATA5;                    /*!< RNG collected bits.                                                       */
  __IOM uint32_t  RND_SOURCE_ENABLE;            /*!< Enable signal for the random source.                                      */
  __IOM uint32_t  SAMPLE_CNT1;                  /*!< Counts clocks between sampling of random bit.                             */
  __IOM uint32_t  AUTOCORR_STATISTIC;           /*!< Statistic about Autocorrelation test activations.                         */
  __IOM uint32_t  TRNG_DEBUG_CONTROL;           /*!< Debug register.                                                           */
  __IM  uint32_t  RESERVED1;
  __IOM uint32_t  TRNG_SW_RESET;                /*!< Generate internal SW reset within the RNG block.                          */
  __IM  uint32_t  RESERVED2[28];
  __IOM uint32_t  RNG_DEBUG_EN_INPUT;           /*!< Enable the RNG debug mode                                                 */
  __IOM uint32_t  TRNG_BUSY;                    /*!< RNG Busy indication.                                                      */
  __IOM uint32_t  RST_BITS_COUNTER;             /*!< Reset the counter of collected bits in the RNG.                           */
  __IOM uint32_t  RNG_VERSION;                  /*!< Displays the version settings of the TRNG.                                */
  __IM  uint32_t  RESERVED3[7];
  __IOM uint32_t  RNG_BIST_CNTR_0;              /*!< Collected BIST results.                                                   */
  __IOM uint32_t  RNG_BIST_CNTR_1;              /*!< Collected BIST results.                                                   */
  __IOM uint32_t  RNG_BIST_CNTR_2;              /*!< Collected BIST results.                                                   */
} TRNG_Type;                                    /*!< Size = 492 (0x1ec)                                                        */



/* =========================================================================================================================== */
/* ================                                      GLITCH_DETECTOR                                      ================ */
/* =========================================================================================================================== */


/**
  * @brief Glitch detector controls (GLITCH_DETECTOR)
  */

typedef struct {                                /*!< GLITCH_DETECTOR Structure                                                 */
  __IOM uint32_t  ARM;                          /*!< Forcibly arm the glitch detectors, if they are not already armed
                                                     by OTP. When armed, any individual detector trigger will
                                                     cause a restart of the switched core power domain's power-on
                                                     reset state machine. Glitch detector triggers are recorded
                                                     accumulatively in TRIG_STATUS. If the system is reset by
                                                     a glitch detector trigger, this is recorded in POWMAN_CHIP_RESET.
                                                     This register is Secure read/write only.                                  */
  __IOM uint32_t  DISARM;                       /*!< DISARM                                                                    */
  __IOM uint32_t  SENSITIVITY;                  /*!< Adjust the sensitivity of glitch detectors to values other than
                                                     their OTP-provided defaults. This register is Secure read/write
                                                     only.                                                                     */
  __IOM uint32_t  LOCK;                         /*!< LOCK                                                                      */
  __IOM uint32_t  TRIG_STATUS;                  /*!< Set when a detector output triggers. Write-1-clear. (May immediately
                                                     return high if the detector remains in a failed state.
                                                     Detectors can only be cleared by a full reset of the switched
                                                     core power domain.) This register is Secure read/write
                                                     only.                                                                     */
  __IOM uint32_t  TRIG_FORCE;                   /*!< Simulate the firing of one or more detectors. Writing ones to
                                                     this register will set the matching bits in STATUS_TRIG.
                                                     If the glitch detectors are currently armed, writing ones
                                                     will also immediately reset the switched core power domain,
                                                     and set the reset reason latches in POWMAN_CHIP_RESET to
                                                     indicate a glitch detector resets. This register is Secure
                                                     read/write only.                                                          */
} GLITCH_DETECTOR_Type;                         /*!< Size = 24 (0x18)                                                          */



/* =========================================================================================================================== */
/* ================                                            OTP                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief SNPS OTP control IF (SBPI and RPi wrapper control) (OTP)
  */

typedef struct {                                /*!< OTP Structure                                                             */
  __IOM uint32_t  SW_LOCK0;                     /*!< Software lock register for page 0. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK1;                     /*!< Software lock register for page 1. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK2;                     /*!< Software lock register for page 2. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK3;                     /*!< Software lock register for page 3. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK4;                     /*!< Software lock register for page 4. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK5;                     /*!< Software lock register for page 5. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK6;                     /*!< Software lock register for page 6. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK7;                     /*!< Software lock register for page 7. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK8;                     /*!< Software lock register for page 8. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK9;                     /*!< Software lock register for page 9. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK10;                    /*!< Software lock register for page 10. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK11;                    /*!< Software lock register for page 11. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK12;                    /*!< Software lock register for page 12. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK13;                    /*!< Software lock register for page 13. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK14;                    /*!< Software lock register for page 14. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK15;                    /*!< Software lock register for page 15. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK16;                    /*!< Software lock register for page 16. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK17;                    /*!< Software lock register for page 17. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK18;                    /*!< Software lock register for page 18. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK19;                    /*!< Software lock register for page 19. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK20;                    /*!< Software lock register for page 20. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK21;                    /*!< Software lock register for page 21. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK22;                    /*!< Software lock register for page 22. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK23;                    /*!< Software lock register for page 23. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK24;                    /*!< Software lock register for page 24. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK25;                    /*!< Software lock register for page 25. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK26;                    /*!< Software lock register for page 26. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK27;                    /*!< Software lock register for page 27. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK28;                    /*!< Software lock register for page 28. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK29;                    /*!< Software lock register for page 29. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK30;                    /*!< Software lock register for page 30. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK31;                    /*!< Software lock register for page 31. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK32;                    /*!< Software lock register for page 32. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK33;                    /*!< Software lock register for page 33. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK34;                    /*!< Software lock register for page 34. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK35;                    /*!< Software lock register for page 35. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK36;                    /*!< Software lock register for page 36. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK37;                    /*!< Software lock register for page 37. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK38;                    /*!< Software lock register for page 38. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK39;                    /*!< Software lock register for page 39. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK40;                    /*!< Software lock register for page 40. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK41;                    /*!< Software lock register for page 41. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK42;                    /*!< Software lock register for page 42. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK43;                    /*!< Software lock register for page 43. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK44;                    /*!< Software lock register for page 44. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK45;                    /*!< Software lock register for page 45. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK46;                    /*!< Software lock register for page 46. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK47;                    /*!< Software lock register for page 47. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK48;                    /*!< Software lock register for page 48. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK49;                    /*!< Software lock register for page 49. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK50;                    /*!< Software lock register for page 50. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK51;                    /*!< Software lock register for page 51. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK52;                    /*!< Software lock register for page 52. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK53;                    /*!< Software lock register for page 53. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK54;                    /*!< Software lock register for page 54. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK55;                    /*!< Software lock register for page 55. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK56;                    /*!< Software lock register for page 56. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK57;                    /*!< Software lock register for page 57. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK58;                    /*!< Software lock register for page 58. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK59;                    /*!< Software lock register for page 59. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK60;                    /*!< Software lock register for page 60. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK61;                    /*!< Software lock register for page 61. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK62;                    /*!< Software lock register for page 62. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SW_LOCK63;                    /*!< Software lock register for page 63. Locks are initialised from
                                                     the OTP lock pages at reset. This register can be written
                                                     to further advance the lock state of each page (until next
                                                     reset), and read to check the current lock state of a page.               */
  __IOM uint32_t  SBPI_INSTR;                   /*!< Dispatch instructions to the SBPI interface, used for programming
                                                     the OTP fuses.                                                            */
  __IOM uint32_t  SBPI_WDATA_0;                 /*!< SBPI write payload bytes 3..0                                             */
  __IOM uint32_t  SBPI_WDATA_1;                 /*!< SBPI write payload bytes 7..4                                             */
  __IOM uint32_t  SBPI_WDATA_2;                 /*!< SBPI write payload bytes 11..8                                            */
  __IOM uint32_t  SBPI_WDATA_3;                 /*!< SBPI write payload bytes 15..12                                           */
  __IOM uint32_t  SBPI_RDATA_0;                 /*!< Read payload bytes 3..0. Once read, the data in the register
                                                     will automatically clear to 0.                                            */
  __IOM uint32_t  SBPI_RDATA_1;                 /*!< Read payload bytes 7..4. Once read, the data in the register
                                                     will automatically clear to 0.                                            */
  __IOM uint32_t  SBPI_RDATA_2;                 /*!< Read payload bytes 11..8. Once read, the data in the register
                                                     will automatically clear to 0.                                            */
  __IOM uint32_t  SBPI_RDATA_3;                 /*!< Read payload bytes 15..12. Once read, the data in the register
                                                     will automatically clear to 0.                                            */
  __IOM uint32_t  SBPI_STATUS;                  /*!< SBPI_STATUS                                                               */
  __IOM uint32_t  USR;                          /*!< Controls for APB data read interface (USER interface)                     */
  __IOM uint32_t  DBG;                          /*!< Debug for OTP power-on state machine                                      */
  __IM  uint32_t  RESERVED;
  __IOM uint32_t  BIST;                         /*!< During BIST, count address locations that have at least one
                                                     leaky bit                                                                 */
  __IOM uint32_t  CRT_KEY_W0;                   /*!< Word 0 (bits 31..0) of the key. Write only, read returns 0x0              */
  __IOM uint32_t  CRT_KEY_W1;                   /*!< Word 1 (bits 63..32) of the key. Write only, read returns 0x0             */
  __IOM uint32_t  CRT_KEY_W2;                   /*!< Word 2 (bits 95..64) of the key. Write only, read returns 0x0             */
  __IOM uint32_t  CRT_KEY_W3;                   /*!< Word 3 (bits 127..96) of the key. Write only, read returns 0x0            */
  __IOM uint32_t  CRITICAL;                     /*!< Quickly check values of critical flags read during boot up                */
  __IOM uint32_t  KEY_VALID;                    /*!< Which keys were valid (enrolled) at boot time                             */
  __IOM uint32_t  DEBUGEN;                      /*!< Enable a debug feature that has been disabled. Debug features
                                                     are disabled if one of the relevant critical boot flags
                                                     is set in OTP (DEBUG_DISABLE or SECURE_DEBUG_DISABLE),
                                                     OR if a debug key is marked valid in OTP, and the matching
                                                     key value has not been supplied over SWD. Specifically:
                                                     - The DEBUG_DISABLE flag disables all debug features. This
                                                     can be fully overridden by setting all bits of this register.
                                                     - The SECURE_DEBUG_DISABLE flag disables secure processor
                                                     debug. This can be fully overridden by setting the PROC0_SECURE
                                                     and PROC1_SECURE bits of this register. - If a single debug
                                                     key has been registered, and no matching key value has
                                                     been supplied over SWD, then all debug features are disabled.
                                                     This can be fully overridden by setting all bits of this
                                                     register. - If both debug keys have been registered, and
                                                     the Non-secure key's value (key 6) has been supplied over
                                                     SWD, secure processor debug is disabled. This can be fully
                                                     overridden by setting the PROC0_SECURE and PROC1_SECURE
                                                     bits of this register. - If both debug keys have been registered,
                                                     and the Secure key's value (key 5) has been supplied over
                                                     SWD, then no debug features are disabled by the key mechanism.
                                                     However, note that in this case debug features may still
                                                     be disabled by the critical boot flags.                                   */
  __IOM uint32_t  DEBUGEN_LOCK;                 /*!< Write 1s to lock corresponding bits in DEBUGEN. This register
                                                     is reset by the processor cold reset.                                     */
  __IOM uint32_t  ARCHSEL;                      /*!< Architecture select (Arm/RISC-V). The default and allowable
                                                     values of this register are constrained by the critical
                                                     boot flags. This register is reset by the earliest reset
                                                     in the switched core power domain (before a processor cold
                                                     reset). Cores sample their architecture select signal on
                                                     a warm reset. The source of the warm reset could be the
                                                     system power-up state machine, the watchdog timer, Arm
                                                     SYSRESETREQ or from RISC-V hartresetreq. Note that when
                                                     an Arm core is deselected, its cold reset domain is also
                                                     held in reset, since in particular the SYSRESETREQ bit
                                                     becomes inaccessible once the core is deselected. Note
                                                     also the RISC-V cores do not have a cold reset domain,
                                                     since their corresponding controls are located in the Debug
                                                     Module.                                                                   */
  __IOM uint32_t  ARCHSEL_STATUS;               /*!< Get the current architecture select state of each core. Cores
                                                     sample the current value of the ARCHSEL register when their
                                                     warm reset is released, at which point the corresponding
                                                     bit in this register will also update.                                    */
  __IOM uint32_t  BOOTDIS;                      /*!< Tell the bootrom to ignore scratch register boot vectors (both
                                                     power manager and watchdog) on the next power up. If an
                                                     early boot stage has soft-locked some OTP pages in order
                                                     to protect their contents from later stages, there is a
                                                     risk that Secure code running at a later stage can unlock
                                                     the pages by performing a watchdog reset that resets the
                                                     OTP. This register can be used to ensure that the bootloader
                                                     runs as normal on the next power up, preventing Secure
                                                     code at a later stage from accessing OTP in its unlocked
                                                     state. Should be used in conjunction with the power manager
                                                     BOOTDIS register.                                                         */
  __IOM uint32_t  INTR;                         /*!< Raw Interrupts                                                            */
  __IOM uint32_t  INTE;                         /*!< Interrupt Enable                                                          */
  __IOM uint32_t  INTF;                         /*!< Interrupt Force                                                           */
  __IOM uint32_t  INTS;                         /*!< Interrupt status after masking & forcing                                  */
} OTP_Type;                                     /*!< Size = 372 (0x174)                                                        */



/* =========================================================================================================================== */
/* ================                                         OTP_DATA                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Predefined OTP data layout for RP2350 (OTP_DATA)
  */

typedef struct {                                /*!< OTP_DATA Structure                                                        */
  __IOM uint16_t  CHIPID0;                      /*!< Bits 15:0 of public device ID. (ECC) The CHIPID0..3 rows contain
                                                     a 64-bit random identifier for this chip, which can be
                                                     read from the USB bootloader PICOBOOT interface or from
                                                     the get_sys_info ROM API. The number of random bits makes
                                                     the occurrence of twins exceedingly unlikely: for example,
                                                     a fleet of a hundred million devices has a 99.97% probability
                                                     of no twinned IDs. This is estimated to be lower than the
                                                     occurrence of process errors in the assignment of sequential
                                                     random IDs, and for practical purposes CHIPID may be treated
                                                     as unique.                                                                */
  __IOM uint16_t  CHIPID1;                      /*!< Bits 31:16 of public device ID (ECC)                                      */
  __IOM uint16_t  CHIPID2;                      /*!< Bits 47:32 of public device ID (ECC)                                      */
  __IOM uint16_t  CHIPID3;                      /*!< Bits 63:48 of public device ID (ECC)                                      */
  __IOM uint16_t  RANDID0;                      /*!< Bits 15:0 of private per-device random number (ECC) The RANDID0..7
                                                     rows form a 128-bit random number generated during device
                                                     test. This ID is not exposed through the USB PICOBOOT GET_INFO
                                                     command or the ROM `get_sys_info()` API. However note that
                                                     the USB PICOBOOT OTP access point can read the entirety
                                                     of page 0, so this value is not meaningfully private unless
                                                     the USB PICOBOOT interface is disabled via the DISABLE_BOOTSEL_USB_PICOBO
                                                     T_IFC flag in BOOT_FLAGS0.                                                */
  __IOM uint16_t  RANDID1;                      /*!< Bits 31:16 of private per-device random number (ECC)                      */
  __IOM uint16_t  RANDID2;                      /*!< Bits 47:32 of private per-device random number (ECC)                      */
  __IOM uint16_t  RANDID3;                      /*!< Bits 63:48 of private per-device random number (ECC)                      */
  __IOM uint16_t  RANDID4;                      /*!< Bits 79:64 of private per-device random number (ECC)                      */
  __IOM uint16_t  RANDID5;                      /*!< Bits 95:80 of private per-device random number (ECC)                      */
  __IOM uint16_t  RANDID6;                      /*!< Bits 111:96 of private per-device random number (ECC)                     */
  __IOM uint16_t  RANDID7;                      /*!< Bits 127:112 of private per-device random number (ECC)                    */
  __IM  uint16_t  RESERVED[4];
  __IOM uint16_t  ROSC_CALIB;                   /*!< Ring oscillator frequency in kHz, measured during manufacturing
                                                     (ECC) This is measured at 1.1 V, at room temperature, with
                                                     the ROSC configuration registers in their reset state.                    */
  __IOM uint16_t  LPOSC_CALIB;                  /*!< Low-power oscillator frequency in Hz, measured during manufacturing
                                                     (ECC) This is measured at 1.1V, at room temperature, with
                                                     the LPOSC trim register in its reset state.                               */
  __IM  uint16_t  RESERVED1[6];
  __IOM uint16_t  NUM_GPIOS;                    /*!< The number of main user GPIOs (bank 0). Should read 48 in the
                                                     QFN80 package, and 30 in the QFN60 package. (ECC)                         */
  __IM  uint16_t  RESERVED2[29];
  __IOM uint16_t  INFO_CRC0;                    /*!< Lower 16 bits of CRC32 of OTP addresses 0x00 through 0x6b (polynomial
                                                     0x4c11db7, input reflected, output reflected, seed all-ones,
                                                     final XOR all-ones) (ECC)                                                 */
  __IOM uint16_t  INFO_CRC1;                    /*!< Upper 16 bits of CRC32 of OTP addresses 0x00 through 0x6b (ECC)           */
  __IM  uint16_t  RESERVED3[28];
  __IOM uint16_t  FLASH_DEVINFO;                /*!< Stores information about external flash device(s). (ECC) Assumed
                                                     to be valid if BOOT_FLAGS0_FLASH_DEVINFO_ENABLE is set.                   */
  __IOM uint16_t  FLASH_PARTITION_SLOT_SIZE;    /*!< Gap between partition table slot 0 and slot 1 at the start of
                                                     flash (the default size is 4096 bytes) (ECC) Enabled by
                                                     the OVERRIDE_FLASH_PARTITION_SLOT_SIZE bit in BOOT_FLAGS,
                                                     the size is 4096 * (value + 1)                                            */
  __IOM uint16_t  BOOTSEL_LED_CFG;              /*!< Pin configuration for LED status, used by USB bootloader. (ECC)
                                                     Must be valid if BOOT_FLAGS0_ENABLE_BOOTSEL_LED is set.                   */
  __IOM uint16_t  BOOTSEL_PLL_CFG;              /*!< Optional PLL configuration for BOOTSEL mode. (ECC) This should
                                                     be configured to produce an exact 48 MHz based on the crystal
                                                     oscillator frequency. User mode software may also use this
                                                     value to calculate the expected crystal frequency based
                                                     on an assumed 48 MHz PLL output. If no configuration is
                                                     given, the crystal is assumed to be 12 MHz. The PLL frequency
                                                     can be calculated as: PLL out = (XOSC frequency / (REFDIV+1))
                                                     x FBDIV / (POSTDIV1 x POSTDIV2) Conversely the crystal
                                                     frequency can be calculated as: XOSC frequency = 48 MHz
                                                     x (REFDIV+1) x (POSTDIV1 x POSTDIV2) / FBDIV (Note the
                                                     +1 on REFDIV is because the value stored in this OTP location
                                                     is the actual divisor value minus one.) Used if and only
                                                     if ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG is set in BOOT_FLAGS0.
                                                     That bit should be set only after this row and BOOTSEL_XOSC_CFG
                                                     are both correctly programmed.                                            */
  __IOM uint16_t  BOOTSEL_XOSC_CFG;             /*!< Non-default crystal oscillator configuration for the USB bootloader.
                                                     (ECC) These values may also be used by user code configuring
                                                     the crystal oscillator. Used if and only if ENABLE_BOOTSEL_NON_DEFAULT_PL
                                                     _XOSC_CFG is set in BOOT_FLAGS0. That bit should be set
                                                     only after this row and BOOTSEL_PLL_CFG are both correctly
                                                     programmed.                                                               */
  __IM  uint16_t  RESERVED4[3];
  __IOM uint16_t  USB_WHITE_LABEL_ADDR;         /*!< Row index of the USB_WHITE_LABEL structure within OTP (ECC)
                                                     The table has 16 rows, each of which are also ECC and marked
                                                     valid by the corresponding valid bit in USB_BOOT_FLAGS
                                                     (ECC). The entries are either _VALUEs where the 16 bit
                                                     value is used as is, or _STRDEFs which acts as a pointers
                                                     to a string value. The value stored in a _STRDEF is two
                                                     separate bytes: The low seven bits of the first (LSB) byte
                                                     indicates the number of characters in the string, and the
                                                     top bit of the first (LSB) byte if set to indicate that
                                                     each character in the string is two bytes (Unicode) versus
                                                     one byte if unset. The second (MSB) byte represents the
                                                     location of the string data, and is encoded as the number
                                                     of rows from this USB_WHITE_LABEL_ADDR; i.e. the row of
                                                     the start of the string is USB_WHITE_LABEL_ADDR value +
                                                     msb_byte. In each case, the corresponding valid bit enables
                                                     replacing the default value for the corresponding item
                                                     provided by the boot rom. Note that Unicode _STRDEFs are
                                                     only supported for USB_DEVICE_PRODUCT_STRDEF, USB_DEVICE_SERIAL_NUMBER_ST
                                                     DEF and USB_DEVICE_MANUFACTURER_STRDEF. Unicode values
                                                     will be ignored if specified for other fields, and non-unicode
                                                     values for these three items will be converted to Unicode
                                                     characters by setting the upper 8 bits to zero. Note that
                                                     if the USB_WHITE_LABEL structure or the corresponding strings
                                                     are not readable by BOOTSEL mode based on OTP permissions,
                                                     or if alignment requirements are not met, then the corresponding
                                                     default values are used. The index values indicate where
                                                     each field is located (row USB_WHITE_LABEL_ADDR value +
                                                     index):                                                                   */
  __IM  uint16_t  RESERVED5;
  __IOM uint16_t  OTPBOOT_SRC;                  /*!< OTP start row for the OTP boot image. (ECC) If OTP boot is enabled,
                                                     the bootrom will load from this location into SRAM and
                                                     then directly enter the loaded image. Note that the image
                                                     must be signed if SECURE_BOOT_ENABLE is set. The image
                                                     itself is assumed to be ECC-protected. This must be an
                                                     even number. Equivalently, the OTP boot image must start
                                                     at a word-aligned location in the ECC read data address
                                                     window.                                                                   */
  __IOM uint16_t  OTPBOOT_LEN;                  /*!< Length in rows of the OTP boot image. (ECC) OTPBOOT_LEN must
                                                     be even. The total image size must be a multiple of 4 bytes
                                                     (32 bits).                                                                */
  __IOM uint16_t  OTPBOOT_DST0;                 /*!< Bits 15:0 of the OTP boot image load destination (and entry
                                                     point). (ECC) This must be a location in main SRAM (main
                                                     SRAM is addresses 0x20000000 through 0x20082000) and must
                                                     be word-aligned.                                                          */
  __IOM uint16_t  OTPBOOT_DST1;                 /*!< Bits 31:16 of the OTP boot image load destination (and entry
                                                     point). (ECC) This must be a location in main SRAM (main
                                                     SRAM is addresses 0x20000000 through 0x20082000) and must
                                                     be word-aligned.                                                          */
  __IM  uint16_t  RESERVED6[30];
  __IOM uint16_t  BOOTKEY0_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 0 (ECC)                             */
  __IOM uint16_t  BOOTKEY0_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint16_t  BOOTKEY0_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint16_t  BOOTKEY0_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint16_t  BOOTKEY0_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint16_t  BOOTKEY0_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint16_t  BOOTKEY0_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 0 (ECC)                           */
  __IOM uint16_t  BOOTKEY0_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY0_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 1 (ECC)                             */
  __IOM uint16_t  BOOTKEY1_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint16_t  BOOTKEY1_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint16_t  BOOTKEY1_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint16_t  BOOTKEY1_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint16_t  BOOTKEY1_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint16_t  BOOTKEY1_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 1 (ECC)                           */
  __IOM uint16_t  BOOTKEY1_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY1_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 2 (ECC)                             */
  __IOM uint16_t  BOOTKEY2_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint16_t  BOOTKEY2_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint16_t  BOOTKEY2_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint16_t  BOOTKEY2_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint16_t  BOOTKEY2_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint16_t  BOOTKEY2_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 2 (ECC)                           */
  __IOM uint16_t  BOOTKEY2_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY2_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 3 (ECC)                             */
  __IOM uint16_t  BOOTKEY3_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint16_t  BOOTKEY3_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint16_t  BOOTKEY3_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint16_t  BOOTKEY3_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint16_t  BOOTKEY3_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint16_t  BOOTKEY3_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 3 (ECC)                           */
  __IOM uint16_t  BOOTKEY3_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint16_t  BOOTKEY3_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 3 (ECC)                          */
  __IM  uint16_t  RESERVED7[3720];
  __IOM uint16_t  KEY1_0;                       /*!< Bits 15:0 of OTP access key 1 (ECC)                                       */
  __IOM uint16_t  KEY1_1;                       /*!< Bits 31:16 of OTP access key 1 (ECC)                                      */
  __IOM uint16_t  KEY1_2;                       /*!< Bits 47:32 of OTP access key 1 (ECC)                                      */
  __IOM uint16_t  KEY1_3;                       /*!< Bits 63:48 of OTP access key 1 (ECC)                                      */
  __IOM uint16_t  KEY1_4;                       /*!< Bits 79:64 of OTP access key 1 (ECC)                                      */
  __IOM uint16_t  KEY1_5;                       /*!< Bits 95:80 of OTP access key 1 (ECC)                                      */
  __IOM uint16_t  KEY1_6;                       /*!< Bits 111:96 of OTP access key 1 (ECC)                                     */
  __IOM uint16_t  KEY1_7;                       /*!< Bits 127:112 of OTP access key 1 (ECC)                                    */
  __IOM uint16_t  KEY2_0;                       /*!< Bits 15:0 of OTP access key 2 (ECC)                                       */
  __IOM uint16_t  KEY2_1;                       /*!< Bits 31:16 of OTP access key 2 (ECC)                                      */
  __IOM uint16_t  KEY2_2;                       /*!< Bits 47:32 of OTP access key 2 (ECC)                                      */
  __IOM uint16_t  KEY2_3;                       /*!< Bits 63:48 of OTP access key 2 (ECC)                                      */
  __IOM uint16_t  KEY2_4;                       /*!< Bits 79:64 of OTP access key 2 (ECC)                                      */
  __IOM uint16_t  KEY2_5;                       /*!< Bits 95:80 of OTP access key 2 (ECC)                                      */
  __IOM uint16_t  KEY2_6;                       /*!< Bits 111:96 of OTP access key 2 (ECC)                                     */
  __IOM uint16_t  KEY2_7;                       /*!< Bits 127:112 of OTP access key 2 (ECC)                                    */
  __IOM uint16_t  KEY3_0;                       /*!< Bits 15:0 of OTP access key 3 (ECC)                                       */
  __IOM uint16_t  KEY3_1;                       /*!< Bits 31:16 of OTP access key 3 (ECC)                                      */
  __IOM uint16_t  KEY3_2;                       /*!< Bits 47:32 of OTP access key 3 (ECC)                                      */
  __IOM uint16_t  KEY3_3;                       /*!< Bits 63:48 of OTP access key 3 (ECC)                                      */
  __IOM uint16_t  KEY3_4;                       /*!< Bits 79:64 of OTP access key 3 (ECC)                                      */
  __IOM uint16_t  KEY3_5;                       /*!< Bits 95:80 of OTP access key 3 (ECC)                                      */
  __IOM uint16_t  KEY3_6;                       /*!< Bits 111:96 of OTP access key 3 (ECC)                                     */
  __IOM uint16_t  KEY3_7;                       /*!< Bits 127:112 of OTP access key 3 (ECC)                                    */
  __IOM uint16_t  KEY4_0;                       /*!< Bits 15:0 of OTP access key 4 (ECC)                                       */
  __IOM uint16_t  KEY4_1;                       /*!< Bits 31:16 of OTP access key 4 (ECC)                                      */
  __IOM uint16_t  KEY4_2;                       /*!< Bits 47:32 of OTP access key 4 (ECC)                                      */
  __IOM uint16_t  KEY4_3;                       /*!< Bits 63:48 of OTP access key 4 (ECC)                                      */
  __IOM uint16_t  KEY4_4;                       /*!< Bits 79:64 of OTP access key 4 (ECC)                                      */
  __IOM uint16_t  KEY4_5;                       /*!< Bits 95:80 of OTP access key 4 (ECC)                                      */
  __IOM uint16_t  KEY4_6;                       /*!< Bits 111:96 of OTP access key 4 (ECC)                                     */
  __IOM uint16_t  KEY4_7;                       /*!< Bits 127:112 of OTP access key 4 (ECC)                                    */
  __IOM uint16_t  KEY5_0;                       /*!< Bits 15:0 of OTP access key 5 (ECC)                                       */
  __IOM uint16_t  KEY5_1;                       /*!< Bits 31:16 of OTP access key 5 (ECC)                                      */
  __IOM uint16_t  KEY5_2;                       /*!< Bits 47:32 of OTP access key 5 (ECC)                                      */
  __IOM uint16_t  KEY5_3;                       /*!< Bits 63:48 of OTP access key 5 (ECC)                                      */
  __IOM uint16_t  KEY5_4;                       /*!< Bits 79:64 of OTP access key 5 (ECC)                                      */
  __IOM uint16_t  KEY5_5;                       /*!< Bits 95:80 of OTP access key 5 (ECC)                                      */
  __IOM uint16_t  KEY5_6;                       /*!< Bits 111:96 of OTP access key 5 (ECC)                                     */
  __IOM uint16_t  KEY5_7;                       /*!< Bits 127:112 of OTP access key 5 (ECC)                                    */
  __IOM uint16_t  KEY6_0;                       /*!< Bits 15:0 of OTP access key 6 (ECC)                                       */
  __IOM uint16_t  KEY6_1;                       /*!< Bits 31:16 of OTP access key 6 (ECC)                                      */
  __IOM uint16_t  KEY6_2;                       /*!< Bits 47:32 of OTP access key 6 (ECC)                                      */
  __IOM uint16_t  KEY6_3;                       /*!< Bits 63:48 of OTP access key 6 (ECC)                                      */
  __IOM uint16_t  KEY6_4;                       /*!< Bits 79:64 of OTP access key 6 (ECC)                                      */
  __IOM uint16_t  KEY6_5;                       /*!< Bits 95:80 of OTP access key 6 (ECC)                                      */
  __IOM uint16_t  KEY6_6;                       /*!< Bits 111:96 of OTP access key 6 (ECC)                                     */
  __IOM uint16_t  KEY6_7;                       /*!< Bits 127:112 of OTP access key 6 (ECC)                                    */
} OTP_DATA_Type;                                /*!< Size = 7920 (0x1ef0)                                                      */



/* =========================================================================================================================== */
/* ================                                       OTP_DATA_RAW                                        ================ */
/* =========================================================================================================================== */


/**
  * @brief Predefined OTP data layout for RP2350 (OTP_DATA_RAW)
  */

typedef struct {                                /*!< OTP_DATA_RAW Structure                                                    */
  __IOM uint32_t  CHIPID0;                      /*!< Bits 15:0 of public device ID. (ECC) The CHIPID0..3 rows contain
                                                     a 64-bit random identifier for this chip, which can be
                                                     read from the USB bootloader PICOBOOT interface or from
                                                     the get_sys_info ROM API. The number of random bits makes
                                                     the occurrence of twins exceedingly unlikely: for example,
                                                     a fleet of a hundred million devices has a 99.97% probability
                                                     of no twinned IDs. This is estimated to be lower than the
                                                     occurrence of process errors in the assignment of sequential
                                                     random IDs, and for practical purposes CHIPID may be treated
                                                     as unique.                                                                */
  __IOM uint32_t  CHIPID1;                      /*!< Bits 31:16 of public device ID (ECC)                                      */
  __IOM uint32_t  CHIPID2;                      /*!< Bits 47:32 of public device ID (ECC)                                      */
  __IOM uint32_t  CHIPID3;                      /*!< Bits 63:48 of public device ID (ECC)                                      */
  __IOM uint32_t  RANDID0;                      /*!< Bits 15:0 of private per-device random number (ECC) The RANDID0..7
                                                     rows form a 128-bit random number generated during device
                                                     test. This ID is not exposed through the USB PICOBOOT GET_INFO
                                                     command or the ROM `get_sys_info()` API. However note that
                                                     the USB PICOBOOT OTP access point can read the entirety
                                                     of page 0, so this value is not meaningfully private unless
                                                     the USB PICOBOOT interface is disabled via the DISABLE_BOOTSEL_USB_PICOBO
                                                     T_IFC flag in BOOT_FLAGS0.                                                */
  __IOM uint32_t  RANDID1;                      /*!< Bits 31:16 of private per-device random number (ECC)                      */
  __IOM uint32_t  RANDID2;                      /*!< Bits 47:32 of private per-device random number (ECC)                      */
  __IOM uint32_t  RANDID3;                      /*!< Bits 63:48 of private per-device random number (ECC)                      */
  __IOM uint32_t  RANDID4;                      /*!< Bits 79:64 of private per-device random number (ECC)                      */
  __IOM uint32_t  RANDID5;                      /*!< Bits 95:80 of private per-device random number (ECC)                      */
  __IOM uint32_t  RANDID6;                      /*!< Bits 111:96 of private per-device random number (ECC)                     */
  __IOM uint32_t  RANDID7;                      /*!< Bits 127:112 of private per-device random number (ECC)                    */
  __IM  uint32_t  RESERVED[4];
  __IOM uint32_t  ROSC_CALIB;                   /*!< Ring oscillator frequency in kHz, measured during manufacturing
                                                     (ECC) This is measured at 1.1 V, at room temperature, with
                                                     the ROSC configuration registers in their reset state.                    */
  __IOM uint32_t  LPOSC_CALIB;                  /*!< Low-power oscillator frequency in Hz, measured during manufacturing
                                                     (ECC) This is measured at 1.1V, at room temperature, with
                                                     the LPOSC trim register in its reset state.                               */
  __IM  uint32_t  RESERVED1[6];
  __IOM uint32_t  NUM_GPIOS;                    /*!< The number of main user GPIOs (bank 0). Should read 48 in the
                                                     QFN80 package, and 30 in the QFN60 package. (ECC)                         */
  __IM  uint32_t  RESERVED2[29];
  __IOM uint32_t  INFO_CRC0;                    /*!< Lower 16 bits of CRC32 of OTP addresses 0x00 through 0x6b (polynomial
                                                     0x4c11db7, input reflected, output reflected, seed all-ones,
                                                     final XOR all-ones) (ECC)                                                 */
  __IOM uint32_t  INFO_CRC1;                    /*!< Upper 16 bits of CRC32 of OTP addresses 0x00 through 0x6b (ECC)           */
  __IOM uint32_t  CRIT0;                        /*!< Page 0 critical boot flags (RBIT-8)                                       */
  __IOM uint32_t  CRIT0_R1;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT0_R2;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT0_R3;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT0_R4;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT0_R5;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT0_R6;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT0_R7;                     /*!< Redundant copy of CRIT0                                                   */
  __IOM uint32_t  CRIT1;                        /*!< Page 1 critical boot flags (RBIT-8)                                       */
  __IOM uint32_t  CRIT1_R1;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  CRIT1_R2;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  CRIT1_R3;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  CRIT1_R4;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  CRIT1_R5;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  CRIT1_R6;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  CRIT1_R7;                     /*!< Redundant copy of CRIT1                                                   */
  __IOM uint32_t  BOOT_FLAGS0;                  /*!< Disable/Enable boot paths/features in the RP2350 mask ROM. Disables
                                                     always supersede enables. Enables are provided where there
                                                     are other configurations in OTP that must be valid. (RBIT-3)              */
  __IOM uint32_t  BOOT_FLAGS0_R1;               /*!< Redundant copy of BOOT_FLAGS0                                             */
  __IOM uint32_t  BOOT_FLAGS0_R2;               /*!< Redundant copy of BOOT_FLAGS0                                             */
  __IOM uint32_t  BOOT_FLAGS1;                  /*!< Disable/Enable boot paths/features in the RP2350 mask ROM. Disables
                                                     always supersede enables. Enables are provided where there
                                                     are other configurations in OTP that must be valid. (RBIT-3)              */
  __IOM uint32_t  BOOT_FLAGS1_R1;               /*!< Redundant copy of BOOT_FLAGS1                                             */
  __IOM uint32_t  BOOT_FLAGS1_R2;               /*!< Redundant copy of BOOT_FLAGS1                                             */
  __IOM uint32_t  DEFAULT_BOOT_VERSION0;        /*!< Default boot version thermometer counter, bits 23:0 (RBIT-3)              */
  __IOM uint32_t  DEFAULT_BOOT_VERSION0_R1;     /*!< Redundant copy of DEFAULT_BOOT_VERSION0                                   */
  __IOM uint32_t  DEFAULT_BOOT_VERSION0_R2;     /*!< Redundant copy of DEFAULT_BOOT_VERSION0                                   */
  __IOM uint32_t  DEFAULT_BOOT_VERSION1;        /*!< Default boot version thermometer counter, bits 47:24 (RBIT-3)             */
  __IOM uint32_t  DEFAULT_BOOT_VERSION1_R1;     /*!< Redundant copy of DEFAULT_BOOT_VERSION1                                   */
  __IOM uint32_t  DEFAULT_BOOT_VERSION1_R2;     /*!< Redundant copy of DEFAULT_BOOT_VERSION1                                   */
  __IOM uint32_t  FLASH_DEVINFO;                /*!< Stores information about external flash device(s). (ECC) Assumed
                                                     to be valid if BOOT_FLAGS0_FLASH_DEVINFO_ENABLE is set.                   */
  __IOM uint32_t  FLASH_PARTITION_SLOT_SIZE;    /*!< Gap between partition table slot 0 and slot 1 at the start of
                                                     flash (the default size is 4096 bytes) (ECC) Enabled by
                                                     the OVERRIDE_FLASH_PARTITION_SLOT_SIZE bit in BOOT_FLAGS,
                                                     the size is 4096 * (value + 1)                                            */
  __IOM uint32_t  BOOTSEL_LED_CFG;              /*!< Pin configuration for LED status, used by USB bootloader. (ECC)
                                                     Must be valid if BOOT_FLAGS0_ENABLE_BOOTSEL_LED is set.                   */
  __IOM uint32_t  BOOTSEL_PLL_CFG;              /*!< Optional PLL configuration for BOOTSEL mode. (ECC) This should
                                                     be configured to produce an exact 48 MHz based on the crystal
                                                     oscillator frequency. User mode software may also use this
                                                     value to calculate the expected crystal frequency based
                                                     on an assumed 48 MHz PLL output. If no configuration is
                                                     given, the crystal is assumed to be 12 MHz. The PLL frequency
                                                     can be calculated as: PLL out = (XOSC frequency / (REFDIV+1))
                                                     x FBDIV / (POSTDIV1 x POSTDIV2) Conversely the crystal
                                                     frequency can be calculated as: XOSC frequency = 48 MHz
                                                     x (REFDIV+1) x (POSTDIV1 x POSTDIV2) / FBDIV (Note the
                                                     +1 on REFDIV is because the value stored in this OTP location
                                                     is the actual divisor value minus one.) Used if and only
                                                     if ENABLE_BOOTSEL_NON_DEFAULT_PLL_XOSC_CFG is set in BOOT_FLAGS0.
                                                     That bit should be set only after this row and BOOTSEL_XOSC_CFG
                                                     are both correctly programmed.                                            */
  __IOM uint32_t  BOOTSEL_XOSC_CFG;             /*!< Non-default crystal oscillator configuration for the USB bootloader.
                                                     (ECC) These values may also be used by user code configuring
                                                     the crystal oscillator. Used if and only if ENABLE_BOOTSEL_NON_DEFAULT_PL
                                                     _XOSC_CFG is set in BOOT_FLAGS0. That bit should be set
                                                     only after this row and BOOTSEL_PLL_CFG are both correctly
                                                     programmed.                                                               */
  __IOM uint32_t  USB_BOOT_FLAGS;               /*!< USB boot specific feature flags (RBIT-3)                                  */
  __IOM uint32_t  USB_BOOT_FLAGS_R1;            /*!< Redundant copy of USB_BOOT_FLAGS                                          */
  __IOM uint32_t  USB_BOOT_FLAGS_R2;            /*!< Redundant copy of USB_BOOT_FLAGS                                          */
  __IOM uint32_t  USB_WHITE_LABEL_ADDR;         /*!< Row index of the USB_WHITE_LABEL structure within OTP (ECC)
                                                     The table has 16 rows, each of which are also ECC and marked
                                                     valid by the corresponding valid bit in USB_BOOT_FLAGS
                                                     (ECC). The entries are either _VALUEs where the 16 bit
                                                     value is used as is, or _STRDEFs which acts as a pointers
                                                     to a string value. The value stored in a _STRDEF is two
                                                     separate bytes: The low seven bits of the first (LSB) byte
                                                     indicates the number of characters in the string, and the
                                                     top bit of the first (LSB) byte if set to indicate that
                                                     each character in the string is two bytes (Unicode) versus
                                                     one byte if unset. The second (MSB) byte represents the
                                                     location of the string data, and is encoded as the number
                                                     of rows from this USB_WHITE_LABEL_ADDR; i.e. the row of
                                                     the start of the string is USB_WHITE_LABEL_ADDR value +
                                                     msb_byte. In each case, the corresponding valid bit enables
                                                     replacing the default value for the corresponding item
                                                     provided by the boot rom. Note that Unicode _STRDEFs are
                                                     only supported for USB_DEVICE_PRODUCT_STRDEF, USB_DEVICE_SERIAL_NUMBER_ST
                                                     DEF and USB_DEVICE_MANUFACTURER_STRDEF. Unicode values
                                                     will be ignored if specified for other fields, and non-unicode
                                                     values for these three items will be converted to Unicode
                                                     characters by setting the upper 8 bits to zero. Note that
                                                     if the USB_WHITE_LABEL structure or the corresponding strings
                                                     are not readable by BOOTSEL mode based on OTP permissions,
                                                     or if alignment requirements are not met, then the corresponding
                                                     default values are used. The index values indicate where
                                                     each field is located (row USB_WHITE_LABEL_ADDR value +
                                                     index):                                                                   */
  __IM  uint32_t  RESERVED3;
  __IOM uint32_t  OTPBOOT_SRC;                  /*!< OTP start row for the OTP boot image. (ECC) If OTP boot is enabled,
                                                     the bootrom will load from this location into SRAM and
                                                     then directly enter the loaded image. Note that the image
                                                     must be signed if SECURE_BOOT_ENABLE is set. The image
                                                     itself is assumed to be ECC-protected. This must be an
                                                     even number. Equivalently, the OTP boot image must start
                                                     at a word-aligned location in the ECC read data address
                                                     window.                                                                   */
  __IOM uint32_t  OTPBOOT_LEN;                  /*!< Length in rows of the OTP boot image. (ECC) OTPBOOT_LEN must
                                                     be even. The total image size must be a multiple of 4 bytes
                                                     (32 bits).                                                                */
  __IOM uint32_t  OTPBOOT_DST0;                 /*!< Bits 15:0 of the OTP boot image load destination (and entry
                                                     point). (ECC) This must be a location in main SRAM (main
                                                     SRAM is addresses 0x20000000 through 0x20082000) and must
                                                     be word-aligned.                                                          */
  __IOM uint32_t  OTPBOOT_DST1;                 /*!< Bits 31:16 of the OTP boot image load destination (and entry
                                                     point). (ECC) This must be a location in main SRAM (main
                                                     SRAM is addresses 0x20000000 through 0x20082000) and must
                                                     be word-aligned.                                                          */
  __IM  uint32_t  RESERVED4[30];
  __IOM uint32_t  BOOTKEY0_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 0 (ECC)                             */
  __IOM uint32_t  BOOTKEY0_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint32_t  BOOTKEY0_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint32_t  BOOTKEY0_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint32_t  BOOTKEY0_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint32_t  BOOTKEY0_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 0 (ECC)                            */
  __IOM uint32_t  BOOTKEY0_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 0 (ECC)                           */
  __IOM uint32_t  BOOTKEY0_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY0_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 0 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 1 (ECC)                             */
  __IOM uint32_t  BOOTKEY1_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint32_t  BOOTKEY1_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint32_t  BOOTKEY1_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint32_t  BOOTKEY1_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint32_t  BOOTKEY1_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 1 (ECC)                            */
  __IOM uint32_t  BOOTKEY1_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 1 (ECC)                           */
  __IOM uint32_t  BOOTKEY1_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY1_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 1 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 2 (ECC)                             */
  __IOM uint32_t  BOOTKEY2_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint32_t  BOOTKEY2_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint32_t  BOOTKEY2_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint32_t  BOOTKEY2_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint32_t  BOOTKEY2_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 2 (ECC)                            */
  __IOM uint32_t  BOOTKEY2_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 2 (ECC)                           */
  __IOM uint32_t  BOOTKEY2_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY2_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 2 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_0;                   /*!< Bits 15:0 of SHA-256 hash of boot key 3 (ECC)                             */
  __IOM uint32_t  BOOTKEY3_1;                   /*!< Bits 31:16 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint32_t  BOOTKEY3_2;                   /*!< Bits 47:32 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint32_t  BOOTKEY3_3;                   /*!< Bits 63:48 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint32_t  BOOTKEY3_4;                   /*!< Bits 79:64 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint32_t  BOOTKEY3_5;                   /*!< Bits 95:80 of SHA-256 hash of boot key 3 (ECC)                            */
  __IOM uint32_t  BOOTKEY3_6;                   /*!< Bits 111:96 of SHA-256 hash of boot key 3 (ECC)                           */
  __IOM uint32_t  BOOTKEY3_7;                   /*!< Bits 127:112 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_8;                   /*!< Bits 143:128 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_9;                   /*!< Bits 159:144 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_10;                  /*!< Bits 175:160 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_11;                  /*!< Bits 191:176 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_12;                  /*!< Bits 207:192 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_13;                  /*!< Bits 223:208 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_14;                  /*!< Bits 239:224 of SHA-256 hash of boot key 3 (ECC)                          */
  __IOM uint32_t  BOOTKEY3_15;                  /*!< Bits 255:240 of SHA-256 hash of boot key 3 (ECC)                          */
  __IM  uint32_t  RESERVED5[3720];
  __IOM uint32_t  KEY1_0;                       /*!< Bits 15:0 of OTP access key 1 (ECC)                                       */
  __IOM uint32_t  KEY1_1;                       /*!< Bits 31:16 of OTP access key 1 (ECC)                                      */
  __IOM uint32_t  KEY1_2;                       /*!< Bits 47:32 of OTP access key 1 (ECC)                                      */
  __IOM uint32_t  KEY1_3;                       /*!< Bits 63:48 of OTP access key 1 (ECC)                                      */
  __IOM uint32_t  KEY1_4;                       /*!< Bits 79:64 of OTP access key 1 (ECC)                                      */
  __IOM uint32_t  KEY1_5;                       /*!< Bits 95:80 of OTP access key 1 (ECC)                                      */
  __IOM uint32_t  KEY1_6;                       /*!< Bits 111:96 of OTP access key 1 (ECC)                                     */
  __IOM uint32_t  KEY1_7;                       /*!< Bits 127:112 of OTP access key 1 (ECC)                                    */
  __IOM uint32_t  KEY2_0;                       /*!< Bits 15:0 of OTP access key 2 (ECC)                                       */
  __IOM uint32_t  KEY2_1;                       /*!< Bits 31:16 of OTP access key 2 (ECC)                                      */
  __IOM uint32_t  KEY2_2;                       /*!< Bits 47:32 of OTP access key 2 (ECC)                                      */
  __IOM uint32_t  KEY2_3;                       /*!< Bits 63:48 of OTP access key 2 (ECC)                                      */
  __IOM uint32_t  KEY2_4;                       /*!< Bits 79:64 of OTP access key 2 (ECC)                                      */
  __IOM uint32_t  KEY2_5;                       /*!< Bits 95:80 of OTP access key 2 (ECC)                                      */
  __IOM uint32_t  KEY2_6;                       /*!< Bits 111:96 of OTP access key 2 (ECC)                                     */
  __IOM uint32_t  KEY2_7;                       /*!< Bits 127:112 of OTP access key 2 (ECC)                                    */
  __IOM uint32_t  KEY3_0;                       /*!< Bits 15:0 of OTP access key 3 (ECC)                                       */
  __IOM uint32_t  KEY3_1;                       /*!< Bits 31:16 of OTP access key 3 (ECC)                                      */
  __IOM uint32_t  KEY3_2;                       /*!< Bits 47:32 of OTP access key 3 (ECC)                                      */
  __IOM uint32_t  KEY3_3;                       /*!< Bits 63:48 of OTP access key 3 (ECC)                                      */
  __IOM uint32_t  KEY3_4;                       /*!< Bits 79:64 of OTP access key 3 (ECC)                                      */
  __IOM uint32_t  KEY3_5;                       /*!< Bits 95:80 of OTP access key 3 (ECC)                                      */
  __IOM uint32_t  KEY3_6;                       /*!< Bits 111:96 of OTP access key 3 (ECC)                                     */
  __IOM uint32_t  KEY3_7;                       /*!< Bits 127:112 of OTP access key 3 (ECC)                                    */
  __IOM uint32_t  KEY4_0;                       /*!< Bits 15:0 of OTP access key 4 (ECC)                                       */
  __IOM uint32_t  KEY4_1;                       /*!< Bits 31:16 of OTP access key 4 (ECC)                                      */
  __IOM uint32_t  KEY4_2;                       /*!< Bits 47:32 of OTP access key 4 (ECC)                                      */
  __IOM uint32_t  KEY4_3;                       /*!< Bits 63:48 of OTP access key 4 (ECC)                                      */
  __IOM uint32_t  KEY4_4;                       /*!< Bits 79:64 of OTP access key 4 (ECC)                                      */
  __IOM uint32_t  KEY4_5;                       /*!< Bits 95:80 of OTP access key 4 (ECC)                                      */
  __IOM uint32_t  KEY4_6;                       /*!< Bits 111:96 of OTP access key 4 (ECC)                                     */
  __IOM uint32_t  KEY4_7;                       /*!< Bits 127:112 of OTP access key 4 (ECC)                                    */
  __IOM uint32_t  KEY5_0;                       /*!< Bits 15:0 of OTP access key 5 (ECC)                                       */
  __IOM uint32_t  KEY5_1;                       /*!< Bits 31:16 of OTP access key 5 (ECC)                                      */
  __IOM uint32_t  KEY5_2;                       /*!< Bits 47:32 of OTP access key 5 (ECC)                                      */
  __IOM uint32_t  KEY5_3;                       /*!< Bits 63:48 of OTP access key 5 (ECC)                                      */
  __IOM uint32_t  KEY5_4;                       /*!< Bits 79:64 of OTP access key 5 (ECC)                                      */
  __IOM uint32_t  KEY5_5;                       /*!< Bits 95:80 of OTP access key 5 (ECC)                                      */
  __IOM uint32_t  KEY5_6;                       /*!< Bits 111:96 of OTP access key 5 (ECC)                                     */
  __IOM uint32_t  KEY5_7;                       /*!< Bits 127:112 of OTP access key 5 (ECC)                                    */
  __IOM uint32_t  KEY6_0;                       /*!< Bits 15:0 of OTP access key 6 (ECC)                                       */
  __IOM uint32_t  KEY6_1;                       /*!< Bits 31:16 of OTP access key 6 (ECC)                                      */
  __IOM uint32_t  KEY6_2;                       /*!< Bits 47:32 of OTP access key 6 (ECC)                                      */
  __IOM uint32_t  KEY6_3;                       /*!< Bits 63:48 of OTP access key 6 (ECC)                                      */
  __IOM uint32_t  KEY6_4;                       /*!< Bits 79:64 of OTP access key 6 (ECC)                                      */
  __IOM uint32_t  KEY6_5;                       /*!< Bits 95:80 of OTP access key 6 (ECC)                                      */
  __IOM uint32_t  KEY6_6;                       /*!< Bits 111:96 of OTP access key 6 (ECC)                                     */
  __IOM uint32_t  KEY6_7;                       /*!< Bits 127:112 of OTP access key 6 (ECC)                                    */
  __IM  uint32_t  RESERVED6;
  __IOM uint32_t  KEY1_VALID;                   /*!< Valid flag for key 1. Once the valid flag is set, the key can
                                                     no longer be read or written, and becomes a valid fixed
                                                     key for protecting OTP pages.                                             */
  __IOM uint32_t  KEY2_VALID;                   /*!< Valid flag for key 2. Once the valid flag is set, the key can
                                                     no longer be read or written, and becomes a valid fixed
                                                     key for protecting OTP pages.                                             */
  __IOM uint32_t  KEY3_VALID;                   /*!< Valid flag for key 3. Once the valid flag is set, the key can
                                                     no longer be read or written, and becomes a valid fixed
                                                     key for protecting OTP pages.                                             */
  __IOM uint32_t  KEY4_VALID;                   /*!< Valid flag for key 4. Once the valid flag is set, the key can
                                                     no longer be read or written, and becomes a valid fixed
                                                     key for protecting OTP pages.                                             */
  __IOM uint32_t  KEY5_VALID;                   /*!< Valid flag for key 5. Once the valid flag is set, the key can
                                                     no longer be read or written, and becomes a valid fixed
                                                     key for protecting OTP pages.                                             */
  __IOM uint32_t  KEY6_VALID;                   /*!< Valid flag for key 6. Once the valid flag is set, the key can
                                                     no longer be read or written, and becomes a valid fixed
                                                     key for protecting OTP pages.                                             */
  __IM  uint32_t  RESERVED7;
  __IOM uint32_t  PAGE0_LOCK0;                  /*!< Lock configuration LSBs for page 0 (rows 0x0 through 0x3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE0_LOCK1;                  /*!< Lock configuration MSBs for page 0 (rows 0x0 through 0x3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE1_LOCK0;                  /*!< Lock configuration LSBs for page 1 (rows 0x40 through 0x7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE1_LOCK1;                  /*!< Lock configuration MSBs for page 1 (rows 0x40 through 0x7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE2_LOCK0;                  /*!< Lock configuration LSBs for page 2 (rows 0x80 through 0xbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE2_LOCK1;                  /*!< Lock configuration MSBs for page 2 (rows 0x80 through 0xbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE3_LOCK0;                  /*!< Lock configuration LSBs for page 3 (rows 0xc0 through 0xff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE3_LOCK1;                  /*!< Lock configuration MSBs for page 3 (rows 0xc0 through 0xff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE4_LOCK0;                  /*!< Lock configuration LSBs for page 4 (rows 0x100 through 0x13f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE4_LOCK1;                  /*!< Lock configuration MSBs for page 4 (rows 0x100 through 0x13f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE5_LOCK0;                  /*!< Lock configuration LSBs for page 5 (rows 0x140 through 0x17f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE5_LOCK1;                  /*!< Lock configuration MSBs for page 5 (rows 0x140 through 0x17f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE6_LOCK0;                  /*!< Lock configuration LSBs for page 6 (rows 0x180 through 0x1bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE6_LOCK1;                  /*!< Lock configuration MSBs for page 6 (rows 0x180 through 0x1bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE7_LOCK0;                  /*!< Lock configuration LSBs for page 7 (rows 0x1c0 through 0x1ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE7_LOCK1;                  /*!< Lock configuration MSBs for page 7 (rows 0x1c0 through 0x1ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE8_LOCK0;                  /*!< Lock configuration LSBs for page 8 (rows 0x200 through 0x23f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE8_LOCK1;                  /*!< Lock configuration MSBs for page 8 (rows 0x200 through 0x23f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE9_LOCK0;                  /*!< Lock configuration LSBs for page 9 (rows 0x240 through 0x27f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE9_LOCK1;                  /*!< Lock configuration MSBs for page 9 (rows 0x240 through 0x27f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE10_LOCK0;                 /*!< Lock configuration LSBs for page 10 (rows 0x280 through 0x2bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE10_LOCK1;                 /*!< Lock configuration MSBs for page 10 (rows 0x280 through 0x2bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE11_LOCK0;                 /*!< Lock configuration LSBs for page 11 (rows 0x2c0 through 0x2ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE11_LOCK1;                 /*!< Lock configuration MSBs for page 11 (rows 0x2c0 through 0x2ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE12_LOCK0;                 /*!< Lock configuration LSBs for page 12 (rows 0x300 through 0x33f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE12_LOCK1;                 /*!< Lock configuration MSBs for page 12 (rows 0x300 through 0x33f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE13_LOCK0;                 /*!< Lock configuration LSBs for page 13 (rows 0x340 through 0x37f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE13_LOCK1;                 /*!< Lock configuration MSBs for page 13 (rows 0x340 through 0x37f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE14_LOCK0;                 /*!< Lock configuration LSBs for page 14 (rows 0x380 through 0x3bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE14_LOCK1;                 /*!< Lock configuration MSBs for page 14 (rows 0x380 through 0x3bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE15_LOCK0;                 /*!< Lock configuration LSBs for page 15 (rows 0x3c0 through 0x3ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE15_LOCK1;                 /*!< Lock configuration MSBs for page 15 (rows 0x3c0 through 0x3ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE16_LOCK0;                 /*!< Lock configuration LSBs for page 16 (rows 0x400 through 0x43f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE16_LOCK1;                 /*!< Lock configuration MSBs for page 16 (rows 0x400 through 0x43f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE17_LOCK0;                 /*!< Lock configuration LSBs for page 17 (rows 0x440 through 0x47f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE17_LOCK1;                 /*!< Lock configuration MSBs for page 17 (rows 0x440 through 0x47f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE18_LOCK0;                 /*!< Lock configuration LSBs for page 18 (rows 0x480 through 0x4bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE18_LOCK1;                 /*!< Lock configuration MSBs for page 18 (rows 0x480 through 0x4bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE19_LOCK0;                 /*!< Lock configuration LSBs for page 19 (rows 0x4c0 through 0x4ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE19_LOCK1;                 /*!< Lock configuration MSBs for page 19 (rows 0x4c0 through 0x4ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE20_LOCK0;                 /*!< Lock configuration LSBs for page 20 (rows 0x500 through 0x53f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE20_LOCK1;                 /*!< Lock configuration MSBs for page 20 (rows 0x500 through 0x53f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE21_LOCK0;                 /*!< Lock configuration LSBs for page 21 (rows 0x540 through 0x57f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE21_LOCK1;                 /*!< Lock configuration MSBs for page 21 (rows 0x540 through 0x57f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE22_LOCK0;                 /*!< Lock configuration LSBs for page 22 (rows 0x580 through 0x5bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE22_LOCK1;                 /*!< Lock configuration MSBs for page 22 (rows 0x580 through 0x5bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE23_LOCK0;                 /*!< Lock configuration LSBs for page 23 (rows 0x5c0 through 0x5ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE23_LOCK1;                 /*!< Lock configuration MSBs for page 23 (rows 0x5c0 through 0x5ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE24_LOCK0;                 /*!< Lock configuration LSBs for page 24 (rows 0x600 through 0x63f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE24_LOCK1;                 /*!< Lock configuration MSBs for page 24 (rows 0x600 through 0x63f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE25_LOCK0;                 /*!< Lock configuration LSBs for page 25 (rows 0x640 through 0x67f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE25_LOCK1;                 /*!< Lock configuration MSBs for page 25 (rows 0x640 through 0x67f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE26_LOCK0;                 /*!< Lock configuration LSBs for page 26 (rows 0x680 through 0x6bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE26_LOCK1;                 /*!< Lock configuration MSBs for page 26 (rows 0x680 through 0x6bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE27_LOCK0;                 /*!< Lock configuration LSBs for page 27 (rows 0x6c0 through 0x6ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE27_LOCK1;                 /*!< Lock configuration MSBs for page 27 (rows 0x6c0 through 0x6ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE28_LOCK0;                 /*!< Lock configuration LSBs for page 28 (rows 0x700 through 0x73f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE28_LOCK1;                 /*!< Lock configuration MSBs for page 28 (rows 0x700 through 0x73f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE29_LOCK0;                 /*!< Lock configuration LSBs for page 29 (rows 0x740 through 0x77f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE29_LOCK1;                 /*!< Lock configuration MSBs for page 29 (rows 0x740 through 0x77f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE30_LOCK0;                 /*!< Lock configuration LSBs for page 30 (rows 0x780 through 0x7bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE30_LOCK1;                 /*!< Lock configuration MSBs for page 30 (rows 0x780 through 0x7bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE31_LOCK0;                 /*!< Lock configuration LSBs for page 31 (rows 0x7c0 through 0x7ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE31_LOCK1;                 /*!< Lock configuration MSBs for page 31 (rows 0x7c0 through 0x7ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE32_LOCK0;                 /*!< Lock configuration LSBs for page 32 (rows 0x800 through 0x83f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE32_LOCK1;                 /*!< Lock configuration MSBs for page 32 (rows 0x800 through 0x83f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE33_LOCK0;                 /*!< Lock configuration LSBs for page 33 (rows 0x840 through 0x87f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE33_LOCK1;                 /*!< Lock configuration MSBs for page 33 (rows 0x840 through 0x87f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE34_LOCK0;                 /*!< Lock configuration LSBs for page 34 (rows 0x880 through 0x8bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE34_LOCK1;                 /*!< Lock configuration MSBs for page 34 (rows 0x880 through 0x8bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE35_LOCK0;                 /*!< Lock configuration LSBs for page 35 (rows 0x8c0 through 0x8ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE35_LOCK1;                 /*!< Lock configuration MSBs for page 35 (rows 0x8c0 through 0x8ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE36_LOCK0;                 /*!< Lock configuration LSBs for page 36 (rows 0x900 through 0x93f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE36_LOCK1;                 /*!< Lock configuration MSBs for page 36 (rows 0x900 through 0x93f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE37_LOCK0;                 /*!< Lock configuration LSBs for page 37 (rows 0x940 through 0x97f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE37_LOCK1;                 /*!< Lock configuration MSBs for page 37 (rows 0x940 through 0x97f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE38_LOCK0;                 /*!< Lock configuration LSBs for page 38 (rows 0x980 through 0x9bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE38_LOCK1;                 /*!< Lock configuration MSBs for page 38 (rows 0x980 through 0x9bf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE39_LOCK0;                 /*!< Lock configuration LSBs for page 39 (rows 0x9c0 through 0x9ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE39_LOCK1;                 /*!< Lock configuration MSBs for page 39 (rows 0x9c0 through 0x9ff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE40_LOCK0;                 /*!< Lock configuration LSBs for page 40 (rows 0xa00 through 0xa3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE40_LOCK1;                 /*!< Lock configuration MSBs for page 40 (rows 0xa00 through 0xa3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE41_LOCK0;                 /*!< Lock configuration LSBs for page 41 (rows 0xa40 through 0xa7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE41_LOCK1;                 /*!< Lock configuration MSBs for page 41 (rows 0xa40 through 0xa7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE42_LOCK0;                 /*!< Lock configuration LSBs for page 42 (rows 0xa80 through 0xabf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE42_LOCK1;                 /*!< Lock configuration MSBs for page 42 (rows 0xa80 through 0xabf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE43_LOCK0;                 /*!< Lock configuration LSBs for page 43 (rows 0xac0 through 0xaff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE43_LOCK1;                 /*!< Lock configuration MSBs for page 43 (rows 0xac0 through 0xaff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE44_LOCK0;                 /*!< Lock configuration LSBs for page 44 (rows 0xb00 through 0xb3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE44_LOCK1;                 /*!< Lock configuration MSBs for page 44 (rows 0xb00 through 0xb3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE45_LOCK0;                 /*!< Lock configuration LSBs for page 45 (rows 0xb40 through 0xb7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE45_LOCK1;                 /*!< Lock configuration MSBs for page 45 (rows 0xb40 through 0xb7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE46_LOCK0;                 /*!< Lock configuration LSBs for page 46 (rows 0xb80 through 0xbbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE46_LOCK1;                 /*!< Lock configuration MSBs for page 46 (rows 0xb80 through 0xbbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE47_LOCK0;                 /*!< Lock configuration LSBs for page 47 (rows 0xbc0 through 0xbff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE47_LOCK1;                 /*!< Lock configuration MSBs for page 47 (rows 0xbc0 through 0xbff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE48_LOCK0;                 /*!< Lock configuration LSBs for page 48 (rows 0xc00 through 0xc3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE48_LOCK1;                 /*!< Lock configuration MSBs for page 48 (rows 0xc00 through 0xc3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE49_LOCK0;                 /*!< Lock configuration LSBs for page 49 (rows 0xc40 through 0xc7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE49_LOCK1;                 /*!< Lock configuration MSBs for page 49 (rows 0xc40 through 0xc7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE50_LOCK0;                 /*!< Lock configuration LSBs for page 50 (rows 0xc80 through 0xcbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE50_LOCK1;                 /*!< Lock configuration MSBs for page 50 (rows 0xc80 through 0xcbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE51_LOCK0;                 /*!< Lock configuration LSBs for page 51 (rows 0xcc0 through 0xcff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE51_LOCK1;                 /*!< Lock configuration MSBs for page 51 (rows 0xcc0 through 0xcff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE52_LOCK0;                 /*!< Lock configuration LSBs for page 52 (rows 0xd00 through 0xd3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE52_LOCK1;                 /*!< Lock configuration MSBs for page 52 (rows 0xd00 through 0xd3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE53_LOCK0;                 /*!< Lock configuration LSBs for page 53 (rows 0xd40 through 0xd7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE53_LOCK1;                 /*!< Lock configuration MSBs for page 53 (rows 0xd40 through 0xd7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE54_LOCK0;                 /*!< Lock configuration LSBs for page 54 (rows 0xd80 through 0xdbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE54_LOCK1;                 /*!< Lock configuration MSBs for page 54 (rows 0xd80 through 0xdbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE55_LOCK0;                 /*!< Lock configuration LSBs for page 55 (rows 0xdc0 through 0xdff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE55_LOCK1;                 /*!< Lock configuration MSBs for page 55 (rows 0xdc0 through 0xdff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE56_LOCK0;                 /*!< Lock configuration LSBs for page 56 (rows 0xe00 through 0xe3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE56_LOCK1;                 /*!< Lock configuration MSBs for page 56 (rows 0xe00 through 0xe3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE57_LOCK0;                 /*!< Lock configuration LSBs for page 57 (rows 0xe40 through 0xe7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE57_LOCK1;                 /*!< Lock configuration MSBs for page 57 (rows 0xe40 through 0xe7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE58_LOCK0;                 /*!< Lock configuration LSBs for page 58 (rows 0xe80 through 0xebf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE58_LOCK1;                 /*!< Lock configuration MSBs for page 58 (rows 0xe80 through 0xebf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE59_LOCK0;                 /*!< Lock configuration LSBs for page 59 (rows 0xec0 through 0xeff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE59_LOCK1;                 /*!< Lock configuration MSBs for page 59 (rows 0xec0 through 0xeff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE60_LOCK0;                 /*!< Lock configuration LSBs for page 60 (rows 0xf00 through 0xf3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE60_LOCK1;                 /*!< Lock configuration MSBs for page 60 (rows 0xf00 through 0xf3f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE61_LOCK0;                 /*!< Lock configuration LSBs for page 61 (rows 0xf40 through 0xf7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE61_LOCK1;                 /*!< Lock configuration MSBs for page 61 (rows 0xf40 through 0xf7f).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE62_LOCK0;                 /*!< Lock configuration LSBs for page 62 (rows 0xf80 through 0xfbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE62_LOCK1;                 /*!< Lock configuration MSBs for page 62 (rows 0xf80 through 0xfbf).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE63_LOCK0;                 /*!< Lock configuration LSBs for page 63 (rows 0xfc0 through 0xfff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
  __IOM uint32_t  PAGE63_LOCK1;                 /*!< Lock configuration MSBs for page 63 (rows 0xfc0 through 0xfff).
                                                     Locks are stored with 3-way majority vote encoding, so
                                                     that bits can be set independently. This OTP location is
                                                     always readable, and is write-protected by its own permissions.           */
} OTP_DATA_RAW_Type;                            /*!< Size = 16384 (0x4000)                                                     */



/* =========================================================================================================================== */
/* ================                                           TBMAN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief For managing simulation testbenches (TBMAN)
  */

typedef struct {                                /*!< TBMAN Structure                                                           */
  __IOM uint32_t  PLATFORM;                     /*!< Indicates the type of platform in use                                     */
} TBMAN_Type;                                   /*!< Size = 4 (0x4)                                                            */



/* =========================================================================================================================== */
/* ================                                         USB_DPRAM                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief DPRAM layout for USB device. (USB_DPRAM)
  */

typedef struct {                                /*!< USB_DPRAM Structure                                                       */
  __IOM uint32_t  SETUP_PACKET_LOW;             /*!< Bytes 0-3 of the SETUP packet from the host.                              */
  __IOM uint32_t  SETUP_PACKET_HIGH;            /*!< Bytes 4-7 of the setup packet from the host.                              */
  __IOM uint32_t  EP1_IN_CONTROL;               /*!< EP1_IN_CONTROL                                                            */
  __IOM uint32_t  EP1_OUT_CONTROL;              /*!< EP1_OUT_CONTROL                                                           */
  __IOM uint32_t  EP2_IN_CONTROL;               /*!< EP2_IN_CONTROL                                                            */
  __IOM uint32_t  EP2_OUT_CONTROL;              /*!< EP2_OUT_CONTROL                                                           */
  __IOM uint32_t  EP3_IN_CONTROL;               /*!< EP3_IN_CONTROL                                                            */
  __IOM uint32_t  EP3_OUT_CONTROL;              /*!< EP3_OUT_CONTROL                                                           */
  __IOM uint32_t  EP4_IN_CONTROL;               /*!< EP4_IN_CONTROL                                                            */
  __IOM uint32_t  EP4_OUT_CONTROL;              /*!< EP4_OUT_CONTROL                                                           */
  __IOM uint32_t  EP5_IN_CONTROL;               /*!< EP5_IN_CONTROL                                                            */
  __IOM uint32_t  EP5_OUT_CONTROL;              /*!< EP5_OUT_CONTROL                                                           */
  __IOM uint32_t  EP6_IN_CONTROL;               /*!< EP6_IN_CONTROL                                                            */
  __IOM uint32_t  EP6_OUT_CONTROL;              /*!< EP6_OUT_CONTROL                                                           */
  __IOM uint32_t  EP7_IN_CONTROL;               /*!< EP7_IN_CONTROL                                                            */
  __IOM uint32_t  EP7_OUT_CONTROL;              /*!< EP7_OUT_CONTROL                                                           */
  __IOM uint32_t  EP8_IN_CONTROL;               /*!< EP8_IN_CONTROL                                                            */
  __IOM uint32_t  EP8_OUT_CONTROL;              /*!< EP8_OUT_CONTROL                                                           */
  __IOM uint32_t  EP9_IN_CONTROL;               /*!< EP9_IN_CONTROL                                                            */
  __IOM uint32_t  EP9_OUT_CONTROL;              /*!< EP9_OUT_CONTROL                                                           */
  __IOM uint32_t  EP10_IN_CONTROL;              /*!< EP10_IN_CONTROL                                                           */
  __IOM uint32_t  EP10_OUT_CONTROL;             /*!< EP10_OUT_CONTROL                                                          */
  __IOM uint32_t  EP11_IN_CONTROL;              /*!< EP11_IN_CONTROL                                                           */
  __IOM uint32_t  EP11_OUT_CONTROL;             /*!< EP11_OUT_CONTROL                                                          */
  __IOM uint32_t  EP12_IN_CONTROL;              /*!< EP12_IN_CONTROL                                                           */
  __IOM uint32_t  EP12_OUT_CONTROL;             /*!< EP12_OUT_CONTROL                                                          */
  __IOM uint32_t  EP13_IN_CONTROL;              /*!< EP13_IN_CONTROL                                                           */
  __IOM uint32_t  EP13_OUT_CONTROL;             /*!< EP13_OUT_CONTROL                                                          */
  __IOM uint32_t  EP14_IN_CONTROL;              /*!< EP14_IN_CONTROL                                                           */
  __IOM uint32_t  EP14_OUT_CONTROL;             /*!< EP14_OUT_CONTROL                                                          */
  __IOM uint32_t  EP15_IN_CONTROL;              /*!< EP15_IN_CONTROL                                                           */
  __IOM uint32_t  EP15_OUT_CONTROL;             /*!< EP15_OUT_CONTROL                                                          */
  __IOM uint32_t  EP0_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP0_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP1_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP1_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP2_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP2_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP3_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP3_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP4_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP4_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP5_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP5_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP6_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP6_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP7_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP7_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP8_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP8_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP9_IN_BUFFER_CONTROL;        /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP9_OUT_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP10_IN_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP10_OUT_BUFFER_CONTROL;      /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP11_IN_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP11_OUT_BUFFER_CONTROL;      /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP12_IN_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP12_OUT_BUFFER_CONTROL;      /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP13_IN_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP13_OUT_BUFFER_CONTROL;      /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP14_IN_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP14_OUT_BUFFER_CONTROL;      /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP15_IN_BUFFER_CONTROL;       /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
  __IOM uint32_t  EP15_OUT_BUFFER_CONTROL;      /*!< Buffer control for both buffers of an endpoint. Fields ending
                                                     in a _1 are for buffer 1. Fields ending in a _0 are for
                                                     buffer 0. Buffer 1 controls are only valid if the endpoint
                                                     is in double buffered mode.                                               */
} USB_DPRAM_Type;                               /*!< Size = 256 (0x100)                                                        */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#if 0
#define RESETS_BASE                 0x40020000UL
#define PSM_BASE                    0x40018000UL
#define CLOCKS_BASE                 0x40010000UL
#define TICKS_BASE                  0x40108000UL
#define PADS_BANK0_BASE             0x40038000UL
#define PADS_QSPI_BASE              0x40040000UL
#define IO_QSPI_BASE                0x40030000UL
#define IO_BANK0_BASE               0x40028000UL
#define SYSINFO_BASE                0x40000000UL
#define SHA256_BASE                 0x400F8000UL
#define HSTX_FIFO_BASE              0x50600000UL
#define HSTX_CTRL_BASE              0x400C0000UL
#define EPPB_BASE                   0xE0080000UL
#define PPB_BASE                    0xE0000000UL
#define PPB_NS_BASE                 0xE0020000UL
#define QMI_BASE                    0x400D0000UL
#define XIP_CTRL_BASE               0x400C8000UL
#define XIP_AUX_BASE                0x50500000UL
#define SYSCFG_BASE                 0x40008000UL
#define XOSC_BASE                   0x40048000UL
#define PLL_SYS_BASE                0x40050000UL
#define PLL_USB_BASE                0x40058000UL
#define ACCESSCTRL_BASE             0x40060000UL
#define UART0_BASE                  0x40070000UL
#define UART1_BASE                  0x40078000UL
#define ROSC_BASE                   0x400E8000UL
#define POWMAN_BASE                 0x40100000UL
#define WATCHDOG_BASE               0x400D8000UL
#define DMA_BASE                    0x50000000UL
#define TIMER0_BASE                 0x400B0000UL
#define TIMER1_BASE                 0x400B8000UL
#define PWM_BASE                    0x400A8000UL
#define ADC_BASE                    0x400A0000UL
#define I2C0_BASE                   0x40090000UL
#define I2C1_BASE                   0x40098000UL
#define SPI0_BASE                   0x40080000UL
#define SPI1_BASE                   0x40088000UL
#define PIO0_BASE                   0x50200000UL
#define PIO1_BASE                   0x50300000UL
#define PIO2_BASE                   0x50400000UL
#define BUSCTRL_BASE                0x40068000UL
#define SIO_BASE                    0xD0000000UL
#define SIO_NS_BASE                 0xD0020000UL
#define BOOTRAM_BASE                0x400E0000UL
#define CORESIGHT_TRACE_BASE        0x50700000UL
#define USB_BASE                    0x50110000UL
#define TRNG_BASE                   0x400F0000UL
#define GLITCH_DETECTOR_BASE        0x40158000UL
#define OTP_BASE                    0x40120000UL
#define OTP_DATA_BASE               0x40130000UL
#define OTP_DATA_RAW_BASE           0x40134000UL
#define TBMAN_BASE                  0x40160000UL
#define USB_DPRAM_BASE              0x50100000UL
#endif

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define RESETS                      ((RESETS_Type*)            RESETS_BASE)
#define PSM                         ((PSM_Type*)               PSM_BASE)
#define CLOCKS                      ((CLOCKS_Type*)            CLOCKS_BASE)
#define TICKS                       ((TICKS_Type*)             TICKS_BASE)
#define PADS_BANK0                  ((PADS_BANK0_Type*)        PADS_BANK0_BASE)
#define PADS_QSPI                   ((PADS_QSPI_Type*)         PADS_QSPI_BASE)
#define IO_QSPI                     ((IO_QSPI_Type*)           IO_QSPI_BASE)
#define IO_BANK0                    ((IO_BANK0_Type*)          IO_BANK0_BASE)
#define SYSINFO                     ((SYSINFO_Type*)           SYSINFO_BASE)
#define SHA256                      ((SHA256_Type*)            SHA256_BASE)
#define HSTX_FIFO                   ((HSTX_FIFO_Type*)         HSTX_FIFO_BASE)
#define HSTX_CTRL                   ((HSTX_CTRL_Type*)         HSTX_CTRL_BASE)
#define EPPB                        ((EPPB_Type*)              EPPB_BASE)
#define PPB                         ((PPB_Type*)               PPB_BASE)
#define PPB_NS                      ((PPB_Type*)               PPB_NS_BASE)
#define QMI                         ((QMI_Type*)               QMI_BASE)
#define XIP_CTRL                    ((XIP_CTRL_Type*)          XIP_CTRL_BASE)
#define XIP_AUX                     ((XIP_AUX_Type*)           XIP_AUX_BASE)
#define SYSCFG                      ((SYSCFG_Type*)            SYSCFG_BASE)
#define XOSC                        ((XOSC_Type*)              XOSC_BASE)
#define PLL_SYS                     ((PLL_SYS_Type*)           PLL_SYS_BASE)
#define PLL_USB                     ((PLL_SYS_Type*)           PLL_USB_BASE)
#define ACCESSCTRL                  ((ACCESSCTRL_Type*)        ACCESSCTRL_BASE)
#define UART0                       ((UART0_Type*)             UART0_BASE)
#define UART1                       ((UART0_Type*)             UART1_BASE)
#define ROSC                        ((ROSC_Type*)              ROSC_BASE)
#define POWMAN                      ((POWMAN_Type*)            POWMAN_BASE)
#define WATCHDOG                    ((WATCHDOG_Type*)          WATCHDOG_BASE)
#define DMA                         ((DMA_Type*)               DMA_BASE)
#define TIMER0                      ((TIMER0_Type*)            TIMER0_BASE)
#define TIMER1                      ((TIMER0_Type*)            TIMER1_BASE)
#define PWM                         ((PWM_Type*)               PWM_BASE)
#define ADC                         ((ADC_Type*)               ADC_BASE)
#define I2C0                        ((I2C0_Type*)              I2C0_BASE)
#define I2C1                        ((I2C0_Type*)              I2C1_BASE)
#define SPI0                        ((SPI0_Type*)              SPI0_BASE)
#define SPI1                        ((SPI0_Type*)              SPI1_BASE)
#define PIO0                        ((PIO0_Type*)              PIO0_BASE)
#define PIO1                        ((PIO0_Type*)              PIO1_BASE)
#define PIO2                        ((PIO0_Type*)              PIO2_BASE)
#define BUSCTRL                     ((BUSCTRL_Type*)           BUSCTRL_BASE)
#define SIO                         ((SIO_Type*)               SIO_BASE)
#define SIO_NS                      ((SIO_Type*)               SIO_NS_BASE)
#define BOOTRAM                     ((BOOTRAM_Type*)           BOOTRAM_BASE)
#define CORESIGHT_TRACE             ((CORESIGHT_TRACE_Type*)   CORESIGHT_TRACE_BASE)
#define USB                         ((USB_Type*)               USB_BASE)
#define TRNG                        ((TRNG_Type*)              TRNG_BASE)
#define GLITCH_DETECTOR             ((GLITCH_DETECTOR_Type*)   GLITCH_DETECTOR_BASE)
#define OTP                         ((OTP_Type*)               OTP_BASE)
#define OTP_DATA                    ((OTP_DATA_Type*)          OTP_DATA_BASE)
#define OTP_DATA_RAW                ((OTP_DATA_RAW_Type*)      OTP_DATA_RAW_BASE)
#define TBMAN                       ((TBMAN_Type*)             TBMAN_BASE)
#define USB_DPRAM                   ((USB_DPRAM_Type*)         USB_DPRAM_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


#ifdef __cplusplus
}
#endif

#endif /* RP2350_H */


/** @} */ /* End of group RP2350 */

/** @} */ /* End of group Raspberry Pi */
