/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

public class GenericQueue {
    private static final int open = 0;
    private static final int closing = 1;
    private static final int closed = 2;
    private int status;
    private Bucket head;
    private Bucket tail;
    private int count;

    private void init() {
        this.head = null;
        this.tail = null;
        this.count = 0;
    }

    public GenericQueue() {
        this.init();
        this.status = 0;
    }

    public void flush() {
        this.init();
    }

    public void close() {
        this.status = 1;
    }

    public synchronized void put(Object object) {
        Bucket bucket = new Bucket(object);
        if (this.tail != null) {
            this.tail.setNext(bucket);
            this.tail = bucket;
        } else {
            this.head = this.tail = bucket;
        }
        ++this.count;
        this.notify();
    }

    public synchronized Object get() {
        Object object = null;
        while ((object = this.tryGet()) == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return object;
    }

    public synchronized Object get(long l) throws InterruptedException {
        if (this.status == 2) {
            return null;
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 + l;
        Object object = null;
        while ((object = this.tryGet()) == null) {
            l2 = System.currentTimeMillis();
            if (l3 <= l2) {
                throw new InterruptedException("Get operation timed out");
            }
            try {
                this.wait(l3 - l2);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return object;
    }

    public Object tryGet() {
        Object object = null;
        if (this.head != null) {
            object = this.head.getContents();
            this.head = this.head.getNext();
            --this.count;
            if (this.head == null) {
                this.tail = null;
                this.count = 0;
            }
        }
        return object;
    }

    public synchronized int getCount() {
        return this.count;
    }

    class Bucket {
        private Bucket next = null;
        private final Object contents;

        public Bucket(Object object) {
            this.contents = object;
        }

        public void setNext(Bucket bucket) {
            this.next = bucket;
        }

        public Bucket getNext() {
            return this.next;
        }

        public Object getContents() {
            return this.contents;
        }
    }
}

