/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.ConfigurationException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.command.script.CommandChain;
import schemacrawler.tools.command.script.GraalScriptExecutor;
import schemacrawler.tools.command.script.ScriptExecutor;
import schemacrawler.tools.command.script.options.ScriptLanguageType;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import us.fatehi.utility.ioresource.InputResource;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public final class ScriptCommand
extends BaseSchemaCrawlerCommand<ScriptOptions> {
    private static final Logger LOGGER = Logger.getLogger(ScriptCommand.class.getName());
    static final PropertyName COMMAND = new PropertyName("script", "Process a script file, such as JavaScript, against the database schema");
    private ScriptExecutor scriptExecutor;

    public ScriptCommand() {
        super(COMMAND);
    }

    public void checkAvailability() {
        ((ScriptOptions)this.commandOptions).createInputResource().orElseThrow(() -> new ConfigurationException("Script not found <%s>".formatted(((ScriptOptions)this.commandOptions).getScript())));
        ScriptLanguageType scriptingLanguage = (ScriptLanguageType)((ScriptOptions)this.commandOptions).getLanguage();
        if (scriptingLanguage == null || scriptingLanguage == ScriptLanguageType.unknown) {
            throw new InternalRuntimeException("Unknown scripting language");
        }
        this.scriptExecutor = new GraalScriptExecutor(scriptingLanguage);
        if (this.scriptExecutor.canGenerate()) {
            LOGGER.log(Level.CONFIG, "Loaded Graal Polyglot script executor");
            return;
        }
        throw new InternalRuntimeException("Scripting engine not found for language <%s>".formatted(scriptingLanguage));
    }

    public void execute() {
        Objects.requireNonNull((ScriptOptions)this.commandOptions, "No script language provided");
        this.checkCatalog();
        Objects.requireNonNull(this.scriptExecutor, "Scripting engine not found");
        try {
            Charset inputCharset = this.outputOptions.getInputCharset();
            InputResource inputResource = ((ScriptOptions)this.commandOptions).createInputResource().get();
            try (BufferedReader reader = inputResource.openNewInputReader(inputCharset);
                 PrintWriter writer = this.outputOptions.openNewOutputWriter();){
                LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Evaluating script, %s", new Object[]{inputResource}));
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("title", this.outputOptions.getTitle());
                context.put("catalog", this.catalog);
                context.put("connection", this.connection);
                context.put("chain", (Object)new CommandChain(this));
                this.scriptExecutor.initialize(context, reader, writer);
                this.scriptExecutor.run();
            }
        }
        catch (Exception e) {
            throw new InternalRuntimeException("Could not execute script", (Throwable)e);
        }
    }

    public boolean usesConnection() {
        return true;
    }
}

