/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.opensearch.ml.common.agent.MLToolSpec;
import org.opensearch.ml.common.conversation.Interaction;

public class ContextManagerContext {
    private Map<String, Object> invocationState;
    private String systemPrompt;
    private List<Interaction> chatHistory;
    private String userPrompt;
    private List<MLToolSpec> toolConfigs;
    private List<String> toolInteractions;
    private Map<String, String> parameters;

    public int getEstimatedTokenCount() {
        int tokenCount = 0;
        if (this.systemPrompt != null) {
            tokenCount += this.estimateTokens(this.systemPrompt);
        }
        if (this.userPrompt != null) {
            tokenCount += this.estimateTokens(this.userPrompt);
        }
        for (Interaction interaction : this.chatHistory) {
            if (interaction.getInput() != null) {
                tokenCount += this.estimateTokens(interaction.getInput());
            }
            if (interaction.getResponse() == null) continue;
            tokenCount += this.estimateTokens(interaction.getResponse());
        }
        for (String string : this.toolInteractions) {
            tokenCount += this.estimateTokens(string);
        }
        return tokenCount;
    }

    public int getMessageCount() {
        return this.chatHistory.size();
    }

    private int estimateTokens(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((double)text.length() / 4.0);
    }

    public void addToolInteraction(String interaction) {
        if (this.toolInteractions == null) {
            this.toolInteractions = new ArrayList<String>();
        }
        this.toolInteractions.add(interaction);
    }

    public void addChatHistoryInteraction(Interaction interaction) {
        if (this.chatHistory == null) {
            this.chatHistory = new ArrayList<Interaction>();
        }
        this.chatHistory.add(interaction);
    }

    public void clearChatHistory() {
        if (this.chatHistory != null) {
            this.chatHistory.clear();
        }
    }

    public Object getParameter(String key) {
        return this.parameters != null ? this.parameters.get(key) : null;
    }

    public void setParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, String>();
        }
        this.parameters.put(key, value);
    }

    @Generated
    private static List<Interaction> $default$chatHistory() {
        return new ArrayList<Interaction>();
    }

    @Generated
    private static List<MLToolSpec> $default$toolConfigs() {
        return new ArrayList<MLToolSpec>();
    }

    @Generated
    private static List<String> $default$toolInteractions() {
        return new ArrayList<String>();
    }

    @Generated
    private static Map<String, String> $default$parameters() {
        return new HashMap<String, String>();
    }

    @Generated
    public static ContextManagerContextBuilder builder() {
        return new ContextManagerContextBuilder();
    }

    @Generated
    public Map<String, Object> getInvocationState() {
        return this.invocationState;
    }

    @Generated
    public String getSystemPrompt() {
        return this.systemPrompt;
    }

    @Generated
    public List<Interaction> getChatHistory() {
        return this.chatHistory;
    }

    @Generated
    public String getUserPrompt() {
        return this.userPrompt;
    }

    @Generated
    public List<MLToolSpec> getToolConfigs() {
        return this.toolConfigs;
    }

    @Generated
    public List<String> getToolInteractions() {
        return this.toolInteractions;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public void setInvocationState(Map<String, Object> invocationState) {
        this.invocationState = invocationState;
    }

    @Generated
    public void setSystemPrompt(String systemPrompt) {
        this.systemPrompt = systemPrompt;
    }

    @Generated
    public void setChatHistory(List<Interaction> chatHistory) {
        this.chatHistory = chatHistory;
    }

    @Generated
    public void setUserPrompt(String userPrompt) {
        this.userPrompt = userPrompt;
    }

    @Generated
    public void setToolConfigs(List<MLToolSpec> toolConfigs) {
        this.toolConfigs = toolConfigs;
    }

    @Generated
    public void setToolInteractions(List<String> toolInteractions) {
        this.toolInteractions = toolInteractions;
    }

    @Generated
    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextManagerContext)) {
            return false;
        }
        ContextManagerContext other = (ContextManagerContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$invocationState = this.getInvocationState();
        Map<String, Object> other$invocationState = other.getInvocationState();
        if (this$invocationState == null ? other$invocationState != null : !((Object)this$invocationState).equals(other$invocationState)) {
            return false;
        }
        String this$systemPrompt = this.getSystemPrompt();
        String other$systemPrompt = other.getSystemPrompt();
        if (this$systemPrompt == null ? other$systemPrompt != null : !this$systemPrompt.equals(other$systemPrompt)) {
            return false;
        }
        List<Interaction> this$chatHistory = this.getChatHistory();
        List<Interaction> other$chatHistory = other.getChatHistory();
        if (this$chatHistory == null ? other$chatHistory != null : !((Object)this$chatHistory).equals(other$chatHistory)) {
            return false;
        }
        String this$userPrompt = this.getUserPrompt();
        String other$userPrompt = other.getUserPrompt();
        if (this$userPrompt == null ? other$userPrompt != null : !this$userPrompt.equals(other$userPrompt)) {
            return false;
        }
        List<MLToolSpec> this$toolConfigs = this.getToolConfigs();
        List<MLToolSpec> other$toolConfigs = other.getToolConfigs();
        if (this$toolConfigs == null ? other$toolConfigs != null : !((Object)this$toolConfigs).equals(other$toolConfigs)) {
            return false;
        }
        List<String> this$toolInteractions = this.getToolInteractions();
        List<String> other$toolInteractions = other.getToolInteractions();
        if (this$toolInteractions == null ? other$toolInteractions != null : !((Object)this$toolInteractions).equals(other$toolInteractions)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContextManagerContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $invocationState = this.getInvocationState();
        result = result * 59 + ($invocationState == null ? 43 : ((Object)$invocationState).hashCode());
        String $systemPrompt = this.getSystemPrompt();
        result = result * 59 + ($systemPrompt == null ? 43 : $systemPrompt.hashCode());
        List<Interaction> $chatHistory = this.getChatHistory();
        result = result * 59 + ($chatHistory == null ? 43 : ((Object)$chatHistory).hashCode());
        String $userPrompt = this.getUserPrompt();
        result = result * 59 + ($userPrompt == null ? 43 : $userPrompt.hashCode());
        List<MLToolSpec> $toolConfigs = this.getToolConfigs();
        result = result * 59 + ($toolConfigs == null ? 43 : ((Object)$toolConfigs).hashCode());
        List<String> $toolInteractions = this.getToolInteractions();
        result = result * 59 + ($toolInteractions == null ? 43 : ((Object)$toolInteractions).hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContextManagerContext(invocationState=" + String.valueOf(this.getInvocationState()) + ", systemPrompt=" + this.getSystemPrompt() + ", chatHistory=" + String.valueOf(this.getChatHistory()) + ", userPrompt=" + this.getUserPrompt() + ", toolConfigs=" + String.valueOf(this.getToolConfigs()) + ", toolInteractions=" + String.valueOf(this.getToolInteractions()) + ", parameters=" + String.valueOf(this.getParameters()) + ")";
    }

    @Generated
    public ContextManagerContext() {
        this.chatHistory = ContextManagerContext.$default$chatHistory();
        this.toolConfigs = ContextManagerContext.$default$toolConfigs();
        this.toolInteractions = ContextManagerContext.$default$toolInteractions();
        this.parameters = ContextManagerContext.$default$parameters();
    }

    @Generated
    public ContextManagerContext(Map<String, Object> invocationState, String systemPrompt, List<Interaction> chatHistory, String userPrompt, List<MLToolSpec> toolConfigs, List<String> toolInteractions, Map<String, String> parameters) {
        this.invocationState = invocationState;
        this.systemPrompt = systemPrompt;
        this.chatHistory = chatHistory;
        this.userPrompt = userPrompt;
        this.toolConfigs = toolConfigs;
        this.toolInteractions = toolInteractions;
        this.parameters = parameters;
    }

    @Generated
    public static class ContextManagerContextBuilder {
        @Generated
        private Map<String, Object> invocationState;
        @Generated
        private String systemPrompt;
        @Generated
        private boolean chatHistory$set;
        @Generated
        private List<Interaction> chatHistory$value;
        @Generated
        private String userPrompt;
        @Generated
        private boolean toolConfigs$set;
        @Generated
        private List<MLToolSpec> toolConfigs$value;
        @Generated
        private boolean toolInteractions$set;
        @Generated
        private List<String> toolInteractions$value;
        @Generated
        private boolean parameters$set;
        @Generated
        private Map<String, String> parameters$value;

        @Generated
        ContextManagerContextBuilder() {
        }

        @Generated
        public ContextManagerContextBuilder invocationState(Map<String, Object> invocationState) {
            this.invocationState = invocationState;
            return this;
        }

        @Generated
        public ContextManagerContextBuilder systemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
            return this;
        }

        @Generated
        public ContextManagerContextBuilder chatHistory(List<Interaction> chatHistory) {
            this.chatHistory$value = chatHistory;
            this.chatHistory$set = true;
            return this;
        }

        @Generated
        public ContextManagerContextBuilder userPrompt(String userPrompt) {
            this.userPrompt = userPrompt;
            return this;
        }

        @Generated
        public ContextManagerContextBuilder toolConfigs(List<MLToolSpec> toolConfigs) {
            this.toolConfigs$value = toolConfigs;
            this.toolConfigs$set = true;
            return this;
        }

        @Generated
        public ContextManagerContextBuilder toolInteractions(List<String> toolInteractions) {
            this.toolInteractions$value = toolInteractions;
            this.toolInteractions$set = true;
            return this;
        }

        @Generated
        public ContextManagerContextBuilder parameters(Map<String, String> parameters) {
            this.parameters$value = parameters;
            this.parameters$set = true;
            return this;
        }

        @Generated
        public ContextManagerContext build() {
            List<Interaction> chatHistory$value = this.chatHistory$value;
            if (!this.chatHistory$set) {
                chatHistory$value = ContextManagerContext.$default$chatHistory();
            }
            List<MLToolSpec> toolConfigs$value = this.toolConfigs$value;
            if (!this.toolConfigs$set) {
                toolConfigs$value = ContextManagerContext.$default$toolConfigs();
            }
            List<String> toolInteractions$value = this.toolInteractions$value;
            if (!this.toolInteractions$set) {
                toolInteractions$value = ContextManagerContext.$default$toolInteractions();
            }
            Map<String, String> parameters$value = this.parameters$value;
            if (!this.parameters$set) {
                parameters$value = ContextManagerContext.$default$parameters();
            }
            return new ContextManagerContext(this.invocationState, this.systemPrompt, chatHistory$value, this.userPrompt, toolConfigs$value, toolInteractions$value, parameters$value);
        }

        @Generated
        public String toString() {
            return "ContextManagerContext.ContextManagerContextBuilder(invocationState=" + String.valueOf(this.invocationState) + ", systemPrompt=" + this.systemPrompt + ", chatHistory$value=" + String.valueOf(this.chatHistory$value) + ", userPrompt=" + this.userPrompt + ", toolConfigs$value=" + String.valueOf(this.toolConfigs$value) + ", toolInteractions$value=" + String.valueOf(this.toolInteractions$value) + ", parameters$value=" + String.valueOf(this.parameters$value) + ")";
        }
    }
}

