/*
 * Decompiled with CFR 0.152.
 */
package org.cryptacular.bean;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.cryptacular.CryptUtil;
import org.cryptacular.CryptoException;
import org.cryptacular.StreamException;
import org.cryptacular.bean.FactoryBean;
import org.cryptacular.io.Resource;

public class KeyStoreFactoryBean
implements FactoryBean<KeyStore> {
    public static final String DEFAULT_TYPE = "JCEKS";
    private final String type;
    private final Resource resource;
    private final String password;

    public KeyStoreFactoryBean(Resource resource, String password) {
        this(resource, DEFAULT_TYPE, password);
    }

    public KeyStoreFactoryBean(Resource resource, String type, String password) {
        this.resource = CryptUtil.assertNotNullArg(resource, "Resource cannot be null");
        this.type = CryptUtil.assertNotNullArg(type, "Type cannot be null");
        this.password = password;
    }

    public String getType() {
        return this.type;
    }

    public Resource getResource() {
        return this.resource;
    }

    @Override
    public KeyStore newInstance() {
        KeyStore store;
        if (this.resource == null) {
            throw new IllegalStateException("Must provide resource.");
        }
        try {
            store = KeyStore.getInstance(this.type);
        }
        catch (KeyStoreException e) {
            String message = "Unsupported keystore type " + this.type;
            if ("BKS".equalsIgnoreCase(this.type)) {
                message = message + ". Is BC provider installed?";
            }
            throw new CryptoException(message, e);
        }
        try {
            store.load(this.resource.getInputStream(), this.password.toCharArray());
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new CryptoException("Error loading keystore", e);
        }
        catch (IOException e) {
            throw new StreamException(e);
        }
        return store;
    }
}

