/*
 * Decompiled with CFR 0.152.
 */
package StructuredEncryptionHeader_Compile;

import BoundedInts_Compile.uint64;
import BoundedInts_Compile.uint8;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKey;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKeyList;
import StructuredEncryptionHeader_Compile.CMPEncryptedDataKeyListEmptyOK;
import StructuredEncryptionHeader_Compile.CMPEncryptionContext;
import StructuredEncryptionHeader_Compile.CMPUtf8Bytes;
import StructuredEncryptionHeader_Compile.Legend;
import StructuredEncryptionHeader_Compile.LegendByte;
import StructuredEncryptionHeader_Compile.PartialHeader;
import StructuredEncryptionUtil_Compile.CanonCryptoItem;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Function0;
import dafny.Function2;
import dafny.Helpers;
import dafny.Tuple2;
import dafny.Tuple3;
import dafny.TypeDescriptor;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.CryptoAction;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.HMacInput;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class __default {
    public static boolean ValidVersion(byte x) {
        return x == 1 || x == 2;
    }

    public static boolean IsVersion2Schema(DafnySequence<? extends CanonCryptoItem> data, int pos) {
        while (pos != data.cardinalityInt()) {
            if (Objects.equals(((CanonCryptoItem)data.select(pos)).dtor_action(), CryptoAction.create_SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT())) {
                return true;
            }
            DafnySequence<? extends CanonCryptoItem> _in0 = data;
            int _in1 = pos + 1;
            data = _in0;
            pos = _in1;
        }
        return false;
    }

    public static byte VersionFromSchema(DafnySequence<? extends CanonCryptoItem> data) {
        if (__default.IsVersion2Schema(data, 0)) {
            return 2;
        }
        return 1;
    }

    public static boolean ValidFlavor(byte x) {
        return DafnySequence.of((byte[])new byte[]{0, 1}).contains((Object)x);
    }

    public static boolean ValidLegendByte(byte x) {
        return DafnySequence.of((byte[])new byte[]{__default.ENCRYPT__AND__SIGN__LEGEND(), __default.SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT__LEGEND(), __default.SIGN__ONLY__LEGEND()}).contains((Object)x);
    }

    public static boolean ValidEncryptionContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        return Long.compareUnsigned(x.cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0 && ((Function<DafnyMap, Boolean>)_0_x -> Helpers.Quantifier((Iterable)_0_x.keySet().Elements(), (boolean)true, _forall_var_0_boxed0 -> {
            DafnySequence _forall_var_0 = _forall_var_0_boxed0;
            DafnySequence _1_k = _forall_var_0;
            return !_0_x.contains((Object)_1_k) || Long.compareUnsigned(_1_k.cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0 && Long.compareUnsigned(((DafnySequence)_0_x.get((Object)_1_k)).cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0;
        })).apply(x) != false;
    }

    public static boolean ValidEncryptedDataKey(EncryptedDataKey x) {
        return Long.compareUnsigned(x.dtor_keyProviderId().cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0 && Long.compareUnsigned(x.dtor_keyProviderInfo().cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0 && Long.compareUnsigned(x.dtor_ciphertext().cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0;
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Serialize(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, PartialHeader PartialHeader2) {
        DafnySequence<? extends Byte> _0_body = PartialHeader2.serialize();
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _1_valueOrError0 = __default.CalculateHeaderCommitment(client, alg, commitKey, _0_body);
        if (_1_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
        }
        DafnySequence _2_commitment = (DafnySequence)_1_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)DafnySequence.concatenate(_0_body, (DafnySequence)_2_commitment));
    }

    public static Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> Create(DafnySequence<? extends Character> tableName, DafnySequence<? extends CanonCryptoItem> schema, DafnySequence<? extends Byte> msgID, EncryptionMaterials mat) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(schema.cardinalityInt(), StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT().longValue()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected large schema")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _1_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidEncryptionContext((DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)mat.dtor_encryptionContext()), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Encryption Context")));
        if (_1_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _2_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((long)mat.dtor_encryptedDataKeys().cardinalityInt() != 0L ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"There must be at least one data key")));
        if (_2_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _3_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(mat.dtor_encryptedDataKeys().cardinalityInt(), __default.UINT8__LIMIT64()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too many data keys.")));
        if (_3_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _4_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Function<EncryptionMaterials, Boolean>)_5_mat -> Helpers.Quantifier((Iterable)_5_mat.dtor_encryptedDataKeys().UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            EncryptedDataKey _forall_var_0;
            EncryptedDataKey _6_x = _forall_var_0 = _forall_var_0_boxed0;
            return !_5_mat.dtor_encryptedDataKeys().contains((Object)_6_x) || __default.ValidEncryptedDataKey(_6_x);
        })).apply(mat), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Data Key")));
        if (_4_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _7_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((long)mat.dtor_algorithmSuite().dtor_binaryId().cardinalityInt() == 2L ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Algorithm Suite Binary ID")));
        if (_7_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _7_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _8_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), ((Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(0) == StructuredEncryptionUtil_Compile.__default.DbeAlgorithmFamily() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Algorithm Suite not suitable for structured encryption.")));
        if (_8_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _8_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _9_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidFlavor((Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(1)), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Algorithm Suite has unexpected flavor.")));
        if (_9_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _9_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _10_valueOrError8 = __default.MakeLegend(schema);
        if (_10_valueOrError8.IsFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _10_valueOrError8.PropagateFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        DafnySequence _11_legend = (DafnySequence)_10_valueOrError8.Extract(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnyMap _12_storedEC = ((Function<EncryptionMaterials, DafnyMap>)_13_mat -> (DafnyMap)((Function0)() -> {
            HashMap<DafnySequence, DafnySequence> _coll0 = new HashMap<DafnySequence, DafnySequence>();
            for (DafnySequence _compr_0_boxed0 : _13_mat.dtor_encryptionContext().keySet().Elements()) {
                DafnySequence _compr_0 = _compr_0_boxed0;
                DafnySequence _14_k = _compr_0;
                if (!ValidUTF8Bytes._Is((DafnySequence)_14_k) || !_13_mat.dtor_encryptionContext().contains((Object)_14_k) || _13_mat.dtor_requiredEncryptionContextKeys().contains((Object)_14_k)) continue;
                _coll0.put(_14_k, (DafnySequence)_13_mat.dtor_encryptionContext().get((Object)_14_k));
            }
            return new DafnyMap(_coll0);
        }).apply()).apply(mat);
        Outcome _15_valueOrError9 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidEncryptionContext((DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_12_storedEC), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Encryption Context")));
        if (_15_valueOrError9.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _15_valueOrError9.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        return Result.create_Success(PartialHeader._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)PartialHeader.create(__default.VersionFromSchema(schema), (Byte)mat.dtor_algorithmSuite().dtor_binaryId().select(1), msgID, (DafnySequence<? extends Byte>)_11_legend, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_12_storedEC, (DafnySequence<? extends EncryptedDataKey>)mat.dtor_encryptedDataKeys()));
    }

    public static Result<PartialHeader, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> PartialDeserialize(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(__default.PREFIX__LEN64(), data.cardinalityInt()) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Serialized PartialHeader too short.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        byte _1_version = (Byte)data.select(0);
        Outcome _2_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidVersion(_1_version), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Version Number")));
        if (_2_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        byte _3_flavor = (Byte)data.select(1);
        Outcome _4_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.ValidFlavor(_3_flavor), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Flavor")));
        if (_4_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        DafnySequence _5_msgID = data.subsequence(2, Helpers.unsignedToInt((long)__default.PREFIX__LEN64()));
        DafnySequence _6_legendData = data.drop(__default.PREFIX__LEN64());
        Result<Tuple2<DafnySequence<? extends Byte>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _7_valueOrError3 = __default.GetLegend((DafnySequence<? extends Byte>)_6_legendData);
        if (_7_valueOrError3.IsFailure(Tuple2._typeDescriptor(Legend._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _7_valueOrError3.PropagateFailure(Tuple2._typeDescriptor(Legend._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _8_legendAndLen = (Tuple2)_7_valueOrError3.Extract(Tuple2._typeDescriptor(Legend._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnySequence _9_legend = (DafnySequence)_8_legendAndLen.dtor__0();
        DafnySequence _10_contextData = _6_legendData.drop(((Long)_8_legendAndLen.dtor__1()).longValue());
        Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _11_valueOrError4 = __default.GetContext((DafnySequence<? extends Byte>)_10_contextData);
        if (_11_valueOrError4.IsFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _11_valueOrError4.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _12_contextAndLen = (Tuple2)_11_valueOrError4.Extract(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnyMap _13_encContext = (DafnyMap)_12_contextAndLen.dtor__0();
        DafnySequence _14_keysData = _10_contextData.drop(((Long)_12_contextAndLen.dtor__1()).longValue());
        Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _15_valueOrError5 = __default.GetDataKeys((DafnySequence<? extends Byte>)_14_keysData);
        if (_15_valueOrError5.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _15_valueOrError5.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Tuple2 _16_keysAndLen = (Tuple2)_15_valueOrError5.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKeyList._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        DafnySequence _17_dataKeys = (DafnySequence)_16_keysAndLen.dtor__0();
        DafnySequence _18_trailingData = _14_keysData.drop(((Long)_16_keysAndLen.dtor__1()).longValue());
        Outcome _19_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(_18_trailingData.cardinalityInt(), __default.COMMITMENT__LEN64()) >= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid header serialization: unexpected end of data.")));
        if (_19_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _19_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        Outcome _20_valueOrError7 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(_18_trailingData.cardinalityInt(), __default.COMMITMENT__LEN64()) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid header serialization: unexpected bytes.")));
        if (_20_valueOrError7.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _20_valueOrError7.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), PartialHeader._typeDescriptor());
        }
        return Result.create_Success(PartialHeader._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)PartialHeader.create(_1_version, _3_flavor, (DafnySequence<? extends Byte>)_5_msgID, (DafnySequence<? extends Byte>)_9_legend, (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)_13_encContext, (DafnySequence<? extends EncryptedDataKey>)_17_dataKeys));
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> CalculateHeaderCommitment(IAwsCryptographicPrimitivesClient client, AlgorithmSuiteInfo alg, DafnySequence<? extends Byte> commitKey, DafnySequence<? extends Byte> data) {
        HMacInput _0_input = HMacInput.create((DigestAlgorithm)alg.dtor_commitment().dtor_HKDF().dtor_hmac(), commitKey, data);
        Result _1_outputR = client.HMac(_0_input);
        Result _2_valueOrError0 = _1_outputR.MapFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), _3_e_boxed0 -> {
            Error _3_e = _3_e_boxed0;
            return software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error.create_AwsCryptographyPrimitives(_3_e);
        });
        if (_2_valueOrError0.IsFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError0.PropagateFailure(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()));
        }
        DafnySequence _4_output = (DafnySequence)_2_valueOrError0.Extract(DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if (Long.compareUnsigned(_4_output.cardinalityInt(), __default.COMMITMENT__LEN64()) < 0) {
            return Result.create_Failure((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"HMAC did not produce enough bits")));
        }
        return Result.create_Success((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_4_output.take(__default.COMMITMENT__LEN64()));
    }

    public static <__X, __Y, __Z> DafnyMap<? extends __Y, ? extends __Z> MyMap(TypeDescriptor<__X> _td___X, TypeDescriptor<__Y> _td___Y, TypeDescriptor<__Z> _td___Z, Function<__X, __Y> f, DafnyMap<? extends __X, ? extends __Z> m) {
        return (DafnyMap)((Function2)(_0_m, _1_f) -> (DafnyMap)((Function0)() -> {
            HashMap _coll0 = new HashMap();
            for (Object _compr_0_boxed0 : _0_m.keySet().Elements()) {
                Object _compr_0 = _compr_0_boxed0;
                Object _2_k = _compr_0;
                if (!_0_m.contains(_2_k)) continue;
                _coll0.put(_1_f.apply(_2_k), _0_m.get(_2_k));
            }
            return new DafnyMap(_coll0);
        }).apply()).apply(m, f);
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend(DafnySequence<? extends CanonCryptoItem> schema) {
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _0_valueOrError0 = __default.MakeLegend2(schema, 0L, __default.EmptyLegend());
        if (_0_valueOrError0.IsFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
        }
        DafnySequence _1_legend = (DafnySequence)_0_valueOrError0.Extract(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        long _2_authCount = __default.CountAuthAttrs(schema, 0L, 0L);
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (_2_authCount == (long)_1_legend.cardinalityInt() ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Internal Error : bad legend calculation.")));
        if (_3_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
        }
        return Result.create_Success(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_1_legend);
    }

    public static Result<DafnySequence<? extends Byte>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> MakeLegend2(DafnySequence<? extends CanonCryptoItem> data, long pos, DafnySequence<? extends Byte> serialized) {
        while ((long)data.cardinalityInt() != pos) {
            if (StructuredEncryptionUtil_Compile.__default.IsAuthAttr(((CanonCryptoItem)data.select(Helpers.unsignedToInt((long)pos))).dtor_action())) {
                Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned((long)serialized.cardinalityInt() + 1L, StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Legend Too Long.")));
                if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                    return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Legend._typeDescriptor());
                }
                byte _1_legendChar = __default.GetActionLegend(((CanonCryptoItem)data.select(Helpers.unsignedToInt((long)pos))).dtor_action());
                DafnySequence<? extends CanonCryptoItem> _in0 = data;
                long _in1 = pos + 1L;
                DafnySequence _in2 = DafnySequence.concatenate(serialized, (DafnySequence)DafnySequence.of((byte[])new byte[]{_1_legendChar}));
                data = _in0;
                pos = _in1;
                serialized = _in2;
                continue;
            }
            DafnySequence<? extends CanonCryptoItem> _in3 = data;
            long _in4 = pos + 1L;
            DafnySequence _in5 = serialized;
            data = _in3;
            pos = _in4;
            serialized = _in5;
        }
        return Result.create_Success(Legend._typeDescriptor(), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), serialized);
    }

    public static byte GetActionLegend(CryptoAction x) {
        CryptoAction _source0 = x;
        if (_source0.is_ENCRYPT__AND__SIGN()) {
            return __default.ENCRYPT__AND__SIGN__LEGEND();
        }
        if (_source0.is_SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT()) {
            return __default.SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT__LEGEND();
        }
        return __default.SIGN__ONLY__LEGEND();
    }

    public static long CountAuthAttrs(DafnySequence<? extends CanonCryptoItem> data, long pos, long acc) {
        while ((long)data.cardinalityInt() != pos) {
            if (StructuredEncryptionUtil_Compile.__default.IsAuthAttr(((CanonCryptoItem)data.select(Helpers.unsignedToInt((long)pos))).dtor_action())) {
                DafnySequence<? extends CanonCryptoItem> _in0 = data;
                long _in1 = pos + 1L;
                long _in2 = StandardLibrary_mMemoryMath_Compile.__default.Add((long)acc, (long)1L);
                data = _in0;
                pos = _in1;
                acc = _in2;
                continue;
            }
            DafnySequence<? extends CanonCryptoItem> _in3 = data;
            long _in4 = pos + 1L;
            long _in5 = acc;
            data = _in3;
            pos = _in4;
            acc = _in5;
        }
        return acc;
    }

    public static DafnySequence<? extends Byte> SerializeLegend(DafnySequence<? extends Byte> x) {
        return DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)x.cardinalityInt())), x);
    }

    public static Result<Tuple2<DafnySequence<? extends Byte>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetLegend(DafnySequence<? extends Byte> data) {
        long _0_data__size = data.cardinalityInt();
        Outcome _1_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(2L, _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_1_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _2_len = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)0L));
        long _3_size = StandardLibrary_mMemoryMath_Compile.__default.Add((long)_2_len, (long)2L);
        Outcome _4_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(_3_size, _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_4_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _4_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        DafnySequence _5_legend = data.subsequence(2, Helpers.unsignedToInt((long)_3_size));
        Outcome _6_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)((Function<DafnySequence, Boolean>)_7_legend -> Helpers.Quantifier((Iterable)_7_legend.UniqueElements(), (boolean)true, _forall_var_0_boxed0 -> {
            byte _forall_var_0 = _forall_var_0_boxed0;
            byte _8_x = _forall_var_0;
            return !_7_legend.contains((Object)_8_x) || __default.ValidLegendByte(_8_x);
        })).apply(_5_legend), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid byte in stored legend")));
        if (_6_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _6_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)Tuple2.create((Object)_5_legend, (Object)_3_size));
    }

    public static Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext(DafnySequence<? extends Byte> data) {
        long _0_data__size = data.cardinalityInt();
        Outcome _1_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(2L, _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_1_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _2_count = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)0L));
        Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _3_valueOrError1 = __default.GetContext2(_2_count, data, (Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, Long>)Tuple2.create((Object)DafnyMap.fromElements((Tuple2[])new Tuple2[0]), (Object)2L), (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        if (_3_valueOrError1.IsFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        Tuple2 _4_context = (Tuple2)_3_valueOrError1.Extract(Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_4_context);
    }

    public static Result<Tuple3<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneKVPair(DafnySequence<? extends Byte> data, long pos) {
        long _0_data__size = data.cardinalityInt();
        Outcome _1_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add((long)2L, (long)pos), _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_1_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _2_keyLen = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)pos));
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add3((long)_2_keyLen, (long)4L, (long)pos), _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_3_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        DafnySequence _4_key = data.subsequence(Helpers.unsignedToInt((long)(2L + pos)), Helpers.unsignedToInt((long)StandardLibrary_mMemoryMath_Compile.__default.Add3((long)_2_keyLen, (long)2L, (long)pos)));
        Outcome _5_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_4_key), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_5_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _5_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _6_valueLen = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)StandardLibrary_mMemoryMath_Compile.__default.Add3((long)_2_keyLen, (long)2L, (long)pos)));
        long _7_kvLen = 2L + _2_keyLen + 2L + _6_valueLen;
        Outcome _8_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add((long)_7_kvLen, (long)pos), _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_8_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _8_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        DafnySequence _9_value = data.subsequence(Helpers.unsignedToInt((long)(_2_keyLen + 4L + pos)), Helpers.unsignedToInt((long)(_7_kvLen + pos)));
        Outcome _10_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_9_value), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_10_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _10_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()));
        }
        return Result.create_Success((TypeDescriptor)Tuple3._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)uint8._typeDescriptor()), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)Tuple3.create((Object)_4_key, (Object)_9_value, (Object)_7_kvLen));
    }

    public static boolean BytesLess(DafnySequence<? extends Byte> a, DafnySequence<? extends Byte> b, long pos) {
        while (!a.equals(b)) {
            if ((long)a.cardinalityInt() == pos) {
                return true;
            }
            if ((long)b.cardinalityInt() == pos) {
                return false;
            }
            if (((Byte)a.select(Helpers.unsignedToInt((long)pos))).byteValue() != ((Byte)b.select(Helpers.unsignedToInt((long)pos))).byteValue()) {
                return Integer.compareUnsigned(((Byte)a.select(Helpers.unsignedToInt((long)pos))).byteValue(), ((Byte)b.select(Helpers.unsignedToInt((long)pos))).byteValue()) < 0;
            }
            DafnySequence<? extends Byte> _in0 = a;
            DafnySequence<? extends Byte> _in1 = b;
            long _in2 = pos + 1L;
            a = _in0;
            b = _in1;
            pos = _in2;
        }
        return false;
    }

    public static Result<Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetContext2(long count, DafnySequence<? extends Byte> data, Tuple2<DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>, Long> deserialized, DafnySequence<? extends Byte> prevKey) {
        while (count != 0L) {
            Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned((long)((DafnyMap)deserialized.dtor__0()).cardinalityInt() + 1L, StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT().longValue()) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too much context")));
            if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
            }
            Result<Tuple3<DafnySequence<? extends Byte>, DafnySequence<? extends Byte>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _1_valueOrError1 = __default.GetOneKVPair(data, (Long)deserialized.dtor__1());
            if (_1_valueOrError1.IsFailure(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _1_valueOrError1.PropagateFailure(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
            }
            Tuple3 _2_kv = (Tuple3)_1_valueOrError1.Extract(Tuple3._typeDescriptor(CMPUtf8Bytes._typeDescriptor(), CMPUtf8Bytes._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            Outcome _3_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)__default.BytesLess(prevKey, (DafnySequence<? extends Byte>)((DafnySequence)_2_kv.dtor__0()), 0L), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Context keys out of order.")));
            if (_3_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _3_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
            }
            long _in0 = count - 1L;
            DafnySequence<? extends Byte> _in1 = data;
            Tuple2 _in2 = Tuple2.create((Object)DafnyMap.update((DafnyMap)((DafnyMap)deserialized.dtor__0()), (Object)_2_kv.dtor__0(), (Object)_2_kv.dtor__1()), (Object)StandardLibrary_mMemoryMath_Compile.__default.Add((long)((Long)deserialized.dtor__1()), (long)((Long)_2_kv.dtor__2())));
            DafnySequence _in3 = (DafnySequence)_2_kv.dtor__0();
            count = _in0;
            data = _in1;
            deserialized = _in2;
            prevKey = _in3;
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptionContext._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), deserialized);
    }

    public static DafnySequence<? extends Byte> SerializeContext(DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x) {
        DafnySequence _0_keys = SortedSets.__default.SetToOrderedSequence2((TypeDescriptor)uint8._typeDescriptor(), (DafnySet)x.keySet(), StructuredEncryptionUtil_Compile.__default::ByteLess);
        return DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)x.cardinalityInt())), __default.SerializeContext2((DafnySequence<? extends DafnySequence<? extends Byte>>)_0_keys, x, 0L, (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor())));
    }

    public static DafnySequence<? extends Byte> SerializeOneKVPair(DafnySequence<? extends Byte> key, DafnySequence<? extends Byte> value) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)key.cardinalityInt())), key), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)value.cardinalityInt()))), value);
    }

    public static DafnySequence<? extends Byte> SerializeOneDataKey(EncryptedDataKey k) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_keyProviderId().cardinalityInt())), (DafnySequence)k.dtor_keyProviderId()), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_keyProviderInfo().cardinalityInt()))), (DafnySequence)k.dtor_keyProviderInfo()), (DafnySequence)StandardLibrary_mUInt_Compile.__default.UInt16ToSeq((short)((short)k.dtor_ciphertext().cardinalityInt()))), (DafnySequence)k.dtor_ciphertext());
    }

    public static Result<Tuple2<EncryptedDataKey, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetOneDataKey(DafnySequence<? extends Byte> data, long pos) {
        long _0_data__size = data.cardinalityInt();
        Outcome _1_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add((long)2L, (long)pos), _0_data__size) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_1_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _1_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _2_provIdSize = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)pos));
        Outcome _3_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add3((long)_2_provIdSize, (long)2L, (long)pos), _0_data__size) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_3_valueOrError1.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _3_valueOrError1.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        DafnySequence _4_provId = data.subsequence(Helpers.unsignedToInt((long)(pos + 2L)), Helpers.unsignedToInt((long)(pos + 2L + _2_provIdSize)));
        Outcome _5_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (boolean)UTF8.__default.ValidUTF8Seq((DafnySequence)_4_provId), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid UTF8 found in header.")));
        if (_5_valueOrError2.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _5_valueOrError2.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _6_part1Size = 2L + _2_provIdSize;
        Outcome _7_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add3((long)_6_part1Size, (long)2L, (long)pos), _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_7_valueOrError3.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _7_valueOrError3.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _8_provInfoSize = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)(pos + _6_part1Size)));
        long _9_part2Size = _6_part1Size + 2L + _8_provInfoSize;
        Outcome _10_valueOrError4 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add((long)_9_part2Size, (long)pos), _0_data__size) < 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_10_valueOrError4.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _10_valueOrError4.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        DafnySequence _11_provInfo = data.subsequence(Helpers.unsignedToInt((long)(pos + _6_part1Size + 2L)), Helpers.unsignedToInt((long)(pos + _9_part2Size)));
        Outcome _12_valueOrError5 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add3((long)_9_part2Size, (long)2L, (long)pos), _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_12_valueOrError5.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _12_valueOrError5.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _13_cipherSize = Short.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqPosToUInt16(data, (long)(pos + _9_part2Size)));
        long _14_part3Size = _9_part2Size + 2L + _13_cipherSize;
        Outcome _15_valueOrError6 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(StandardLibrary_mMemoryMath_Compile.__default.Add((long)_14_part3Size, (long)pos), _0_data__size) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_15_valueOrError6.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _15_valueOrError6.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        DafnySequence _16_cipher = data.subsequence(Helpers.unsignedToInt((long)(pos + _9_part2Size + 2L)), Helpers.unsignedToInt((long)(pos + _14_part3Size)));
        EncryptedDataKey _17_edk = EncryptedDataKey.create((DafnySequence)_4_provId, (DafnySequence)_11_provInfo, (DafnySequence)_16_cipher);
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)Tuple2.create((Object)_17_edk, (Object)_14_part3Size));
    }

    public static DafnySequence<? extends Byte> SerializeContext2(DafnySequence<? extends DafnySequence<? extends Byte>> keys, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> x, long pos, DafnySequence<? extends Byte> acc) {
        while ((long)keys.cardinalityInt() != pos) {
            DafnySequence<? extends DafnySequence<? extends Byte>> _in0 = keys;
            DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _in1 = x;
            long _in2 = pos + 1L;
            DafnySequence _in3 = DafnySequence.concatenate(acc, __default.SerializeOneKVPair((DafnySequence<? extends Byte>)((DafnySequence)keys.select(Helpers.unsignedToInt((long)pos))), (DafnySequence<? extends Byte>)((DafnySequence)x.get((Object)((DafnySequence)keys.select(Helpers.unsignedToInt((long)pos)))))));
            keys = _in0;
            x = _in1;
            pos = _in2;
            acc = _in3;
        }
        return acc;
    }

    public static DafnySequence<? extends Byte> SerializeDataKeys(DafnySequence<? extends EncryptedDataKey> x) {
        DafnySequence<? extends Byte> _0_body = __default.SerializeDataKeys2(x, 0L, (DafnySequence<? extends Byte>)DafnySequence.empty((TypeDescriptor)uint8._typeDescriptor()));
        return DafnySequence.concatenate((DafnySequence)DafnySequence.of((byte[])new byte[]{(byte)x.cardinalityInt()}), _0_body);
    }

    public static DafnySequence<? extends Byte> SerializeDataKeys2(DafnySequence<? extends EncryptedDataKey> x, long pos, DafnySequence<? extends Byte> acc) {
        while ((long)x.cardinalityInt() != pos) {
            DafnySequence<? extends EncryptedDataKey> _in0 = x;
            long _in1 = pos + 1L;
            DafnySequence _in2 = DafnySequence.concatenate(acc, __default.SerializeOneDataKey((EncryptedDataKey)x.select(Helpers.unsignedToInt((long)pos))));
            x = _in0;
            pos = _in1;
            acc = _in2;
        }
        return acc;
    }

    public static Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys(DafnySequence<? extends Byte> data) {
        Outcome _0_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Long.compareUnsigned(1L, data.cardinalityInt()) <= 0 ? 1 : 0) != 0, (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected end of header data.")));
        if (_0_valueOrError0.IsFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _0_valueOrError0.PropagateFailure(software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        long _1_count = Byte.toUnsignedLong((Byte)data.select(0));
        Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _2_valueOrError1 = __default.GetDataKeys2(_1_count, _1_count, data, (Tuple2<DafnySequence<? extends EncryptedDataKey>, Long>)Tuple2.create((Object)DafnySequence.empty(CMPEncryptedDataKey._typeDescriptor()), (Object)1L));
        if (_2_valueOrError1.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
            return _2_valueOrError1.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
        }
        Tuple2 _3_keys = (Tuple2)_2_valueOrError1.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
        if (!((long)((DafnySequence)_3_keys.dtor__0()).cardinalityInt() != 0L)) {
            return Result.create_Failure((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"At least one Data Key required")));
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)_3_keys);
    }

    public static Result<Tuple2<DafnySequence<? extends EncryptedDataKey>, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> GetDataKeys2(long count, long origCount, DafnySequence<? extends Byte> data, Tuple2<DafnySequence<? extends EncryptedDataKey>, Long> deserialized) {
        while (count != 0L) {
            if (Long.compareUnsigned(((DafnySequence)deserialized.dtor__0()).cardinalityInt(), 255L) >= 0) {
                return Result.create_Failure((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), (Object)StructuredEncryptionUtil_Compile.__default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Too Many Data Keys")));
            }
            Result<Tuple2<EncryptedDataKey, Long>, software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error> _0_valueOrError0 = __default.GetOneDataKey(data, (Long)deserialized.dtor__1());
            if (_0_valueOrError0.IsFailure(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor())) {
                return _0_valueOrError0.PropagateFailure(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()));
            }
            Tuple2 _1_edk = (Tuple2)_0_valueOrError0.Extract(Tuple2._typeDescriptor(CMPEncryptedDataKey._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor());
            long _in0 = count - 1L;
            long _in1 = origCount;
            DafnySequence<? extends Byte> _in2 = data;
            Tuple2 _in3 = Tuple2.create((Object)DafnySequence.concatenate((DafnySequence)((DafnySequence)deserialized.dtor__0()), (DafnySequence)DafnySequence.of(CMPEncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{(EncryptedDataKey)_1_edk.dtor__0()})), (Object)((Long)deserialized.dtor__1() + (Long)_1_edk.dtor__1()));
            count = _in0;
            origCount = _in1;
            data = _in2;
            deserialized = _in3;
        }
        return Result.create_Success((TypeDescriptor)Tuple2._typeDescriptor(CMPEncryptedDataKeyListEmptyOK._typeDescriptor(), (TypeDescriptor)uint64._typeDescriptor()), software.amazon.cryptography.dbencryptionsdk.structuredencryption.internaldafny.types.Error._typeDescriptor(), deserialized);
    }

    public static long VERSION__LEN64() {
        return 1L;
    }

    public static long FLAVOR__LEN64() {
        return 1L;
    }

    public static long PREFIX__LEN64() {
        return __default.VERSION__LEN64() + __default.FLAVOR__LEN64() + StructuredEncryptionUtil_Compile.__default.MSGID__LEN64();
    }

    public static byte ENCRYPT__AND__SIGN__LEGEND() {
        return 101;
    }

    public static byte SIGN__AND__INCLUDE__IN__ENCRYPTION__CONTEXT__LEGEND() {
        return 99;
    }

    public static byte SIGN__ONLY__LEGEND() {
        return 115;
    }

    public static long COMMITMENT__LEN64() {
        return 32L;
    }

    public static long UINT8__LIMIT64() {
        return 256L;
    }

    public static DafnySequence<? extends Byte> EmptyLegend() {
        return DafnySequence.empty(LegendByte._typeDescriptor());
    }

    public String toString() {
        return "StructuredEncryptionHeader._default";
    }
}

