/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.dataset.MLInputDataset;
import org.opensearch.ml.common.dataset.remote.RemoteInferenceInputDataSet;
import org.opensearch.ml.common.input.Input;
import org.opensearch.ml.common.input.execute.agent.AgentMLInput;
import org.opensearch.ml.common.output.model.ModelTensorOutput;
import org.opensearch.ml.common.spi.tools.Parser;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskAction;
import org.opensearch.ml.common.transport.execute.MLExecuteTaskRequest;
import org.opensearch.ml.common.utils.ToolUtils;
import org.opensearch.ml.engine.tools.parser.ToolParser;
import org.opensearch.ml.repackage.com.google.common.annotations.VisibleForTesting;
import org.opensearch.transport.client.Client;

@ToolAnnotation(value="AgentTool")
public class AgentTool
implements Tool {
    @Generated
    private static final Logger log = LogManager.getLogger(AgentTool.class);
    public static final String TYPE = "AgentTool";
    private final Client client;
    private String agentId;
    private String name = "AgentTool";
    @VisibleForTesting
    static String DEFAULT_DESCRIPTION = "Use this tool to run any agent.";
    private String description = DEFAULT_DESCRIPTION;
    private Map<String, Object> attributes;
    private Parser outputParser;

    public AgentTool(Client client, String agentId) {
        if (agentId == null || agentId.isBlank()) {
            throw new IllegalArgumentException("Agent ID cannot be null or empty");
        }
        this.client = client;
        this.agentId = agentId;
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        try {
            if (this.agentId == null || this.agentId.isBlank()) {
                throw new IllegalArgumentException("Agent ID not registered in tool");
            }
            Map extractedParameters = ToolUtils.extractInputParameters(parameters, this.attributes);
            String tenantId = parameters.get("tenant_id");
            AgentMLInput agentMLInput = AgentMLInput.AgentMLInputBuilder().agentId(this.agentId).tenantId(tenantId).functionName(FunctionName.AGENT).inputDataset((MLInputDataset)RemoteInferenceInputDataSet.builder().parameters(extractedParameters).build()).build();
            MLExecuteTaskRequest request = new MLExecuteTaskRequest(FunctionName.AGENT, (Input)agentMLInput, false);
            this.client.execute((ActionType)MLExecuteTaskAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> {
                ModelTensorOutput output = (ModelTensorOutput)r.getOutput();
                listener.onResponse(this.outputParser.parse((Object)output));
            }, e -> {
                log.error("Failed to run agent " + this.agentId, (Throwable)e);
                listener.onFailure(e);
            }));
        }
        catch (Exception e2) {
            log.error("Failed to run AgentTool with agent: {}", (Object)this.agentId, (Object)e2);
            listener.onFailure(e2);
        }
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public boolean validate(Map<String, String> parameters) {
        return true;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setOutputParser(Parser outputParser) {
        this.outputParser = outputParser;
    }

    public static class Factory
    implements Tool.Factory<AgentTool> {
        private Client client;
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<AgentTool> clazz = AgentTool.class;
            synchronized (AgentTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public void init(Client client) {
            this.client = client;
        }

        public AgentTool create(Map<String, Object> params) {
            AgentTool agentTool = new AgentTool(this.client, (String)params.get("agent_id"));
            agentTool.setOutputParser(ToolParser.createFromToolParams(params));
            return agentTool;
        }

        public String getDefaultDescription() {
            return DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return AgentTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }
    }
}

