/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.indices;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.Version;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.knn.indices.ModelState;
import org.opensearch.knn.indices.ModelUtil;

public class ModelMetadata
implements Writeable,
ToXContentObject {
    @Generated
    private static final Logger log = LogManager.getLogger(ModelMetadata.class);
    public static final String DELIMITER = ",";
    private final KNNEngine knnEngine;
    private final SpaceType spaceType;
    private final int dimension;
    private AtomicReference<ModelState> state;
    private final String timestamp;
    private final String description;
    private final String trainingNodeAssignment;
    private final VectorDataType vectorDataType;
    private MethodComponentContext methodComponentContext;
    private final Mode mode;
    private String error;
    private final CompressionLevel compressionLevel;
    private final Version version;

    public ModelMetadata(StreamInput in) throws IOException {
        this.knnEngine = KNNEngine.getEngine(in.readString());
        this.spaceType = SpaceType.getSpace(in.readString());
        this.dimension = in.readInt();
        this.state = new AtomicReference<ModelState>(ModelState.readFrom(in));
        this.timestamp = in.readString();
        this.description = in.readString();
        ModelUtil.blockCommasInModelDescription(this.description);
        this.error = in.readString();
        this.trainingNodeAssignment = IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), "training_node_assignment") ? in.readString() : "";
        this.methodComponentContext = IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), "model_definition") ? new MethodComponentContext(in) : MethodComponentContext.EMPTY;
        this.vectorDataType = IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), "data_type") ? VectorDataType.get(in.readString()) : VectorDataType.DEFAULT;
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), "mode_and_compression_feature")) {
            this.mode = Mode.fromName(in.readOptionalString());
            this.compressionLevel = CompressionLevel.fromName(in.readOptionalString());
        } else {
            this.mode = Mode.NOT_CONFIGURED;
            this.compressionLevel = CompressionLevel.NOT_CONFIGURED;
        }
        this.version = IndexUtil.isVersionOnOrAfterMinRequiredVersion(in.getVersion(), "model_version") ? Version.fromString((String)in.readString()) : Version.V_EMPTY;
    }

    public ModelMetadata(KNNEngine knnEngine, SpaceType spaceType, int dimension, ModelState modelState, String timestamp, String description, String error, String trainingNodeAssignment, MethodComponentContext methodComponentContext, VectorDataType vectorDataType, Mode mode, CompressionLevel compressionLevel, Version version) {
        this.knnEngine = Objects.requireNonNull(knnEngine, "knnEngine must not be null");
        this.spaceType = Objects.requireNonNull(spaceType, "spaceType must not be null");
        int maxDimensions = KNNEngine.getMaxDimensionByEngine(this.knnEngine);
        if (dimension <= 0 || dimension > maxDimensions) {
            throw new IllegalArgumentException(String.format("Dimension \"%s\" is invalid. Value must be greater than 0 and less than or equal to %d", dimension, maxDimensions));
        }
        this.dimension = dimension;
        this.state = new AtomicReference<ModelState>(Objects.requireNonNull(modelState, "modelState must not be null"));
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp must not be null");
        this.description = Objects.requireNonNull(description, "description must not be null");
        ModelUtil.blockCommasInModelDescription(this.description);
        this.error = Objects.requireNonNull(error, "error must not be null");
        this.trainingNodeAssignment = Objects.requireNonNull(trainingNodeAssignment, "node assignment must not be null");
        this.methodComponentContext = Objects.requireNonNull(methodComponentContext, "method context must not be null");
        this.vectorDataType = Objects.requireNonNull(vectorDataType, "vector data type must not be null");
        this.mode = Objects.requireNonNull(mode, "Mode must not be null");
        this.compressionLevel = Objects.requireNonNull(compressionLevel, "Compression level must not be null");
        this.version = Objects.requireNonNull(version, "model version must not be null");
    }

    public KNNEngine getKnnEngine() {
        return this.knnEngine;
    }

    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    public int getDimension() {
        return this.dimension;
    }

    public ModelState getState() {
        return this.state.get();
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getDescription() {
        return this.description;
    }

    public String getError() {
        return this.error;
    }

    public String getNodeAssignment() {
        return this.trainingNodeAssignment;
    }

    public MethodComponentContext getMethodComponentContext() {
        return this.methodComponentContext;
    }

    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }

    public Version getModelVersion() {
        return this.version;
    }

    public synchronized void setState(ModelState state) {
        this.state.set(Objects.requireNonNull(state, "state must not be null"));
    }

    public synchronized void setError(String error) {
        this.error = error;
    }

    public String toString() {
        return String.join((CharSequence)DELIMITER, this.knnEngine.getName(), this.spaceType.getValue(), Integer.toString(this.dimension), this.getState().toString(), this.timestamp, this.description, this.error, this.trainingNodeAssignment, this.methodComponentContext.toClusterStateString(), this.vectorDataType.getValue(), this.mode.getName(), this.compressionLevel.getName(), this.version.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ModelMetadata other = (ModelMetadata)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append((Object)this.getKnnEngine(), (Object)other.getKnnEngine());
        equalsBuilder.append((Object)this.getSpaceType(), (Object)other.getSpaceType());
        equalsBuilder.append(this.getDimension(), other.getDimension());
        equalsBuilder.append((Object)this.getState(), (Object)other.getState());
        equalsBuilder.append((Object)this.getTimestamp(), (Object)other.getTimestamp());
        equalsBuilder.append((Object)this.getDescription(), (Object)other.getDescription());
        equalsBuilder.append((Object)this.getError(), (Object)other.getError());
        equalsBuilder.append((Object)this.getVectorDataType(), (Object)other.getVectorDataType());
        equalsBuilder.append((Object)this.getMode(), (Object)other.getMode());
        equalsBuilder.append((Object)this.getCompressionLevel(), (Object)other.getCompressionLevel());
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getKnnEngine()).append((Object)this.getSpaceType()).append(this.getDimension()).append((Object)this.getState()).append((Object)this.getTimestamp()).append((Object)this.getDescription()).append((Object)this.getError()).append((Object)this.getMethodComponentContext()).append((Object)this.getVectorDataType()).append((Object)this.getMode()).append((Object)this.getCompressionLevel()).append((Object)this.getModelVersion()).toHashCode();
    }

    public static ModelMetadata fromString(String modelMetadataString) {
        String[] modelMetadataArray = modelMetadataString.split(DELIMITER, -1);
        int length = modelMetadataArray.length;
        if (length < 7 || length > 13) {
            throw new IllegalArgumentException("Illegal format for model metadata. Must be of the form \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>\" or \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>,<NodeAssignment>\" or \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>,<NodeAssignment>,<MethodContext>\" or \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>,<NodeAssignment>,<MethodContext>,<VectorDataType>\". or \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>,<NodeAssignment>,<MethodContext>,<VectorDataType>,<Mode>,<CompressionLevel>\" or \"<KNNEngine>,<SpaceType>,<Dimension>,<ModelState>,<Timestamp>,<Description>,<Error>,<NodeAssignment>,<MethodContext>,<VectorDataType>,<Mode>,<CompressionLevel>,<Version>\".");
        }
        KNNEngine knnEngine = KNNEngine.getEngine(modelMetadataArray[0]);
        SpaceType spaceType = SpaceType.getSpace(modelMetadataArray[1]);
        int dimension = Integer.parseInt(modelMetadataArray[2]);
        ModelState modelState = ModelState.getModelState(modelMetadataArray[3]);
        String timestamp = modelMetadataArray[4];
        String description = modelMetadataArray[5];
        String error = modelMetadataArray[6];
        String trainingNodeAssignment = length > 7 ? modelMetadataArray[7] : "";
        MethodComponentContext methodComponentContext = length > 8 ? MethodComponentContext.fromClusterStateString(modelMetadataArray[8]) : MethodComponentContext.EMPTY;
        VectorDataType vectorDataType = length > 9 ? VectorDataType.get(modelMetadataArray[9]) : VectorDataType.DEFAULT;
        Mode mode = length > 10 ? Mode.fromName(modelMetadataArray[10]) : Mode.NOT_CONFIGURED;
        CompressionLevel compressionLevel = length > 11 ? CompressionLevel.fromName(modelMetadataArray[11]) : CompressionLevel.NOT_CONFIGURED;
        Version version = length > 12 ? Version.fromString((String)modelMetadataArray[12]) : Version.V_EMPTY;
        log.debug(ModelMetadata.getLogMessage(length));
        return new ModelMetadata(knnEngine, spaceType, dimension, modelState, timestamp, description, error, trainingNodeAssignment, methodComponentContext, vectorDataType, mode, compressionLevel, version);
    }

    private static String getLogMessage(int length) {
        switch (length) {
            case 7: {
                return "Model metadata array does not contain training node assignment or method component context. Assuming empty string node assignment and empty method component context.";
            }
            case 8: {
                return "Model metadata contains training node assignment. Assuming empty method component context.";
            }
            case 9: {
                return "Model metadata contains training node assignment and method context.";
            }
            case 10: {
                return "Model metadata contains training node assignment, method context and vector data type.";
            }
            case 12: {
                return "Model metadata contains mode and compression level";
            }
            case 13: {
                return "Model metadata contains training node assignment, method context, vector data type, and version";
            }
        }
        throw new IllegalArgumentException("Unexpected metadata array length: " + length);
    }

    private static String objectToString(Object value) {
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    private static Integer objectToInteger(Object value) {
        if (value == null) {
            return null;
        }
        return (Integer)value;
    }

    public static ModelMetadata getMetadataFromSourceMap(Map<String, Object> modelSourceMap) {
        Object engine = modelSourceMap.get("engine");
        Object space = modelSourceMap.get("space_type");
        Object dimension = modelSourceMap.get("dimension");
        Object state = modelSourceMap.get("state");
        Object timestamp = modelSourceMap.get("timestamp");
        Object description = modelSourceMap.get("description");
        Object error = modelSourceMap.get("error");
        Object trainingNodeAssignment = modelSourceMap.get("training_node_assignment");
        Object methodComponentContext = modelSourceMap.get("model_definition");
        Object vectorDataType = modelSourceMap.get("data_type");
        Object mode = modelSourceMap.get("mode");
        Object compressionLevel = modelSourceMap.get("compression_level");
        Object version = modelSourceMap.get("model_version");
        if (trainingNodeAssignment == null) {
            trainingNodeAssignment = "";
        }
        if (Objects.nonNull(methodComponentContext)) {
            try {
                XContentParser xContentParser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, ModelMetadata.objectToString(methodComponentContext));
                methodComponentContext = MethodComponentContext.fromXContent(xContentParser);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Error parsing method component context");
            }
        } else {
            methodComponentContext = MethodComponentContext.EMPTY;
        }
        if (vectorDataType == null) {
            vectorDataType = VectorDataType.DEFAULT.getValue();
        }
        if (version == null) {
            version = Version.V_EMPTY;
        }
        ModelMetadata modelMetadata = new ModelMetadata(KNNEngine.getEngine(ModelMetadata.objectToString(engine)), SpaceType.getSpace(ModelMetadata.objectToString(space)), ModelMetadata.objectToInteger(dimension), ModelState.getModelState(ModelMetadata.objectToString(state)), ModelMetadata.objectToString(timestamp), ModelMetadata.objectToString(description), ModelMetadata.objectToString(error), ModelMetadata.objectToString(trainingNodeAssignment), (MethodComponentContext)methodComponentContext, VectorDataType.get(ModelMetadata.objectToString(vectorDataType)), Mode.fromName(ModelMetadata.objectToString(mode)), CompressionLevel.fromName(ModelMetadata.objectToString(compressionLevel)), Version.fromString((String)version.toString()));
        return modelMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.getKnnEngine().getName());
        out.writeString(this.getSpaceType().getValue());
        out.writeInt(this.getDimension());
        this.getState().writeTo(out);
        out.writeString(this.getTimestamp());
        out.writeString(this.getDescription());
        out.writeString(this.getError());
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), "training_node_assignment")) {
            out.writeString(this.getNodeAssignment());
        }
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), "model_definition")) {
            this.getMethodComponentContext().writeTo(out);
        }
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), "data_type")) {
            out.writeString(this.vectorDataType.getValue());
        }
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), "mode_and_compression_feature")) {
            out.writeOptionalString(this.mode.getName());
            out.writeOptionalString(this.compressionLevel.getName());
        }
        if (IndexUtil.isVersionOnOrAfterMinRequiredVersion(out.getVersion(), "model_version")) {
            out.writeString(this.version.toString());
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("state", this.getState().getName());
        builder.field("timestamp", this.getTimestamp());
        builder.field("description", this.getDescription());
        builder.field("error", this.getError());
        builder.field("space_type", this.getSpaceType().getValue());
        builder.field("dimension", this.getDimension());
        builder.field("engine", this.getKnnEngine().getName());
        if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("training_node_assignment")) {
            builder.field("training_node_assignment", this.getNodeAssignment());
        }
        if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("model_definition")) {
            builder.field("model_definition").startObject();
            this.getMethodComponentContext().toXContent(builder, params);
            builder.endObject();
        }
        if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("data_type")) {
            builder.field("data_type", this.vectorDataType.getValue());
        }
        if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("mode_and_compression_feature")) {
            if (Mode.isConfigured(this.mode)) {
                builder.field("mode", this.mode.getName());
            }
            if (CompressionLevel.isConfigured(this.compressionLevel)) {
                builder.field("compression_level", this.compressionLevel.getName());
            }
        }
        if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("model_version")) {
            String versionString = "unknown";
            if (this.version != Version.V_EMPTY) {
                versionString = this.version.toString();
            }
            builder.field("model_version", versionString);
        }
        return builder;
    }

    @Generated
    public Mode getMode() {
        return this.mode;
    }

    @Generated
    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }
}

