/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.InternetGateway;

public class DescribeInternetGatewaysIterable
implements SdkIterable<DescribeInternetGatewaysResponse> {
    private final Ec2Client client;
    private final DescribeInternetGatewaysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInternetGatewaysIterable(Ec2Client client, DescribeInternetGatewaysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeInternetGatewaysResponseFetcher();
    }

    public Iterator<DescribeInternetGatewaysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InternetGateway> internetGateways() {
        Function<DescribeInternetGatewaysResponse, Iterator> getIterator = response -> {
            if (response != null && response.internetGateways() != null) {
                return response.internetGateways().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInternetGatewaysResponseFetcher
    implements SyncPageFetcher<DescribeInternetGatewaysResponse> {
        private DescribeInternetGatewaysResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInternetGatewaysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInternetGatewaysResponse nextPage(DescribeInternetGatewaysResponse previousPage) {
            if (previousPage == null) {
                return DescribeInternetGatewaysIterable.this.client.describeInternetGateways(DescribeInternetGatewaysIterable.this.firstRequest);
            }
            return DescribeInternetGatewaysIterable.this.client.describeInternetGateways((DescribeInternetGatewaysRequest)((Object)DescribeInternetGatewaysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

