/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.task;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ADHCBatchTaskCache {
    private Queue<String> pendingEntities = new ConcurrentLinkedQueue<String>();
    private Queue<String> runningEntities = new ConcurrentLinkedQueue<String>();
    private Queue<String> tempEntities = new ConcurrentLinkedQueue<String>();
    private AtomicInteger entityTaskLanes;
    private Integer topEntityCount;
    private Semaphore detectorTaskUpdatingSemaphore;
    private Boolean topEntitiesInited = false;
    private Map<String, AtomicInteger> taskRetryTimes = new ConcurrentHashMap<String, AtomicInteger>();
    private Instant lastScaleEntityTaskSlotsTime;
    private Instant latestTaskRunTime;

    public ADHCBatchTaskCache() {
        this.detectorTaskUpdatingSemaphore = new Semaphore(1);
        this.lastScaleEntityTaskSlotsTime = Instant.now();
        this.latestTaskRunTime = Instant.now();
    }

    public void setTopEntityCount(Integer topEntityCount) {
        this.refreshLatestTaskRunTime();
        this.topEntityCount = topEntityCount;
    }

    public String[] getPendingEntities() {
        return this.pendingEntities.toArray(new String[0]);
    }

    public String[] getRunningEntities() {
        return this.runningEntities.toArray(new String[0]);
    }

    public String[] getTempEntities() {
        return this.tempEntities.toArray(new String[0]);
    }

    public Integer getTopEntityCount() {
        return this.topEntityCount;
    }

    public boolean tryAcquireTaskUpdatingSemaphore(long timeoutInMillis) throws InterruptedException {
        return this.detectorTaskUpdatingSemaphore.tryAcquire(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public void releaseTaskUpdatingSemaphore() {
        this.detectorTaskUpdatingSemaphore.release();
    }

    public boolean getTopEntitiesInited() {
        return this.topEntitiesInited;
    }

    public void setEntityTaskLanes(int entityTaskLanes) {
        this.refreshLatestTaskRunTime();
        this.entityTaskLanes = new AtomicInteger(entityTaskLanes);
    }

    public int getAndDecreaseEntityTaskLanes() {
        return this.entityTaskLanes.getAndDecrement();
    }

    public int getEntityTaskLanes() {
        return this.entityTaskLanes.get();
    }

    public void setTopEntitiesInited(boolean inited) {
        this.topEntitiesInited = inited;
    }

    public int getTaskRetryTimes(String taskId) {
        return this.taskRetryTimes.computeIfAbsent(taskId, id -> new AtomicInteger(0)).get();
    }

    public void addPendingEntities(List<String> entities) {
        this.refreshLatestTaskRunTime();
        if (entities == null || entities.size() == 0) {
            return;
        }
        for (String entity : entities) {
            if (entity == null) continue;
            this.tempEntities.remove(entity);
            this.runningEntities.remove(entity);
            if (this.pendingEntities.contains(entity)) continue;
            this.pendingEntities.add(entity);
        }
    }

    public void moveToRunningEntity(String entity) {
        this.refreshLatestTaskRunTime();
        if (entity == null) {
            return;
        }
        boolean removed = this.tempEntities.remove(entity);
        if (removed && !this.runningEntities.contains(entity)) {
            this.runningEntities.add(entity);
            this.pendingEntities.remove(entity);
        }
    }

    public int getPendingEntityCount() {
        return this.pendingEntities.size();
    }

    public int getRunningEntityCount() {
        return this.runningEntities.size();
    }

    public int getUnfinishedEntityCount() {
        return this.runningEntities.size() + this.tempEntities.size() + this.pendingEntities.size();
    }

    public int getTempEntityCount() {
        return this.tempEntities.size();
    }

    public Instant getLastScaleEntityTaskSlotsTime() {
        return this.lastScaleEntityTaskSlotsTime;
    }

    public void setLastScaleEntityTaskSlotsTime(Instant lastScaleEntityTaskSlotsTime) {
        this.lastScaleEntityTaskSlotsTime = lastScaleEntityTaskSlotsTime;
    }

    public Instant getLatestTaskRunTime() {
        return this.latestTaskRunTime;
    }

    public void refreshLatestTaskRunTime() {
        this.latestTaskRunTime = Instant.now();
    }

    public boolean hasEntity() {
        return !this.pendingEntities.isEmpty() || !this.runningEntities.isEmpty() || !this.tempEntities.isEmpty();
    }

    public boolean hasRunningEntity() {
        return !this.runningEntities.isEmpty() || !this.tempEntities.isEmpty();
    }

    public boolean removeRunningEntity(String entity) {
        return this.runningEntities.remove(entity) || this.tempEntities.remove(entity);
    }

    public void clear() {
        this.pendingEntities.clear();
        this.runningEntities.clear();
        this.tempEntities.clear();
        this.taskRetryTimes.clear();
    }

    public String pollEntity() {
        this.refreshLatestTaskRunTime();
        String entity = this.pendingEntities.poll();
        if (entity != null && !this.tempEntities.contains(entity)) {
            this.tempEntities.add(entity);
        }
        return entity;
    }

    public void clearPendingEntities() {
        this.pendingEntities.clear();
    }

    public int increaseTaskRetry(String taskId) {
        return this.taskRetryTimes.computeIfAbsent(taskId, id -> new AtomicInteger(0)).getAndIncrement();
    }

    public boolean removeEntity(String entity) {
        this.refreshLatestTaskRunTime();
        if (entity == null) {
            return false;
        }
        boolean removedFromTempQueue = this.tempEntities.remove(entity);
        boolean removedFromPendingQueue = this.pendingEntities.remove(entity);
        boolean removedFromRunningQueue = this.runningEntities.remove(entity);
        return removedFromTempQueue || removedFromPendingQueue || removedFromRunningQueue;
    }
}

