/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.lucene.analysis.ja.dict.JaMorphData;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOSupplier;

class TokenInfoMorphData
implements JaMorphData {
    private final ByteBuffer buffer;
    private final String[] posDict;
    private final String[] inflTypeDict;
    private final String[] inflFormDict;
    public static final int HAS_BASEFORM = 1;
    public static final int HAS_READING = 2;
    public static final int HAS_PRONUNCIATION = 4;

    TokenInfoMorphData(ByteBuffer buffer, IOSupplier<InputStream> posResource) throws IOException {
        this.buffer = buffer;
        try (BufferedInputStream posIS = new BufferedInputStream((InputStream)posResource.get());){
            InputStreamDataInput in = new InputStreamDataInput((InputStream)posIS);
            CodecUtil.checkHeader((DataInput)in, (String)"kuromoji_dict_pos", (int)1, (int)1);
            int posSize = in.readVInt();
            this.posDict = new String[posSize];
            this.inflTypeDict = new String[posSize];
            this.inflFormDict = new String[posSize];
            TokenInfoMorphData.populatePosDict((DataInput)in, posSize, this.posDict, this.inflTypeDict, this.inflFormDict);
        }
    }

    private static void populatePosDict(DataInput in, int posSize, String[] posDict, String[] inflTypeDict, String[] inflFormDict) throws IOException {
        for (int j = 0; j < posSize; ++j) {
            posDict[j] = in.readString();
            inflTypeDict[j] = in.readString();
            inflFormDict[j] = in.readString();
            if (inflTypeDict[j].length() == 0) {
                inflTypeDict[j] = null;
            }
            if (inflFormDict[j].length() != 0) continue;
            inflFormDict[j] = null;
        }
    }

    public int getLeftId(int morphId) {
        return (this.buffer.getShort(morphId) & 0xFFFF) >>> 3;
    }

    public int getRightId(int morphId) {
        return (this.buffer.getShort(morphId) & 0xFFFF) >>> 3;
    }

    public int getWordCost(int morphId) {
        return this.buffer.getShort(morphId + 2);
    }

    @Override
    public String getBaseForm(int morphId, char[] surfaceForm, int off, int len) {
        if (this.hasBaseFormData(morphId)) {
            int offset = TokenInfoMorphData.baseFormOffset(morphId);
            int data = this.buffer.get(offset++) & 0xFF;
            int prefix = data >>> 4;
            int suffix = data & 0xF;
            char[] text = new char[prefix + suffix];
            System.arraycopy(surfaceForm, off, text, 0, prefix);
            for (int i = 0; i < suffix; ++i) {
                text[prefix + i] = this.buffer.getChar(offset + (i << 1));
            }
            return new String(text);
        }
        return null;
    }

    @Override
    public String getReading(int morphId, char[] surface, int off, int len) {
        if (this.hasReadingData(morphId)) {
            int readingData;
            int offset = this.readingOffset(morphId);
            return this.readString(offset, readingData >>> 1, ((readingData = this.buffer.get(offset++) & 0xFF) & 1) == 1);
        }
        char[] text = new char[len];
        for (int i = 0; i < len; ++i) {
            char ch = surface[off + i];
            text[i] = ch > '\u3040' && ch < '\u3097' ? (char)(ch + 96) : ch;
        }
        return new String(text);
    }

    @Override
    public String getPartOfSpeech(int morphId) {
        return this.posDict[this.getLeftId(morphId)];
    }

    @Override
    public String getPronunciation(int morphId, char[] surface, int off, int len) {
        if (this.hasPronunciationData(morphId)) {
            int pronunciationData;
            int offset = this.pronunciationOffset(morphId);
            return this.readString(offset, pronunciationData >>> 1, ((pronunciationData = this.buffer.get(offset++) & 0xFF) & 1) == 1);
        }
        return this.getReading(morphId, surface, off, len);
    }

    @Override
    public String getInflectionType(int morphId) {
        return this.inflTypeDict[this.getLeftId(morphId)];
    }

    @Override
    public String getInflectionForm(int wordId) {
        return this.inflFormDict[this.getLeftId(wordId)];
    }

    private int readingOffset(int wordId) {
        int offset = TokenInfoMorphData.baseFormOffset(wordId);
        if (this.hasBaseFormData(wordId)) {
            int baseFormLength = this.buffer.get(offset++) & 0xF;
            return offset + (baseFormLength << 1);
        }
        return offset;
    }

    private int pronunciationOffset(int wordId) {
        if (this.hasReadingData(wordId)) {
            int readingData;
            int offset = this.readingOffset(wordId);
            int readingLength = ((readingData = this.buffer.get(offset++) & 0xFF) & 1) == 0 ? readingData & 0xFE : readingData >>> 1;
            return offset + readingLength;
        }
        return this.readingOffset(wordId);
    }

    private static int baseFormOffset(int wordId) {
        return wordId + 4;
    }

    private boolean hasBaseFormData(int wordId) {
        return (this.buffer.getShort(wordId) & 1) != 0;
    }

    private boolean hasReadingData(int wordId) {
        return (this.buffer.getShort(wordId) & 2) != 0;
    }

    private boolean hasPronunciationData(int wordId) {
        return (this.buffer.getShort(wordId) & 4) != 0;
    }

    private String readString(int offset, int length, boolean kana) {
        char[] text = new char[length];
        if (kana) {
            for (int i = 0; i < length; ++i) {
                text[i] = (char)(12448 + (this.buffer.get(offset + i) & 0xFF));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                text[i] = this.buffer.getChar(offset + (i << 1));
            }
        }
        return new String(text);
    }
}

