/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.pollingingest.mappers;

import java.util.Map;
import org.opensearch.common.util.RequestUtils;
import org.opensearch.index.IngestionShardPointer;
import org.opensearch.index.Message;
import org.opensearch.indices.pollingingest.IngestionUtils;
import org.opensearch.indices.pollingingest.ShardUpdateMessage;
import org.opensearch.indices.pollingingest.mappers.IngestionMessageMapper;

public class DefaultIngestionMessageMapper
implements IngestionMessageMapper {
    @Override
    public ShardUpdateMessage mapAndProcess(IngestionShardPointer pointer, Message message) throws IllegalArgumentException {
        Map<String, Object> payloadMap = IngestionUtils.getParsedPayloadMap((byte[])message.getPayload());
        long autoGeneratedIdTimestamp = -1L;
        if (!payloadMap.containsKey("_id")) {
            String id = RequestUtils.generateID();
            payloadMap.put("_id", id);
            autoGeneratedIdTimestamp = System.currentTimeMillis();
        }
        return new ShardUpdateMessage<IngestionShardPointer, Message>(pointer, message, payloadMap, autoGeneratedIdTimestamp);
    }
}

