/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.ir.convertors;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u000fJ\n\u0010\u0015\u001a\u00020\u0013H\u0096\u0080\u0004R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/wasm/ir/convertors/StringBuilderWithLocations;", "", "<init>", "()V", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "value", "", "lineNumber", "getLineNumber", "()I", "columnNumber", "getColumnNumber", "append", "", "char", "", "text", "", "appendLine", "toString", "wasm.ir"})
public final class StringBuilderWithLocations {
    @NotNull
    private final StringBuilder builder = new StringBuilder();
    private int lineNumber;
    private int columnNumber = -1;

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final int getColumnNumber() {
        return this.columnNumber;
    }

    public final void append(char c2) {
        if (c2 == '\n') {
            this.appendLine();
        } else {
            this.builder.append(c2);
        }
    }

    public final void append(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        this.builder.append(text);
        Object object = new char[]{'\n'};
        char[] it = object = (Object)StringsKt.split$default((CharSequence)text, object, false, 0, 6, null);
        boolean bl = false;
        if (it.size() > 1) {
            this.columnNumber = -1;
        }
        char[] lines = object;
        this.lineNumber += lines.size() - 1;
        this.columnNumber += ((String)CollectionsKt.last(lines)).length();
    }

    public final void appendLine() {
        this.builder.append('\n');
        ++this.lineNumber;
        this.columnNumber = -1;
    }

    @NotNull
    public String toString() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }
}

