/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.FieldReference;
import com.dickimawbooks.bibgls.bib2gls.FieldValueElement;
import com.dickimawbooks.bibgls.bib2gls.GlsResource;
import com.dickimawbooks.bibgls.bib2gls.MissingFieldAction;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.SingleToken;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import com.dickimawbooks.texparserlib.bib.BibUserString;
import com.dickimawbooks.texparserlib.bib.BibValue;
import com.dickimawbooks.texparserlib.bib.BibValueList;
import java.io.IOException;

public class Field
implements FieldValueElement {
    private GlsResource resource;
    private FieldReference fieldRef;
    private String name;
    private Field follow;
    private String fallbackOption;
    public static final String FOLLOW_MARKER = "->";

    public Field(GlsResource glsResource, FieldReference fieldReference, String string, Field field, String string2) throws Bib2GlsException {
        if (fieldReference == null || glsResource == null) {
            throw new NullPointerException();
        }
        this.resource = glsResource;
        this.fieldRef = fieldReference;
        this.setFollow(field);
        this.setName(string);
        this.fallbackOption = string2;
    }

    public Field(GlsResource glsResource, FieldReference fieldReference, String string) throws Bib2GlsException {
        this(glsResource, fieldReference, null, null, string);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String string) throws Bib2GlsException {
        if (string != null) {
            Bib2Gls bib2Gls = this.resource.getBib2Gls();
            if (this.fieldRef == FieldReference.ENTRY_TYPE || this.fieldRef == FieldReference.ENTRY_LABEL || this.fieldRef == FieldReference.ENTRY_BIB) {
                if (!string.equals("original") && !string.equals("actual")) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.field_identifier", string, this.fieldRef.getTag()));
                }
            } else {
                if (bib2Gls.isPrivateNonBibField(string)) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.field_name", string));
                }
                if (!(bib2Gls.isKnownField(string) || bib2Gls.isKnownSpecialField(string) || bib2Gls.isNonBibField(string) || string.equals("entrytype") || string.equals("entrylabel") || string.equals("entrybib") || string.equals("original") || string.equals("actual"))) {
                    this.resource.addUserField(string);
                }
            }
        }
        this.name = string;
    }

    public Field getFollow() {
        return this.follow;
    }

    protected void setFollow(Field field) throws IllegalArgumentException {
        if (field != null && (this.fieldRef == FieldReference.ENTRY_TYPE || this.fieldRef == FieldReference.ENTRY_LABEL || this.fieldRef == FieldReference.ENTRY_BIB)) {
            throw new IllegalArgumentException("Field reference " + field.fieldRef.getTag() + " can't follow " + this.fieldRef.getTag());
        }
        this.follow = field;
    }

    public Field getLast() {
        if (this.follow == null) {
            return this;
        }
        return this.follow.getLast();
    }

    @Override
    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws IOException {
        Bib2GlsEntry bib2GlsEntry2 = this.fieldRef.getEntry(bib2GlsEntry);
        if (bib2GlsEntry2 == null) {
            return null;
        }
        TeXParser teXParser = this.resource.getBibParser();
        BibValue bibValue = null;
        TeXObjectList teXObjectList = null;
        if (this.follow == null) {
            if (this.fieldRef == FieldReference.ENTRY_TYPE) {
                String string = this.name.equals("original") ? bib2GlsEntry2.getOriginalEntryType() : bib2GlsEntry2.getEntryType();
                teXObjectList = teXParser.getListener().createString(string);
                bibValue = new BibUserString(teXObjectList);
            } else if (this.fieldRef == FieldReference.ENTRY_LABEL) {
                String string = this.name.equals("original") ? bib2GlsEntry2.getOriginalId() : bib2GlsEntry2.getId();
                teXObjectList = teXParser.getListener().createString(string);
                bibValue = new BibUserString(teXObjectList);
            } else if (this.fieldRef == FieldReference.ENTRY_BIB) {
                String string = this.name.equals("original") ? bib2GlsEntry2.getBase() : bib2GlsEntry2.getBaseFile().toString();
                teXObjectList = teXParser.getListener().createString(string);
                bibValue = new BibUserString(teXObjectList);
            } else {
                bibValue = bib2GlsEntry2.getField(this.name);
                if (bibValue == null) {
                    MissingFieldAction missingFieldAction = this.resource.getMissingFieldAction(this.fallbackOption);
                    if (missingFieldAction == MissingFieldAction.FALLBACK) {
                        bibValue = bib2GlsEntry2.getFallbackContents(this.name);
                    } else if (missingFieldAction == MissingFieldAction.EMPTY) {
                        bibValue = new BibValueList();
                        teXObjectList = new TeXObjectList();
                    }
                }
            }
        } else {
            return this.follow.getValue(bib2GlsEntry2);
        }
        return bibValue;
    }

    @Override
    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws IOException {
        Bib2GlsEntry bib2GlsEntry2 = this.fieldRef.getEntry(bib2GlsEntry);
        if (bib2GlsEntry2 == null) {
            return null;
        }
        String string = null;
        if (this.follow == null) {
            TeXParser teXParser = this.resource.getBibParser();
            string = this.fieldRef == FieldReference.ENTRY_TYPE ? (this.name.equals("original") ? bib2GlsEntry2.getOriginalEntryType() : bib2GlsEntry2.getEntryType()) : (this.fieldRef == FieldReference.ENTRY_LABEL ? (this.name.equals("original") ? bib2GlsEntry2.getOriginalId() : bib2GlsEntry2.getId()) : bib2GlsEntry2.getFieldValue(this.name));
            if (string == null) {
                BibValue bibValue = this.getValue(bib2GlsEntry);
                if (bibValue == null) {
                    return null;
                }
                TeXObjectList teXObjectList = bibValue.expand(teXParser);
                return teXObjectList.toString(teXParser);
            }
        } else {
            string = this.follow.getStringValue(bib2GlsEntry2);
        }
        return string;
    }

    public static Field popField(GlsResource glsResource, String string, TeXObjectList teXObjectList) throws Bib2GlsException, IOException {
        Object object;
        Bib2Gls bib2Gls = glsResource.getBib2Gls();
        TeXParser teXParser = glsResource.getParser();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        String string2 = null;
        Field field = null;
        if (bib2Gls.isDebuggingOn()) {
            bib2Gls.logAndPrintMessage("Parsing field from " + teXObjectList.toString(teXParser));
        }
        while (!teXObjectList.isEmpty()) {
            object = teXObjectList.peek();
            if (object instanceof WhiteSpace) {
                if (string2 == null && stringBuilder.length() > 0) {
                    string2 = stringBuilder.toString();
                    stringBuilder.setLength(0);
                }
                stringBuilder2.append(object.toString(teXParser));
                teXObjectList.pop();
                continue;
            }
            if (object instanceof SingleToken) {
                int n;
                TeXObject teXObject;
                int n2 = ((SingleToken)object).getCharCode();
                boolean bl = false;
                if (n2 == FOLLOW_MARKER.charAt(0) && teXObjectList.size() > 1 && (teXObject = (TeXObject)teXObjectList.get(1)) instanceof SingleToken && (n = ((SingleToken)teXObject).getCharCode()) == FOLLOW_MARKER.charAt(1)) {
                    bl = true;
                }
                if (bl) {
                    if (stringBuilder.length() > 0) {
                        string2 = stringBuilder.toString();
                        stringBuilder.setLength(0);
                    }
                    try {
                        if (field == null) {
                            field = new Field(glsResource, FieldReference.getReference(string2), string);
                        } else {
                            field.getLast().setFollow(new Field(glsResource, FieldReference.getReference(string2), string));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        String string3 = teXObjectList.toString(teXParser).trim();
                        if (string3.isEmpty()) {
                            throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.field_ref", string2), illegalArgumentException);
                        }
                        throw new Bib2GlsException(bib2Gls.getMessage("error.invalid.field_ref_before", string2, bib2Gls.truncate(string3)), illegalArgumentException);
                    }
                    string2 = null;
                    stringBuilder2.append(FOLLOW_MARKER);
                    teXObjectList.pop();
                    teXObjectList.pop();
                    continue;
                }
                if (n2 == 44 || n2 == 61 || n2 == 60 || n2 == 62 || n2 == 43 || n2 == 91 || n2 == 93 || n2 == 40 || n2 == 41 || n2 == 33 || n2 == 38 || n2 == 124 || string2 != null) break;
                stringBuilder.appendCodePoint(n2);
                stringBuilder2.appendCodePoint(n2);
                teXObjectList.pop();
                continue;
            }
            if (string2 != null || object instanceof ControlSequence) break;
            String string4 = object.toString(teXParser);
            stringBuilder.append(string4);
            stringBuilder2.append(string4);
            teXObjectList.pop();
        }
        if (string2 == null && stringBuilder.length() > 0) {
            string2 = stringBuilder.toString();
        }
        if (string2 == null) {
            if (field != null) {
                object = field.getLast();
                if (((Field)object).fieldRef == FieldReference.PARENT) {
                    ((Field)object).fieldRef = FieldReference.SELF;
                    ((Field)object).name = "parent";
                    return field;
                }
            }
            if (((String)(object = stringBuilder2.toString().trim())).isEmpty()) {
                String string5 = teXObjectList.toString(teXParser).trim();
                if (string5.isEmpty()) {
                    throw new Bib2GlsException(bib2Gls.getMessage("error.missing.field"));
                }
                throw new Bib2GlsException(bib2Gls.getMessage("error.missing.field_before", bib2Gls.truncate(string5)));
            }
            throw new Bib2GlsException(bib2Gls.getMessage("error.missing.field_after", (String)object));
        }
        if (field == null) {
            return new Field(glsResource, FieldReference.SELF, string2, null, string);
        }
        field.getLast().setName(string2);
        return field;
    }

    public String toString() {
        if (this.follow == null) {
            return this.fieldRef.getTag() + " " + FOLLOW_MARKER + " " + this.name;
        }
        return this.fieldRef.getTag() + " " + FOLLOW_MARKER + " " + this.follow.toString();
    }
}

