/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.implementation;

import java.util.List;
import java.util.Objects;
import schemacrawler.ermodel.implementation.AbstractDatabaseObjectBacked;
import schemacrawler.ermodel.model.EntityAttribute;
import schemacrawler.ermodel.model.EntityAttributeType;
import schemacrawler.ermodel.model.TableBacked;
import schemacrawler.ermodel.utility.EntityModelUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;

class MutableEntityAttribute
extends AbstractDatabaseObjectBacked<Column>
implements EntityAttribute {
    private static final long serialVersionUID = 7349443487412594755L;
    private final TableBacked parent;
    private final EntityAttributeType type;
    private final List<String> enumValues;

    MutableEntityAttribute(TableBacked parent, Column column) {
        super(column);
        this.parent = Objects.requireNonNull(parent, "No parent provided");
        ColumnDataType columnDataType = column.getColumnDataType();
        this.type = EntityModelUtility.inferEntityAttributeType(columnDataType);
        this.enumValues = columnDataType.getEnumValues();
    }

    @Override
    public String getDefaultValue() {
        return ((Column)this.getDatabaseObject()).getDefaultValue();
    }

    @Override
    public List<String> getEnumValues() {
        return List.copyOf(this.enumValues);
    }

    @Override
    public TableBacked getParent() {
        return this.parent;
    }

    @Override
    public EntityAttributeType getType() {
        return this.type;
    }

    @Override
    public boolean hasDefaultValue() {
        return ((Column)this.getDatabaseObject()).hasDefaultValue();
    }

    @Override
    public boolean isRequired() {
        return !((Column)this.getDatabaseObject()).isNullable();
    }
}

